//
//
//	3D2 objects parser
//
//										(C) JoOl 1998


#ifndef _PARSER_3D2_H_
#define _PARSER_3D2_H_


#include "LAPbinParser.h"
#include "PierrotParser.h"


class						Parser3d2 : public LAPbinParser, public PierrotParser
{
#define SIGNATURE_3D2		0x3d02

	typedef struct
	{
		uint16				Sig;
		uint16				NbObj;
		uint16				LightAon, LightBon, LightCon;
		uint16				BrightA, BrightB, BrightC, BrightAmb;
		int16				Az, Bz, Cz;
		int16				Ay, By, Cy;
		int16				Ax, Bx, Cx;
		uint16				ObjColor[32];
		uint16				ColGroup[32];
		uint16				PalType;		// 0 = 7-shade, 1 = 14-shade, 2 = custom
		uint16				WireColor;
		uint16				OutlineColor;
		uint8				Dummy[86];		// should be 150;
	} tHeader3d2;

	tHeader3d2				header;

	// private parsing methods
	bool					ParseHeader();
	void					ProcessHeader();
	void					ParseObject();
	void					ParseVertices(pObject* );
	void					ParseFaces(pObject* );

	virtual status_t		_Identify();
	virtual status_t		_Parse();
	virtual void			_Terminate();
	virtual status_t		DoAbort();


public:

							Parser3d2(int32 , LAPtracer* );
	virtual					~Parser3d2();
};


#if __POWERPC__
#pragma export on
#endif
extern "C" Parser3d2*		instantiate_parser(int32 , LAPtracer* );
#if __POWERPC__
#pragma export reset
#endif


#endif	/* _PARSER_3D2_H_ */
