//
//
//	LAP dynamically-allocated buffer class
//
//										(C) JoOl 1998


#include "LAPimpexp.h"

#include <new.h>
#include "LAPdynBuffer.h"
#include "LAPmemoryException.h"
#include "LAPerrors.h"


LAPdynBuffer::LAPdynBuffer(int32 bufSize)
: LAPbuffer(bufSize)
{
}


LAPdynBuffer::~LAPdynBuffer()
{
}


void
LAPdynBuffer::GrowToFit(int32 len)
{
	int32			newAlloc = (((writePtr + len) / blockSize) + 1) * blockSize;
	try
	{
		char*		newBuffer = new char[newAlloc+1];
		memcpy(newBuffer, buffer, writePtr);
		buffer = newBuffer;
		alloc = newAlloc;
	}
	catch (bad_alloc )
	{
		throw LAPbadAlloc("LAPdynBuffer::GrowToFit", "newBuffer", newAlloc+1);
	}
}


// Make the buffer big enough
void
LAPdynBuffer::_badWrite(char* str, int32 len)
{
	GrowToFit(len);
	memcpy(&buffer[writePtr], str, len);
	writePtr += len;
}


void
LAPdynBuffer::badWrite(char* str, int32 len)
{
	_badWrite(str, len);
}
