//
//
//	LAP tracer class
//
//										(C) JoOl 1998


#include "LAPimpexp.h"

#include "LAPtracer.h"
#include "LAPerrors.h"


LAPtracer::LAPtracer(int32 a, uint8 b, uint8 c)
: LAPtextBufferedOutput(a, b, c)
{
	header = NULL;
	lineNumber = NULL;
	input = NULL;
}


LAPtracer::~LAPtracer()
{
	delete[] header;
}


void
LAPtracer::SetHeader(const char* h)
{
	if (header)
		delete[] header;
	header = strdup(h);
	lineNumber = NULL;
	input = NULL;
}


void
LAPtracer::SetHeader(const char* h, int32* lnp)
{
	if (header)
		delete[] header;
	header = strdup(h);
	lineNumber = lnp;
	input = NULL;
}


void
LAPtracer::SetHeader(const char* h, LAPbufferedInput* io)
{
	if (header)
		delete[] header;
	header = strdup(h);
	lineNumber = NULL;
	input = io;
}


void
LAPtracer::_GenerateLineHeader()
{
	GenerateSpaces(margin);
	if (header)
		*this << header;

	if (lineNumber)
	{
		*this << ", line " << *lineNumber;
	}
	else if (input)
	{
		off_t				offset = input->GetPosition();
		*this << ", offset " << offset;
	}

	if (header || lineNumber || input)
		*this << ": ";
}
