//
//
//	LAP binary lexer class
//
//										(C) JoOl 1998


#ifndef _LAP_BIN_LEXER_H_
#define _LAP_BIN_LEXER_H_


#include "LAPlexer.h"
#include "LAPbinBufferedInput.h"


class						LAPbinLexer: public LAPlexer
{
protected:

//#if __POWERPC__
#pragma export on
//#endif

	LAPbinBufferedInput*	input;
	virtual status_t		_SetInput(entry_ref );

public:
							LAPbinLexer(int32 , LAPendianness );
							LAPbinLexer(LAPbinBufferedInput* );
	virtual					~LAPbinLexer();

	LAPbinBufferedInput*	GetInput() const;

	void					ReadInt8(int8& out);
	void					ReadInt16(int16& out);
	void					ReadInt32(int32& out);
	void					ReadInt64(int64& out);
	void					ReadFloat(float& out);
	void					ReadDouble(double& out);
	void					ReadBytes(char* out, int32 n);
	void					ReadString(char* out, int32 max);
	void					SkipBytes(int32 n);

//#if __POWERPC__
#pragma export reset
//#endif
};


#endif	/* _LAP_BIN_LEXER_H_ */

