//
//
//	LAP library memory exceptions
//
//										(C) JoOl 1998


#ifndef _LAP_MEMORY_EXCEPTION_H_
#define _LAP_MEMORY_EXCEPTION_H_


#include "LAPexception.h"
#include "LAPtextBufferedOutput.h"



//-------------------------------------------------------------
//
//-------------------------------------------------------------

class					LAPmemoryException: public LAPexception
{
public:

//#if __POWERPC__
#pragma export on
//#endif
	const char*			varName;

						LAPmemoryException(int32 , const char* , const char* );
						LAPmemoryException(LAPmemoryException& );
	virtual				~LAPmemoryException();

	void				_Output(LAPtextBufferedOutput& );
	virtual void		Output(LAPtextBufferedOutput& );

//#if __POWERPC__
#pragma export reset
//#endif
};


//-------------------------------------------------------------
//
//-------------------------------------------------------------

class					LAPbadInit: public LAPmemoryException
{
public:

//#if __POWERPC__
#pragma export on
//#endif
	char				c;

						LAPbadInit(const char* , const char* );
						LAPbadInit(LAPbadInit& );
	virtual				~LAPbadInit();

	virtual void		Output(LAPtextBufferedOutput& );

//#if __POWERPC__
#pragma export reset
//#endif
};


//-------------------------------------------------------------
//
//-------------------------------------------------------------

class					LAPbadBufferWrite: public LAPmemoryException
{
public:

//#if __POWERPC__
#pragma export on
//#endif
	ssize_t				asked;
	ssize_t				limit;

						LAPbadBufferWrite(const char* , const char* , ssize_t , ssize_t );
						LAPbadBufferWrite(LAPbadBufferWrite& );
	virtual				~LAPbadBufferWrite();

	virtual void		Output(LAPtextBufferedOutput& );

//#if __POWERPC__
#pragma export reset
//#endif
};


//-------------------------------------------------------------
//
//-------------------------------------------------------------

class					LAPbadBufferRead: public LAPmemoryException
{
public:

//#if __POWERPC__
#pragma export on
//#endif
	ssize_t				asked;
	ssize_t				left;

						LAPbadBufferRead(const char* , const char* , ssize_t , ssize_t );
						LAPbadBufferRead(LAPbadBufferRead& );
	virtual				~LAPbadBufferRead();

	virtual void		Output(LAPtextBufferedOutput& );

//#if __POWERPC__
#pragma export reset
//#endif
};


//-------------------------------------------------------------
//
//-------------------------------------------------------------

class					LAPbadAlloc: public LAPmemoryException
{
public:

//#if __POWERPC__
#pragma export on
//#endif
	ssize_t				asked;

						LAPbadAlloc(const char* , const char* , ssize_t );
						LAPbadAlloc(LAPbadAlloc& );
	virtual				~LAPbadAlloc();

	virtual void		Output(LAPtextBufferedOutput& );

//#if __POWERPC__
#pragma export reset
//#endif
};


#endif	/* _LAP_MEMORY_EXCEPTION_H_ */
