//
//
//	LAP text data buffered-output class
//
//											(C) JoOl 1998


#ifndef _LAP_TEXT_BUFFERED_OUTPUT_H_
#define _LAP_TEXT_BUFFERED_OUTPUT_H_


#include "LAPcommon.h"
#include "LAPbufferedOutput.h"


// Buffer-End Of Line indicator
class						LAPbufferEol {};
// Buffer-advance margin indicator
class						LAPbufferAdvance {};
// Buffer-retreat margin indicator
class						LAPbufferRetreat {};

static LAPbufferEol			eol;
static LAPbufferAdvance		adv;
static LAPbufferRetreat		ret;


// message related indicators
class						LAPnoMessage {};
class						LAPerrorMessage {};
class						LAPwarningMessage {};
class						LAPinfoMessage {};
static LAPnoMessage			nomsg;
static LAPerrorMessage		errmsg;
static LAPwarningMessage	warnmsg;
static LAPinfoMessage		infomsg;


class						LAPtextBufferedOutput: public LAPbufferedOutput
{
#define LAP_BUFFER_TEXT_SPACESBITS	4
#define LAP_BUFFER_TEXT_SPACES		(1 << LAP_BUFFER_TEXT_SPACESBITS)

	int32					indentSize;
	char					Spaces[LAP_BUFFER_TEXT_SPACES+1];

	bool					headerGenerated;
	virtual void			_GenerateLineHeader();

protected:

#pragma export on

	void					GenerateSpaces(int32 );
	void					GenerateLineHeader();

	virtual status_t		OutputScreen(char* , int32 );

public:

							LAPtextBufferedOutput(int32 , uint8 , uint8 );
	virtual					~LAPtextBufferedOutput();

	// ident-related methods
	int32					GetIndentSize() const;
	void					SetIndentSize(int32 );

	// margin-related stuff
	int32					margin;
	int32					SetMargin(int32 );
	void					ResetMargin(int32 );
	void					AdvanceMargin();
	void					RetreatMargin();

	const char*				GetBuffer();
	char*					Detach();

	LAPtextBufferedOutput&	operator<<(char );
	LAPtextBufferedOutput&	operator<<(uchar );
	LAPtextBufferedOutput&	operator<<(int16 );
	LAPtextBufferedOutput&	operator<<(uint16 );
	LAPtextBufferedOutput&	operator<<(int32 );
	LAPtextBufferedOutput&	operator<<(uint32 );
	LAPtextBufferedOutput&	operator<<(int64& );
	LAPtextBufferedOutput&	operator<<(uint64& );
	LAPtextBufferedOutput&	operator<<(float );
	LAPtextBufferedOutput&	operator<<(double& );
	LAPtextBufferedOutput&	operator<<(char* );
	LAPtextBufferedOutput&	operator<<(const char* );
	LAPtextBufferedOutput&	operator<<(void* );
	LAPtextBufferedOutput&	operator<<(LAPbufferFlush& );
	LAPtextBufferedOutput&	operator<<(LAPbufferEol& );
	LAPtextBufferedOutput&	operator<<(LAPbufferAdvance& );
	LAPtextBufferedOutput&	operator<<(LAPbufferRetreat& );

	LAPtextBufferedOutput&	operator<<(LAPnoMessage& );
	LAPtextBufferedOutput&	operator<<(LAPerrorMessage& );
	LAPtextBufferedOutput&	operator<<(LAPwarningMessage& );
	LAPtextBufferedOutput&	operator<<(LAPinfoMessage& );


#pragma export reset
};


#endif	/* _LAP_TEXT_BUFFERED_OUTPUT_H_ */
