//
//
//	LAP text Lexer class
//
//										(C) JoOl 1998


#ifndef _LAP_TEXT_LEXER_H_
#define _LAP_TEXT_LEXER_H_


#include "LAPcommon.h"
#include "LAPlexer.h"
#include "LAPtoken.h"
#include "LAPliteral.h"
#include "LAPlexemeTable.h"
#include "LAPlexemeBuffer.h"
#include "LAPtextBufferedInput.h"



// char codes for LAPlexerText::Charcodes
enum
{
	LAP_CHAR_SPACE = LAP_CHAR_FIRST,
	LAP_CHAR_ALPHA,
	LAP_CHAR_DIGIT,
	LAP_CHAR_ILLEGAL,

	LAP_CHAR_LAST
};


class					LAPtextLexer: public LAPlexer
{
#define IsSpace(a)		(charCode[a] == LAP_CHAR_SPACE)
#define IsDigit(a)		(charCode[a] == LAP_CHAR_DIGIT)
#define IsAlpha(a)		(charCode[a] == LAP_CHAR_ALPHA)
#define IsIllegal(a)	(charCode[a] == LAP_CHAR_ILLEGAL)

protected:

//#if __POWERPC__
#pragma export on
//#endif

	LAPtextBufferedInput*	input;
	virtual status_t	_SetInput(entry_ref );

	uint8				charCode[256];
	void				SetCharCode(char , uint8 );
	void				SetCharCode(uchar , uchar , uint8 );
	void				SetDefaultCharCodes();

	int32				lineNumber;
	int32				charNumber;

	LAPliteral			literal;
	LAPliteralType		literalType;
	LAPtoken			token;
	LAPlexemeBuffer*	lexeme;

	LAPlexemeTable		lexemes;

	virtual LAPtoken	_NextToken() = 0;

public:
						LAPtextLexer(int32 , LAPlexemeBuffer* );
						LAPtextLexer(LAPtextBufferedInput* , LAPlexemeBuffer* );
	virtual				~LAPtextLexer();

	LAPtextBufferedInput*	GetInput() const;

	int32				GetLineNumber() const;
	int32*				GetLineNumberPointer();
	int32				GetCharNumber() const;
	int32*				GetCharNumberPointer();

	void				Skip();
	void				Fwd();

	LAPliteralType		GetLiteralType() const;
	char				GetCharLiteral() const;
	int32				GetInt32Literal() const;
	int64				GetInt64Literal() const;
	float				GetFloatLiteral() const;
	double				GetDoubleLiteral() const;
	char*				GetStringLiteral() const;
	char*				DetachStringLiteral();

	virtual void		ProcessIllegal(char ); // throw (LAPillegalCharacter);
	void				SkipSpaces();
	void				SkipLine();
	void				LexNumber();
	void				LexWord();
	void				LexIdentifier();
	void				LexTo(char );
	void				ReadLine();

	virtual void		SetLexemes();
	const char*			GetLexeme(LAPtoken );
	virtual void		SetCharCodes();

	LAPtoken			NextToken();

//#if __POWERPC__
#pragma export reset
//#endif
};


#endif	/* _LAP_TEXT_LEXER_H_ */
