//
//
//	LAP lexeme buffer class
//
//										(C) JoOl 1998


#include "LAPimpexp.h"

#include "LAPlexemeBuffer.h"


LAPlexemeBuffer::LAPlexemeBuffer(int32 bufSize, bool errorOnOverflow)
: LAPdynBuffer(bufSize)
{
	policy = (errorOnOverflow) ? LAP_BUFFER_ERROR_ON_OVERFLOW : LAP_BUFFER_GROW_ON_OVERFLOW;
}


LAPlexemeBuffer::~LAPlexemeBuffer()
{
}


void
LAPlexemeBuffer::badWrite(char* str, int32 len)
{
	(policy == LAP_BUFFER_GROW_ON_OVERFLOW)
	? LAPdynBuffer::_badWrite(str, len)		// dynamic buffer
	: LAPbuffer::_badWrite(str, len);		// static buffer
}


LAPlexemeBuffer&
LAPlexemeBuffer::operator<<(char in)
{
	this->Append(&in, 1);
	return *this;
}



const char*
LAPlexemeBuffer::GetBuffer()
{
	int32		outLen;
	char*		outStr = (char* )LAPbuffer::GetBuffer(outLen);
	outStr[outLen] = 0;
	return (const char* )outStr;
}


char*
LAPlexemeBuffer::Detach()
{
	int32		outLen;
	char*		outStr = (char* )LAPbuffer::Detach(outLen);
	outStr[outLen] = 0;
	return outStr;
}
