//
//
//	Pierrot color (RGBA components)
//
//										(C) JoOl 1998


#ifndef _PIERROT_COLOR_4_H_
#define _PIERROT_COLOR_4_H_


#include <SupportDefs.h>
#include "PierrotGeometry.h"



class pColor4;

//--------------------------------------------------------
// RGBA spectra
//--------------------------------------------------------

class					pSpectra4
{
public:

	float				r, g, b, a;

#pragma export on
						pSpectra4();
						pSpectra4(float , float , float , float );
						pSpectra4(pSpectra4& );
						pSpectra4(pColor4& );
						~pSpectra4();

	void				Set(float , float , float , float );
	void				Set(pSpectra4& );
	void				Set(pColor4& );
	bool				Eq(pSpectra4& , float = PIERROT_EPSILON);

	void				Clamp(float , float );

	pSpectra4&			operator*=(float );
	pSpectra4&			operator/=(float );
	pSpectra4			operator*(float );
	pSpectra4			operator/(float );
	pSpectra4&			operator+=(pSpectra4& );
	pSpectra4&			operator-=(pSpectra4& );
	pSpectra4			operator+(pSpectra4& );
	pSpectra4			operator-(pSpectra4& );

	pSpectra4&			operator=(pSpectra4& );
	int					operator!=(pSpectra4& );
	int					operator==(pSpectra4& );

#pragma export reset
};


//--------------------------------------------------------
// RGBA color
//--------------------------------------------------------

class					pColor4
{
public:

	uint8				r, g, b, a;

#pragma export on
						pColor4();
						pColor4(uint8 , uint8 , uint8 , uint8 );
						pColor4(pColor4& );
						pColor4(pSpectra4& );
						~pColor4();

	void				Set(uint8 , uint8 , uint8 , uint8 );
	void				Set(pSpectra4& );
	void				Set(pColor4& );
	bool				Eq(pColor4& , float = PIERROT_EPSILON);

	void				Clamp(uint8 , uint8 );

	pColor4&			operator=(pColor4& );
	int					operator==(pColor4& );
	int					operator!=(pColor4& );

#pragma export reset
};


#endif /* _PIERROT_COLOR_4_H_ */
