//
//
//	Pierrot parser
//
//										(C) JoOl 1998


#ifndef _PIERROT_PARSER_H_
#define _PIERROT_PARSER_H_


#include "PierrotScene.h"
#include "LAPtextBufferedOutput.h"

#include "PierrotPointsArray.h"


enum
{
	PRINT_NOTHING			= 0x0,

	PRINT_VIEW				= 0x01,
	PRINT_BOUNDS			= 0x02,
	PRINT_LIGHT_ALL			= 0x04,
	PRINT_MATERIAL_ALL		= 0x08,

	PRINT_OBJECT_BOUNDS		= 0x020,
	PRINT_OBJECT_MATRIX		= 0x040,
	PRINT_OBJECT_DOTS		= 0x080,
	PRINT_OBJECT_LINES		= 0x100,
	PRINT_OBJECT_POINTS		= 0x200,
	PRINT_OBJECT_FACES		= 0x400,
	PRINT_OBJECT_NORMALS	= 0x800,
	PRINT_OBJECT_MAPS		= 0x1000,
	PRINT_OBJECT_ALL		= PRINT_OBJECT_BOUNDS
							| PRINT_OBJECT_MATRIX
							| PRINT_OBJECT_DOTS
							| PRINT_OBJECT_LINES
							| PRINT_OBJECT_POINTS
							| PRINT_OBJECT_FACES
							| PRINT_OBJECT_NORMALS
							| PRINT_OBJECT_MAPS,

	PRINT_ALL				= PRINT_LIGHT_ALL | PRINT_MATERIAL_ALL | PRINT_OBJECT_ALL
};


class						PierrotParser
{

protected:
	pScene*					scene;

#pragma export on

	void					Reset();

	// find or add new vertex
	int32					NewVertex(pObject* , pPoint3& );

	pDirectionalLight*		NewDirectionalLight(char* , pVector3& );
	pPositionalLight*		NewPositionalLight(char* , pPoint3& );
	pSpotlight*				NewSpotlight(char* , pPoint3& , pVector3& , float , float );

	pMaterial*				NewMaterial(char* );
	pMaterial*				NewMaterial(char* , pSpectra& );
	pMaterial*				NewMaterial(char* , float , pSpectra& , float );

	pObject*				NewObject(char* );
	pObject*				NewObject(char* , int32 , int32 , int32 , int32 );
	pObject*				NewObject(char* , pPointsArray* , pVectorsArray* );

	pObject*				BuildSpinObject(char* ,			// name
											pPointsArray* ,	// spin description
											pMaterial* ,	// material
											pPoint3& ,		// center
											pVector3& ,		// orientation
											int32 );		// # spin steps
	// for concave objects
	pObject*				BuildSpinObject2(char* ,
											pPointsArray* ,
											pMaterial* ,	
											pPoint3& ,
											pVector3& ,
											int32 );
	pObject*				BuildVolume(char* , pSpinVolume& , pMaterial* , int32 , int32 );
	pObject*				BuildVolume2(char* , pSpinVolume& , pMaterial* , int32 , int32 );
	pObject*				BuildCylinder(char* , pCylinder& , pMaterial* , int32 );
	pObject*				BuildCone(char* , pCone& , pMaterial* , int32 );
	pObject*				BuildSphere(char* , pSphere& , pMaterial* , int32 , int32 );
	pObject*				BuildTorus(char* , pTorus& , pMaterial* , int32 , int32 );
	pObject*				BuildRing(char* , pRing& , pMaterial* , int32 );

public:
							PierrotParser();
	virtual					~PierrotParser();

	static void				Output(LAPtextBufferedOutput& , pScene* , uint32 = PRINT_NOTHING);
	static void				Output(LAPtextBufferedOutput& , pLight* );
	static void				Output(LAPtextBufferedOutput& , pMaterial* );
	static void				Output(LAPtextBufferedOutput& , pObject* , uint32 );

	static void				Output(LAPtextBufferedOutput& , pMatrix4& );
	static void				Output(LAPtextBufferedOutput& , pBox& );
	static void				Output(LAPtextBufferedOutput& , pSphere& );
	static void				Output(LAPtextBufferedOutput& , pSpectra& );
	static void				Output(LAPtextBufferedOutput& , pSpectra4& );
	static void				Output(LAPtextBufferedOutput& , pColor& );
	static void				Output(LAPtextBufferedOutput& , pColor4& );
	static void				Output(LAPtextBufferedOutput& , pPoint3& );
	static void				Output(LAPtextBufferedOutput& , pVector3& );
	static void				Output(LAPtextBufferedOutput& , pTexPoint& );
	static void				Output(LAPtextBufferedOutput& , pFace* );

#pragma export reset
};


#endif	/* _PIERROT_PARSER_H_ */

