//
//
//	Pierrot color (RGBA components)
//
//										(C) JoOl 1998


#include "PierrotImpExp.h"

#include <math.h>
#include "PierrotColor4.h"


//--------------------------------------------------------
// RGBA spectra
//--------------------------------------------------------

pSpectra4::pSpectra4()
{}


pSpectra4::pSpectra4(float _r, float _g, float _b, float _a)
{
	r = _r;
	g = _g;
	b = _b;
	a = _a;
}



pSpectra4::pSpectra4(pSpectra4& s)
{
	r = s.r;
	g = s.g;
	b = s.b;
	a = s.a;
}



pSpectra4::pSpectra4(pColor4& c)
{ Set(c); }


pSpectra4::~pSpectra4()
{}


void
pSpectra4::Set(float _r, float _g, float _b, float _a)
{
	r = _r;
	g = _g;
	b = _b;
	a = _a;
}


void
pSpectra4::Set(pColor4& c)
{
	r = float(c.r) / 255.0;
	g = float(c.g) / 255.0;
	b = float(c.b) / 255.0;
	a = float(c.a) / 255.0;
}


void
pSpectra4::Set(pSpectra4& s)
{
	r = s.r;
	g = s.g;
	b = s.b;
	a = s.a;
}


bool
pSpectra4::Eq(pSpectra4& s, float e)
{
	return (fabs(r - s.r) < e)
		&& (fabs(g - s.g) < e)
		&& (fabs(b - s.b) < e)
		&& (fabs(a - s.a) < e);
}


void
pSpectra4::Clamp(float _min, float _max)
{
	r = max_c(min_c(r, _max), _min);
	g = max_c(min_c(g, _max), _min);
	b = max_c(min_c(b, _max), _min);
	a = max_c(min_c(a, _max), _min);
}


pSpectra4&
pSpectra4::operator*=(float s)
{
	r *= s;
	g *= s;
	b *= s;
	a *= s;
	return *this;
}


pSpectra4&
pSpectra4::operator/=(float s)
{
	r /= s;
	g /= s;
	b /= s;
	a /= s;
	return *this;
}


pSpectra4
pSpectra4::operator*(float s)
{ return pSpectra4(r*s, g*s, b*s, a*s); }


pSpectra4
pSpectra4::operator/(float s)
{ return pSpectra4(r/s, g/s, b/s, a/s); }


pSpectra4&
pSpectra4::operator+=(pSpectra4& s)
{
	r += s.r;
	g += s.g;
	b += s.b;
	a += s.a;
	return *this;
}


pSpectra4&
pSpectra4::operator-=(pSpectra4& s)
{
	r -= s.r;
	g -= s.g;
	b -= s.b;
	a -= s.a;
	return *this;
}


pSpectra4
pSpectra4::operator+(pSpectra4& s)
{ return pSpectra4(r+s.r, g+s.g, b+s.b, a+s.a); }


pSpectra4
pSpectra4::operator-(pSpectra4& s)
{ return pSpectra4(r-s.r, g-s.g, b-s.b, a-s.a); }


pSpectra4&
pSpectra4::operator=(pSpectra4& s)
{
	this->Set(s);
	return *this;
}


int
pSpectra4::operator==(pSpectra4& s)
{ return (r == s.r) && (g == s.g) && (b == s.b) && (a == s.a); }


int
pSpectra4::operator!=(pSpectra4& s)
{ return (r != s.r) || (g != s.g) || (b != s.b) || (a != s.a); }



//--------------------------------------------------------
// RGBA color
//--------------------------------------------------------

pColor4::pColor4()
{}


pColor4::pColor4(uint8 _r, uint8 _g, uint8 _b, uint8 _a)
{
	r = _r;
	g = _g;
	b = _b;
	a = _a;
}


pColor4::pColor4(pColor4& s)
{
	r = s.r;
	g = s.g;
	b = s.b;
	a = s.a;
}


pColor4::pColor4(pSpectra4& s)
{ Set(s); }


pColor4::~pColor4()
{};


void
pColor4::Set(uint8 _r, uint8 _g, uint8 _b, uint8 _a)
{
	r = _r;
	g = _g;
	b = _b;
	a = _a;
}


void
pColor4::Set(pColor4& c)
{
	r = c.r;
	g = c.g;
	b = c.b;
	a = c.a;
}


void
pColor4::Set(pSpectra4& s)
{
	r = uint8(s.r * 255.0);
	g = uint8(s.g * 255.0);
	b = uint8(s.b * 255.0);
	a = uint8(s.a * 255.0);
}


bool
pColor4::Eq(pColor4& c, float e)
{
	return (fabs(r - c.r) < e)
		&& (fabs(g - c.g) < e)
		&& (fabs(b - c.b) < e)
		&& (fabs(a - c.a) < e);
}


void
pColor4::Clamp(uint8 _min, uint8 _max)
{
	r = max_c(min_c(r, _max), _min);
	g = max_c(min_c(g, _max), _min);
	b = max_c(min_c(b, _max), _min);
	a = max_c(min_c(a, _max), _min);
}


pColor4&
pColor4::operator=(pColor4& s)
{
	this->Set(s);
	return *this;
}


int
pColor4::operator==(pColor4& s)
{ return (r == s.r) && (g == s.g) && (b == s.b) && (a == s.a); }


int
pColor4::operator!=(pColor4& s)
{ return (r != s.r) || (g != s.g) || (b != s.b) || (a != s.a); }

