//
//
//	Pierrot material
//
//										(C) JoOl 1998


#include "PierrotImpExp.h"

#include <string.h>
#include "PierrotMaterial.h"



//--------------------------------------------------------
// material
//--------------------------------------------------------

pMaterial::pMaterial(char* n)
{
	name = strdup(n);
	SetDefaultMaterial();
	refCount = 0;
}


pMaterial::pMaterial(char* n, float op, pSpectra& em, float sh)
{
	name = strdup(n);
	SetDefaultMaterial();
	opacity =op;
	emission = em;
	shininess = min_c(max_c(sh, 0.0), 128.0);
	refCount = 0;
}


pMaterial::~pMaterial()
{ delete[] name; }


void
pMaterial::SetAmbientAndDiffuse(pSpectra& s)
{ ambient = diffuse = s; }


void
pMaterial::SetDefaultMaterial()
{
	opacity = 1.0;
	ambient.Set(0.1, 0.1, 0.1);
	diffuse.Set(0.6, 0.6, 0.6);
	specular.Set(0.4, 0.4, 0.4);
	emission.Set(0.0, 0.0, 0.0);
//	shininess = 0.0; 
	shininess = 40.0; 
}
