//
//
//	Regular iconed string item
//
//											(C) JoOl 1998


#include <malloc.h>
#include <stdio.h>
#include <Bitmap.h>

#include "RiconedStringItem.h"

#define RISI_ICON_MARGIN		18.0


RiconedStringItem::RiconedStringItem(char* i, char* lbl, BBitmap* icn, bool own)
: RstringItem(i, lbl)
{
	ownIcon = false;
	icon = NULL;
	SetIcon(icn, own);
}


RiconedStringItem::~RiconedStringItem()
{
	if (icon && ownIcon)
		delete icon;
}



void
RiconedStringItem::SetIcon(BBitmap* icn, bool own)
{
	if (icon && ownIcon)
		delete icon;

	ownIcon = own;
	icon = icn;
}


BBitmap*
RiconedStringItem::GetIcon() const
{
	return icon;
}


void
RiconedStringItem::DrawItem(BView* owner, BRect itemRect, bool drawEverything)
{
	BFont			font;
	owner->SetFont(be_plain_font);
	owner->GetFont(&font);

	float			iw0 = 0.0;
	float			iw = 0.0;
	float			ih = 0.0;
	if (icon)
	{
		iw0 = icon->Bounds().Width();
		iw = max_c(iw0, RISI_ICON_MARGIN);
		ih = icon->Bounds().Height();
	}
	BPoint			iconPt(itemRect.left + (RISI_ICON_MARGIN-iw0)*0.5,
							itemRect.top + (itemRect.Height() - ih)*0.5);
	BPoint			labelPt(itemRect.left + 2.0 + iw + 2.0,
							itemRect.bottom - (itemRect.Height() - font.Size())*0.5-1.0);

	BRect			labelRect = itemRect;
	labelRect.left += iw;
	owner->SetDrawingMode(B_OP_COPY);
	if (IsSelected())
		owner->SetHighColor(200, 200, 200, 0);
	else
		owner->SetHighColor(viewColor);
	owner->FillRect(labelRect);

	if (icon)
	{
		owner->SetDrawingMode(B_OP_OVER);
		owner->SetLowColor(B_TRANSPARENT_32_BIT);
		owner->DrawBitmap(icon, iconPt);
	}

	owner->SetDrawingMode(B_OP_COPY);
	if (!IsEnabled())
		owner->SetHighColor(150, 150, 150, 0);
	else
		owner->SetHighColor(0, 0, 0, 0);
	owner->SetLowColor(255, 255, 255, 0);
	owner->MovePenTo(labelPt);
	owner->DrawString(label);
}


void
RiconedStringItem::Update(BView* owner, const BFont* font)
{
	SetHeight(max_c(icon->Bounds().Height()+2.0, font->Size()+2.0));
	SetWidth(2.0 + icon->Bounds().Width() + 2.0 + font->StringWidth(label) + 2.0);
}

