//
//
//	Regular items list
//
//											(C) JoOl 1998

#include <string.h>
#include <stdio.h>
#include <ScrollBar.h>
#include "VitemsList.h"



VitemsList::VitemsList(BView* lv, const char* n, uint32 sbars)
: PitemsList(lv, n, sbars)
{
}


VitemsList::~VitemsList()
{
	DeleteItems();
}


float
VitemsList::ComputeItemsWidth() const
{
	float			max = 0.0;
	for (int32 i = 0; i < itemsCount; i++)
	{
		float		curr = ((BView* )items.ItemAt(i))->Bounds().Width();
		if (curr > max)
			max = curr;
	}
	return max;
}


BRect
VitemsList::ItemFrame(int32 index)
{
	BView*			v = (BView* )items.ItemAt(index);
	if (!v)
		return BRect(0.0, 0.0, 0.0, 0.0);
	return v->Frame();
}


void
VitemsList::MakeEmpty()
{
	for (int32 i = itemsCount-1; i >= 0; i--)
		RemoveItem(i);
}


void
VitemsList::DeleteItems()
{
	for (int32 i = itemsCount-1; i >= 0; i--)
		DeleteItem(i);
}


bool
VitemsList::IsEmpty() const
{
	return itemsCount < 1;
}


bool
VitemsList::AddItem(Vitem* item, int32 rank)
{
	return AddItem(Pitem::cmpPitems, item, rank);
}


bool
VitemsList::AddItem(PitemsCmpFunc func, Vitem* item, int32 rank)
{
	if (Search(func, item) >= 0)
		return false;

	BRect				itemBounds = item->Bounds();

	if (rank < 0)
		rank = itemsCount;

	// set new item's position
	if (itemsCount < 1)
		item->MoveTo(0.0, 0.0);
	else
		item->MoveTo(0.0, ItemAt(rank-1)->Frame().bottom);
	//shift all other items
	float			yshift = itemBounds.Height();
	for (int32 i = rank; i < itemsCount; i++)
	{
		Vitem*		it = ItemAt(i);
		it->MoveBy(0.0, yshift);
		it->SetViewColor(ColorFor(i+1));
	}
	// add new item
	item->SetViewColor(ColorFor(rank));
	itemsView->AddChild(item);
	items.AddItem(item, rank);
	itemsCount++;

	itemsHeight += yshift-1.0;	//---
	if (itemBounds.Width() > itemsWidth)
		itemsWidth = itemBounds.Width();

	UpdateScrollBars(itemsWidth, itemsHeight);

	return true;
}


int32
VitemsList::CountItems() const
{
	return itemsCount;
}


Vitem*
VitemsList::ItemAt(int32 i) const
{
	return (Vitem* )items.ItemAt(i);
}


int32
VitemsList::IndexOf(Vitem* item) const
{
	return Search(Pitem::cmpPitems, item);
}


int32
VitemsList::Search(Vitem* item) const
{
	return Search(Pitem::cmpPitems, item);
}


int32
VitemsList::Search(PitemsCmpFunc func, void* data) const
{
	for (int32 i = 0; i < itemsCount; i++)
	{
		if (func((Pitem* )items.ItemAt(i), data) == 0)
			return i;
	}
	return -1;
}


bool
VitemsList::Exists(Vitem* item) const
{
	return Search(Pitem::cmpPitems, item) >= 0;
}


bool
VitemsList::Exists(PitemsCmpFunc func, void* data) const
{
	return Search(func, data) >= 0;
}


bool
VitemsList::DeleteItem(int32 i)
{
	Vitem*			item = RemoveItem(i);
	if (!item)
		return false;
	delete item;
	return true;
}


bool
VitemsList::DeleteItem(PitemsCmpFunc func, void* data)
{
	Vitem*			item = RemoveItem(func, data);
	if (!item)
		return false;
	delete item;
	return true;
}


Vitem*
VitemsList::RemoveItem(int32 rank)
{
	Vitem*			item = (Vitem* )items.RemoveItem(rank);
	if (item)
	{
		itemsView->RemoveChild(item);
		itemsCount--;

		float		yshift = -item->Bounds().Height();
		for (int32 i = rank; i < itemsCount; i++)
		{
			Vitem*		it = ItemAt(i);
			it->MoveBy(0.0, yshift);
			it->SetViewColor(ColorFor(i));
		}
		itemsWidth = ComputeItemsWidth();
		itemsHeight += yshift+1.0;	//---

		UpdateScrollBars(itemsWidth, itemsHeight);
	}
	return item;
}


Vitem*
VitemsList::RemoveItem(PitemsCmpFunc func, void* data)
{
	int32			rank = Search(func, data);
	if (rank < 0)
		return NULL;
	return RemoveItem(rank);
}
