//
//
//	Open GL configuration view
//
//


#include <stdio.h>
#include <Application.h>
#include <SupportDefs.h>
#include <PopUpMenu.h>
#include <MenuItem.h>
#include <MenuField.h>
#include <Box.h>
#include <Button.h>

#include "AmachiDefs.h"
#include "ParamsSetupView.h"



ParamsSetupView::ParamsSetupView(BRect frm, char* n, uint32 rmode, uint32 f)
:BView(frm, n, rmode, f)
{
	BRect				fr = Bounds();
	BPopUpMenu*			popup_menu;
	BMenuItem*			menu_item;

	// parser block size
	fr.bottom = fr.top + 20.0;

	popup_menu = new BPopUpMenu("pbs_popup", true, true, B_ITEMS_IN_COLUMN);

	menu_item = new BMenuItem("2 K", NULL);
	popup_menu->AddItem(menu_item);
	menu_item = new BMenuItem("4 K", NULL);
	popup_menu->AddItem(menu_item);
	menu_item = new BMenuItem("8 K", NULL);
	popup_menu->AddItem(menu_item);
	menu_item = new BMenuItem("16 K", NULL);
	popup_menu->AddItem(menu_item);
	menu_item = new BMenuItem("32 K", NULL);
	popup_menu->AddItem(menu_item);
	menu_item = new BMenuItem("64 K", NULL);
	popup_menu->AddItem(menu_item);
	popup_menu->ItemAt(0)->SetMarked(true);

	parserBlockSize = new BMenuField(fr, "parserBlockSize", "parser block size: ",
									popup_menu,
									B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW);
	parserBlockSize->SetAlignment(B_ALIGN_RIGHT);
	AddChild(parserBlockSize);


	// max running loaders
	fr.OffsetBy(0.0, fr.Height() + 2.0);

	popup_menu = new BPopUpMenu("mrl_popup", true, true, B_ITEMS_IN_COLUMN);
	menu_item = new BMenuItem("1", NULL);
	popup_menu->AddItem(menu_item);
	menu_item = new BMenuItem("2", NULL);
	popup_menu->AddItem(menu_item);
	menu_item = new BMenuItem("3", NULL);
	popup_menu->AddItem(menu_item);
	menu_item = new BMenuItem("4", NULL);
	popup_menu->AddItem(menu_item);
	menu_item = new BMenuItem("5", NULL);
	popup_menu->AddItem(menu_item);
	popup_menu->ItemAt(0)->SetMarked(true);

	maxRunningParsers = new BMenuField(fr, "maxRunningParsers", "max number of running parsers: ",
										popup_menu,
										B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW);
	maxRunningParsers->SetAlignment(B_ALIGN_RIGHT);
	AddChild(maxRunningParsers);


	// rendering config
	fr.OffsetBy(0.0, fr.Height() + 12.0);
	fr.bottom = fr.top + 155.0;
	fr.InsetBy(5.0, 0.0);

	BBox*				box;
	box = new BBox(fr, "renderConfigBox", B_FOLLOW_LEFT_RIGHT | B_FOLLOW_TOP,
					B_WILL_DRAW | B_FRAME_EVENTS, B_FANCY_BORDER);
	box->SetLabel("Default rendering parameters");

	fr = box->Bounds();
	fr.InsetBy(15.0, 15.0);
	fr.OffsetBy(0.0, 5.0);
	renderConfig = new AmachiGLConfig(fr, "renderConfig",
									B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW);
	box->AddChild(renderConfig);
	AddChild(box);

	// apply button
	fr = box->Frame();
	fr.OffsetBy(0.0, fr.Height() + 5.0);
	fr.right = fr.left + 45.0;
	fr.bottom = fr.top + 20.0;
	applyParams = new BButton(fr, "appliParams", "Apply",
								new BMessage(AMACHI_PREFS_MSG),
								B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW);
	AddChild(applyParams);


	fr = ChildAt(0)->Frame();
	for (int32 i = 1; i < CountChildren(); i++)
		fr = fr | ChildAt(i)->Frame();
	ResizeTo(fr.Width(), fr.Height());
}


ParamsSetupView::~ParamsSetupView()
{
}


void
ParamsSetupView::ReadFrom(GLconfig& conf)
{
	renderConfig->ReadFrom(conf);
}


void
ParamsSetupView::ReadFrom(BMessage* msg)
{
	int32				n;

	renderConfig->ReadFrom(msg);

	msg->FindInt32("parserBlockSize", &n);
	n = (n >> 10) - 2;
	parserBlockSize->Menu()->ItemAt(n)->SetMarked(true);

	msg->FindInt32("maxRunningParsers", &n);
	n--;
	maxRunningParsers->Menu()->ItemAt(n)->SetMarked(true);
}


void
ParamsSetupView::WriteTo(GLconfig& conf)
{
	renderConfig->WriteTo(conf);
	renderConfig->SetEnabled(true);
}


void
ParamsSetupView::WriteTo(BMessage* msg)
{
	int32				n;

	renderConfig->WriteTo(msg);

	n = parserBlockSize->Menu()->IndexOf(parserBlockSize->Menu()->FindMarked());
	n = 1 << (10+n+1);
	msg->AddInt32("parserBlockSize", n);

	n = maxRunningParsers->Menu()->IndexOf(maxRunningParsers->Menu()->FindMarked());
	n++;
	msg->AddInt32("maxRunningParsers", n);
}


void
ParamsSetupView::AttachedToWindow()
{
	renderConfig->SetTarget(this);
	renderConfig->EnableAll();
	applyParams->SetTarget(this);
}


void
ParamsSetupView::MessageReceived(BMessage* msg)
{
	int32			n;
	BMessage			msg2(AMACHI_PREFS_MSG);
	GLconfig			config;

	switch (msg->what)
	{
		case AMACHI_PREFS_MSG:
			WriteTo(&msg2);
			be_app->PostMessage(&msg2);
			break;

		case SETUP_PARSER_BLOCK:
			msg->FindInt32("size", &n);
			printf("parser block size: %d\n", n);
			break;

		case SETUP_MAX_PARSERS:
			msg->FindInt32("count", &n);
			printf("max running parsers: %d\n", n);
			break;

		default:
			BView::MessageReceived(msg);
			break;
	}
}
