//
//
//	IOB objects parser
//
//										(C) JoOl 1998


#ifndef _PARSER_IOB_H_
#define _PARSER_IOB_H_


#include "LAPbinParser.h"
#include "PierrotParser.h"



class						ParserIob : public LAPbinParser, public PierrotParser
{

	enum
	{
		CHUNK_FORM						= 'FORM',
		CHUNK_TDDD						= 'TDDD',
		CHUNK_OBJ						= 'OBJ ',
			OBJ_DESC					= 'DESC',
				DESC_NAME				= 'NAME',
				DESC_SHAPE				= 'SHAP',
				DESC_SHAPE2				= 'SHP2',
					SHAPE_SPHERE				= 0,
					SHAPE_AXIS					= 2,
					SHAPE_GROUND				= 5,
					SHAPE_LAMP_POSITIONNAL		= 0x01,
					SHAPE_LAMP_DIRECTIONAL		= 0x02,
					SHAPE_LAMP_ROUND_SHAPE		= 0x04,
					SHAPE_LAMP_RECT_SHAPE		= 0x08,
					SHAPE_LAMP_NO_LENS_FLARE	= 0x10,
					SHAPE_LAMP_DIMINISH			= 0x20,	// 1/r dominishing intensity
					SHAPE_LAMP_FALLOFF			= 0x40,
					SHAPE_LAMP_CAST_SHADOWS		= 0x80,
				DESC_POSITION			= 'POSI',
				DESC_AXIS				= 'AXIS',
				DESC_SIZE				= 'SIZE',
				DESC_BBOX				= 'BBOX',
				DESC_STND				= 'STND',
					STND_STATE_ID		= 'STID',
						STID_AXIS		= 0x01,
						STID_SHAPE		= 0x02,
						STID_COLOR		= 0x04,
					STND_STATE_DATA		= 'STDT',
						STDT_AXIS				= 101,
						STDT_POINT				= 102,
						STDT_PATH				= 103,
						STDT_AXIS_SIZE			= 104,
						STDT_FACE_COLOR			= 105,
						STDT_FACE_TRANSMISSION	= 106,
						STDT_FACE_REFLECTIVITY	= 107,
						STDT_ATTRIBUTE			= 108,
				DESC_POINTS					= 'PNTS',
				DESC_EDGES					= 'EDGE',
				DESC_FACES					= 'FACE',
				DESC_PTH2					= 'PTH2',
				DESC_OBJ_COLOR				= 'COLR',
				DESC_OBJ_REFLECTIVITY		= 'REFL',
				DESC_OBJ_TRANSPARENCY		= 'TRAN',
				DESC_OBJ_SPECULARITY		= 'SPC1',
				DESC_FACES_COLOR			= 'CLST',
				DESC_FACES_REFLECTIVITY		= 'RLST',
				DESC_FACES_TRANSPARENCY		= 'TLST',
				DESC_TEXTURE				= 'TXT3',
				DESC_BRUSH					= 'BRS4',
				DESC_FOG_LENGTH				= 'FOGL',
				DESC_OBJ_PROPERTIES			= 'PRP1',
				DESC_INTENSITY				= 'INT1',
				DESC_ANID					= 'ANID',
				DESC_FORM					= 'FOR2',
				DESC_PART					= 'PART',
					PART_TYPE				= 'PTFN',
					PART_FACE_GROUP			= 'FGR2',
				DESC_BIG_BONE				= 'BBSG',
				DESC_SMALL_BONE				= 'SBSG',
				DESC_EDGES_FLAG				= 'ELFG',
		CHUNK_TOBJ						= 'TOBJ'
	};


	virtual status_t		_Identify();
	virtual status_t		_Parse();
	virtual void			_Terminate();
	virtual status_t		DoAbort();


#define ReadChunkId										\
	uint32			chunkId;							\
	ReadInt32(chunkId)

#define ReadChunkLen									\
	uint32			chunkLen;							\
	ReadInt32(chunkLen)
#define ReadChunk										\
	ReadChunkId;										\
	ReadChunkLen
#define skipChunk										\
	SkipChunk(chunkId, chunkLen)
#define PadChunk										\
	if (chunkLen & 0x01)								\
	{													\
		SkipBytes(1);									\
		currLen++;										\
	}

#define Assert(location, exp)							\
	if (len != exp)										\
		throw LAPmismatchLength(location, exp, len)

	void					SkipChunk(uint32 , uint32 );
	void					ReadFract(float& );
	void					ReadColor(pSpectra& );
	void					ReadPaddedColor(pColor& );
	void					ReadPoint(pPoint3& );
	void					ReadVector(pVector3& );
	void					ReadMatrix(pMatrix3& );

	void					ReadMainChunk(uint32 );
		void					ReadObjectChunk(uint32 );
			void					ReadDescChunk(uint32 );
				void					ReadNameChunk(uint32 , char* );
				void					ReadShapeChunk(uint32 );
				void					ReadPositionChunk(uint32 , pObject* );
				void					ReadAxisChunk(uint32 , pObject* );
/*				void					ReadStateNameDataChunk(uint32 );
					void					ReadStateIdChunk(uint32 );
					void					ReadStateDataChunk(uint32 );
						void					ReadFacesProperty(uint32 );
						void					ReadObjectProperties(uint32 );
*/				void					ReadPointsChunk(uint32 , pObject* );
				void					ReadEdgesChunk(uint32 , pObject* );
				void					ReadFacesChunk(uint32 , pObject* );
				void					ReadFacesColorChunk(uint32 , pObject* );
				void					ReadFacesReflectivityChunk(uint32 , pObject* );
				void					ReadFacesTransparencyChunk(uint32 , pObject* );
				void					ReadObjectPropertiesChunk(uint32 );
				void					ReadIntensityChunk(uint32 , pSpectra& );


	void					CheckMaterials();

	pMaterial*				SearchMaterial(pSpectra& );
	pMaterial*				SearchMaterial(pSpectra& , pSpectra& );
	pMaterial*				SearchMaterial(pSpectra& , pSpectra& , pSpectra& );
	pMaterial*				defaultMaterial;


public:

							ParserIob(int32 );
	virtual					~ParserIob();
};


#if __POWERPC__
#pragma export on
#endif
extern "C" ParserIob*		instantiate_parser(int32 );
#if __POWERPC__
#pragma export reset
#endif


#endif	/* _PARSER_IOB_H_ */

