//
//
//	PLY objects parser
//
//										(C) JoOl 1998


#ifndef _PARSER_PLY_H_
#define _PARSER_PLY_H_


#include "LAPbinParser.h"
#include "PierrotParser.h"
#include "LAPlexemeTable.h"


class						ParserPly : public LAPbinParser, public PierrotParser
{
	enum
	{
		TOKEN_PLY			= LAP_TOKEN_LAST,
		TOKEN_FORMAT,
			TOKEN_ASCII,
			TOKEN_BIG_ENDIAN,
			TOKEN_LITTLE_ENDIAN,
		TOKEN_COMMENT,
		TOKEN_ELEMENT,
			TOKEN_VERTEX,
			TOKEN_FACE,
		TOKEN_PROPERTY,
			TOKEN_X,
			TOKEN_Y,
			TOKEN_Z,
			TOKEN_LIST,
			TOKEN_CHAR,
			TOKEN_UCHAR,
			TOKEN_INT16,
			TOKEN_UINT16,
			TOKEN_INT32,
			TOKEN_UINT32,
			TOKEN_FLOAT,
			TOKEN_DOUBLE,
		TOKEN_END_HEADER,
		TOKEN_IDENTIFIER,
		TOKEN_NUMBER
	};

	// if countType = -1, it's a regular property
	// else, it's a list property
	class plyProperty
	{
	public:
		int32		countType;
		char*		name;
		int32		type;

		plyProperty(char* n, int32 t)
		{
			countType = -1;
			name = strdup(n);
			type = t;
		};
		plyProperty(int32 ct, char* n, int32 t)
		{
			countType = ct;
			name = strdup(n);
			type = t;
		};
		~plyProperty()
		{ delete[] name; };

		bool			IsList()
		{ return countType != -1; };
	};

	class plyElement
	{
	public:
		char*				name;
		int32				nb;
		PierrotArray<plyProperty* >	properties;

		plyElement(char* n)
		: properties(8, 4)
		{ name = strdup(n); };
		~plyElement()
		{ delete[] name; };
	};

	char*					typeString[8];
	LAPlexemeTable			lexemes;
	PierrotPtrArray<plyElement* >*	elements;

	plyElement*				currentElement;
	pMaterial*				defaultMaterial;


	int32					format;
	float					version;

	char					buffer[128];
	int32					ReadWord();
	void					SkipLine();

	int32					SizeOf(int32 );
	int32					SizeOf(plyProperty* , int32 );
	void					SkipElement(plyElement* );
	void					SkipProperty(plyProperty* );
	void					ReadProperty(int32 , int32& );
	void					ReadProperty(plyProperty* , int32& );
	void					ReadProperty(plyProperty* , float& );

	// private parsing methods
	status_t				ParseHeader();
		void					ParseFormat();
		void					ParseElement();
		void					ParseProperty();
	void					ParseObject();
	void					ParseVertices(pObject* , plyElement* );
		void					ParseVertex(plyElement* , pPoint3& );
	void					ParseFaces(pObject* , plyElement* );
		void					ParseFace(plyElement* , pFace*& );

	virtual status_t		_Identify();
	virtual status_t		_Parse();
	virtual void			_Terminate();
	virtual status_t		DoAbort();


public:

							ParserPly(int32 );
	virtual					~ParserPly();
};


#if __POWERPC__
#pragma export on
#endif
extern "C" ParserPly*		instantiate_parser(int32 );
#if __POWERPC__
#pragma export reset
#endif


#endif	/* _PARSER_PLY_H_ */
