//
//
//	Test application
//
//										(C) JoOl 1998


#include <SupportDefs.h>
#include <OS.h>
#include <image.h>
#include <stdio.h>
#include <unistd.h>
#include "LAPparser.h"
#include "LAPerrors.h"


image_id				LoadAddOn(char* );
int						main(int , char** );


image_id				LoadAddOn(char* p)
{
	if (*p == '/')
		return load_add_on(p);

	char				path[256];
	getcwd(path, 256);
	strcat(path, "/");
	strcat(path, p);
	return load_add_on(path);
}


int
main(int argc, char** argv)
{
	if (argc < 2)
	{
		printf("Usage: %s [-s] <Amachi add-on> <files>\n", argv[0]);
		return -1;
	}

	int32				index = 1;
	bool				screenOutput = false;
	if (!strcmp(argv[index], "-s"))
	{
		screenOutput = true;
		index++;
	}

	image_id		addOn;
	char*			hname;
	char*			hversion;
	char*			hauthor;
	char*			hemail;
	LAPparser*		(*hconstructor)(int32 , LAPtracer* );

	addOn = LoadAddOn(argv[index]);		//load_add_on(argv[1]);
	if (addOn < 0)
	{
		printf("Can't load add-on '%s'\n", argv[index]);
		return -1;
	}
	if (get_image_symbol(addOn, "handlerName", B_SYMBOL_TYPE_DATA, &hname) != B_NO_ERROR)
	{
		printf("%s is not an Amachi add-on, 'handlerName' missing\n", argv[1]);
		return -1;
	}
	if (get_image_symbol(addOn, "handlerVersion", B_SYMBOL_TYPE_DATA, &hversion) != B_NO_ERROR)
	{
		printf("%s is not an Amachi add-on, 'handlerVersion' missing\n", argv[1]);
		return -1;
	}
	if (get_image_symbol(addOn, "handlerAuthor", B_SYMBOL_TYPE_DATA, &hauthor) != B_NO_ERROR)
	{
		printf("%s is not an Amachi add-on, 'handlerAuthor' missing\n", argv[1]);
		return -1;
	}
	if (get_image_symbol(addOn, "handlerEmail", B_SYMBOL_TYPE_DATA, &hemail) != B_NO_ERROR)
	{
		printf("%s is not an Amachi add-on, 'handlerEmail' missing\n", argv[1]);
		return -1;
	}
	if (get_image_symbol(addOn, "instantiate_parser", B_SYMBOL_TYPE_TEXT, &hconstructor) != B_NO_ERROR)
	{
		printf("%s is not an Amachi add-on, 'instantiate_parser' missing\n", argv[1]);
		return -1;
	}

	printf("add-on name: %s\n", hname);
	printf("add-on version: %s\n", hversion);
	printf("add-on author: %s\n", hauthor);
	printf("add-on email: %s\n", hemail);


	LAPparser*			p = hconstructor(2048, NULL);
	int32				errorCount = 0;

	for (int32 i = index+1; i < argc; i++)
	{
		printf("__ processing %s\n", argv[i]);
		entry_ref	ref;
		BEntry		entry(argv[i], false);
		entry.GetRef(&ref);

		status_t	st = p->SetInput(ref, screenOutput ? LAP_NO_TRACE : LAP_TRACE);
		if (st == LAP_NO_ERROR)
		{
			if (screenOutput)
				p->GetTraceOutput()->SetScreenOutput();
			st = p->Parse();
			if (st != LAP_NO_ERROR)
			{
				printf("  ***__ parse error: %d\n", st);
				errorCount++;
			}
			else
				printf("  __ done\n");
		}
		else
		{
			printf("  ***__ Can't set input: error code %d\n", st);
			errorCount++;
		}
	}

	printf("__ %d entries parsed, %d errors\n", argc - index-1, errorCount);

	delete p;
}
