//
//
//	LAP buffered-output class
//
//											(C) JoOl 1998


#include "LAPimpexp.h"

#include <new.h>
#include "LAPbufferedOutput.h"
#include "LAPerrors.h"
#include "LAPmemoryException.h"



LAPbufferedOutput::LAPbufferedOutput(int32 bufSize, uint8 opolicy, uint8 oflags)
: LAPdynBuffer(bufSize)
{
	silent = false;
	policy = opolicy;
	outputs = oflags & ~(LAP_BUFFER_FILE_OUTPUT | LAP_BUFFER_BHANDLER_OUTPUT);
	outputMessenger = NULL;
	outputMessage = NULL;

	msgType = LAP_NO_MESSAGE;
	// status set in LAPbuffer::LAPbuffer
}


LAPbufferedOutput::~LAPbufferedOutput()
{
	SetNoOutput();
}


void
LAPbufferedOutput::badWrite(char* str, int32 len)
{
	(policy == LAP_BUFFER_GROW_ON_OVERFLOW)
	? LAPdynBuffer::_badWrite(str, len)		// dynamic buffer
	: LAPbuffer::_badWrite(str, len);		// static buffer
}



void
LAPbufferedOutput::SetSilent(bool b)
{
	silent = b;
}


bool
LAPbufferedOutput::IsSilent() const
{
	return silent;
}


void
LAPbufferedOutput::SetMessageType(LAPmessageType mt)
{
	msgType = mt;
}


uint8
LAPbufferedOutput::GetOutputs() const
{
	return outputs;
}


status_t
LAPbufferedOutput::SetNoOutput()
{
	UnsetFileOutput();
	UnsetBHandlerOutput();
	outputs = LAP_BUFFER_NO_OUTPUT;
	return LAP_NO_ERROR;
}


status_t
LAPbufferedOutput::SetScreenOutput()
{
	outputs |= LAP_BUFFER_SCREEN_OUTPUT;
	return LAP_NO_ERROR;
}


void
LAPbufferedOutput::UnsetScreenOutput()
{
	outputs &= ~LAP_BUFFER_SCREEN_OUTPUT;
}


status_t
LAPbufferedOutput::SetFileOutput(char* file, uint32 flags)
{
	UnsetFileOutput();
	outputFile.SetTo(file, flags);
	if (outputFile.InitCheck() != B_NO_ERROR)
		return LAP_CANT_OPEN_FILE;
	outputs |= LAP_BUFFER_FILE_OUTPUT;
	return LAP_NO_ERROR;
}


void
LAPbufferedOutput::UnsetFileOutput()
{
	if (outputs & LAP_BUFFER_FILE_OUTPUT)
	{
		outputFile.Unset();
		outputs &= ~LAP_BUFFER_FILE_OUTPUT;
	}
}


status_t
LAPbufferedOutput::SetBHandlerOutput(BHandler* h, BLooper* l, BMessage* m)
{
	try
	{
		UnsetBHandlerOutput();

		status_t			s;
		outputMessenger = new BMessenger(h, l, &s);
		if (s != B_NO_ERROR)
			return LAP_BAD_VALUE;
		outputs |= LAP_BUFFER_BHANDLER_OUTPUT;
		outputMessage = new BMessage(*m);
		outputMessage->AddInt32("msg_type", msgType);

		char*			ptr;
		if (outputMessage->FindString("buffer", &ptr) != B_NO_ERROR)
			outputMessage->AddString("buffer", "");//NULL);
		int32			len;
		if (outputMessage->FindInt32("buffer_length", &len) != B_NO_ERROR)
			outputMessage->AddInt32("buffer_length", 0);
		return LAP_NO_ERROR;
	}
	catch (bad_alloc )
	{
		return LAP_BAD_ALLOC;
	}
}


void
LAPbufferedOutput::UnsetBHandlerOutput()
{
	if (outputs & LAP_BUFFER_BHANDLER_OUTPUT)
	{
		delete outputMessenger;
		delete outputMessage;
		outputs &= ~LAP_BUFFER_BHANDLER_OUTPUT;
	}
}


status_t
LAPbufferedOutput::_Append(char* str, int32 len)
{
	try
	{
		LAPbuffer::Append(str, len);
		return LAP_NO_ERROR;
	}
	catch (LAPbadBufferWrite& e)
	{
		if (policy == LAP_BUFFER_ERROR_ON_OVERFLOW)
		{
			e.where = "LAPbufferedOutput::Append";
			throw ;
		}
		return LAP_BUFFER_OVERFLOW;
	}
}


void
LAPbufferedOutput::Append(char* str, int32 len)
{
	if (silent)
		return ;

	status_t		s = _Append(str, len);
	if (s != LAP_BUFFER_OVERFLOW)
		return ;

	// Append by pieces
	while (len > 0)
	{
		AppendWhatFits(str, len);
		if (IsFull())
		{
			int32		l;
			char*		ptr = (char* )GetBuffer(l);
			Output(ptr, l);
			Reset();
		}
	}
}


void
LAPbufferedOutput::Output(char* str, int32 len)
{
	if (silent)
		return ;

	if (outputs & LAP_BUFFER_SCREEN_OUTPUT)
		OutputScreen(str, len);
	if (outputs & LAP_BUFFER_FILE_OUTPUT)
		OutputFile(str, len);
	if (outputs & LAP_BUFFER_BHANDLER_OUTPUT)
		OutputBHandler(str, len);
}


status_t
LAPbufferedOutput::OutputFile(char* str, int32 len)
{
	char*			header = NULL;
/*	if (msgType == LAP_ERROR_MESSAGE)
		header = "error: ";
	else if (msgType == LAP_WARNING_MESSAGE)
		header = "warning: ";
	else if (msgType == LAP_INFO_MESSAGE)
		header = "info: ";
*/
	if (header)
		outputFile.Write((void* )header, strlen(header));
	if (outputFile.Write((void* )str, len) != len)
		return LAP_BAD_WRITE;
	return LAP_NO_ERROR;
}


status_t
LAPbufferedOutput::OutputBHandler(char* str, int32 len)
{
	outputMessage->ReplaceString("buffer", str);
	outputMessage->ReplaceInt32("buffer_length", len);
	outputMessage->ReplaceInt32("msg_type", msgType);
	if (outputMessenger->SendMessage(outputMessage) != B_NO_ERROR)
		return LAP_ERROR;
	return LAP_NO_ERROR;
}

