//
//
//	LAP text data buffered-output class
//
//											(C) JoOl 1998



#include "LAPimpexp.h"

#include "LAPtextBufferedOutput.h"
#include "LAPerrors.h"



LAPtextBufferedOutput::LAPtextBufferedOutput(int32 bufSize, uint8 p, uint8 f)
: LAPbufferedOutput(bufSize, p, f)
{
	indentSize = 2;
	margin = 0;
	headerGenerated = false;
	for (int32 i = 0; i < LAP_BUFFER_TEXT_SPACES; i++)
		Spaces[i] = ' ';
	Spaces[LAP_BUFFER_TEXT_SPACES] = 0;
}


LAPtextBufferedOutput::~LAPtextBufferedOutput()
{
	*this << flush;
}


void
LAPtextBufferedOutput::GenerateLineHeader()
{
	headerGenerated = true;
	_GenerateLineHeader();
}


void
LAPtextBufferedOutput::_GenerateLineHeader()
{
	GenerateSpaces(margin);
}



void
LAPtextBufferedOutput::GenerateSpaces(int32 n)
{
	// Generate spaces
	int32			Nb = n >> LAP_BUFFER_TEXT_SPACESBITS;
	for (int32 i = 0; i < Nb; i++)
		Append(Spaces, LAP_BUFFER_TEXT_SPACES);

	Nb = n & (LAP_BUFFER_TEXT_SPACES-1);
	Append(Spaces+LAP_BUFFER_TEXT_SPACES-Nb, Nb);
}


int32
LAPtextBufferedOutput::GetIndentSize() const
{
	return indentSize;
}


void
LAPtextBufferedOutput::SetIndentSize(int32 i)
{
	indentSize = max_c(i, 0);
}


int32
LAPtextBufferedOutput::SetMargin(int32 lm)
{
	int32			formerLm = margin;
	margin = max_c(0, lm);
	return formerLm;
}


void
LAPtextBufferedOutput::ResetMargin(int32 lm)
{
	margin = max_c(0, lm);
}


void
LAPtextBufferedOutput::AdvanceMargin()
{
	margin += indentSize;
}


void
LAPtextBufferedOutput::RetreatMargin()
{
	if (margin < indentSize)
		margin = 0;
	else
		margin -= indentSize;
}


const char*
LAPtextBufferedOutput::GetBuffer()
{
	int32				len;
	char*				ptr = (char* )LAPbuffer::GetBuffer(len);
	ptr[len] = 0;
	return (const char* )ptr;
}


char*
LAPtextBufferedOutput::Detach()
{
	int32			len;
	char*			ptr = LAPbuffer::Detach(len);
	ptr[len] = 0;
	return ptr;
}


LAPtextBufferedOutput&
LAPtextBufferedOutput::operator<<(char In)
{
	if (!silent)
	{
		if (!headerGenerated)
			GenerateLineHeader();
		Append(&In, 1);
	}
	return *this;
}


LAPtextBufferedOutput&
LAPtextBufferedOutput::operator<<(uchar In)
{
	if (!silent)
	{
		if (!headerGenerated)
			GenerateLineHeader();

		sprintf(tmp, "%02x", In);
		Append(tmp, 2);
	}
	return *this;
}


LAPtextBufferedOutput&
LAPtextBufferedOutput::operator<<(int16 In)
{
	if (!silent)
		*this << int32(In);
	return *this;
}


LAPtextBufferedOutput&
LAPtextBufferedOutput::operator<<(uint16 In)
{
	if (!silent)
	{
		if (!headerGenerated)
			GenerateLineHeader();

		sprintf(tmp, "%04x", In);
		Append(tmp, 4);
	}
	return *this;
}


LAPtextBufferedOutput&
LAPtextBufferedOutput::operator<<(int32 In)
{
	if (!silent)
	{
		if (!headerGenerated)
			GenerateLineHeader();

		sprintf(tmp, "%d", In);
		Append(tmp, strlen(tmp));
	}
	return *this;
}


LAPtextBufferedOutput&
LAPtextBufferedOutput::operator<<(uint32 In)
{
	if (!silent)
	{
		if (!headerGenerated)
			GenerateLineHeader();

		sprintf(tmp, "%08x", In);
		Append(tmp, 8);
	}
	return *this;
}


LAPtextBufferedOutput&
LAPtextBufferedOutput::operator<<(int64& In)
{
	if (!silent)
	{
		if (!headerGenerated)
			GenerateLineHeader();

		sprintf(tmp, "%Ld", In);
		Append(tmp, strlen(tmp));
	}
	return *this;
}


LAPtextBufferedOutput&
LAPtextBufferedOutput::operator<<(uint64& In)
{
	if (!silent)
	{
		if (!headerGenerated)
			GenerateLineHeader();

		sprintf(tmp, "%016Lx", In);
		Append(tmp, 16);
	}
	return *this;
}


LAPtextBufferedOutput&
LAPtextBufferedOutput::operator<<(float In)
{
	if (!silent)
	{
		if (!headerGenerated)
			GenerateLineHeader();

		sprintf(tmp, "%f", In);
		Append(tmp, strlen(tmp));
	}
	return *this;
}


LAPtextBufferedOutput&
LAPtextBufferedOutput::operator<<(double& In)
{
	if (!silent)
	{
		if (!headerGenerated)
			GenerateLineHeader();

		sprintf(tmp, "%g", In);
		Append(tmp, strlen(tmp));
	}
	return *this;
}


LAPtextBufferedOutput&
LAPtextBufferedOutput::operator<<(char* In)
{
	if (!silent)
	{
		if (!headerGenerated)
			GenerateLineHeader();

		if (!In)
			Append("<nil>", 5);
		else
			Append(In, strlen(In));
	}
	return *this;
}


LAPtextBufferedOutput&
LAPtextBufferedOutput::operator<<(const char* In)
{
	return *this << (char*)In;
}


LAPtextBufferedOutput&
LAPtextBufferedOutput::operator<<(void* In)
{
	if (!silent)
	{
		if (!headerGenerated)
			GenerateLineHeader();

		sprintf(tmp, "%p", In);
		Append(tmp, strlen(tmp));
	}
	return *this;
}


LAPtextBufferedOutput&
LAPtextBufferedOutput::operator<<(LAPbufferFlush& /*eb*/)
{
	int32			len;
	char*			ptr = (char* )LAPbuffer::GetBuffer(len);
	if ((!silent) && (len > 0))
	{
		Output(ptr, len);
		headerGenerated = false;
	}
	Reset();
	return *this;
}


LAPtextBufferedOutput&
LAPtextBufferedOutput::operator<<(LAPbufferEol& /*el*/)
{
	if (!silent)
	{
		// Don't generate the header if the buffer is empty
		if (GetLength() < 1)
			headerGenerated = true;
		*this << '\n';
		headerGenerated = false;
	}
	return *this;
}


LAPtextBufferedOutput&
LAPtextBufferedOutput::operator<<(LAPbufferAdvance& /*ad*/)
{
	if (!silent)
		AdvanceMargin();
	return *this;
}


LAPtextBufferedOutput&
LAPtextBufferedOutput::operator<<(LAPbufferRetreat& /*rt*/)
{
	if (!silent)
		RetreatMargin();
	return *this;
}


LAPtextBufferedOutput&
LAPtextBufferedOutput::operator<<(LAPnoMessage& )
{
	msgType = LAP_NO_MESSAGE;
	return *this;
}


LAPtextBufferedOutput&
LAPtextBufferedOutput::operator<<(LAPerrorMessage& )
{
	msgType = LAP_ERROR_MESSAGE;
	return *this;
}


LAPtextBufferedOutput&
LAPtextBufferedOutput::operator<<(LAPwarningMessage& )
{
	msgType = LAP_WARNING_MESSAGE;
	return *this;
}


LAPtextBufferedOutput&
LAPtextBufferedOutput::operator<<(LAPinfoMessage& )
{
	msgType = LAP_INFO_MESSAGE;
	return *this;
}


status_t
LAPtextBufferedOutput::OutputScreen(char* str, int32 len)
{
/*	if (msgType == LAP_ERROR_MESSAGE)
		printf("error: ");
	else if (msgType == LAP_WARNING_MESSAGE)
		printf("warning: ");
	else if (msgType == LAP_INFO_MESSAGE)
		printf("info: ");
*/
	str[len] = 0;
	printf("%s", str);
	return LAP_NO_ERROR;
}

