//
//
//	LAP display class
//
//										(C) JoOl 1998


#ifndef _LAP_DISPLAY_H_
#define _LAP_DISPLAY_H_

#include "LAPsymbolTable.h"
#include "LAPparserException.h"
#include "LAPmemoryException.h"


class					LAPdisplay
{
	// Stack of symbol tables
	BList				stack;

public:

//#if __POWERPC__
#pragma export on
//#endif
						LAPdisplay();
						~LAPdisplay();

	bool				IsEmpty() const;
	int32				GetCurrentLevel() const;
	LAPsymbolTable*		GetScope(int32 ) const; // throw (LAPbadScope);
	LAPsymbolTable*		GetCurrentScope() const; // throw (LAPbadScope);
	LAPsymbolTable*		GetGlobalScope() const; // throw (LAPbadScope);

	LAPsymbolTable*		EnterScope(); // throw (LAPbadAlloc);
	LAPsymbolTable*		EnterLocalScope(); // throw (LAPbadAlloc);
	LAPsymbolTable*		ExitScope(); // throw (LAPbadScope);

	LAPsymbol*			Search(char* ) const; // throw (LAPbadScope);
	LAPsymbol*			SearchLocal(char* ) const; // throw (LAPbadScope);
	status_t			Insert(LAPsymbol* ); // throw (LAPbadScope);

//#if __POWERPC__
#pragma export reset
//#endif
};


#endif	/* _LAP_DISPLAY_H_ */
