//
//
//	LAP name-indexed table class
//
//										(C) JoOl 1998


#include "LAPimpexp.h"

#include "LAPtable.h"
#include "LAPerrors.h"



LAPtable::LAPtable(LAPtableCmpFunc c)
{
	searchedName = NULL;
	cmpFunc = c;
}



LAPtable::~LAPtable()
{
}


int32
LAPtable::SearchRecur(int32 i, int32 j) const
{
	int32			k = (i+j) >> 1;
	void*			Elt = table.ItemAt(k);
	int32			Cmp = cmpFunc(Elt, searchedName);

	if (i == j)
	{
		if (Cmp == 0)
			return k;			// found!
		// Return the negated rank where the item should be inserted
		if (Cmp < 0)
			return -k-2;
		return -k-1;
	}
	if (Cmp < 0)
		return SearchRecur(k+1, j);
	return SearchRecur(i, k);
}


int32
LAPtable::RankOf(char* n)
{
	if (!n)
		return -1;
	if (table.CountItems() < 1)
		return -1;

	searchedName = n;
	return SearchRecur(0, table.CountItems()-1);
}


int32
LAPtable::CountItems() const
{
	return table.CountItems();
}


void*
LAPtable::ItemAt(int32 i) const
{
	return table.ItemAt(i);
}


void
LAPtable::MakeEmpty()
{
	table.MakeEmpty();
}


void*
LAPtable::Search(char* n)
{
	int32		Rank = RankOf(n);
	if (Rank < 0)
		return NULL;
	return table.ItemAt(Rank);
}


status_t
LAPtable::Insert(char* n, void* s)
{
	int32			Rank = RankOf(n);
	if (Rank >= 0)
		return LAP_SYMBOL_ALREADY_DEFINED;
	table.AddItem(s, -Rank-1);
	return LAP_NO_ERROR;
}

