//
//
//	LAP symbol table class
//
//										(C) JoOl 1998


#include "LAPimpexp.h"

#include "LAPsymbolTable.h"
#include "LAPerrors.h"



LAPsymbolTable::LAPsymbolTable(LAPsymbolTable* p)
: LAPtable(LAPsymbolCmpFunc)
{
	parent = p;
}


LAPsymbolTable::~LAPsymbolTable()
{
	for (int32 i = 0; i < table.CountItems(); i++)
		delete (LAPsymbol* )table.ItemAt(i);
	table.MakeEmpty();
}


int32
LAPsymbolTable::LAPsymbolCmpFunc(void* e, char* n)
{
	return strcmp(((LAPsymbol* )e)->GetName(), n);
}


void
LAPsymbolTable::SetParent(LAPsymbolTable* p)
{
	parent = p;
}


LAPsymbol*
LAPsymbolTable::SearchLocal(char* n)
{
	return (LAPsymbol* )LAPtable::Search(n);
}


LAPsymbol*
LAPsymbolTable::Search(char* n)
{
	LAPsymbol*		s = (LAPsymbol* )LAPtable::Search(n);
	if (s != NULL)
		return s;
	if (!parent)
		return NULL;
	// Recursively search in parent symbol tables
	return parent->Search(n);
}


status_t
LAPsymbolTable::Insert(LAPsymbol* s)
{
	if (!s)
		return LAP_BAD_VALUE;
	return LAPtable::Insert(s->GetName(), s);
}
