//
//
//	Pierrot color (no alpha component)
//
//										(C) JoOl 1998


#ifndef _PIERROT_COLOR_H_
#define _PIERROT_COLOR_H_


#include <SupportDefs.h>
#include "PierrotGeometry.h"


class pColor;


//--------------------------------------------------------
// RGB spectra
//--------------------------------------------------------

class					pSpectra
{
public:

	float				r, g, b;

#pragma export on
						pSpectra();
						pSpectra(float , float , float );
						pSpectra(pSpectra& );
						pSpectra(pColor& );
						~pSpectra();

	void				Set(float , float , float );
	void				Set(pSpectra& );
	void				Set(pColor& );
	bool				Eq(pSpectra& , float = PIERROT_EPSILON);

	void				Clamp(float , float );
	float				GreyLevel();

	pSpectra&			operator*=(float );
	pSpectra&			operator/=(float );
	pSpectra			operator*(float );
	pSpectra			operator/(float );
	pSpectra&			operator+=(pSpectra& );
	pSpectra&			operator-=(pSpectra& );
	pSpectra			operator+(pSpectra& );
	pSpectra			operator-(pSpectra& );

	pSpectra&			operator=(pSpectra& );
	int					operator!=(pSpectra& );
	int					operator==(pSpectra& );

#pragma export reset
};


//--------------------------------------------------------
// RGB color
//--------------------------------------------------------

class					pColor
{
public:

	uint8				r, g, b;

#pragma export on
						pColor();
						pColor(uint8 , uint8 , uint8 );
						pColor(pColor& );
						pColor(pSpectra& );
						~pColor();

	void				Set(uint8 , uint8 , uint8 );
	void				Set(pSpectra& );
	void				Set(pColor& );
	bool				Eq(pColor& , float = PIERROT_EPSILON);

	void				Clamp(uint8 , uint8 );
	uint8				GreyLevel();

	pColor&				operator=(pColor& );
	int					operator==(pColor& );
	int					operator!=(pColor& );

#pragma export reset
};


#endif /* _PIERROT_COLOR_H_ */
