//
//
//	Pierrot pointer array
//
//											(C) JoOl 1998


#ifndef _PIERROT_PTR_ARRAY_H_
#define _PIERROT_PTR_ARRAY_H_


#include <SupportDefs.h>
#include <malloc.h>
#include <string.h>
#include <stdio.h>


//-----------------------------------------------
// base class
//-----------------------------------------------

class						PierrotPtrArrayBase
{
protected:
	typedef int				ppabCmpFunc(void* , void* );

	void**					items;
	int32					nbItems;
	int32					blockSize;
	int32					nbSlots;

	void					Grow(int32 );

public:

#pragma export on

							PierrotPtrArrayBase();
							PierrotPtrArrayBase(int32 , int32 );
	virtual					~PierrotPtrArrayBase();

	void					GrowForItems(int32 );
	void					SetAlloc(int32 , int32 );
	void					DelAlloc();
	bool					IsAllocated() const;

	int32					CountItems() const;
	void					ClearItem(int32 );
	void					ClearItems();
	void*					operator[](int32 );
	void					AddItem(void* );

	int32					Search(ppabCmpFunc , void* );

#pragma export reset

};


//-----------------------------------------------
// template class
//-----------------------------------------------

template <class Item>
class						PierrotPtrArray: public PierrotPtrArrayBase
{
public:
	PierrotPtrArray()
	{};
	PierrotPtrArray(int32 is, int32 bs)
	: PierrotPtrArrayBase(is, bs)
	{};

	virtual					~PierrotPtrArray()
	{
		for (int32 i = 0; i < nbItems; i++)
			if (items[i])
				delete (Item )items[i];
	};

	void					DelItems()
	{
		for (int32 i = 0; i < nbItems; i++)
			if (items[i])
			{
				delete (Item )items[i];
				items[i] = NULL;
			}
		nbItems = 0;
	};

	Item					operator[](int32 index)
	{ return (Item )PierrotPtrArrayBase::operator[](index); };

	void					AddItem(Item item)
	{ PierrotPtrArrayBase::AddItem((void* )item); };
};


#endif /* _PIERROT_PTR_ARRAY_H_ */
