//
//
//	Pierrot 4d geometry
//
//										(C) JoOl 1998


#include "PierrotImpExp.h"

#include <math.h>
#include "PierrotGeometry4.h"
#include "PierrotMatrix4.h"



//--------------------------------------------------------
// 4d position
//--------------------------------------------------------

pPoint4::pPoint4()
{}


pPoint4::pPoint4(float _x, float _y, float _z, float _w)
{ Set(_x, _y, _z, _w); }



pPoint4::pPoint4(pPoint4& p)
{ Set(p.x, p.y, p.z, p.w); }


pPoint4::~pPoint4()
{}


void
pPoint4::Set(float _x, float _y, float _z, float _w)
{
	x = _x;
	y = _y;
	z = _z;
	w = _w;
}


void
pPoint4::Clear()
{
	x = y = z = w = 0.0;
}


pPoint3
pPoint4::Perspective()
{
	if (w != 0.0)
		return pPoint3(x/w, y/w, z/w);
	return pPoint3(x, y, z);
}


pPoint4
pPoint4::operator*(float s)
{
	return pPoint4(x * s, y * s, z * s, w * s);
}


pPoint4
pPoint4::operator/(float s)
{
	return pPoint4(x / s, y / s, z / s, w / s);
}


float
pPoint4::operator*(pPoint4& p)
{ return x * p.x + y * p.y + z * p.z + w * p.w; }


float
pPoint4::operator*(pVector4& v)
{ return x * v.x + y * v.y + z * v.z + w * v.w; }


pPoint4
pPoint4::operator*(pMatrix4& m)
{
	return pPoint4(	*this * m.GetX(),
					*this * m.GetY(),
					*this * m.GetZ(),
					*this * m.GetW());
}


pPoint4&
pPoint4::operator*=(float s)
{
	x *= s;
	y *= s;
	z *= s;
	w *= s;
	return *this;
}


pPoint4&
pPoint4::operator*=(pMatrix4& m)
{
	pPoint4		res(*this * m.GetX(),
					*this * m.GetY(),
					*this * m.GetZ(),
					*this * m.GetW());
	*this = res;
	return *this;
}


pPoint4&
pPoint4::operator/=(float s)
{
	x /= s;
	y /= s;
	z /= s;
	w /= s;
	return *this;
}


pPoint4
pPoint4::operator+(pPoint4& p)
{
	return pPoint4(x + p.x, y + p.y, z + p.z, w + p.w);
}


pPoint4
pPoint4::operator+(pVector4& v)
{
	return pPoint4(x + v.x, y + v.y, z + v.z, w + v.w);
}


pPoint4&
pPoint4::operator+=(pPoint4& p)
{
	x += p.x;
	y += p.y;
	z += p.z;
	w += p.w;
	return *this;
}


pPoint4&
pPoint4::operator+=(pVector4& v)
{
	x += v.x;
	y += v.y;
	z += v.z;
	w += v.w;
	return *this;
}


pPoint4
pPoint4::operator-(pPoint4& p)
{
	return pPoint4(x - p.x, y - p.y, z - p.z, w - p.w);
}


pPoint4
pPoint4::operator-(pVector4& v)
{
	return pPoint4(x - v.x, y - v.y, z - v.z, w - v.w);
}


pPoint4&
pPoint4::operator-=(pPoint4& p)
{
	x -= p.x;
	y -= p.y;
	z -= p.z;
	w -= p.w;
	return *this;
}


pPoint4&
pPoint4::operator-=(pVector4& v)
{
	x -= v.x;
	y -= v.y;
	z -= v.z;
	w -= v.w;
	return *this;
}


pPoint4&
pPoint4::operator=(pPoint4& p)
{
	x = p.x;
	y = p.y;
	z = p.z;
	w = p.w;
	return *this;
}


pPoint4&
pPoint4::operator=(pVector4& v)
{
	x = v.x;
	y = v.y;
	z = v.z;
	w = v.w;
	return *this;
}


int
pPoint4::operator==(pPoint4& v)
{
	return (x == v.x) && (y == v.y) && (z == v.z) && (w == v.w);
}


int
pPoint4::operator!=(pPoint4& v)
{
	return (x != v.x) || (y != v.y) || (z != v.z) || (w != v.w);
}



//--------------------------------------------------------
// 3d vector
//--------------------------------------------------------

pVector4::pVector4()
{}


pVector4::pVector4(float _x, float _y, float _z, float _w)
{ Set(_x, _y, _z, _w); }


pVector4::pVector4(pPoint4& a, pPoint4& b)
{ Set(a, b); }


pVector4::pVector4(pVector4& v)
{ Set(v.x, v.y, v.z, v.w); }


pVector4::~pVector4()
{}


void
pVector4::Set(float _x, float _y, float _z, float _w)
{
	x = _x;
	y = _y;
	z = _z;
	w = _w;
}


void
pVector4::Set(pPoint4& a, pPoint4& b)
{
	x = b.x - a.x;
	y = b.y - a.y;
	z = b.z - a.z;
	w = b.w - a.w;
}


void
pVector4::Clear()
{
	x = y = z = w = 0.0;
}


pVector3
pVector4::Perspective()
{
	if (w != 0.0)
		return pVector3(x/w, y/w, z/w);
	return pVector3(x, y, z);
}


float
pVector4::Length2() const
{
	return x * x + y * y + z * z + w * w;
}


float
pVector4::Length() const
{
	return sqrt(x * x + y * y + z * z + w * w);
}


void
pVector4::Norm()
{
	float			n = Length();
	x /= n;
	y /= n;
	z /= n;
	w /= n;
}


pVector4
pVector4::operator*(float s)
{
	return pVector4(x * s, y * s, z * s, w * s);
}


pVector4
pVector4::operator/(float s)
{
	return pVector4(x / s, y / s, z / s, w / s);
}


float
pVector4::operator*(pPoint4& p)
{ return x * p.x + y * p.y + z * p.z + w * p.w; }


float
pVector4::operator*(pVector4& v)
{ return x * v.x + y * v.y + z * v.z + w * v.w; }


pVector4
pVector4::operator*(pMatrix4& m)
{
	return pVector4(*this * m.GetX(),
					*this * m.GetY(),
					*this * m.GetZ(),
					*this * m.GetW());
}


pVector4&
pVector4::operator*=(float s)
{
	x *= s;
	y *= s;
	z *= s;
	w *= s;
	return *this;
}


pVector4&
pVector4::operator*=(pMatrix4& m)
{
	pPoint4		res(*this * m.GetX(),
					*this * m.GetY(),
					*this * m.GetZ(),
					*this * m.GetW());
	*this = res;
	return *this;
}


pVector4&
pVector4::operator/=(float s)
{
	x /= s;
	y /= s;
	z /= s;
	w /= s;
	return *this;
}


pVector4
pVector4::operator+(pPoint4& p)
{
	return pVector4(x + p.x, y + p.y, z + p.z, w + p.w);
}


pVector4
pVector4::operator+(pVector4& v)
{
	return pVector4(x + v.x, y + v.y, z + v.z, w + v.w);
}


pVector4&
pVector4::operator+=(pPoint4& p)
{
	x += p.x;
	y += p.y;
	z += p.z;
	w += p.w;
	return *this;
}


pVector4&
pVector4::operator+=(pVector4& v)
{
	x += v.x;
	y += v.y;
	z += v.z;
	w += v.w;
	return *this;
}


pVector4
pVector4::operator-(pPoint4& p)
{
	return pVector4(x - p.x, y - p.y, z - p.z, w - p.w);
}


pVector4
pVector4::operator-(pVector4& v)
{
	return pVector4(x - v.x, y - v.y, z - v.z, w - v.w);
}


pVector4&
pVector4::operator-=(pPoint4& p)
{
	x -= p.x;
	y -= p.y;
	z -= p.z;
	w -= p.w;
	return *this;
}


pVector4&
pVector4::operator-=(pVector4& v)
{
	x -= v.x;
	y -= v.y;
	z -= v.z;
	w -= v.w;
	return *this;
}


pVector4&
pVector4::operator=(pPoint4& p)
{
	x = p.x;
	y = p.y;
	z = p.z;
	w = p.w;
	return *this;
}


pVector4&
pVector4::operator=(pVector4& v)
{
	x = v.x;
	y = v.y;
	z = v.z;
	w = v.w;
	return *this;
}


int
pVector4::operator==(pVector4& v)
{
	return (x == v.x) && (y == v.y) && (z == v.z) && (w == v.w);
}


int
pVector4::operator!=(pVector4& v)
{
	return (x != v.x) || (y != v.y) || (z != v.z) || (w != v.w);
}
