/*	ess.h
	Decalarations for ESS 1869 function calls.
	Manuel Costa
	3-31-2005*/

#ifndef ESS_H
#define ESS_H

#define DMA_TRANSFER_SIZE			2*B_PAGE_SIZE
#define ESS_DELAY					3

/*port offsets*/
#define ESS_RESET					0x6
#define ESS_READ_BUFFER_STATUS		0xe
#define ESS_READ_DATA				0xa
#define ESS_WRITE_BUFFER_STATUS		0xc
#define ESS_WRITE_DATA				0xc
#define ESS_REG						0x4
#define ESS_DATA					0x5

/*commands*/
#define ESS_EXTENDED				0xc6

/*mixer commands*/
#define ESS_ADC_GAIN				0x69
#define ESS_MIC_GAIN				0x68
#define ESS_CD_OUT_GAIN				0x38
#define ESS_MIDI_OUT_GAIN			0x3a
#define ESS_LINE_OUT_GAIN			0x3e
#define ESS_DAC_OUT_GAIN			0x36

typedef struct dma_buffer {
	char *data;
	int32 size;
	area_id area;
	} dma_buffer;

dma_buffer write_buffer, read_buffer;
struct isa_module_info *isamod_info;
int dma8;

#endif
