#ifndef ATARIMEMTEST_H
#define ATARIMEMTEST_H


// AtariMemTest.h
// Implementation for the AtariMemTest class

// Jon Pimble, fatrat@fat-rat.com
// Last revised: 2002.05.30


// This is a very silly screensaver for BeOS; it draws a screensaver that looks
//  like the memory test on 8-bit Atari XL/XE computers.



#include <stdlib.h>
#include <sys/types.h>
#include <time.h>

#include <ScreenSaver.h>
#include <StringView.h>
#include <View.h>



// Credits, version number, etc.
#define AT_TITLE_STRING "Atari XL/XE Memory Test"
#define AT_SUBTITLE_STRING "(Yes, this is a joke!)"
#define AT_VERSION_STRING "Version 1.0 --- 2002.05.30"
#define AT_CREDITS_STRING "Jon Pimble - fatrat@fat-rat.com"


// Screen size (in pixels) for the actual Atari framebuffer
#define ATARI_WIDTH 320
#define ATARI_HEIGHT 192


// Chances of a bank of memory being bad (1 in X, where X is ATARI_FAIL_CHANCE)
#define ATARI_FAIL_CHANCE 100


// Info for the font
#define ATFONT_NUM_CHARS 16
#define ATFONT_NUM_ROWS 8

// Character-to-data LUT is defined by #define statements in AtariMemTest,h
//  Characters needed:   A E H I L M O P R S T X Y + 3 funky (16 in all)
#define ATFONT_CHAR_A 0
#define ATFONT_CHAR_E 1
#define ATFONT_CHAR_H 2
#define ATFONT_CHAR_I 3
#define ATFONT_CHAR_L 4
#define ATFONT_CHAR_M 5
#define ATFONT_CHAR_O 6
#define ATFONT_CHAR_P 7
#define ATFONT_CHAR_R 8
#define ATFONT_CHAR_S 9
#define ATFONT_CHAR_T 10
#define ATFONT_CHAR_X 11
#define ATFONT_CHAR_Y 12
#define ATFONT_CHAR_SPACE 13
#define ATFONT_CHAR_LT_BAR 14
#define ATFONT_CHAR_RT_BAR 15



// Class is derived from the BScreenSaver base class
class AtariMemTest : public BScreenSaver
{
  private:
    // ROM banks drawn
    int rom_banks_drawn;
    
    // RAM banks drawn
    int ram_banks_drawn;
    
    // ROM status array (are they bad or not)
    char rom_status[2];
    
    // RAM status array (are they bad or not)
    char ram_status[64];

    // Flag needed for special case drawing of final RAM bank
    bool first_loop_flag;

    // Scaling factors, so that this works on any resolution screen
    float x_scale;
    float y_scale;

    
    // (private) Member functions
    // Draws a bitmap charcter at the specified location
    void AtariMemTest::FontPlotter(BView *view, char plot_char,
     bool reverse_video, float x_pos, float y_pos,
     float x_zoom, float y_zoom);
    
    // Data for Atari font characters used
    char *atfont_data;

  public:
    // Constructor
    AtariMemTest( BMessage *archive, image_id image );
    
    // Destructor 
    virtual ~AtariMemTest( void ); 
    
    
    // Virtual function implementations from base class
    virtual void StartConfig( BView *view );
    virtual status_t StartSaver( BView *view, bool preview ); 
    virtual void Draw( BView *view, int32 frame );  
  
};



#endif
