#include <allegro.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <string.h>
#include <time.h>

#define MAXUPDATES 5000
#define MAXPLAYERS 10
#define TANKHEIGHT 20
#define TANKWIDTH 15
#define GUNLENGTH 16
#define MENU 30
#define SKIES 5
#define LANDS 1
#define WEAPONS 19
#define ITEMS 5
#define THINGS WEAPONS+ITEMS
#define RADII 6
#define MAXRADIUS 200
#define BUTTONFRAMES 6
#define EXPLODEFRAMES 18
#define TANKSAG 10
#define MENUBUTTONS 4
#define MISSILEFRAMES 1
#define ACHANGE 256/360
#define INGAMEBUTTONS 3
#define MAX_MISSILES 10
#define SPREAD 10
#define OPTIONS 3
#define BTPS 12
#define SHIELDS 4
#define PARA 4
#define WEAPONSOUNDS 4

typedef struct
{
  int x, y, w, h;
} BOX;

typedef struct
{
  double x, y, xv, yv;
  int t, a, p, no, cw, l, done, money, score, damage, sh, sht, fs, ds, para, pen;
  int nm[WEAPONS], ni[ITEMS];
} TANK;

typedef struct
{
  double x, y, xv, yv;
  int t, a, angle, s, sp;
} MISSILE;

int globalcommand;
int k;
TANK t[MAXPLAYERS];
MISSILE m[MAX_MISSILES];
BOX update[MAXUPDATES], window;
DATAFILE *M, *T, *TITLE, *S, *W, *E, *B, *L, *TG, *MI, *SOUND;
BITMAP *db, *terrain, *sky;
int cclock, updates, z, zz, zzz, z4, z5, z6, fps, frames, players=4, cp, turn, cursky, curland, fi, lx, ly, stopwindow, rounds=5, order[MAXPLAYERS];
double startmoney=100000, turntype=0;
int WHITE, BLACK, PINK, COLOR[MAXPLAYERS];
int height[640], landtable[400];
int steep=2, mheight=200, mbase=0;
double msteep=.2, smooth=.00, gravity=.15;
double slope[360][2];
double interest=1.3;
char name[MAXPLAYERS][11];

char weaponname[WEAPONS][30]={"Small Missile","Medium Missile","Large Missile","Small Nuke","Nuke","Death Head","Small Spread","Medium Spread","Large Spread","Super Spread","Death Spread","Armaggedon","Small Roller","Large Roller","Death Roller","Cluster Bomb","Super Cluster","Funky Bomb","Funky Death"};
int weaponcost[WEAPONS]={0,2000,3000,5000,6000,12000,3000,6000,9000,25000,50000,100000,2000,2000,5000,10000,20000,10000,20000};
int weaponamt[WEAPONS]={0,5,3,2,1,1,3,2,1,1,1,1,3,1,1,3,2,3,1};
int rrindex[WEAPONS]={0,1,2,3,4,5,0,1,2,3,4,5,1,2,3,1,2,1,3};
int etime[WEAPONS]={2,2,3,4,5,6,2,2,3,4,5,6,2,3,4,2,2,0,1};
int damage[WEAPONS]={30,40,60,100,150,200,30,40,60,100,150,200,40,60,100,40,40,20,30};
int eframes[WEAPONS]={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
int picpoint[WEAPONS]={0,1,2,3,4,5,0,1,2,3,4,5,6,6,6,7,7,9,9};
int spread[WEAPONS]={1,1,1,1,1,1,5,5,5,4,3,3,1,1,1,1,1,1,1};

char itemname[ITEMS][30]={"Light Shield","Medium Shield","Large Shield","Deflector Shield","Parachute"};
int itemcost[ITEMS]={10000,20000,30000,40000,5000};
int itemamt[ITEMS]={5,4,3,3,10};
int itemstat[ITEMS]={50,125,200,200,0};

int radius[RADII]={25,40,60,100,150,200};
int blastheight[RADII][(MAXRADIUS*2)+1];
int soundpoint[RADII]={0,0,1,2,2,3};
int winner;
int SHIELDCOLOR[SHIELDS];
char buf[100];

void fpsadd()
{
  fps=frames;
  frames=0;
}

void clockadd()
{
  cclock++;
}

void change(BITMAP *target)
{
  show_mouse(NULL);
  for (z=0; z < 161; z++) {
     blit(target, screen, z*2, 0, z*2, 0, 2, 480);
     blit(target, screen, 639-(z*2), 0, 639-(z*2), 0, 2, 480);
     blit(target, screen, 0, z*1.5, 0, z*1.5, 640, 2);
     blit(target, screen, 0, 480-(z*1.5), 0, 480-(z*1.5), 640, 2);
     rest(5); }
  while (keypressed()) readkey();
}

void credits()
{
  show_mouse(NULL);
  blit(TITLE[0].dat, db, 0, 0, 0, 0, 640, 480);
  textout_centre(db, font, "Atomic Tanks by Stevante Software", 320, 200, makecol16(255, 0, 128));
  textout_centre(db, font, "Programming & Some Graphics: Steve Condie (stevante@yahoo.com)", 320, 210, makecol16(255, 0, 128));
  textout_centre(db, font, "Graphics: Trevor Paulsen (supergass@aol.com)", 320, 220, makecol16(255, 0, 128));
  textout_centre(db, font, "Graphics: Ricky Galati (benogalati@yahoo.com)", 320, 230, makecol16(255, 0, 128));
  textout_centre(db, font, "Allegro v3.11: Shawn Hargreaves (shawn@talula.demon.co.uk)", 320, 240, makecol16(255, 0, 128));
  textout_centre(db, font, "Allegro Website: http://talula.demon.co.uk/allegro/", 320, 250, makecol16(255, 0, 128));
  textout_centre(db, font, "Text Logos: http://www.cooltext.com", 320, 260, makecol16(255, 0, 128));
  change(db);
  show_mouse(screen);
  readkey();
}

void newgame()
{
  char tname[11];
  char ke;

  for (z=0; z < MAXPLAYERS; z++) {
     t[z].pen=0;
     t[z].para=0;
     t[z].fs=0;
     t[z].sht=0;
     t[z].ds=0;
     t[z].sh=0;
     t[z].x=0;
     t[z].y=0;
     t[z].xv=0;
     t[z].yv=0;
     t[z].t=0;
     t[z].a=0;
     t[z].p=0;
     t[z].no=z;
     t[z].cw=0;
     t[z].money=startmoney;
     t[z].score=0;
     t[z].damage=0;
     for (zz=0; zz < WEAPONS; zz++) t[z].nm[zz]=0;
     for (zz=0; zz < ITEMS; zz++) t[z].ni[zz]=0;
     for (zz=0; zz < 10; zz++) name[z][zz]=z+65;
     name[z][10]=0;
     t[z].nm[0]=99;
  }

  show_mouse(NULL);
  clear(db);
  draw_sprite(db, M[2].dat, 270, 215);
  textprintf(db, font, 280, 225, BLACK, "Player %d:", 1);
  change(db);
  show_mouse(screen);

  for (z=0; z < players; z++) {
     ke=0;
     for (zz=0; zz < 11; zz++) tname[zz]=0;
     if (z) {
        draw_sprite(screen, M[2].dat, 270, 215);
        textprintf(screen, font, 280, 225, BLACK, "Player %d:", z+1); }
     //while (ke!=13 ||strlen(tname) < 1) {
        ke=readkey();
        if (ke >= 32 && strlen(tname) < 10) {
           tname[strlen(tname)]=ke;
           textprintf(screen, font, 273+(strlen(tname)*8), 243, COLOR[z], "%c", ke); }
        if (ke==8) {
           tname[strlen(tname)-1]=0;
           rectfill(screen, 281+(strlen(tname)*8), 243, 289+(strlen(tname)*8), 251, WHITE); }
    // }

     for (zz=0; zz < 11; zz++) name[z][zz]=tname[zz];
  }

}

void do_updates()
{
  for (z=0; z < updates && z < MAXUPDATES; z++)
     blit(db, screen, update[z].x, update[z].y, update[z].x, update[z].y, update[z].w, update[z].h);
  updates=0;
}

void make_update(int x, int y, int w, int h)
{
  update[updates].x=x;
  update[updates].y=y;
  update[updates].w=w;
  update[updates].h=h;

  if (!stopwindow) {
     if (x < window.x) window.x=x;
     if (y < window.y) window.y=y;
     if (x+w > window.w) window.w=(x+w)-1;
     if (y+h > window.h) window.h=(y+h)-1;
     if (window.x < 0) window.x=0;
     if (window.y < MENU) window.y=MENU;
     if (window.w > 639) window.w=639;
     if (window.h > 479) window.h=479; }

  updates++;
}

void init_game_settings()
{
  allegro_init();
  set_color_depth(16);
  //set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0);
  
  set_gfx_mode(GFX_BEOS_WINDOWED,640,480,0,0);
  install_keyboard();
  install_timer();
  install_mouse();
  install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL);
  install_int_ex(clockadd, BPS_TO_TIMER(100));
  install_int(fpsadd, 1000);
  text_mode(-1);
  srand(time(0));

  WHITE=makecol16(255, 255, 255);
  BLACK=makecol16(0, 0, 0);
  PINK=makecol16(255, 0, 255);

  M=load_datafile("misc.dat");
  T=load_datafile("tank.dat");
  TITLE=load_datafile("title.dat");
  S=load_datafile("sky.dat");
  W=load_datafile("weapon.dat");
  E=load_datafile("explode.dat");
  B=load_datafile("button.dat");
  L=load_datafile("land.dat");
  TG=load_datafile("tankgun.dat");
  MI=load_datafile("missile.dat");
  SOUND=load_datafile("sound.dat");

  db=create_bitmap(640, 480);
  terrain=create_bitmap(640, 480);
  sky=create_bitmap(640, 480-MENU);
  clear_to_color(sky, PINK);
  clear_to_color(db, WHITE);
  clear_to_color(terrain, PINK);
  set_volume(255, 255);

  set_mouse_sprite(M[0].dat);
  set_mouse_sprite_focus(0, 0);

  for (z=0; z < MAXPLAYERS; z++)
     COLOR[z]=makecol16(rand()%255, rand()%255, rand()%255);

  COLOR[0]=makecol16(255, 0, 0);
  COLOR[1]=makecol16(0, 255, 0);
  COLOR[2]=makecol16(0, 0, 255);
  COLOR[3]=makecol16(255, 0, 255);
  COLOR[4]=makecol16(0, 255, 255);
  COLOR[5]=makecol16(128, 128, 0);
  COLOR[6]=makecol16(0, 128, 255);
  COLOR[7]=makecol16(0, 0, 0);
  COLOR[8]=makecol16(255, 128, 128);
  COLOR[9]=makecol16(255, 128, 0);

  SHIELDCOLOR[0]=makecol16(255, 0, 0);
  SHIELDCOLOR[1]=makecol16(0, 255, 0);
  SHIELDCOLOR[2]=makecol16(0, 0, 255);
  SHIELDCOLOR[3]=makecol16(255, 0, 255);

  srand(time(0));

  for (z=0; z < 360; z++) {
     slope[z][0]=sin(z/(180/PI));
     slope[z][1]=cos(z/(180/PI)); }
  slope[270][1]=0;

  window.x=0;
  window.y=0;
  window.w=0;
  window.h=0;
  for (z=0; z < MAXUPDATES; z++) {
     update[z].x=0;
     update[z].y=0;
     update[z].w=0;
     update[z].h=0; }
  for (z=0; z < MAXPLAYERS; z++) {
     t[z].pen=0;
     t[z].para=0;
     t[z].fs=0;
     t[z].sht=0;
     t[z].ds=0;
     t[z].sh=0;
     t[z].x=0;
     t[z].y=0;
     t[z].xv=0;
     t[z].yv=0;
     t[z].t=0;
     t[z].a=0;
     t[z].p=0;
     t[z].no=z;
     t[z].cw=0;
     t[z].money=0;
     t[z].score=0;
     t[z].damage=0;
     for (zz=0; zz < WEAPONS; zz++) t[z].nm[zz]=0;
     for (zz=0; zz < ITEMS; zz++) t[z].ni[zz]=0;
     for (zz=0; zz < 10; zz++) name[z][zz]=0;
     name[z][10]=0;
  }
  for (z=0; z < MAX_MISSILES; z++) {
     m[z].sp=0;
     m[z].s=0;
     m[z].x=0;
     m[z].y=0;
     m[z].xv=0;
     m[z].yv=0;
     m[z].t=0;
     m[z].a=0; }

  for (z=0; z < RADII; z++) {
     clear_to_color(db, BLACK);
     circlefill(db, 320, 240, radius[z], PINK);
     for (zz=320-radius[z], zzz=0; zz <= 320+radius[z]; zz++, zzz++) {
        blastheight[z][zzz]=0;
        for (z4=0; z4 < 480; z4++) {
           if (getpixel(db, zz, z4)==PINK) {
              blastheight[z][zzz]++;
              putpixel(db, zz, z4, WHITE);
           }
        }
     }
  }

}

int ingamemenu()
{
  int button[INGAMEBUTTONS]={205, 230, 255}, pressed, updatew[INGAMEBUTTONS];
  char buttext[INGAMEBUTTONS][10]={"Return", "Main Menu", "Quit"};

  pressed=-1;
  for (z=0; z < INGAMEBUTTONS; z++) updatew[z]=0;

  show_mouse(NULL);

  make_update(220, 190, 200, 100);
  rectfill(db, 220, 190, 419, 289, makecol16(128, 128, 128));
  rect(db, 220, 190, 419, 289, BLACK);

  while (1) {
     if (keypressed()) {
        k=readkey();
        if (k >> 8 == KEY_ESC) return(0); }

     if (mouse_b & 1) {
        zz=0;
        for (z=0; z < INGAMEBUTTONS; z++) {
           if (mouse_x >= 245 && mouse_x < 395 && mouse_y >= button[z] && mouse_y < button[z]+20) {
              zz=1;
              if (pressed > -1) updatew[pressed]=1;
              pressed=z;
              updatew[z]=1;
           }
        }
        if (!zz) {
           if (pressed > -1) updatew[pressed]=1;
           pressed=-1; }
     }

     if (pressed > -1 && !mouse_b & 1) return(pressed);

     for (z=0; z < INGAMEBUTTONS; z++) {
        if (updatew[z]) {
           updatew[z]=0;
           make_update(245, button[z], 150, 20);
        }
     }

     make_update(mouse_x, mouse_y, ((BITMAP *)(M[0].dat))->w, ((BITMAP *)(M[0].dat))->h);
     make_update(lx, ly, ((BITMAP *)(M[0].dat))->w, ((BITMAP *)(M[0].dat))->h);
     lx=mouse_x;
     ly=mouse_y;

     show_mouse(NULL);
     for (z=0; z < INGAMEBUTTONS; z++) {
        draw_sprite(db, M[(pressed==z)?8:7].dat, 245, button[z]);
        textout_centre(db, font, buttext[z], 320, button[z]+6, WHITE); }
     show_mouse(db);

     do_updates();

  }
}

void options()
{
  double *p[OPTIONS]={&gravity, &startmoney, &turntype};
  double inc[OPTIONS]={.05, 5000, 1},
         max[OPTIONS]={.3, 200000, 2},
         min[OPTIONS]={.05, 0, 0},
         defaultv[OPTIONS]={.15, 100000};
  char turntypetext[3][11]={"High+","Low+","Random"};
  char format[OPTIONS][10]={"%2.2f","%2.0f","%s"},
       opname[OPTIONS][20]={"Gravity", "Starting Money", "Turn Order\0"};
  char buff[10];
  int standard[OPTIONS]={1,1,0};
  int done, updateoption[OPTIONS], lb, mouseclock;

  done=lb=mouseclock=cclock=0;
  fi=1;
  for (z=0; z < OPTIONS; z++) updateoption[z]=1;

  while (!keypressed() || fi) {
     while (cclock > 0) {
        cclock--;

        if (!lb && mouse_b & 1) mouseclock=0;
        lb=(mouse_b & 1)?1:0;

        if (mouse_b & 1 && !mouseclock) {
           for (z=0; z < OPTIONS; z++) {
              if (mouse_x >= 382 && mouse_x < 392 && mouse_y >= (z*15)+170 && mouse_y < (z*15)+180) {
                 *p[z]-=inc[z];
                 updateoption[z]=1; }
              if (mouse_x >= 394 && mouse_x < 404 && mouse_y >= (z*15)+170 && mouse_y < (z*15)+180) {
                 *p[z]+=inc[z];
                 updateoption[z]=1; }
              if (mouse_x >= 408 && mouse_x < 438 && mouse_y >= (z*15)+170 && mouse_y < (z*15)+180) {
                 *p[z]=defaultv[z];
                 updateoption[z]=1; }
              if (*p[z] > max[z]) *p[z]=max[z];
              if (*p[z] < min[z]) *p[z]=min[z];
           }
        }

        mouseclock++;
        if (mouseclock > 10) mouseclock=0;
     }

     make_update(mouse_x, mouse_y, ((BITMAP *)(M[0].dat))->w, ((BITMAP *)(M[0].dat))->h);
     make_update(lx, ly, ((BITMAP *)(M[0].dat))->w, ((BITMAP *)(M[0].dat))->h);
     lx=mouse_x;
     ly=mouse_y;

     show_mouse(NULL);
     if (fi) {
        blit(TITLE[1].dat, db, 0, 0, 0, 0, 640, 480);
        draw_sprite(db, TITLE[2].dat, 170, 30);
        for (z=0; z < OPTIONS; z++) {
           sprintf(buff, "%s:", opname[z]);
           textout(db, font, buff, 317-text_length(font, buff), (z*15)+172, WHITE);
           draw_sprite_v_flip(db, M[6].dat, 382, (z*15)+170);
           draw_sprite(db, M[6].dat, 394, (z*15)+170);
           draw_sprite(db, M[10].dat, 408, (z*15)+170);
        }
     }
     for (z=0; z < OPTIONS; z++) {
        if (updateoption[z]) {
           updateoption[z]=0;
           rectfill(db, 323, (z*15)+170, 378, (z*15)+180, WHITE);
           rect(db, 323, (z*15)+170, 378, (z*15)+180, BLACK);
           if (standard[z]) textprintf_centre(db, font, 350, (z*15)+172, BLACK, format[z], *p[z]);
           else {
              if (z==2) textprintf_centre(db, font, 350, (z*15)+172, BLACK, "%s", turntypetext[(int)turntype]);
           }
           make_update(323, (z*15)+170, 55, 10);
        }
     }
     if (fi) {
        fi=0;
        change(db); }
     show_mouse(db);

     do_updates();
  }
}

void title()
{
  if (keypressed()) readkey();
  show_mouse(NULL);
  blit(TITLE[0].dat, screen, 0, 0, 0, 0, 640, 480);
  show_mouse(screen);
  while (!keypressed());
  readkey();
  show_mouse(NULL);
}

void menu()
{
  int bf=0, bfdd=1, ban, anclock, lb, mouseclock, updateplayers, done, updaterounds;
  BOX button[MENUBUTTONS]={{245, 5, 150, 75},{245, 85, 150, 75},{245, 165, 150, 75},{245, 245, 150, 75}};

  ban=-1;
  cclock=updates=lx=ly=anclock=mouseclock=lb=updateplayers=done=updaterounds=0;
  fi=stopwindow=1;

  while (!done) {
     while (cclock > 0) {
        cclock--;

        zz=0;
        for (z=0; z < MENUBUTTONS; z++) {
           if (mouse_x >= button[z].x && mouse_x < button[z].x+button[z].w && mouse_y >= button[z].y && mouse_y < button[z].y+button[z].h) {
              if (ban > -1 && ban!=z) {
                 draw_sprite(db, B[ban*BUTTONFRAMES].dat, button[ban].x, button[ban].y);
                 make_update(button[ban].x, button[ban].y, button[ban].w, button[ban].h); }
              ban=z;
              zz=1;
              anclock++;
              if (anclock > 6) {
                 anclock=0;
                 bf+=bfdd;
                 if (bf > BUTTONFRAMES-2) bfdd=-1;
                 if (bf < 2) bfdd=1; }
              break;
           }
        }
        if (!zz) {
           bf=0;
           bfdd=1; }

        if (!lb && mouse_b & 1) mouseclock=0;
        lb=(mouse_b & 1)?1:0;

        if (mouse_b & 1) {
           for (z=0; z < MENUBUTTONS; z++) {
              if (mouse_x >= button[z].x && mouse_x < button[z].x+button[z].w && mouse_y >= button[z].y && mouse_y < button[z].y+button[z].h) {
                 if (z==0) done=1;
                 if (z==1) globalcommand=1, done=1;
                 if (z==2) globalcommand=2, done=1;
                 if (z==3) globalcommand=-1, done=1;
              }
           }
           if (players > 2 && !mouseclock && mouse_x >= 260 && mouse_x < 270 && mouse_y >= 399 && mouse_y < 409) {
              updateplayers=1;
              players--; }
           if (players < 10 && !mouseclock && mouse_x >= 384 && mouse_x < 394 && mouse_y >= 399 && mouse_y < 409) {
              updateplayers=1;
              players++; }
           if (rounds > 1 && !mouseclock && mouse_x >= 260 && mouse_x < 270 && mouse_y >= 419 && mouse_y < 429) {
              updaterounds=1;
              rounds--; }
           if (rounds < 10 && !mouseclock && mouse_x >= 384 && mouse_x < 394 && mouse_y >= 419 && mouse_y < 429) {
              updaterounds=1;
              rounds++; }
        }

        mouseclock++;
        if (mouseclock > 10) mouseclock=0;
     }

     if (updateplayers) {
        updateplayers=0;
        make_update(347, 398, 32, 12); }
     if (updaterounds) {
        updaterounds=0;
        make_update(347, 418, 32, 32); }

     show_mouse(NULL);
     if (fi) {
        blit(TITLE[1].dat, db, 0, 0, 0, 0, 640, 480);
        textout(db, font, "Players:", 275, 400, BLACK);
        draw_sprite_v_flip(db, M[6].dat, 260, 399);
        draw_sprite(db, M[6].dat, 384, 399);
        textout(db, font, "Rounds: ", 275, 420, BLACK);
        draw_sprite_v_flip(db, M[6].dat, 260, 419);
        draw_sprite(db, M[6].dat, 384, 419);
        for (z=0; z < MENUBUTTONS; z++) draw_sprite(db, B[z*BUTTONFRAMES].dat, button[z].x, button[z].y); }
     if (ban > -1) {
        draw_sprite(db, B[(ban*BUTTONFRAMES)+bf].dat, button[ban].x, button[ban].y);
        make_update(button[ban].x, button[ban].y, button[ban].w, button[ban].h); }
     rectfill(db, 347, 398, 379, 410, WHITE);
     rect(db, 347, 398, 379, 410, BLACK);
     textprintf_centre(db, font, 363, 400, BLACK, "%d", players);
     rectfill(db, 347, 418, 379, 430, WHITE);
     rect(db, 347, 418, 379, 430, BLACK);
     textprintf_centre(db, font, 363, 420, BLACK, "%d", rounds);
     show_mouse(db);

     make_update(mouse_x, mouse_y, ((BITMAP *)(M[0].dat))->w, ((BITMAP *)(M[0].dat))->h);
     make_update(lx, ly, ((BITMAP *)(M[0].dat))->w, ((BITMAP *)(M[0].dat))->h);
     lx=mouse_x;
     ly=mouse_y;

     if (fi) {
        fi=0;
        change(db); }
     do_updates();
  }

  while (keypressed()) readkey();
}

void buystuff()
{
  int pl, done, updatew[THINGS], updatename, pressed, scroll, lb, mouseclock;
  char buf[50];

  updates=cclock=lb=mouseclock=0;
  fi=stopwindow=updatename=scroll=1;

  if (globalcommand!=rounds) {
     for (z=0; z < players; z++) t[z].money*=interest; }

  while (keypressed()) readkey();

  for (pl=0; pl < players; pl++) {
     done=0, updatename=scroll=1, pressed=-1;
     make_update(0, 0, 640, 480);
     show_mouse(NULL);
     blit(TITLE[1].dat, db, 0, 0, 0, 0, 640, 480);
     draw_sprite(db, M[11].dat, 220, 435);
     drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
     for (z=0; z < 120; z++) {
        set_trans_blender(0, 0, 0, (z*2)+15);
        line(db, z, 0, z, 29, COLOR[pl]); }
     for (z=0; z < 120; z++) {
        set_trans_blender(0, 0, 0, (z*2)+15);
        line(db, 639-z, 0, 639-z, 29, COLOR[pl]); }
     solid_mode();
     for (z=0; z < THINGS; z++) updatew[z]=1;

     while (!done) {
        while (cclock > 0) {
           cclock--;
           if (!lb && mouse_b & 1 && mouse_x >= 270 && mouse_x < 370 && mouse_y >= 443 && mouse_y < 458) done=1;

           if (!lb && mouse_b & 1) mouseclock=0;
           lb=(mouse_b & 1)?1:0;

           if (mouse_b & 1 && !mouseclock) {
              if (mouse_x >= 395 && mouse_x < 410 && mouse_y >= 443 && mouse_y < 458 && scroll > 1) {
                 scroll--;
                 for (z=0; z < THINGS; z++) updatew[z]=1;
              }
              if (mouse_x >= 230 && mouse_x < 245 && mouse_y >= 443 && mouse_y < 458 && scroll <= THINGS-BTPS) {
                 scroll++;
                 for (z=0; z < THINGS; z++) updatew[z]=1;
              }
           }

           if (mouse_b & 1) {

              zz=0;
              for (z=1, zzz=scroll; z < BTPS; z++, zzz++) {
                 if (mouse_x >= 120 && mouse_x < 520 && mouse_y >= z*35 && mouse_y < (z*35)+30) {
                    zz=1;
                    if (pressed > -1) updatew[pressed]=1;
                    pressed=zzz;
                    updatew[zzz]=1;
                 }
              }
              if (!zz) {
                 if (pressed > -1) updatew[pressed]=1;
                 pressed=-1;
              }
           }
           if (pressed > -1 && !mouse_b & 1) {
              updatew[pressed]=1;
              if (t[pl].money >= ((pressed > WEAPONS-1)?itemcost[pressed-WEAPONS]:weaponcost[pressed]) && ((pressed > WEAPONS-1)?t[pl].ni[pressed-WEAPONS]:t[pl].nm[pressed]) < 99) {
                 updatename=1;
                 if (pressed > WEAPONS-1) {
                    t[pl].money-=itemcost[pressed-WEAPONS];
                    t[pl].nm[pressed]+=itemamt[pressed-WEAPONS];
                    if (t[pl].ni[pressed-WEAPONS] > 99) t[pl].ni[pressed-WEAPONS]=99;
                 }
                 else {
                    t[pl].money-=weaponcost[pressed];
                    t[pl].nm[pressed]+=weaponamt[pressed];
                    if (t[pl].nm[pressed] > 99) t[pl].nm[pressed]=99;
                 }
              }
              pressed=-1;
           }
           mouseclock++;
           if (mouseclock > 10) mouseclock=0;
        }

        show_mouse(NULL);
        if (fi) {
           for (z=0; z < THINGS; z++) updatew[z]=1; }
        if (updatename) {
           updatename=0;
           make_update(5, 0, 400, 30);
           draw_sprite(db, M[4].dat, 120, 0);
           textprintf(db, font, 165, 5, BLACK, "Player %d: %s", pl+1, name[pl]);
           textprintf(db, font, 165, 17, BLACK, "Money: $%d", t[pl].money);
           sprintf(buf, "Score: %d", t[pl].score);
           textout(db, font, buf, 475-text_length(font, buf), 17, BLACK); }

        for (z=1, zzz=scroll; z < BTPS; z++, zzz++) {
           if (updatew[zzz]) {
              updatew[zzz]=0;
              make_update(120, z*35, 400, 30);
              draw_sprite(db, M[(pressed==zzz)?5:4].dat, 120, z*35);
              if (zzz > WEAPONS-1) {
                 textout(db, font, itemname[zzz-WEAPONS], 165, (z*35)+5, BLACK);
                 textprintf(db, font, 165, (z*35)+17, BLACK, "Qty. in stock: %d", t[pl].ni[zzz-WEAPONS]);
                 sprintf(buf, "$%d", itemcost[zzz-WEAPONS]);
                 textout(db, font, buf, 475-text_length(font, buf), (z*35)+5, BLACK);
                 sprintf(buf, "for %d", itemamt[zzz-WEAPONS]);
                 textout(db, font, buf, 475-text_length(font, buf), (z*35)+17, BLACK);
              }
              else {
                 textout(db, font, weaponname[zzz], 165, (z*35)+5, BLACK);
                 textprintf(db, font, 165, (z*35)+17, BLACK, "Qty. in stock: %d", t[pl].nm[zzz]);
                 sprintf(buf, "$%d", weaponcost[zzz]);
                 textout(db, font, buf, 475-text_length(font, buf), (z*35)+5, BLACK);
                 sprintf(buf, "for %d", weaponamt[zzz]);
                 textout(db, font, buf, 475-text_length(font, buf), (z*35)+17, BLACK);
              }
           }
        }

        make_update(mouse_x, mouse_y, ((BITMAP *)(M[0].dat))->w, ((BITMAP *)(M[0].dat))->h);
        make_update(lx, ly, ((BITMAP *)(M[0].dat))->w, ((BITMAP *)(M[0].dat))->h);
        lx=mouse_x;
        ly=mouse_y;
        show_mouse(db);

        if (fi) {
           change(db);
           fi=0; }
        else
           do_updates();
     }
  }

  while (keypressed()) readkey();
}

void update_tank(TANK *ta, int xext, int yext)
{
  if (!ta->para) make_update((ta->x-GUNLENGTH)-xext, (ta->y-GUNLENGTH)-yext, (GUNLENGTH*2)+1, TANKHEIGHT+GUNLENGTH);
  else make_update((ta->x-GUNLENGTH)-3, (ta->y-25)-yext, 35, 46);
}

void draw_tank(TANK *ta)
{
  int angle;

  line(db, ta->x-(TANKWIDTH-1), (ta->y+TANKHEIGHT)-2, (ta->x+TANKWIDTH)-2, (ta->y+TANKHEIGHT)-2, COLOR[ta->no]);
  draw_sprite(db, T[0].dat, ta->x-TANKWIDTH, ta->y);
  if (ta->sh > 0) {
     set_trans_blender(0, 0, 0, 50+(((float)ta->sh/(float)itemstat[ta->ds])*(float)150));
     draw_trans_sprite(db, T[ta->ds+4].dat, ta->x-TANKWIDTH, ta->y);
     ellipse(db, ta->x, ta->y+(TANKHEIGHT/2), TANKWIDTH-1, (TANKHEIGHT/2)-1, SHIELDCOLOR[ta->ds]);
     ellipse(db, ta->x+1, ta->y+(TANKHEIGHT/2), TANKWIDTH-1, (TANKHEIGHT/2)-1, SHIELDCOLOR[ta->ds]);
     ellipse(db, ta->x-1, ta->y+(TANKHEIGHT/2), TANKWIDTH-1, (TANKHEIGHT/2)-1, SHIELDCOLOR[ta->ds]); }
  angle=(float)(90-ta->a)*((float)256/(float)360);
  rotate_sprite(db, TG[0].dat, ta->x-GUNLENGTH, ta->y-(GUNLENGTH-2), itofix(angle));
  if (ta->para) draw_sprite(db, T[ta->para].dat, (ta->x-TANKWIDTH)-3, ta->y-25);
}

void set_level_settings()
{
  double h, top, bottom, slope;
  int taken[MAXPLAYERS];

  cursky=rand()%SKIES;
  for (z=0; z < 480-MENU; z++)
     line(sky, 0, z, 640, z, getpixel(S[cursky].dat, 0, z));
  curland=rand()%LANDS;
  for (z=0; z < 400; z++)
     landtable[z]=getpixel(L[curland].dat, 0, z);

  show_mouse(NULL);
  draw_sprite(screen, M[1].dat, 200, 435);
  textout_centre(screen, font, "Rendering Landscape", 320, 440, WHITE);

  h=(rand()%(200-mbase))+mbase;
  top=(rand()%mheight)+mheight;
  bottom=(rand()%(200-mbase))+mbase;
  slope=(steep)?((rand()%steep)+1):0;

  clear_to_color(terrain, PINK);

  for (z=0; z < 640; z++) {
     height[z]=h;
     h+=slope;
     if (slope > 0) slope+=smooth;
     if (slope < 0 && slope+smooth < -msteep) slope+=smooth;
//     slope+=smooth;
     if (h > top) slope=-slope;//(steep)?((-(rand()%steep)+1)):0;
     if (h < bottom) {
        top=(rand()%mheight)+mheight;
        bottom=(rand()%(200-mbase))+mbase;
        slope=(steep)?((rand()%steep)+1):0; }
     if (h < 0) h=0;
     for (zz=1; zz <= height[z]; zz++)
        putpixel(terrain, z, 480-zz, landtable[zz]);
  }

  for (z=0; z < MAXPLAYERS; z++) taken[z]=0;

  for (z=0; z < players; z++) {
     for (zz=rand()%players; taken[zz]; zz=rand()%players);
     taken[zz]=1;
     t[z].x=(zz+1)*(640/(players+1));
     t[z].y=(480-height[(int)t[z].x])-(TANKHEIGHT-TANKSAG);
     t[z].a=(18*(z+1))+90;
     t[z].p=500;
     t[z].cw=0;
     t[z].l=100;
     t[z].done=0;
     t[z].fs=0;
     t[z].ds=0;
     t[z].sh=0;
     t[z].sht=0;
  }
  for (z=0; z < MAXPLAYERS; z++) order[z]=0, taken[z]=0;

  if (turntype!=2) {
     zzz=0;
     for (zz=(turntype==1)?0:rounds; zz >= 0 && zz <= rounds; zz+=(turntype==1)?1:-1) {
        if (!(rand()%2)) {
           for (z=0; z < players; z++) {
              if (t[z].score==zz) order[zzz]=z, zzz++;
           }
        }
        else {
           for (z=players-1; z > -1; z--) {
              if (t[z].score==zz) order[zzz]=z, zzz++;
           }
        }
     }
  }
  if (turntype==2) {
     for (z=0; z < players; z++) {
        do {
           order[z]=rand()%players;
        } while (taken[order[z]]);
        taken[order[z]]=1;
     }
  }

}

void do_winner()
{
  int winners[MAXPLAYERS], maxscore, length;
  char winnertext[MAXPLAYERS*15];

  for (z=0; z < MAXPLAYERS; z++) winners[z]=0;
  for (z=0; z < MAXPLAYERS*15; z++) winnertext[z]=0;
  maxscore=0;

  for (z=0; z < players; z++) {
     if (t[z].score==maxscore) winners[z]=1;
     if (t[z].score > maxscore) {
        for (zz=0; zz < players; zz++) winners[zz]=0;
        winners[z]=1;
        maxscore=t[z].score;
     }
  }
  for (z=0; z < players; z++) {
     if (winners[z]) {
        if (winnertext[0]) strcat(winnertext, ", ");
        strcat(winnertext, name[z]);
     }
  }

  length=(text_length(font, winnertext)/2)+10;

  show_mouse(NULL);
  blit(TITLE[1].dat, db, 0, 0, 0, 0, 640, 480);
  draw_sprite(db, M[9].dat, 170, 190);
  rectfill(db, 320-length, 300, 320+length, 315, WHITE);
  rect(db, 320-length, 300, 320+length, 315, BLACK);
  textout_centre(db, font, winnertext, 320, 304, BLACK);
  change(db);
  readkey();
}

void game()
{
  int updatemenu, stage, exclock, calcblow, tanksfall, ax, ay, lax, lay, ad, ap, curexplode, tanklife, tlt, flashdamage[MAXPLAYERS], dclock, mtarrow, mm, am, emis, ca, hit[MAXPLAYERS], realm, marr, lb, mouseclock, aaaa, pclock, ord;
  int blaststart, blastdiameter, th[(MAXRADIUS*2)+1], nh[(MAXRADIUS*2)+1], h[(MAXRADIUS*2)+1], fp[(MAXRADIUS*2)+1], done[(MAXRADIUS*2)+1];
  float distance;
  char lifetext[4];

  buystuff();
  set_level_settings();

  cclock=lx=ly=stage=exclock=calcblow=tanksfall=tlt=updates=dclock=stopwindow=mtarrow=mm=am=ca=realm=marr=lb=mouseclock=aaaa=pclock=ord=0;
  turn=order[ord];
  for (z=0; z < MAX_MISSILES; z++) m[z].a=0;
  curexplode=winner=tanklife=emis=-1;
  fi=updatemenu=1;
  for (z=0; z < MAXPLAYERS; z++) {
     flashdamage[z]=0;
     hit[z]=0; }
  window.x=0;
  window.y=0;
  window.w=639;
  window.h=479;

  ax=lax=t[turn].x-3;
  ay=lay=t[turn].y+15;
  ad=1;
  ap=0;

  while (1) {
     while (cclock > 0) {
        cclock--;

        if (!lb && mouse_b & 1) mouseclock=0;
        lb=(mouse_b & 1)?1:0;

        ap+=ad;
        ay+=ad;
        if (ap > 10) ad=-1;
        if (ap < 0) ad=1;

        if (stage==1 && emis==-1) {
           make_update(lax, lay, ((BITMAP *)(M[3].dat))->w, ((BITMAP *)(M[3].dat))->h);
           z4=0;
           for (z=0; z < am; z++) {
              if (m[z].a==1) {
                 if (!m[z].s) m[z].angle=(atan(m[z].yv/m[z].xv)*(180/PI)*ACHANGE)-64+((m[z].xv<0)?128:0);
                 make_update(m[z].x-25, m[z].y-25, 50, 50);

                 zz=0;

                 if (!m[z].s) {
                    if (m[z].x+m[z].xv < 1 || m[z].x+m[z].xv > 639) m[z].xv=-m[z].xv;
                    else m[z].x+=m[z].xv;
                    if (m[z].y+m[z].yv > 479 && !height[(int)m[z].x]) {
                       m[z].yv=-m[z].yv;
                       if (m[z].yv > -1) zz=1;
                       m[z].yv+=.8; }
                    else {
                       if ((t[turn].cw!=17 && t[turn].cw!=18) || m[0].a) m[z].y+=m[z].yv; }
                    m[z].yv+=gravity;
                 }
                 else {
                    if (t[turn].cw > 11 && t[turn].cw < 15) {
                       if (m[z].s==1) {
                          if (height[(int)m[z].x] < height[(int)m[z].x+1]) m[z].s=2;
                          else m[z].s=3; }
                       if (m[z].s==2) m[z].x--, m[z].angle-=3;
                       if (m[z].s==3) m[z].x++, m[z].angle+=3;
                       if (m[z].x < 1 || m[z].x > 639 || m[z].y > 480-height[(int)m[z].x]) zz=1;
                       else {
                          m[z].y+=3;
                          if (m[z].y > 480-height[(int)m[z].x]) m[z].y=480-height[(int)m[z].x];
                          if (m[z].y > 475 && !zz) m[z].y=475;
                          if (m[z].angle < 0) m[z].angle+=256;
                          if (m[z].angle > 255) m[z].angle-=256;
                       }
                    }
                 }

                 if ((t[turn].cw==17 || t[turn].cw==18) && !m[0].a) zz=1;

                 for (zzz=0; zzz < players; zzz++) {
                    if (!hit[zzz] && m[z].x > t[zzz].x-TANKWIDTH && m[z].x < t[zzz].x+TANKWIDTH && m[z].y > t[zzz].y && m[z].y < t[zzz].y+TANKHEIGHT && t[zzz].l > 0) zz=1, hit[zzz]=1; }

                 if ((m[z].y > 480-height[(int)m[z].x] || zz) && emis==-1) {
                    zzz=0;
                    if (t[turn].cw > 11 && t[turn].cw < 15 && !m[z].s) {
                       zzz=1;
                       if (m[z].x < 1) m[z].x=1;
                       if (m[z].x > 638) m[z].x=638;
                       m[z].s=1;
                       m[z].y=480-height[(int)m[z].x];
                    }
                    if ((t[turn].cw==15 || t[turn].cw==16) && !m[z].sp) {
                       zzz=1;
                       am=6;
                       realm=5;
                       for (zz=0; zz < MAXPLAYERS; zz++) hit[zz]=0;
                       for (zz=0; zz < 5; zz++) {
                          ca=180+((SPREAD*zz)-(SPREAD*1.5));
                          m[zz+1].sp=1;
                          m[zz+1].s=0;
                          m[zz+1].a=1;
                          m[zz+1].x=m[0].x;
                          m[zz+1].y=m[0].y-20;
                          m[zz+1].xv=slope[ca][0]*5;
                          m[zz+1].yv=slope[ca][1]*5;
                          m[zz+1].t=t[turn].cw;
                          make_update(m[zz+1].x-4, m[zz+1].y-4, 8, 8);
                       }
                       m[0].a=0;
                    }
                    if ((t[turn].cw==17 || t[turn].cw==18) && !m[z].sp) {
                       zzz=1;
                       am=10;
                       realm=9;
                       for (zz=0; zz < MAXPLAYERS; zz++) hit[zz]=0;
                       for (zz=0; zz < 9; zz++) {
                          m[zz+1].sp=2;
                          m[zz+1].s=0;
                          m[zz+1].a=1;
                          m[zz+1].x=m[0].x+((rand()%150)-75);
                          m[zz+1].y=m[0].y+((rand()%150)-75);
                          m[zz+1].xv=0;
                          m[zz+1].yv=0;
                          if (m[zz+1].x < 0 || m[zz+1].x > 639 || m[zz+1].y < MENU || m[zz+1].y > 479) m[zz+1].a=0;
                          m[zz+1].t=t[turn].cw;
                          make_update(m[zz+1].x-4, m[zz+1].y-4, 8, 8);
                       }
                       m[0].a=0;
                    }
                    if (!zzz) {
                       realm--;
                       mtarrow=0;
                       emis=z;
                       exclock=500;
                       play_sample(SOUND[WEAPONSOUNDS+soundpoint[rrindex[t[turn].cw]]].dat, 255, 128, 1000, 0);
                    }
                 }
                 else mtarrow=0;
              }
              if (!m[z].a) z4++;
           }

           if (z4==am) {
              am=0;
              tanksfall=0;
              stage=2;
           }
        }

        if (emis >= 0 && m[emis].a <= EXPLODEFRAMES+1) {
           if (m[emis].a==1) {
              for (z=0; z < players; z++) {
                 distance=sqrt(pow(m[emis].x-t[z].x, 2)+pow(m[emis].y-t[z].y, 2));
                 if (distance <= radius[rrindex[t[turn].cw]] && t[z].l > 0) {
                    updatemenu=1;
                    t[z].damage=(float)damage[t[turn].cw]*((float)1-((distance/(float)radius[rrindex[t[turn].cw]])/2));
                    t[z].sh-=t[z].damage;
                    if (t[z].sh < 0) t[z].l+=t[z].sh;
                    flashdamage[z]=1;
                    if (t[z].l < 0) t[z].l=0;
                    if (t[z].sh < 0) t[z].sh=0;
                 }
              }
           }
           exclock++;
           if (exclock > etime[t[turn].cw]) {
              exclock=0;
              m[emis].a++;
              make_update(m[emis].x-radius[rrindex[t[turn].cw]], m[emis].y-radius[rrindex[t[turn].cw]], radius[rrindex[t[turn].cw]]*2, radius[rrindex[t[turn].cw]]*2); }
           if (m[emis].a > EXPLODEFRAMES+1) {
              calcblow=0; }
        }

        if (emis >= 0 && m[emis].a > EXPLODEFRAMES+1) {
           if (!calcblow) {
              circlefill(terrain, m[emis].x, m[emis].y, radius[rrindex[t[turn].cw]], PINK);
              m[emis].x=floor(m[emis].x);
              m[emis].y=floor(m[emis].y);
              blaststart=m[emis].x-radius[rrindex[t[turn].cw]];
              blastdiameter=(radius[rrindex[t[turn].cw]]*2)+1;
              for (z=0, zz=blaststart; z < blastdiameter; z++, zz++) {
                 zzz=0;
                 done[z]=0;
                 if (zz < 0 || zz > 639) {
                    done[z]=1;
                    continue; }
                 th[z]=479-(m[emis].y+(blastheight[rrindex[t[turn].cw]][z]/2));
                 nh[z]=height[zz]-blastheight[rrindex[t[turn].cw]][z];
                 if (th[z] > height[zz]) zzz=1, done[z]=1, th[z]=height[zz];
                 if (th[z] < 0) th[z]=0;
                 if (nh[z] < 0) nh[z]=0;
                 h[z]=height[zz]+1;
                 fp[z]=(m[emis].y-(blastheight[rrindex[t[turn].cw]][z]/2))-(480-height[zz]);
                 if (fp[z] <= 0 && !zzz) {
                    done[z]=1;
                    height[zz]=th[z]; }
                 if (fp[z] > 0 && !zzz) height[zz]=nh[z];
                 if (height[zz] < 0) height[zz]=0;
              }
              calcblow=1;
           }
           zzz=0;
           for (z=0, zz=blaststart; z < blastdiameter; z++, zz++) {
              if (!done[z]) {
                 if (!realm) {
                    make_update(zz, 480-h[z], 1, fp[z]+1);
                    putpixel(terrain, zz, 480-h[z], PINK);
                    putpixel(terrain, zz, (480-h[z])+fp[z]+1, landtable[h[z]-(fp[z]+1)]);
                    h[z]--;
                    if (h[z] == height[zz]) done[z]=1;
                    if (h[z]==fp[z]) done[z]=1, height[zz]=h[z];
                 }
                 else {
                    make_update(zz, 480-h[z], 1, h[z]);
                    done[z]=1;
                    zzz++;
                    line(terrain, zz, 0, zz, 480, PINK);
                    for (z4=1; z4 <= height[zz]; z4++)
                       putpixel(terrain, zz, 480-z4, landtable[z4]);
                 }
              }
              else zzz++;
           }
           if (zzz==blastdiameter) {              
              m[emis].a=0;
              emis=-1; }
        }

        if (stage==2) {
           zz=0;
           for (z=0; z < players; z++) {
              if (!flashdamage[z]) {
                 if (t[z].y < 480-TANKHEIGHT && t[z].y < (480-height[(int)t[z].x])-(TANKHEIGHT-TANKSAG) && t[z].l > 0) {
                    if (t[z].para && t[z].para < 3 && !pclock) t[z].para++;
                    if (!t[z].para) t[z].y++;
                    else t[z].y+=.5;
                    if (!t[z].damage && !t[z].para) {
                       if (t[z].ni[PARA]) {
                          pclock=1;
                          t[z].para=1;
                          t[z].ni[PARA]--;
                       }
                       else t[z].damage=((480-height[(int)t[z].x])-t[z].y)/2;
                    }
                    update_tank(&t[z], 0, 1);
                 }
                 else {
                    zz++;
                    if (t[z].damage && !t[z].pen) {
                       t[z].sh-=t[z].damage;
                       if (t[z].sh < 0) t[z].l+=t[z].sh;
                       flashdamage[z]=1;
                       if (t[z].l < 0) t[z].l=0;
                       if (t[z].sh < 0) t[z].sh=0;
                       t[z].pen=1;
                    }
                    update_tank(&t[z], 0, 0);
                    t[z].para=0;
                 }
              }
           }
           if (zz==players) {
              tanksfall=1;
           }
           zz=0;
           if (tanksfall) {
              for (z=0; z < players; z++) {
                 t[z].pen=0;
                 if (t[z].l > 0 || t[z].done) zz++;
                 else {
                    if (curexplode==-1) {
                       play_sample(SOUND[WEAPONSOUNDS+soundpoint[1]].dat, 255, 128, 1000, 0);
                       exclock=500;
                       curexplode=z;
                       am=1;
                       m[0].x=t[z].x;
                       m[0].y=t[z].y;
                       m[0].a=1;
                       m[0].t=1; }
                    if (curexplode==z) {
                       exclock++;
                       if (exclock > 4) {
                          exclock=0;
                          m[0].a++;
                          make_update(m[0].x-radius[rrindex[m[0].t]], m[0].y-radius[rrindex[m[0].t]], radius[rrindex[m[0].t]]*2, radius[rrindex[m[0].t]]*2); }
                       if (m[0].a > EXPLODEFRAMES+1) {
                          m[0].a=0;
                          zz++;
                          curexplode=-1;
                          t[z].done=1; }
                    }
                 }
              }
           }
           if (zz==players) {
              stage=0;

              winner=-2;
              for (z=0; z < players; z++) {
                 if (t[z].l > 0 && winner >= 0) winner=-1;
                 if (t[z].l > 0 && winner==-2) winner=z; }

              if (winner >= 0) t[winner].score++;

              if (winner==-1) {
                 do {
                    ord++;
                    if (ord > players-1) ord=0;
                    turn=order[ord];
                 } while (t[turn].done);
                 t[turn].fs=0;
              }

              if (winner >= 0 || winner==-2) {
                 stage=3;
                 make_update(220, 140, 201, 201); }

              ax=t[turn].x-3;
              ay=t[turn].y+15;
              ad=1;
              ap=0;
              updatemenu=1; }
        }

        dclock++;
        if (dclock > 2) {
           dclock=0;
           for (z=0; z < players; z++) {
              if (flashdamage[z]) {
                 flashdamage[z]++;
                 if (flashdamage[z] > 25) {
                    t[z].damage=0;
                    flashdamage[z]=0;
                    update_tank(&t[z], 0, 0);
                 }
              }
           }
        }

        pclock++;
        if (pclock > 10) pclock=0;

        if (tanklife > -1 && !stage) {
           tlt-=2;
           make_update(t[tanklife].x-12, t[tanklife].y, 24, 16);
           if (tlt < 100) tanklife=-1; }

        if (!stage && tanklife==-1) {
           for (z=0; z < players; z++) {
              if (t[z].l > 0 && mouse_x > t[z].x-TANKWIDTH && mouse_x < t[z].x+TANKWIDTH && mouse_y > t[z].y && mouse_y < t[z].y+TANKHEIGHT && mouse_b & 1) {
                 tanklife=z;
                 tlt=255;
                 sprintf(lifetext, "%d", t[z].l);
                 break;
              }
           }
        }

        if (!mouseclock && mouse_b & 1 && mouse_x >= 250 && mouse_x < 378 && mouse_y >= 11 && mouse_y < 19) {
           updatemenu=1;
           if (t[turn].fs) t[turn].sht++;
           t[turn].fs=1;
           if (t[turn].sht > SHIELDS-1) t[turn].sht=0; }
        if (!mouseclock && mouse_b & 1 && mouse_x >= 250 && mouse_x < 378 && mouse_y >= 21 && mouse_y < 29 && t[turn].ni[t[turn].sht] > 0 && (t[turn].fs || t[turn].sh > 0)) {
           updatemenu=1;
           update_tank(&t[turn], 0, 0);
           t[turn].ds=t[turn].sht;
           t[turn].ni[t[turn].sht]--;
           t[turn].sh=itemstat[t[turn].sht]; }

        if (key[KEY_F1]) save_bmp("scrnshot.bmp", db, NULL);
        if (!stage && key[KEY_LEFT] && t[turn].a < 270) {
           t[turn].a++;
           updatemenu=1;
           update_tank(&t[turn], 0, 0); }
        if (!stage && key[KEY_RIGHT] && t[turn].a > 90) {
           t[turn].a--;
           updatemenu=1;
           update_tank(&t[turn], 0, 0); }
        if (!stage && key[KEY_DOWN] && t[turn].p > 0) {
           t[turn].p-=5;
           updatemenu=1; }
        if (!stage && key[KEY_UP] && t[turn].p < 1000) {
           t[turn].p+=5;
           updatemenu=1; }

        if (keypressed() && !fi) {
           k=readkey();

           if (k >> 8 == KEY_N) {
              t[turn].a=180;
              updatemenu=1;
              update_tank(&t[turn], 0, 0); }
           if (k >> 8 == KEY_TAB) {
              updatemenu=1;
              while (1) {
                 t[turn].cw++;
                 if (t[turn].cw > WEAPONS-1) t[turn].cw=0;
                 if (t[turn].nm[t[turn].cw]) break;
              }
           }
           if (k >> 8 == KEY_SPACE && !stage && t[turn].nm[t[turn].cw] > 0) {
              play_sample(SOUND[soundpoint[rrindex[t[turn].cw]]].dat, 255, 128, 1000, 0);
              if (t[turn].cw) t[turn].nm[t[turn].cw]--;
              stage=1, aaaa=1;
              am=spread[t[turn].cw];
              realm=am;
              for (z=0; z < MAXPLAYERS; z++) hit[z]=0;
              for (z=0; z < am; z++) {
                 ca=t[turn].a+((SPREAD*z)-(SPREAD*(am-1)/2));
                 m[z].sp=0;
                 m[z].s=0;
                 m[z].a=1;
                 m[z].x=t[turn].x+(slope[ca][0]*GUNLENGTH);
                 m[z].y=t[turn].y+(slope[ca][1]*GUNLENGTH);
                 m[z].xv=slope[ca][0]*t[turn].p/100;
                 m[z].yv=slope[ca][1]*t[turn].p/100;
                 m[z].t=t[turn].cw;
                 make_update(m[z].x-4, m[z].y-4, 8, 8);
              }
           }
           if (k >> 8 == KEY_ESC && !stage) {
              mm=ingamemenu();
              make_update(220, 190, 200, 100);
              if (mm==1) {
                 globalcommand=1;
                 return; }
              if (mm==2) {
                 globalcommand=0;
                 return; }
           }
           if ((k >> 8 == KEY_ENTER || k >> 8 == KEY_ESC || k >> 8 == KEY_SPACE) && stage==3) return;
        }

        mouseclock++;
        if (mouseclock > 10) mouseclock=0;
     }

     frames++;

     if (!stage || mtarrow || aaaa) {
        make_update(ax, ay, ((BITMAP *)(M[3].dat))->w, ((BITMAP *)(M[3].dat))->h);
        make_update(lax, lay, ((BITMAP *)(M[3].dat))->w, ((BITMAP *)(M[3].dat))->h); }
     stopwindow=1;
     make_update(mouse_x, mouse_y, ((BITMAP *)(M[0].dat))->w, ((BITMAP *)(M[0].dat))->h);
     make_update(lx, ly, ((BITMAP *)(M[0].dat))->w, ((BITMAP *)(M[0].dat))->h);
     stopwindow=0;
     lx=mouse_x;
     ly=mouse_y;
     lax=ax;
     lay=ay;

     set_clip(db, 0, 0, 639, 479);

     show_mouse(NULL);
     marr=0;
     if (stage==1) {
        for (z=0; z < am; z++) {
           if (m[z].a && m[z].y < MENU) marr=1; }
     }
     if (marr) make_update(0, MENU, 640, ((BITMAP *)(M[3].dat))->h);
     if (updatemenu) {
        updatemenu=0;
        rectfill(db, 0, 0, 640, MENU-1, makecol16(125, 125, 125));
        line(db, 0, MENU-1, 640, MENU-1, BLACK);
        textout(db, font, name[turn], 1, 1, COLOR[turn]);
        textprintf(db, font, 1, 11, BLACK, "Angle: %d", t[turn].a-90);
        textprintf(db, font, 1, 21, BLACK, "Power: %d", t[turn].p);
        textprintf(db, font, 100, 1, BLACK, "%s: %d", weaponname[t[turn].cw], t[turn].nm[t[turn].cw]);
        textprintf(db, font, 100, 11, BLACK, "Blast Radius: %d", radius[rrindex[t[turn].cw]]);
        textprintf(db, font, 100, 21, BLACK, "Blast Damage: %d", damage[t[turn].cw]);
        textprintf(db, font, 250, 1, BLACK, "Hull Integrity: %d", t[turn].l);
        if (t[turn].sh > 0 || t[turn].fs) {
           sprintf(buf, itemname[t[turn].sht]);
           strcat(buf, ": %d");
           textprintf(db, font, 250, 11, BLACK, buf, t[turn].ni[t[turn].sht]);
           textprintf(db, font, 250, 21, BLACK, "Shield Energy: %d", t[turn].sh); }
        else textout(db, font, "No Shield", 250, 11, BLACK);
        textprintf(db, font, 450, 1, BLACK, "Round %d", (rounds-globalcommand)+1);
        stopwindow=1;
        make_update(0, 0, 640, MENU);
        stopwindow=0; }

     set_clip(db, 0, MENU, 639, 479);

     blit(sky, db, window.x, window.y-MENU, window.x, window.y, (window.w-window.x)+1, (window.h-window.y)+1);
     masked_blit(terrain, db, window.x, window.y, window.x, window.y, (window.w-window.x)+1, (window.h-window.y)+2);

     for (z=0; z < players; z++) {
        if (!t[z].done && z!=curexplode && stage < 3) draw_tank(&t[z]); }
     for (z=0; z < am; z++) {
        if (!m[z].sp) zz=picpoint[t[turn].cw];
        if (m[z].sp==1) zz=8;
        if (m[z].sp==2) zz=10;
        if (m[z].a==1) rotate_sprite(db, MI[zz].dat, m[z].x-20, m[z].y-20, itofix(m[z].angle));
        if (m[z].a > 1 && m[z].a <= EXPLODEFRAMES+1) rotate_scaled_sprite(db, E[(m[z].a+(EXPLODEFRAMES*eframes[m[z].t]))-2].dat, m[z].x-radius[rrindex[m[z].t]], m[z].y-radius[rrindex[m[z].t]], itofix(0), ftofix((double)radius[rrindex[m[z].t]]/107)); }
     for (z=0; z < players; z++) {
        if (flashdamage[z]) {
           textprintf_centre(db, font, t[z].x, t[z].y-3, makecol16(flashdamage[z]*10, 0, 0), "%d", t[z].damage);
           textprintf_centre(db, font, t[z].x, t[z].y+5, makecol16(flashdamage[z]*10, flashdamage[z]*10, flashdamage[z]*10), "%d", t[z].l);
           textprintf_centre(db, font, t[z].x, t[z].y+13, makecol16(0, flashdamage[z]*10, flashdamage[z]*10), "%d", t[z].sh);
           make_update(t[z].x-12, t[z].y-3, 24, 24);
        }
     }
     if (!stage || mtarrow) draw_sprite(db, M[3].dat, ax, ay);
     if (marr) {
        for (z=0; z < am; z++) {
           if (m[z].a && m[z].y < MENU) draw_sprite(db, M[3].dat, m[z].x-3, MENU); }
     }
     if (tanklife > -1 && !stage) {
        textprintf_centre(db, font, t[tanklife].x, t[tanklife].y, makecol16(tlt, tlt, tlt), "%d", t[tanklife].l);
        textprintf_centre(db, font, t[tanklife].x, t[tanklife].y+8, makecol16(0, tlt, tlt), "%d", t[tanklife].sh); }

     if (stage==3) {
        rectfill(db, 220, 140, 420, 340, BLACK);
        rect(db, 220, 140, 420, 340, WHITE);
        if (winner==-2) textout_centre(db, font, "Draw", 320, 150, WHITE);
        else textprintf_centre(db, font, 320, 150, COLOR[winner], "Winner: %s", name[winner]);
        textout_centre(db, font, "Player Scores", 320, 170, WHITE);
        for (z=0; z < players; z++) {
           textprintf(db, font, 230, (z*10)+190, COLOR[z], "%s:", name[z]);
           textprintf(db, font, 330, (z*10)+190, WHITE, "%d", t[z].score); }
     }

     set_clip(db, 0, 0, 639, 479);
     show_mouse(db);

     if (aaaa) aaaa=0;
     if (fi) {
        while (keypressed()) readkey();
        fi=0;
        change(db); }
     else {
        do_updates();

        window.x=640;
        window.y=480;
        window.w=-1;
        window.h=-1;
     }
  }
}



int main(int argc, char *argv[]) {

#ifdef __BEOS__
int counti;
char datapath[256];
for (counti=strlen(argv[0]) ; argv[0][counti]!='/' ; counti--);
strncpy(datapath, argv[0], counti);
chdir(datapath);
#endif

  init_game_settings();
  title();

  while (1) {
     globalcommand=0;
     menu();
     if (globalcommand==-1) break;
     if (globalcommand==1) {
        options();
        continue; }
     if (globalcommand==2) {
        credits();
        continue; }
     newgame();
     for (globalcommand=rounds; globalcommand > 0; globalcommand--) game();
     if (globalcommand==0) do_winner();
     if (globalcommand==-1) break;
  }

  allegro_exit();
  puts("Atomic Tanks, Stevante Software");
}
