/*#############################################
  #  ASIM : Simulateur Apple ][               #
  #                                           #
  #                 App : classe BApplication # 
  #############################################*/

#include <InterfaceKit.h>
#include <StorageKit.h>
#include <AppKit.h>
#include <alloc.h>
#include "asim.h"
#include "asimbe.h"

BRect reFrame=BRect(100,100,380,292);

unsigned char LeMagnifiqueCurseur[]={  16,1,6,6,
	0x00,0x00,	0x1D,0xC0,	0x25,0x20,	0x45,0x10,
	0x48,0x90,	0x70,0x70,	0x00,0x00,	0x70,0x70,
	0x48,0x90,	0x45,0x10,	0x25,0x20,	0x1D,0xC0,
	0x00,0x00,	0x00,0x00,	0x00,0x00,	0x00,0x00,
	0x00,0x00,	0x1D,0xC0,	0x3D,0xE0,	0x7D,0xF0,
	0x78,0xF0,	0x70,0x70,	0x00,0x00,	0x70,0x70,
	0x78,0xF0,	0x7D,0xF0,	0x3D,0xE0,	0x1D,0xC0,
	0x00,0x00,	0x00,0x00,	0x00,0x00,	0x00,0x00,
	
//  0123	4567	89AB	CDEF
// "    	    	    	    " 0 00 00	00 00
// "   #	## #	##  	    " 1 1D C0	1D C0
// "  #.	.# #	..# 	    " 2 25 20	3D E0
// " #..	.# #	...#	    " 3 45 10	7D F0
// " #..	#   	#..#	    " 4 48 90	78 F0
// " ###	    	 ###	    " 5 70 70	70 70
// "    	    	    	    " 6 00 00	00 00
	};

AsimWindow  *winAsim;

BFilePanel *fpDisk=NULL;
BFilePanel *fpGel=NULL,*fpDegel=NULL;

/*++++++++++++++++++++++++++++++++++++++++++
  +  AsimView                              +
  ++++++++++++++++++++++++++++++++++++++++++*/
AsimView::AsimView(BRect frame,const char *name) : BView(frame,name,B_FOLLOW_ALL,B_WILL_DRAW|B_NAVIGABLE|B_PULSE_NEEDED)
{
  // Nada más !
}
//------------------------------------------
void AsimView::Draw(BRect brUp)
{
 if (!bbEcran) return;
 winAsim->Lock();
 DrawBitmap(bbEcran,brUp,brUp);
 winAsim->Unlock();
}
//------------------------------------------
void AsimView::KeyDown(const char* bytes, int32 numBytes)
{
 if (bytes[0]==B_FUNCTION_KEY) {
	BMessage *msg = Window()->CurrentMessage(); 
	if (msg) {
		int32 key=msg->FindInt32("key"); 
		switch (key) {
			case B_F5_KEY: if (!Drive1.PathList) return;
				if (Drive1.NoImage>0) {
					BMessage msg(msgFileBar);
					msg.AddInt16("noimage",Drive1.NoImage-1);
					winAsim->dvDisk1->MessageReceived(&msg);
					}
				break;
			case B_F6_KEY: if (!Drive1.PathList) return;
				if (Drive1.NoImage<(Drive1.NbImages-1)) {
					BMessage msg(msgFileBar);
					msg.AddInt16("noimage",Drive1.NoImage+1);
					winAsim->dvDisk1->MessageReceived(&msg);
					}
				break;
			case B_F7_KEY: if (!Drive2.PathList) return;
				if (Drive2.NoImage>0) {
					BMessage msg(msgFileBar);
					msg.AddInt16("noimage",Drive2.NoImage-1);
					winAsim->dvDisk2->MessageReceived(&msg);
					}
				break;
			case B_F8_KEY: if (!Drive2.PathList) return;
				if (Drive2.NoImage<(Drive2.NbImages-1)) {
					BMessage msg(msgFileBar);
					msg.AddInt16("noimage",Drive2.NoImage+1);
					winAsim->dvDisk2->MessageReceived(&msg);
					}
				break;
			}
		}
 	return;
 	}
 if (KeyPressed(bytes,numBytes))	// Da él carácter al Apple II.
 	BView::KeyDown(bytes,numBytes);
}
//------------------------------------------
void AsimView::MouseMoved(BPoint point,uint32 transit,const BMessage *message)
{
 int32 buttons;
 switch (transit) {
 	case B_INSIDE_VIEW: {
		winAsim->CurrentMessage()->FindInt32("buttons",&buttons);
		mouseX=(int)point.x;
		mouseY=(int)point.y;
		mouseB=buttons;
		} break;
	case B_ENTERED_VIEW:
		be_app->SetCursor((const void *)LeMagnifiqueCurseur);
		break;
	case B_EXITED_VIEW:
		be_app->SetCursor((const void *)B_HAND_CURSOR);
		break;
	}
}
//------------------------------------------
void AsimView::MouseDown(BPoint point)
{
 int32 buttons=0;
 winAsim->CurrentMessage()->FindInt32("buttons",&buttons);
 mouseX=(int)point.x;
 mouseY=(int)point.y;
 mouseB=buttons;
}
//------------------------------------------
void AsimView::Pulse()
{
 winAsim->Lock();
 VideoUpdate();

 if (Drive1.UpTrack) winAsim->dvDisk1->SetTrack(Drive1.HeadTrack);
 if (Drive2.UpTrack) winAsim->dvDisk2->SetTrack(Drive2.HeadTrack);

 if (Drive1.UpMotor) winAsim->dvDisk1->SetLed(Drive1.MotorON);
 if (Drive2.UpMotor) winAsim->dvDisk2->SetLed(Drive2.MotorON);

 winAsim->Unlock();
 Drive1.UpMotor=Drive2.UpMotor=false;
 Drive1.UpTrack=Drive2.UpTrack=false;
}
/*++++++++++++++++++++++++++++++++++++++++++
  +  AsimWindow                            +
  ++++++++++++++++++++++++++++++++++++++++++*/
AsimWindow::AsimWindow() : BWindow(reFrame,"BeApple][",B_TITLED_WINDOW,B_NOT_RESIZABLE)
{
 winAsim=this;
 
 InitBus();
 InitKeyboard();
 InitDisk();
 InitCPU();
 InitGraphic();
 InitSon();

 BRect r=Bounds();
 //------------ 
 mebAsim=new BMenuBar(BRect(Bounds()),"Menu");

 //------------
 BMenu *meL1=new BMenu("File");
   meL1->AddItem(meiDisk1=new BMenuItem("Disk 1 (F5/F6)",new BMessage(msgDisk1),'1',B_COMMAND_KEY));
   meL1->AddItem(meiDisk2=new BMenuItem("Disk 2 (F7/F8)",new BMessage(msgDisk2),'2',B_COMMAND_KEY));
   meL1->AddSeparatorItem();
   meL1->AddItem(new BMenuItem("Freeze state ...",new BMessage(msgGel),'F',B_COMMAND_KEY));
   meL1->AddItem(new BMenuItem("Unfreeze state ...",new BMessage(msgDegel),'U',B_COMMAND_KEY));
   meL1->AddSeparatorItem();
   BMenuItem *meAbo=new BMenuItem("About...",new BMessage(B_ABOUT_REQUESTED),'A',B_COMMAND_KEY);
   meL1->AddItem(meAbo);  meAbo->SetTarget(be_app);
   meL1->AddItem(new BMenuItem("Quit",new BMessage(B_QUIT_REQUESTED),'Q',B_COMMAND_KEY));
 mebAsim->AddItem(meL1);

 BMenu *meL2=new BMenu("Control");
   meL2->AddItem(new BMenuItem("Reset",new BMessage(msgReset),'R',B_COMMAND_KEY));
   meL2->AddItem(new BMenuItem("Init",new BMessage(msgInit),'I',B_COMMAND_KEY));
 mebAsim->AddItem(meL2); 

 BMenu *meL3=new BMenu("Options");
   meL3->AddItem(new BMenuItem("Configuration...",new BMessage(msgConf),'C',B_COMMAND_KEY));
 mebAsim->AddItem(meL3); 

 //------------
 mebAsim->SetTargetForItems(this); mebAsim->ResizeToPreferred();
 AddChild(mebAsim);

 r.top=mebAsim->Bounds().bottom+2; r.bottom=r.top+192+50;
 r.left=0;                       r.right=280;
 ResizeTo(r.right,r.bottom);

 //------------
 dvDisk1=new DiskView(1,BRect(0,r.top,79,r.top+49),"Disk 1");
 AddChild(dvDisk1);
 dvDisk2=new DiskView(2,BRect(80,r.top,159,r.top+49),"Disk 2");
 AddChild(dvDisk2);

 //------------
 bbReset=new BButton(BRect(160,r.top,219,r.top+24),"Reset","Reset",new BMessage(msgReset));
 AddChild(bbReset);
 bbInit =new BButton(BRect(160,r.top+25,219,r.top+49),"Init","Init",new BMessage(msgInit));
 AddChild(bbInit);
 bbConfig=new BButton(BRect(220,r.top,279,r.top+49),"Config...","Config...",new BMessage(msgConf));
 AddChild(bbConfig);
 
 //------------
 r.top+=50;
 avAsim=new AsimView(r,"Ecran");
 AddChild(avAsim);
 avAsim->MakeFocus(true);	// Pour recevoir les évenements clavier
 
 //------------
 ThreadCPU=spawn_thread((thread_func)CPUTask,"CPU6502",10,NULL); /// NORM_PRIO
 //LockCPU=false;
 resume_thread(ThreadCPU);
 SetPulseRate(PULSE_RATE);

}
//------------------------------------------
bool Sniff=false;
extern FILE *Fil;
extern void PrintStat();
void AsimWindow::MessageReceived(BMessage *msg)
{
 switch(msg->what) {
 	case msgConf:
		printf ("Config\n");
		if (!winConfig) {
			winConfig = new ConfigWindow;
			winConfig->Show();
		  }else{
			winConfig->Activate();
			}
		break;
	case msgStop:
		printf ("Stop\n");
		if (ThreadCPU) suspend_thread(ThreadCPU);
		//printf ("Cycles=%Li  Time=%i\n",TimCycles,(int)(real_time_clock_usecs()/1000-StartTime));
		break;
	case msgCont:
		//Sniff=true;
		printf ("Cont\n");
		if (/*(!LockCPU)&&*/(ThreadCPU)) resume_thread(ThreadCPU);
		PrintStat();
		printf ("Cycles=%Li  Time=%i\n",(int64)(TimCycles+FasCycles),(int)(real_time_clock_usecs()/1000-StartTime));
		break;
	case msgDump:
		 StartTime=real_time_clock_usecs()/1000L;

		//Fil=fopen("truc.dum","wb");
		break;
	case msgNoDump:
		fclose(Fil);
		Fil=NULL;
		break;
	case msgInit:
		printf ("INIT !\n");
		//LockCPU=false;
		InitMem();
		InitCPU();
		break;
	case msgReset:
		printf ("RESET !\n");
		//LockCPU=false;
		InterCPU(INTER_RESET);
		break;
	case msgDisk1: {
		Lock();
		BMessage bmFile(msgFileDisk);
		bmFile.AddInt16("lecteur",1);
		printf ("Disk 1\n");
		if (!fpDisk) fpDisk=new BFilePanel(B_OPEN_PANEL,NULL,NULL,B_FILE_NODE,true,NULL,NULL,false,true);
		fpDisk->SetMessage(&bmFile);
		dvDisk1->SetEnabled(false);
		dvDisk2->SetEnabled(false);
		meiDisk1->SetEnabled(false);
		meiDisk2->SetEnabled(false);
		fpDisk->Show();
		Unlock();
		} break;
	case msgDisk2: {
		Lock();
		BMessage bmFile(msgFileDisk);
		bmFile.AddInt16("lecteur",2);
		printf ("Disk 2\n");
		if (!fpDisk) fpDisk=new BFilePanel(B_OPEN_PANEL,NULL,NULL,B_FILE_NODE,true,NULL,NULL,false,true);
		fpDisk->SetMessage(&bmFile);
		dvDisk1->SetEnabled(false);
		dvDisk2->SetEnabled(false);
		meiDisk1->SetEnabled(false);
		meiDisk2->SetEnabled(false);
		fpDisk->Show();
		Unlock();
		} break;
	case msgGel: {
		Lock();
		SwitchCPU(false); // Pause emulation
		BMessage bmFile(msgFileGel);
		if (!fpGel) fpGel=new BFilePanel(B_SAVE_PANEL,NULL,NULL,B_FILE_NODE,false,NULL,NULL,false,true);
		fpGel->SetMessage(&bmFile);
		fpGel->Show();
		Unlock();
		} break;
	case msgDegel: {
		Lock();
		SwitchCPU(false); // Pause emulation
		BMessage bmFile(msgFileDegel);
		if (!fpDegel) fpDegel=new BFilePanel(B_OPEN_PANEL,NULL,NULL,B_FILE_NODE,false,NULL,NULL,false,true);
		fpDegel->SetMessage(&bmFile);
		fpDegel->Show();
		Unlock();
		} break;
	case B_SIMPLE_DATA: {
		printf ("REFS Asim Win \n");
		msg->PrintToStream();
		BMessage mdrag=msg;
		mdrag.what=msgFileDisk;
		mdrag.AddInt16("lecteur",1);
		be_app->PostMessage(&mdrag);
		} break;
	default:
 		BWindow::MessageReceived(msg);
 	}
}
//------------------------------------------
bool AsimWindow::QuitRequested()
{
 if (ThreadCPU) {
	if (ThreadCPU) suspend_thread(ThreadCPU);
	status_t exit;	 
	StopCPU=true;
	wait_for_thread(ThreadCPU,&exit);
	ThreadCPU=0;
	}
 if (fpDisk) delete fpDisk; fpDisk=0;

 be_app->PostMessage(B_QUIT_REQUESTED);
 SaveConfig();

 return(true);
}

/*++++++++++++++++++++++++++++++++++++++++++
  +  AsimApplication                       +
  ++++++++++++++++++++++++++++++++++++++++++*/
AsimApplication::AsimApplication() : BApplication("application/x-vnd.Be-SimApple2")
{
 Lock();
 AsimWindow *AsimWin=new AsimWindow();
 winAbout=NULL;
 winConfig=NULL;
 AsimWin->Show();
 SetCursor((const void *)LeMagnifiqueCurseur);
 Unlock();
}
//------------------------------------------
void AsimApplication::AboutRequested()
{
 	if (!winAbout) {
		winAbout = new AboutWindow;
		winAbout->Show();
	  } else {
		winAbout->Activate();
		}
}
//------------------------------------------
void	AsimApplication::MessageReceived(BMessage *msg)
{
 entry_ref ER;
 switch(msg->what) {
	case msgFileDisk: {	// Retour panneau sélection disque
		if (ThreadCPU) suspend_thread(ThreadCPU);

		int16 L=msg->FindInt16("lecteur");
		DiskView *dvDisk=(L==1)?winAsim->dvDisk1:winAsim->dvDisk2;
		SDrive *sdDrive=((L==1)?&Drive1:&Drive2);

		winAsim->Lock();
		winAsim->dvDisk1->SetEnabled(true);
		winAsim->dvDisk2->SetEnabled(true);
		winAsim->meiDisk1->SetEnabled(true);
		winAsim->meiDisk2->SetEnabled(true);

		sdDrive->FreePlaylist();
		sdDrive->LoadPlaylist(msg);
		dvDisk->SetupAll();
		winAsim->Unlock();
		if (ThreadCPU) resume_thread(ThreadCPU);
		} break;
	case msgFileGel: {
		winAsim->Lock();
		msg->FindRef("directory",0,&ER);
		BEntry Entry(&ER);
		BPath Path;
		Entry.GetPath(&Path);
		Path.Append(msg->FindString("name"));
		printf ("Gel >>>%s\n",Path.Path());		
		Gel(&Path);
		SwitchCPU(true);
		winAsim->Unlock();
		delete fpGel; fpGel=NULL;
		} break;
	case msgFileDegel: {
		winAsim->Lock();
		msg->FindRef("refs",0,&ER);
		BEntry Entry(&ER);
		BPath Path;
		Entry.GetPath(&Path);
		printf ("DeGel >>>%s\n",Path.Path());		
		Degel(&Path);
		SwitchCPU(true);
		winAsim->dvDisk1->SetupAll();
		winAsim->dvDisk2->SetupAll();
		GraphicModeUpdate();
		winAsim->Unlock();
		delete fpDegel; fpDegel=NULL;
		} break;
	case B_CANCEL: { // Cancel
		BFilePanel *fpSrc;
		msg->FindPointer((const char *)"source",(void **)&fpSrc);
		if (fpSrc!=fpDisk) { // Cancel Freezer
			SwitchCPU(true); 
			break; }
		winAsim->Lock(); // Cancel disk
		winAsim->dvDisk1->SetEnabled(true);
		winAsim->dvDisk2->SetEnabled(true);
		winAsim->meiDisk1->SetEnabled(true);
		winAsim->meiDisk2->SetEnabled(true);
	 	winAsim->Unlock();
		} break;
	default:
 		BApplication::MessageReceived(msg);
 	}
}
//------------------------------------------
void AsimApplication::RefsReceived(BMessage *msg) 
{ 
 printf ("REFS Asim App \n");
 msg->PrintToStream();
}

/*++++++++++++++++++++++++++++++++++++++++++
  +  main                                  +
  ++++++++++++++++++++++++++++++++++++++++++*/
int main()
{
 system_info siInfo;
 get_system_info(&siInfo);
printf ("CPU type=%X CPU freq=%iMHz\n",(int)siInfo.cpu_type,(int)(siInfo.cpu_clock_speed/1E6));
 if (siInfo.platform_type==B_APPLE_II_PLATFORM) {
 	printf ("Native Apple ][ computer, emulation unneeded\n"); return 1; }

 LoadConfig();
 
 AsimApplication *AsimApp=new AsimApplication();
 
 AsimApp->Run();
 
 ClearGraphic();
 ClearDisk();
 ClearSon();
 delete AsimApp;
 return 0;
}
