/*#############################################
  #  ASIM : Simulateur Apple ][               #
  #           Header Panneau de configuration #
  #############################################
*/
#include <InterfaceKit.h>

// DISK.CPP
extern bool TurboDisk;
extern bool CycleDisk;
extern int	SectorSkew;

// GRAPHIC.CPP
extern int DisplayModel;// Display type :off, black & dark, unplugged ...
extern int BlinkMax;	// Blink time = BlinkMax*PULSE_RATE

// CPU.CPP
extern int Speed;		// Vitesse CPU (kHz)
extern int LoopCycles;	// Instruction/bloc
extern bool CMOS;				// 6502=false 65C02=true

// BUS.CPP
extern bool JoyControl;
extern float JoyMaximum; // 256 ou 3060

//------------------------------------------
#define msgCPUSlide	 'baCs'
#define msgCPUType	 'baCt'
#define msgDisplay   'baCd'
#define msgDiskTurbo 'baCe'
#define msgDiskCycle 'baCf'
#define msgDiskSkewDOS 'baCg'
#define msgDiskSkewPRODOS 'baCh'
#define msgJoyTime 'baCi'
#define msgJoyIter 'baCj'
#define msgJoyMaxi 'baCk'

/*++++++++++++++++++++++++++++++++++++++++++
  +  CPUConfigView                         +
  ++++++++++++++++++++++++++++++++++++++++++*/

class SpeedSlider : public BSlider
{ 
 public:
    SpeedSlider(BRect frame, char *label, BMessage *msg,int32 min, int32 max); 
    char* UpdateText() const;
 private:
	char Text[64];
}; 

class CPUConfigView : public BView
{
 public:
			CPUConfigView(BRect frame);

 private:
 	BButton *bbMode; // kwa ???
 	BSlider	*bsSpeed;
 	BCheckBox *cbType;
 	
};

/*++++++++++++++++++++++++++++++++++++++++++
  +  VideoConfigView                        +
  ++++++++++++++++++++++++++++++++++++++++++*/
class VideoConfigView : public BView
{
 public:
			VideoConfigView(BRect frame);
	void	VideoDisplay(bool Update);

	BTextControl *tcJoyMaxi;

 private:
 	//BButton *bbCouleur;
 	BMenu		*meMenu;
	BMenuField	*mfField;
 	
 	BMenu		*meDisColor;
 	BMenu		*meDisMono;
 	BMenuItem	*miDisColor;
 	BMenuItem	*miDisColorlow;
 	BMenuItem	*miDisWhite;
 	BMenuItem	*miDisGreen;
 	BMenuItem	*miDisAmber;

	BRadioButton *rbJoyTime;
	BRadioButton *rbJoyValue;
};

/*++++++++++++++++++++++++++++++++++++++++++
  +  DiskConfigView                       +
  ++++++++++++++++++++++++++++++++++++++++++*/
class DiskConfigView : public BView
{
 public:
			DiskConfigView(BRect frame);
 private:
	BCheckBox	*cbTurbo;	// Turbodisk
	BCheckBox	*cbCycle;	// Time regulation
	BRadioButton *rbSkewDOS;
	BRadioButton *rbSkewPRODOS;
};

/*++++++++++++++++++++++++++++++++++++++++++
  +  ConfigWindow                           +
  ++++++++++++++++++++++++++++++++++++++++++*/
class ConfigWindow : public BWindow
{
public:
	ConfigWindow();
	bool	QuitRequested();
	void	MessageReceived(BMessage *msg);

private:
	BButton     *btOK;
	BTabView	*tvTab;

	CPUConfigView	*vCPU;
	VideoConfigView	*vVideo;
	DiskConfigView	*vDisk;

	BBox		*bbSub;
};

//-----------------------

extern int LoadConfig();
extern int SaveConfig();

extern int Gel(BPath *Path);
extern int Degel(BPath *Path);

