/*#############################################
  #  ASIM : Simulateur Apple ][               #
  #                                           #
  #              Header Disk : Gestion disque # 
  #############################################
*/
#include <AppKit.h>

const int SKEW_DOS=0;
const int SKEW_PRODOS=1;
const int SKEW_NIBBLE=2; 

const int DSK_IMAGE=1;
const int NIB_IMAGE=2;

/*++++++++++++++++++++++++++++++++++++++++++
  +  LedView                               +
  ++++++++++++++++++++++++++++++++++++++++++*/
class LedView : public BView
{
 public:
			LedView(int I,BRect frame,const char *name);
		void	Draw(BRect brUp);
		int		State;
 private:
		int		Num;
};

/*++++++++++++++++++++++++++++++++++++++++++
  +  TrackView                             +
  ++++++++++++++++++++++++++++++++++++++++++*/
class TrackView : public BView
{
 public:
			TrackView(int I,BRect frame,const char *name);
		void	Draw(BRect brUp);
		void	TrackMax(int M);
		int		Track;
 private:
		int		Num;
};

/*++++++++++++++++++++++++++++++++++++++++++
  +  DiskView                              +
  ++++++++++++++++++++++++++++++++++++++++++*/
class DiskView : public BView
{
 public:
			DiskView(int I,BRect frame,const char *name);
		void	MessageReceived(BMessage *msg);
		void	Draw(BRect brUp);
		void	SetEnabled(bool enabled);
		
		//void	SetLabel(char *Tex);
		void	SetupAll();
		void	SetTrack(int Track);
		void	SetLed(int Light);
 private:
 	int			Num;
 	BButton		*bbFile;	// PushButton
 	BMenu		*meMenu;
	BMenuField	*mfField;
 	LedView		*lvLed;
 	TrackView	*tvTrack;

 	//	BStringView	*svFile;
};

//############################################################## 

struct SDrive {
	int		LoadPlaylist(BMessage *msg);
	int		FreePlaylist();

	int		ReadImage(BPath *Path);
	int		CloseImage(BPath *Path);

	int		ReadDSKImage(BFile *Fil);
	int		ReadNIBImage(BFile *Fil);
	int		WriteDSKImage(BFile *Fil);
	int		WriteNIBImage(BFile *Fil);
static int	DetectDSKImage(BFile *Fil);
static int	DetectNIBImage(BFile *Fil);
//static int	DetectImage(entry_ref *Ref);

	void	Init(int I);
	
	int		No;					// No Drive ?!?
// Disk II interface
	bool	PH0,PH1,PH2,PH3;	// Stepper motor phases
	int		HeadTrack;			// Head position
	int		HeadPhase;			// Stepping motor phase 
	bool	MotorON;			// Spinning motor
	bool	WriteProtect;		// Guess ...
	bool	LatchInOut;			// DISK II Latch register direction false=input
	uint8	Latch;				// Data latch
	int		Turn;				// Disk position index

// Disquette
	int		ImageType;			// Disk image type :0=None 1=DSK 2=NIB
	int		MaxTrack;			// Number of tracks of the image file
	int		TrackLen;			// Number of bytes per track
	uint8*	Image;				// Disk nibble image
	int		Skew;				// 0=DOS 1=PRODOS 2=??
	
// Disk images files
	int		NbImages;
	BPath	**PathList;			// List of associated file paths
	int		NoImage;			// Numéro image
	bool	UpdateFile;			// Image file has to be written back

// Display update flags
	bool	UpMotor;			// Motor changed
	bool	UpTrack;			// Stepper moved
	bool	UpRead;				// Read occured
	bool	UpWrite;			// Write occured
	};

//############################################################## 
extern SDrive Drive1,Drive2;
extern bool SelDrive;

extern uint8 *DiskImage1, *DiskImage2;

extern void InitDisk();
extern void ClearDisk();
