#include "CodeGenerator.h"

TCodeGenerator::TCodeGenerator(bool CanCreateSourceFile):TObject("TCodeGenerator")
{
	FDebugMode = 1;
	FDebugMessage= "TCodeGenerator ";

	FCanCreateSourceFile = CanCreateSourceFile;
	FHeaderRW = NULL;
	FCPPRW = NULL;
	FAppRW = NULL;
	FMakeRW = NULL;
	FHasBeenGenerated = false;
	FCodeLineList = new TStringList();
}


TCodeGenerator::~TCodeGenerator(void)
{	
	ShowDebug("TCodeGenerator destructor");
	if (FHeaderRW!=NULL) {delete FHeaderRW;}
	if (FCPPRW!=NULL) {delete FCPPRW;}
	if (FAppRW!=NULL) {delete FAppRW;}
	if (FMakeRW!=NULL) {delete FMakeRW;}
	ShowDebug("Fin de TCodeGenerator destructor");
}

/*
TFileRW *TCodeGenerator::GenerateH(const char * APath,const char *ClassName)
{
	ShowDebug("Inside TCodeGenerator::GenerateH");
	if (FCanCreateSourceFile)
	{
		ShowDebug("Inside TCodeGenerator::GenerateH FCanCreateSourceFile is true");
		string toto;
		toto = APath ;
		toto = toto + ClassName + ".h";
		if (FHeaderRW!=NULL) delete FHeaderRW;
		FHeaderRW = new TFileRW(toto.c_str());
		return FHeaderRW;
	}
	return NULL;
}

TFileRW *TCodeGenerator::GenerateCPP(const char * APath,const char *ClassName)
{
	if (FCanCreateSourceFile)
	{
		string toto;
		toto = APath ;
		toto = toto + ClassName + ".cpp";
		if (FCPPRW!=NULL) delete FCPPRW;
		FCPPRW = new TFileRW(toto.c_str());
		return FCPPRW;		
	}
	return NULL;
}

//--------Application MakeFile ----------------//		
TFileRW * TCodeGenerator::GenerateMakeFile(const char * APath,const char *ClassName) 
{
	ShowDebug("Inside TCodeGenerator::GenerateMakeFile \n");
	if (FCanCreateSourceFile)
	{
		ShowDebug("Inside TCodeGenerator::GenerateMakeFile FCanCreateSourceFile is true\n");
		string toto;
		toto = APath ;
		toto = toto + ClassName;
		if (FMakeRW!=NULL) delete FMakeRW;		
		FMakeRW = new TFileRW(toto.c_str());
		return FMakeRW;
	}
	return NULL;
}


bool TCodeGenerator::InsertionMakeFile(TFileRW *AFileRW,const char *AFileName)		
{
	if (AFileRW==NULL) return false;
	string InsideWhich;
	string AfterWhat;
	string BeforeWhat;
	string MustBeAdded;

//In the Header!
	InsideWhich = "SRCS="; //found the #ifndef
	AfterWhat ="\\"; // found the #define
	BeforeWhat ="#"; // found the #define
	MustBeAdded = AFileName;
	MustBeAdded = MustBeAdded + " \\\n";
	return AddInFunctionPlus(AFileRW,InsideWhich.c_str(),AfterWhat.c_str(),BeforeWhat.c_str(),MustBeAdded.c_str());
}
*/

void TCodeGenerator::Copyrights(TFileRW *AFileRW)		
{
	if (AFileRW==NULL) {AFileRW = FMakeRW;}
	if (AFileRW!=NULL)
	{
		AFileRW->WriteALine("/*********************************************\n");
		AFileRW->WriteALine("* Code Generated By ");
		AFileRW->WriteALine(BE_BUILDER_NAME);
		AFileRW->WriteALine(" ");
		AFileRW->WriteALine(BE_BUILDER_VERSION);
		AFileRW->WriteALine("                \n");
		AFileRW->WriteALine("* Written by Jerome Fillon (Softimedia Inc.) \n");
		AFileRW->WriteALine("* Copyright (1998,1999)");
		AFileRW->WriteALine(BE_BUILDER_COPYRIGHT); 
		AFileRW->WriteALine("\n");	
		AFileRW->WriteALine("**********************************************/\n");	
	}
}

void TCodeGenerator::CopyrightsForMakeFile(TFileRW *AFileRW)
{
	if (AFileRW==NULL) {AFileRW = FMakeRW;}
	if (AFileRW!=NULL)
	{
		AFileRW->WriteALine("####################################################\n");
		AFileRW->WriteALine("# Code Generated By ");
		AFileRW->WriteALine(BE_BUILDER_NAME);
		AFileRW->WriteALine(" ");
		AFileRW->WriteALine(BE_BUILDER_VERSION);
		AFileRW->WriteALine("                  \n");
		AFileRW->WriteALine("# Written by Jerome Fillon ,Softimedia Inc.   \n");
		AFileRW->WriteALine("# Copyright (1998,1999)");
		AFileRW->WriteALine(BE_BUILDER_COPYRIGHT); 
		AFileRW->WriteALine("\n");	
		AFileRW->WriteALine("####################################################\n");
	}
}
/*
bool TCodeGenerator::AddInFunction(TFileRW *AFileRW,const char *AFunctionName, const char *ALocation,const char *AValue)
{
	long res;
	bool resultat =false;
	string truc;
	bool FoundFunctionName = false;
	bool ReadyToWrite = false;
	int32 NbBytesRead = 0;
	if (AFileRW!=NULL)
	{
		if (ALocation==NULL) ALocation = "}";
		while (AFileRW->ReadALine(&truc))
		{
			if (truc.find(AFunctionName)>=0) FoundFunctionName = true;
			if (FoundFunctionName)
			{
				res = truc.find(ALocation);
				if (res > 0) 
				{
					ReadyToWrite = true;
					break;			
				}
				NbBytesRead = AFileRW->GetPositionReader(); //doit etre mis ici!
			}			
		}
		if (ReadyToWrite)
		{
			printf("BytesRead: %ld \n",NbBytesRead);
			AFileRW->TheBFileWriter->Seek(NbBytesRead,SEEK_SET);		
			resultat = AFileRW->InsertALine(AValue);
		}
	}
	return resultat;
}

bool TCodeGenerator::AddInFunctionPlus(TFileRW *AFileRW,const char *AFunctionName,const char *AnAfterLocation, const char *ABeforeLocation,const char *AValue)
//bool TCodeGenerator::AddInFunctionPlus(TFileRW *AFileRW,char *AFunctionName,char *AnAfterLocation, char *ABeforeLocation,char *AValue)
{
	long res;
	bool resultat = false;
	string truc;
	bool FoundFunctionName = false;
	bool FoundAfter = false;
	bool FoundBefore = false;
	bool ReadyToWrite = false;
	bool MustFindBefore =true;
	bool MustFindAfter = true;
	bool MustFindFunction = true;
	int32 NbBytesRead = 0;
	if (AFileRW!=NULL)
	{
//		if (AnAfterLocation==NULL) AnAfterLocation = "{";
//		if (ABeforeLocation==NULL) ABeforeLocation = "}";		
		if (AnAfterLocation==NULL) MustFindAfter = false;
		if (ABeforeLocation==NULL) MustFindBefore = false;		
		if (AFunctionName==NULL) MustFindFunction = false;	
		AFileRW->ResetReader();//To begin at the start of file!
		AFileRW->OpenClose();
		printf("-----------TCodeGenerator::AddInFunctionPlus----------\n");
		printf("AFunctionName: %s\n",AFunctionName);
		printf("ABeforeLocation: %s\n",ABeforeLocation);
		printf("AnAfterLocation: %s\n",AnAfterLocation);
		printf("-------------------------------------------------------\n");
		
		while (AFileRW->ReadALine(&truc))
		{
			if (MustFindFunction)
			{
				res = truc.find(AFunctionName) ;
			}
			printf("TCodeGenerator::AddInFunctionPlus truc: %s res: %ld \n",truc.c_str(),res);
			if ((!MustFindFunction)||(res >= 0)) FoundFunctionName = true;
			
			if ((FoundFunctionName)||(!MustFindFunction))
			{
				if (MustFindAfter)
				{
					res = truc.find(AnAfterLocation) ;
				}
				printf("TCodeGenerator::AddInFunctionPlus functionName, res After : %ld Found\n",res);
				if ((!MustFindAfter)||(res >= 0 )) FoundAfter = true;
				if (FoundAfter)
				{
					if (!MustFindBefore)
					{
						NbBytesRead = AFileRW->GetPositionReader(); //doit etre mis ici!			
					}
					else
					{
						res = truc.find(ABeforeLocation) ;
					}
					printf("TCodeGenerator::AddInFunctionPlus After Found res Before: %ld \n",res);
					if ((!MustFindBefore)||(res >= 0)) 
					{
						printf("TCodeGenerator::AddInFunctionPlus Before Found\n");
						FoundBefore = true;
						ReadyToWrite = true;
						break;
					}
				}
				NbBytesRead = AFileRW->GetPositionReader(); //doit etre mis ici!
			}			
		}
		if (ReadyToWrite)
		{
			AFileRW->TheBFileWriter->Seek(NbBytesRead,SEEK_SET);			
			printf("TCodeGenerator::AddInFunctionPlus ReadyToWrite!\n");
			resultat = AFileRW->InsertALine(AValue);			 
			printf("TCodeGenerator::AddInFunctionPlus ReadyToWrite! After InsertALine\n");

		}
	}
	return resultat;
}
*/
//---------New Generation of Functions
//	FHasBeenGenerated = false;
//	FPath = NULL;
//	FClassName = NULL;
void TCodeGenerator::GenerateAll(const char *APath,const char *ClassName)
{
	ShowDebug("GEnerateAll Inside");
	FHasBeenGenerated = true;
	FPathToGenerate = APath;
	FClassNameToGenerate = ClassName;
	ShowDebug("GenerateAll Quitting");
}

bool TCodeGenerator::PrepareCode(const char *APath, const char *AClassName,bool ReallyWriteInFile = true)
{
	if (CreateBody(ReallyWriteInFile)!=true) return false;
	if (CreateHeader(ReallyWriteInFile)!=true) return false;
	if (CreateMakeFile(ReallyWriteInFile)!=true) return false;
	return true;
}

BMessage *TCodeGenerator::SaveData()
{
	ShowDebug("SaveData Inside");
	TCodeLine *ACodeLine;
	BMessage *AMessage = new BMessage(SAVE_CODE_GENERATOR);
	AMessage->AddBool("HasBeenGenerated",FHasBeenGenerated);
	if (FHasBeenGenerated)
	{
		ShowDebug("SaveData FHasBeenGenerated generated.");
		AMessage->AddString("PathToGenerate",FPathToGenerate.c_str());
		AMessage->AddString("ClassNameToGenerate",FClassNameToGenerate.c_str());
//	FCodeLineList->AddItem("CODELINE",ACodeLine,false);

		for (int ind=0;ind<FCodeLineList->GetCount();ind++)
		{
			ACodeLine = (TCodeLine *)FCodeLineList->GetItem(ind);
			AMessage->AddMessage("CodeLine",ACodeLine->SaveData());			
		}
	}
	ShowDebug("SaveData Quitting");
	return AMessage;	
}

bool TCodeGenerator::LoadData(BMessage *AMessage, BHandler *AGuiHandler)
{
	const char *APathToGenerate;
	const char *AClassNameToGenerate;
	ShowDebug("LoadData Inside");
	if (AMessage->FindBool("HasBeenGenerated",&FHasBeenGenerated)!=B_OK)
	{
		return false;
	}
	if (FHasBeenGenerated)
	{
		if (AMessage->FindString("PathToGenerate",&APathToGenerate)!=B_OK)
		{
			return false;
		}
		if (AMessage->FindString("ClassNameToGenerate",&AClassNameToGenerate)!=B_OK)
		{
			return false;
		}
		FPathToGenerate = APathToGenerate;
		FClassNameToGenerate = AClassNameToGenerate;
		ShowDebug(string("LoadData before PrepareCode PATH=") + FPathToGenerate + string(" CLASS=") + FClassNameToGenerate );
		if (PrepareCode(FPathToGenerate.c_str(),FClassNameToGenerate.c_str(),false)==false)
		{
			ShowDebug("LoadData PrepareCode failed...");
			return false;
		}
		//After PrepareCode We reload the OldValue from CodeLine...
		ShowDebug("LoadData Before Reloading OldValue...");
		BMessage ACodeLineMessage;
		int32 AnIndex;
		TCodeLine *ACodeLine;
//	AMessage->AddString(SAVE_CODE_LINE_OLD_VALUE,FOldLine); 
//	AMessage->AddInt(SAVE_CODE_LINE_INDEX,FUniqueIndex); 
		for (int32 ind=0;;ind++ )
		{
			ShowDebug(string("LoadData Reloading index=") + IntToStr(ind));
			if (AMessage->FindMessage("CodeLine",ind,&ACodeLineMessage)!=B_OK)
			{
				ShowDebug("LoadData Quitting");
				break;
			}
			if (ACodeLineMessage.FindInt32(SAVE_CODE_LINE_INDEX,&AnIndex)!=B_OK)
			{
				ShowDebug("LoadData cant find SAVE_CODE_LINE_INDEX");
				ACodeLineMessage.PrintToStream();
				return false;
			}
			ACodeLineMessage.PrintToStream();
			ShowDebug(string("LoadData before GetItem AnIndex=") + IntToStr(AnIndex));
			ACodeLine = (TCodeLine *)FCodeLineList->GetItem(AnIndex);
			ShowDebug("LoadData GetItem before LoadData...");
			if (ACodeLine==NULL) ShowDebug("LoadData ACodeLine is NULL.");
			else ShowDebug("LoadData ACodeLine is NOT NULL.");
			ACodeLine->LoadData(&ACodeLineMessage,AGuiHandler);			
		}
	}	
	ShowDebug("LoadData Quitting");
	return true;
}

bool TCodeGenerator::AddCodeLine(TCodeLine *ACodeLine)
{
	//	TStringList *FCodeLineList;
		
	int bidule = FCodeLineList->AddItem("CODELINE",ACodeLine,false);
	ShowDebug(string("AddCodeLine bidule=") + IntToStr(bidule));
	ACodeLine->FUniqueIndex = bidule;	
	return true;
}


