
#include "driver.h"
#include "dirty.h"
#include "CMameDisplay.h"

extern struct osd_bitmap *scrbitmap;
extern int gfx_display_lines;
extern int gfx_width;
extern int gfx_height;
extern int skiplines;
extern int skipcolumns;

// From video.c
extern int vector_game;
extern int stretch;

extern "C" {
	void blitscreen_dirty1_vga(void);
	void blitscreen_dirty1_vga_stretch(void);
	void blitscreen_dirty1_vga_scanlines(void);
	void blitscreen_dirty0_vga(void);
	void blitscreen_dirty0_vga_stretch(void);
	void blitscreen_dirty0_vga_scanlines(void);
}

void blitscreen_dirty1_vga(void)
{
	int screen_width;
	int visible_width;
	int i;

	if (vector_game) {
		// Vector games are scaled, so get these from gDisplay()
		screen_width	= 0;
		visible_width	= 0;
	} else {
		if (Machine->orientation & ORIENTATION_SWAP_XY) {
			screen_width	= Machine->drv->screen_height;
			visible_width	= Machine->drv->visible_area.max_y - Machine->drv->visible_area.min_y + 1;
		} else {
			screen_width	= Machine->drv->screen_width;
			visible_width	= Machine->drv->visible_area.max_x - Machine->drv->visible_area.min_x + 1;
		}
	}
	gDisplay->Update8BitDirect(scrbitmap->line[skiplines] + skipcolumns,
								gfx_display_lines - 1,
								screen_width,
								visible_width,
								0);

}

void blitscreen_dirty1_vga_stretch(void)
{
	int screen_width;
	int visible_width;
	int i;

	if (vector_game) {
		// Vector games are scaled, so get these from gDisplay()
		screen_width	= 0;
		visible_width	= 0;
	} else {
		if (Machine->orientation & ORIENTATION_SWAP_XY) {
			screen_width	= Machine->drv->screen_height;
			visible_width	= Machine->drv->visible_area.max_y - Machine->drv->visible_area.min_y + 1;
		} else {
			screen_width	= Machine->drv->screen_width;
			visible_width	= Machine->drv->visible_area.max_x - Machine->drv->visible_area.min_x + 1;
		}
	}

	gDisplay->Update8BitDirect(scrbitmap->line[skiplines] + skipcolumns,
								gfx_display_lines - 1,
								screen_width,
								visible_width /*-1*/,
								1);
}


void blitscreen_dirty1_vga_scanlines(void)
{
	int screen_width;
	int visible_width;
	int i;

	if (vector_game) {
		// Vector games are scaled, so get these from gDisplay()
		screen_width	= 0;
		visible_width	= 0;
	} else {
		if (Machine->orientation & ORIENTATION_SWAP_XY) {
			screen_width	= Machine->drv->screen_height;
			visible_width	= Machine->drv->visible_area.max_y - Machine->drv->visible_area.min_y + 1;
		} else {
			screen_width	= Machine->drv->screen_width;
			visible_width	= Machine->drv->visible_area.max_x - Machine->drv->visible_area.min_x + 1;
		}
	}
	
	gDisplay->Update8BitDirectWScan(scrbitmap->line[skiplines] + skipcolumns,
									gfx_display_lines - 1,
									screen_width,
									visible_width /*-1*/);
}


void blitscreen_dirty0_vga(void)
{
	int screen_width;
	int visible_width;
	int i;

	if (vector_game) {
		// Vector games are scaled, so get these from gDisplay()
		screen_width	= 0;
		visible_width	= 0;
	} else {
		if (Machine->orientation & ORIENTATION_SWAP_XY) {
			screen_width	= Machine->drv->screen_height;
			visible_width	= Machine->drv->visible_area.max_y - Machine->drv->visible_area.min_y + 1;
		} else {
			screen_width	= Machine->drv->screen_width;
			visible_width	= Machine->drv->visible_area.max_x - Machine->drv->visible_area.min_x + 1;
		}
	}
	gDisplay->Update8BitDirect(scrbitmap->line[skiplines] + skipcolumns,
								gfx_display_lines - 1,
								screen_width /*+ 16*/,
								visible_width,
								0);
}


void blitscreen_dirty0_vga_stretch(void)
{
	int screen_width;
	int visible_width;
	int i;

	if (vector_game) {
		// Vector games are scaled, so get these from gDisplay()
		screen_width	= 0;
		visible_width	= 0;
	} else {
		if (Machine->orientation & ORIENTATION_SWAP_XY) {
			screen_width	= Machine->drv->screen_height;
			visible_width	= Machine->drv->visible_area.max_y - Machine->drv->visible_area.min_y + 1;
		} else {
			screen_width	= Machine->drv->screen_width;
			visible_width	= Machine->drv->visible_area.max_x - Machine->drv->visible_area.min_x + 1;
		}
	}

	gDisplay->Update8BitDirect(scrbitmap->line[skiplines] + skipcolumns,
								gfx_display_lines - 1,
								screen_width,
								visible_width /*-1*/,
								1);
}


void blitscreen_dirty0_vga_scanlines(void)
{
	int screen_width;
	int visible_width;
	int i;

	if (vector_game) {
		screen_width = (stretch) ? gfx_width : gfx_width/2;
	} else {
		if (Machine->orientation & ORIENTATION_SWAP_XY) {
			screen_width	= Machine->drv->screen_height;
			visible_width	= Machine->drv->visible_area.max_y - Machine->drv->visible_area.min_y + 1;
		} else {
			screen_width	= Machine->drv->screen_width;
			visible_width	= Machine->drv->visible_area.max_x - Machine->drv->visible_area.min_x + 1;
		}
	}
	
	gDisplay->Update8BitDirectWScan(scrbitmap->line[skiplines] + skipcolumns,
								gfx_display_lines - 1,
								screen_width,
								visible_width /*-1*/);
}

