/***************************************************************************

  z80bw.c

  Functions to emulate the video hardware of the machine.

modified 02-06-98 HJB copied from 8080bw.c and changed to plot_8_pixel

***************************************************************************/

#include "driver.h"
#include "vidhrdw/generic.h"

unsigned char *astinvad_videoram;

/* palette colors (see drivers/z80bw.c) */
enum { BLACK, RED, GREEN, YELLOW, WHITE, CYAN, PURPLE };

static unsigned char astinvad_lookup[32][32] =
{
      {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
      {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
      {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
      {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
      {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
      {0x0,0x4,0x7,0x6,0x6,0x6,0x6,0x6,0x2,0x2,0x2,0x2,0x5,0x5,0x5,0x3,0x3,0x3,0x7,0x6,0x6,0x6,0x1,0x1,0x1,0x4,0x4,0x4,0x6,0x1,0x7,0x0},
      {0x0,0x4,0x7,0x6,0x6,0x6,0x6,0x6,0x2,0x2,0x2,0x2,0x4,0x1,0x4,0x4,0x4,0x4,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x6,0x1,0x7,0x0},
      {0x0,0x4,0x7,0x6,0x6,0x6,0x6,0x6,0x2,0x6,0x6,0x6,0x5,0x1,0x4,0x4,0x4,0x4,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x6,0x1,0x7,0x0},
      {0x0,0x4,0x7,0x6,0x6,0x6,0x6,0x6,0x2,0x6,0x6,0x6,0x5,0x1,0x4,0x4,0x4,0x4,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x6,0x1,0x7,0x0},
      {0x0,0x4,0x7,0x6,0x6,0x6,0x6,0x6,0x2,0x6,0x6,0x6,0x5,0x5,0x4,0x4,0x4,0x4,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x6,0x1,0x5,0x0},
      {0x0,0x4,0x7,0x6,0x6,0x6,0x6,0x6,0x2,0x6,0x6,0x6,0x5,0x5,0x4,0x4,0x4,0x4,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x6,0x1,0x5,0x0},
      {0x0,0x5,0x1,0x6,0x6,0x6,0x6,0x6,0x2,0x6,0x6,0x6,0x5,0x5,0x4,0x4,0x4,0x4,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x6,0x1,0x5,0x0},
      {0x0,0x5,0x1,0x6,0x6,0x6,0x6,0x6,0x2,0x6,0x6,0x6,0x5,0x5,0x4,0x4,0x4,0x4,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x6,0x1,0x5,0x0},
      {0x0,0x5,0x1,0x6,0x6,0x6,0x6,0x6,0x2,0x6,0x6,0x6,0x5,0x5,0x4,0x4,0x4,0x4,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x6,0x1,0x5,0x0},
      {0x0,0x5,0x1,0x6,0x6,0x6,0x6,0x6,0x2,0x6,0x6,0x6,0x5,0x5,0x4,0x4,0x4,0x4,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x6,0x1,0x5,0x0},
      {0x0,0x5,0x1,0x6,0x6,0x6,0x6,0x6,0x2,0x6,0x6,0x6,0x5,0x5,0x4,0x4,0x4,0x4,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x6,0x1,0x5,0x0},
      {0x0,0x5,0x1,0x6,0x6,0x6,0x6,0x6,0x2,0x6,0x6,0x1,0x5,0x5,0x4,0x4,0x4,0x4,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x6,0x1,0x6,0x0},
      {0x0,0x5,0x1,0x6,0x6,0x6,0x6,0x6,0x2,0x6,0x6,0x1,0x7,0x5,0x4,0x4,0x4,0x4,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x6,0x1,0x6,0x0},
      {0x0,0x5,0x1,0x6,0x6,0x6,0x6,0x6,0x2,0x6,0x6,0x1,0x7,0x5,0x4,0x4,0x4,0x4,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x6,0x1,0x6,0x0},
      {0x0,0x5,0x1,0x6,0x6,0x6,0x6,0x6,0x2,0x6,0x6,0x1,0x5,0x5,0x4,0x4,0x4,0x4,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x6,0x1,0x6,0x0},
      {0x0,0x5,0x1,0x6,0x6,0x6,0x6,0x6,0x2,0x6,0x6,0x6,0x5,0x5,0x4,0x4,0x4,0x4,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x6,0x1,0x6,0x0},
      {0x0,0x5,0x1,0x6,0x6,0x6,0x6,0x6,0x2,0x6,0x6,0x6,0x5,0x5,0x4,0x4,0x4,0x4,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x6,0x1,0x6,0x0},
      {0x0,0x5,0x1,0x6,0x6,0x6,0x6,0x6,0x2,0x6,0x6,0x6,0x5,0x5,0x4,0x4,0x4,0x4,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x6,0x1,0x6,0x0},
      {0x0,0x5,0x1,0x6,0x6,0x6,0x6,0x6,0x2,0x6,0x6,0x6,0x5,0x5,0x4,0x4,0x4,0x4,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x6,0x1,0x6,0x0},
      {0x0,0x5,0x1,0x6,0x6,0x6,0x6,0x6,0x2,0x6,0x6,0x6,0x5,0x5,0x4,0x4,0x4,0x4,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x6,0x1,0x6,0x0},
      {0x0,0x6,0x7,0x6,0x6,0x6,0x6,0x6,0x2,0x6,0x6,0x6,0x5,0x5,0x4,0x4,0x4,0x4,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x6,0x1,0x6,0x0},
      {0x0,0x6,0x7,0x6,0x6,0x6,0x6,0x6,0x2,0x6,0x6,0x6,0x5,0x5,0x4,0x4,0x4,0x4,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x6,0x1,0x6,0x0},
      {0x0,0x6,0x7,0x6,0x6,0x6,0x6,0x6,0x2,0x6,0x6,0x6,0x5,0x1,0x4,0x4,0x4,0x4,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x6,0x1,0x6,0x0},
      {0x0,0x6,0x7,0x6,0x6,0x6,0x6,0x6,0x2,0x6,0x6,0x6,0x5,0x1,0x4,0x4,0x4,0x4,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x6,0x1,0x6,0x0},
      {0x0,0x6,0x7,0x6,0x6,0x6,0x6,0x6,0x2,0x2,0x2,0x2,0x5,0x1,0x4,0x4,0x4,0x4,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x6,0x1,0x6,0x0},
      {0x0,0x6,0x7,0x6,0x6,0x6,0x6,0x6,0x2,0x2,0x2,0x2,0x5,0x5,0x5,0x3,0x3,0x3,0x7,0x6,0x6,0x6,0x1,0x1,0x1,0x4,0x4,0x4,0x6,0x1,0x6,0x0},
      {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}
};

/***************************************************************************

  Start the video hardware emulation.

***************************************************************************/
int astinvad_vh_start (void)
{
	if ((tmpbitmap = osd_create_bitmap(Machine->drv->screen_width,Machine->drv->screen_height)) == 0)
		return 1;

	return 0;
}


/***************************************************************************

  Stop the video hardware emulation.

***************************************************************************/
void astinvad_vh_stop (void)
{
	osd_free_bitmap (tmpbitmap);
}

static void plot_8_pixel (int x, int y, int * col)
{
        if (Machine->orientation & ORIENTATION_SWAP_XY)
	{
        int     temp;
                temp = x;
                x = y;
                y = temp;
        }
        if (Machine->orientation & ORIENTATION_FLIP_X)
                x = 255 - x;
        if (Machine->orientation & ORIENTATION_FLIP_Y)
                y = 255 - y;
        if (Machine->orientation & ORIENTATION_SWAP_XY)
        {
                if (Machine->orientation & ORIENTATION_FLIP_Y)
                {
                        tmpbitmap->line[y-0][x] = col[0];
                        tmpbitmap->line[y-1][x] = col[1];
                        tmpbitmap->line[y-2][x] = col[2];
                        tmpbitmap->line[y-3][x] = col[3];
                        tmpbitmap->line[y-4][x] = col[4];
                        tmpbitmap->line[y-5][x] = col[5];
                        tmpbitmap->line[y-6][x] = col[6];
                        tmpbitmap->line[y-7][x] = col[7];
                        osd_mark_dirty (x,y-7,x,y,0);
                }
                else
                {
                        tmpbitmap->line[y+0][x] = col[0];
                        tmpbitmap->line[y+1][x] = col[1];
                        tmpbitmap->line[y+2][x] = col[2];
                        tmpbitmap->line[y+3][x] = col[3];
                        tmpbitmap->line[y+4][x] = col[4];
                        tmpbitmap->line[y+5][x] = col[5];
                        tmpbitmap->line[y+6][x] = col[6];
                        tmpbitmap->line[y+7][x] = col[7];
                        osd_mark_dirty (x,y,x,y+7,0);
                }
        }
        else
        {
                if (Machine->orientation & ORIENTATION_FLIP_Y)
                {
                        tmpbitmap->line[y][x-0] = col[0];
                        tmpbitmap->line[y][x-1] = col[1];
                        tmpbitmap->line[y][x-2] = col[2];
                        tmpbitmap->line[y][x-3] = col[3];
                        tmpbitmap->line[y][x-4] = col[4];
                        tmpbitmap->line[y][x-5] = col[5];
                        tmpbitmap->line[y][x-6] = col[6];
                        tmpbitmap->line[y][x-7] = col[7];
                        osd_mark_dirty (x-7,y,x,y,0);
                }
                else
                {
                        tmpbitmap->line[y][x+0] = col[0];
                        tmpbitmap->line[y][x+1] = col[1];
                        tmpbitmap->line[y][x+2] = col[2];
                        tmpbitmap->line[y][x+3] = col[3];
                        tmpbitmap->line[y][x+4] = col[4];
                        tmpbitmap->line[y][x+5] = col[5];
                        tmpbitmap->line[y][x+6] = col[6];
                        tmpbitmap->line[y][x+7] = col[7];
                        osd_mark_dirty (x,y,x+7,y,0);
                }
        }
}

void astinvad_videoram_w (int offset,int data)
{
	if (astinvad_videoram[offset] != data)
	{
		int i,x,y,colors[8];

		astinvad_videoram[offset] = data;

		y = offset / 32;
		x = 8 * (offset % 32);

		for (i = 0; i < 8; i++)
		{
			if (!(data & 0x01))
				colors[i] = Machine->pens[BLACK];
			else
				colors[i] = Machine->pens[astinvad_lookup[31-y/8][31-x/8]];
			data >>= 1;
		}
		plot_8_pixel(x, y, colors);
	}
}


static void plot_pixel_8080 (int x, int y, int col)
{
	if (Machine->orientation & ORIENTATION_SWAP_XY)
	{
		int temp;

		temp = x;
		x = y;
		y = temp;
	}
	if (Machine->orientation & ORIENTATION_FLIP_X)
		x = 255 - x;
	if (Machine->orientation & ORIENTATION_FLIP_Y)
		y = 255 - y;

	tmpbitmap->line[y][x] = col;
	Machine->scrbitmap->line[y][x] = col;
	/* TODO: we should mark 8 bits dirty at a time */
	osd_mark_dirty (x,y,x,y,0);
}
void spaceint_videoram_w (int offset,int data) /* LT 23-12-1998 */ /*--WIP--*/
 {
	if (astinvad_videoram[offset] != data)
	{
		int i,x,y;

		astinvad_videoram[offset] = data;

		y = (8*(offset / 256));
		x = (offset % 256);

		for (i = 0; i < 8; i++)
		{
			if (!(data & 0x01))
				plot_pixel_8080 (x, y, Machine->pens[BLACK]);
			else
                                plot_pixel_8080 (x, y, Machine->pens[0x07]);

			y ++;
			data >>= 1;
		}
	}
}
/***************************************************************************

  Draw the game screen in the given osd_bitmap.
  Do NOT call osd_update_display() from this function, it will be called by
  the main emulation engine.

***************************************************************************/
void astinvad_vh_screenrefresh(struct osd_bitmap *bitmap,int full_refresh)
{
	/* copy the character mapped graphics */
	copybitmap(bitmap,tmpbitmap,0,0,0,0,&Machine->drv->visible_area,TRANSPARENCY_NONE,0);
}
