/* Copyright (C) 1998, Synack Systems Corporation.  Created 1998. All
   rights reserved.

   License to copy and use this software is granted provided that it
   is identified as the "Synack Systems Corp., BeProtected IP Packet
   Filter" in all material mentioning or referencing this software.

   License is also granted to make and use derivative works provided
   that such works are identified as "derived from the Synack Systems
   Corp., BeProtected IP packet filter" in all material
   mentioning or referencing the derived work.

   Synack Systems Corp.  makes no representations concerning either
   the merchantability of this software or the suitability of this
   software for any particular purpose. It is provided "as is"
   without express or implied warranty of any kind.

   These notices must be retained in any copies of any part of this
   documentation and/or software.
 */       

/* Structure of an ethernet header */

#define ETHER_HEADER_SIZE	14
#define ETHER_HEADER_IP		0x800
#define ETHER_HEADER_ARP	0x806
#define ETHER_HEADER_RARP	0x8035

struct ether_header {
  unsigned char 	ether_dhost[6];
  unsigned char 	ether_shost[6];
  unsigned short 	ether_type;
};

/* Pre-negotiation PPP fields
#define PPP_HEADER_SIZE		5
#define PPP_HEADER_IP		0x21
#define PPP_HEADER_LINKCONTROL	0xC021
#define PPP_HEADER_NETCONTROL	0x8021
struct ppp_header {
  unsigned char		flag;
  unsigned char 	addr;
  unsigned char		control;
  unsigned short	protocol;
};
*/

// Post negotiation PPP fields
#define PPP_HEADER_SIZE		4
#define PPP_HEADER_IP		0x21
#define PPP_HEADER_LINKCONTROL	0xC021
#define PPP_HEADER_NETCONTROL	0x8021
struct ppp_header {
  unsigned char		flag;
  unsigned char		control;
  unsigned short	protocol;
};

#define IP_HEADER_SIZE		20
#define IP_ICMP			1
#define IP_TCP			6
#define IP_UDP			17

/* Structure of an IP header, naked of options */
struct ip {
#if __INTEL__
  unsigned char		ip_hl:4,
			ip_v:4;
#else
  unsigned char		ip_v:4,
			ip_hl;
#endif
  unsigned char		ip_tos;
  unsigned short	ip_len;
  unsigned short	ip_id;
  unsigned short	ip_off;
#define IP_DF		0x4000
#define IP_MF		0x2000
#define IP_OFFMASK	0x1fff
  unsigned char		ip_ttl;
  unsigned char		ip_p;
  unsigned short	ip_sum;
  unsigned long		ip_src, 
			ip_dst;
};

#define TCP_HEADER_SIZE		20
struct tcphdr {
  unsigned short	th_sport;
  unsigned short	th_dport;
  unsigned int		th_seq;
  unsigned int		th_ack;
#if __INTEL__
  unsigned char		th_x2:4,
			th_off:4;
#else
  unsigned char		th_off:4,
			th_x2:4;
#endif
  unsigned char		th_flags;
#define TH_FIN		0x01
#define TH_SYN		0x02
#define TH_RST		0x04
#define TH_PUSH		0x08
#define	TH_ACK		0x10
#define TH_URG		0x20
  unsigned short	th_win;
  unsigned short	th_sum;
  unsigned short	th_urp;
};
  
#define UDP_HEADER_SIZE		8
struct udphdr {
  unsigned short	uh_sport;
  unsigned short	uh_dport;
  short			uh_ulen;
  u_short		uh_sum;
};
