/* Copyright (C) 1998, Synack Systems Corporation.  Created 1998. All
   rights reserved.

   License to copy and use this software is granted provided that it
   is identified as the "Synack Systems Corp., BeProtected IP Packet
   Filter" in all material mentioning or referencing this software.

   License is also granted to make and use derivative works provided
   that such works are identified as "derived from the Synack Systems
   Corp., BeProtected IP packet filter" in all material
   mentioning or referencing the derived work.

   Synack Systems Corp.  makes no representations concerning either
   the merchantability of this software or the suitability of this
   software for any particular purpose. It is provided "as is"
   without express or implied warranty of any kind.

   These notices must be retained in any copies of any part of this
   documentation and/or software.
 */       

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <netdb.h>
#include <malloc.h>
#include <ctype.h>
#include <List.h>

#include "headers.h"
#include "filter.h"

#define LINEBUF 1024

int nfilters = 0;
BList *filters = NULL;

void addFilter(struct FirewallFilter *f) {
	if(filters == NULL)
		filters = new BList(20);
	filters->AddItem(f);
}

// converts an ip address in xxx.xxx.xxx.xxx format to an unsigned int in
// the host's byte order
unsigned packIP(char *s) {
  unsigned ip = 0x00;
  int hitDots = 0; 
  int len = strlen(s);

  for(int i=0; i < len; i++) {
    char c = *(s+i);
    if(!isdigit(c)) return 0;
    
    int b = 0;
    while(c != '.') {
	if(!isdigit(c)) return 0;
	b = b*10+c-'0';

	if(++i >= len) break;
	c = *(s+i);
    }

    if(b > 0xFF) return 0;

    ip = (ip << 8) + b;
    hitDots++;
  }

  return ip;	
}

// Returns an array of 2 port numbers.. both in host byte order
void parsePortRange(char *s, unsigned short ports[]) {
  char *p;
 
  // If the user only specified one port..
  if((p = strchr(s, '-')) == NULL) {
    ports[0] = ports[1] = atoi(s);
    return;
  }

  *p = '\0';
  while(!isdigit(*p)) p++;

  ports[0] = atoi(s);
  ports[1] = atoi(p);
}

void parseIpRange(char *s, unsigned ip[]) {
  char *p;

  if((p = strchr(s, '-')) == NULL) {
    ip[0] = ip[1] = packIP(s);
    return;
  }

  *p = '\0';
  p++;

  ip[0] = packIP(s);
  ip[1] = packIP(p);
}

void readFilters(char *file) {
  FILE *f;
  char line[BUFSIZ];
  char *c;
  struct FirewallFilter *filter;
  char ppp=0, eth=0;
  

  if((f = fopen(file, "r")) == NULL) return;
  
  while(fgets(line, LINEBUF, f) != NULL) {
    // Strip the newline
    line[strlen(line)-1] = '\0';

    //skip comment lines
    if((c = strtok(line, " \t")) == NULL) continue;
    if(*c == '#') continue;

    // Make the filter all defaults
    filter = new FirewallFilter;
    memset(filter, 0, sizeof(filter));
    

    if(!strcmp(c, "interface")) {
	ppp = eth = 0;
	while((c = strtok(NULL, " \t")) != NULL) {
	  if(!strcmp(c, "ppp")) ppp=1;
	  else if(!strcmp(c, "ethernet")) eth=1;
	}
	continue;
    }

    if(!strcmp(c, "allow")) filter->flags |= FILTER_ALLOW;

    // Get the protocol
    if((c = strtok(NULL, " \t")) == NULL) continue;
    if(!strcmp(c, "udp")) {
      filter->flags |= FILTER_PROTOCOL;
      filter->protocol = IP_UDP;
    }
    else if(!strcmp(c, "tcp")) {
      filter->protocol = IP_TCP;
      filter->flags |= FILTER_PROTOCOL;
    }
    else if(!strcmp(c, "icmp")) {
      filter->protocol = IP_ICMP;
      filter->flags |= FILTER_PROTOCOL;
    }

    // Now read in the keywords and their arguments
    while((c = strtok(NULL, " \t")) != NULL) {

      if(!strcmp(c, "from")) {
        // get the address
        if((c = strtok(NULL, " \t")) == NULL) goto END;
        if(strcmp(c, "any")) {
	  parseIpRange(c, filter->ip_src);
          filter->flags |= FILTER_SRC_ADDRESS;
        }
      }
 
      else if(!strcmp(c, "to")) {
	// get the address
	if((c = strtok(NULL, " \t")) == NULL) goto END;
	if(strcmp(c, "any")) {
	  parseIpRange(c, filter->ip_dst);
	  filter->flags |= FILTER_DST_ADDRESS;
	}
      }

      else if(!strcmp(c, "ip_options"))
	filter->flags |= FILTER_IP_OPTIONS;

      else if(!strcmp(c, "dport")) {
    	if((c = strtok(NULL, " \t")) == NULL) goto END;
    	if(strcmp(c, "any")){
		parsePortRange(c, filter->dport);
       		filter->flags |= FILTER_DST_PORT;
    	}	
      }

      else if(!strcmp(c, "sport")) {
	if((c = strtok(NULL, " \t")) == NULL) goto END;
	if(strcmp(c, "any")) {
		filter->flags |= FILTER_SRC_PORT;
		parsePortRange(c, filter->sport);
	}
      }
    
      else if(!strcmp(c, "flags")) { 
    	if((c = strtok(NULL, " \t")) == NULL) goto END;
    	filter->flags |= FILTER_FLAGS;
	if(strchr(c, 'F') != NULL) filter->th_flags |= TH_FIN;
	if(strchr(c, 'S') != NULL) filter->th_flags |= TH_SYN;
	if(strchr(c, 'R') != NULL) filter->th_flags |= TH_RST;
	if(strchr(c, 'P') != NULL) filter->th_flags |= TH_PUSH;
	if(strchr(c, 'A') != NULL) filter->th_flags |= TH_ACK;
	if(strchr(c, 'U') != NULL) filter->th_flags |= TH_URG;
      }

   } // while strtok
    
    END:
    if(ppp || eth) {
	filter->ppp = ppp;
	filter->eth = eth;
	filter->flags |= FILTER_INTERFACE;
    }

    addFilter(filter);
  } // while fgets

  fclose(f);

}
