#include "support/MuscleSupport.h"
#include "util/String.h"
#include "ShareStrings.h"

namespace beshare {

static int _language = LANGUAGE_ENGLISH;   // Everybody's favorite language!

// Returns the best LANGUAGE_* value based on our environment variables, or LANGUAGE_ENGLISH 
// if nothing can be deduced.  Contributed by Francois Revol (revol@free.fr)
int GetDefaultLanguageForLocale()
{
   static const struct 
   {
      const char *posix; 
      int language; 
   } 
   posixLocaleMapping[] = 
   { 
      {"C",  LANGUAGE_ENGLISH}, // the default one 
      {"en", LANGUAGE_ENGLISH}, 
      {"es", LANGUAGE_SPANISH}, 
      {"de", LANGUAGE_GERMAN}, 
      {"nl", LANGUAGE_DUTCH}, 
      {"pt", LANGUAGE_PORTUGUESE}, 
      {"fr", LANGUAGE_FRENCH}, 
      {"it", LANGUAGE_ITALIAN}, 
      {"ru", LANGUAGE_RUSSIAN}, 
      {"sv", LANGUAGE_SWEDISH}, 
      {"eo", LANGUAGE_ESPERANTO}, 
      {"no", LANGUAGE_NORWEGIAN}, 
      {"sr", LANGUAGE_SERBIAN}, 
      {"bg", LANGUAGE_BULGARIAN}, 
      {"ko", LANGUAGE_KOREAN}, 
      {"hu", LANGUAGE_HUNGARIAN}, 
      {"ro", LANGUAGE_ROMANIAN}, 
      {"zh", LANGUAGE_SCHINESE},  // simplified Chinese 
      {"tk", LANGUAGE_TURKISH},
      {"ja", LANGUAGE_JAPANESE},
      {"fi", LANGUAGE_FINNISH}
   }; 

   String posixLocale(getenv("LC_ALL")); 
   if (posixLocale.Length() == 0) posixLocale = getenv("LC_MESSAGES"); 
   if (posixLocale.Length() > 0) 
   {
      posixLocale = posixLocale.Substring(0, "_");  // remove everything at/after 1st underbar
      for (uint32 i=0; i<ARRAYITEMS(posixLocaleMapping); i++) if (posixLocale == posixLocaleMapping[i].posix) return posixLocaleMapping[i].language; 
   }
   return LANGUAGE_ENGLISH;  // the default
}

static const char _englishShortcuts[NUM_SHORTCUTS] = {
   'N',  // New connection
   'B',  // "Bye" to current connection
   'S',  // Shared dir
   'D',  // Download dir
   'L',  // clear Log
   'R',  // Reset Layout
   'Q',  // Quit
   'U',  // Full user Queries
   'M',  // Beep When Mentioned
   'P',  // Open private chat window
   'F',  // Toggle file logging
   'E',  // File sharing enabled
   'O',  // Logs dir
};

static const char * _englishStrings[NUM_STRINGS] = {
   "Anonymous",
   "Unknown",
   " is now connected.",
   " has disconnected.",
   "User #",
   " (a.k.a. ",
   " is now known as ",
   "true",
   "false",
   "<unknown type>",
   "User ",
   " is downloading ",
   "Error writing to file ",
   "An Error Occurred.",
   "Queued (Local machine too busy)",
   "Queued (Remote machine too busy)",
   "Sent: ",
   "Rcvd: ",
   "/sec, ",
   "Awaiting callback...",
   "Connecting...",
   "Download complete",
   "Download aborted",
   "Couldn't connect",
   "Preparing to Upload",
   "Preparing to Download",
   "to",
   "from",
   "Error starting download--no accept port!",
   "Error starting delayed connect!",
   "Error starting delayed connect--no transceiver thread!",
   "Error, couldn't create connect thread! (Try quitting BeShare, then Restarting Networking)",
   "(Sharing %i files)",
   "Couldn't find 'shared' subdirectory, file sharing disabled!",
   "\0011File Name",
   "\0012User",
   "\0013SessionID",
   "\0014Connection",
   "File",
   "Connect to server",
   "Disconnect",
   "Open Shared Folder",
   "Open Downloads Folder",
   "Clear Chat Log",
   "Reset Layout",
   "About BeShare",
   "Quit",
   "Attributes",
   "Settings",
   "Max Simultaneous Uploads",
   "Max Simultaneous Downloads",
   "No Limit",
   "Upload Bandwidth",
   "Log",
   "Uploads",
   "User Events",
   "Query Changes",
   "Full User Queries",
   "I'm Firewalled",
   "Query:",
   "Start Query",
   "Stop Query",
   "Server:",
   "User Name:",
   "Download Selected Files",
   "Clear Finished/Failed Transfers",
   "Remove Selected",
   "Chat",
   "Name",
   "ID",
   "BeShare is listening on port %u.  Select Connect from the File menu to begin!",
   "Couldn't start file-sharing server thread!  (Try Restarting Networking, then restarting BeShare)",
   "Can't download from user ",
   ", no connection information available.",
   "Can't download files from ",
   ", because both of us are behind firewalls.",
   "File download accept session for ",
   " failed to initialize!",
   "File download session to ",
   "Changed Query to",
   "Started Query",
   "Couldn't start ShareFileTransfer session to serve remote transfer request!  (Try Restarting Networking, then restarting BeShare)",
   "Your name has been changed to ",
   "by",
   "Unknown user ",
   ", message \"",
   "\" not sent.",
   "No target user specified in /msg",
   "Stopped Query",
   "System",
   "Warning",
   "Error",
   "Action",
   "Connect to ",
   " - Connecting to ",
   " - %lu results shown (",
   " - Connected to ",
   "Connection established.",
   "Connecting to server...",
   "You are no longer connected to the MUSCLE server.",
   "Connection to server failed.",
   "English",
   "Spanish",
   "Language %s selected.  Change will take effect after you restart BeShare.",
   "Language",
   "German",
   "Kind",
   "File Size",
   "Files",
   "Dutch",
   "Examining Files...",
   "Available irc-style commands:",
   "send a private message",
   "change your user name",
   "do something",
   "synonym for /action",
   "clear the chat log",
   "start a new query",
   "stop the current query",
   "connect to a server",
   "disconnect from the server",
   "quit BeShare",
   "show this help text",
   "<name or session id> <text>",
   "<name>",
   "<action>",
   "[queryString]",
   "[serverName]",
   "Portuguese",
   "French",
   "Beep When Mentioned",
   "Max Simultaneous Uploads Per User",
   "Timestamps",
   "AutoClear Finished Downloads",
   "Max Simultaneous Downloads Per User",
   "Italian",
   "Login on Startup",
   "Private Messages",
   "Open Private Chat Window",
   "BeShare Private Chat Window",
   "Chat With:",
   "Error, no user specified!",
   "Save Preset",
   "Restore Preset",
   "Error, unknown command",
   "Type /help for a list of available commands.",
   " - (%lu-%lu) of %lu results shown (",
   "Display",
   "Info Messages",
   "Warning Messages",
   "Error Messages",
   "Logging Enabled",
   "Logging Disabled",
   "Results Per Page",
   "Switch to Page",
   "specify users to ignore",
   "Ignore pattern set to: ",
   "Ignore pattern removed.",
   "<names or session ids>",
   "Move Up",
   "Move Down",
   "Halt Transfer",
   "Restart Transfer",
   "Open File",
   "Russian",
   "Chat",
   "Current /ignore pattern is: ",
   "Disabled",
   "There are %i transfers in progress, are you sure you want to quit?",
   "Don't Quit",
   "Modification Time",
   "Esperanto",
   "Swedish",
   "ping other clients",
   "Ping returned in %Li milliseconds",
   "Sent ping request to: ",
   "Norwegian",
   "Serbian",
   "away",
   "Auto Away",
   "minutes",
   "tag",
   "change the auto-away tag",
   "Auto-away tag set to: ",
   "Force away state",
   "Open Folder",
   "Watch pattern set to: ",
   "Watch pattern removed.",
   "Current /watch pattern is: ",
   "specify users to watch",
   "Startup commands cleared.",
   "command",
   "add startup command",
   "clear startup commands",
   "Recorded startup command: ",
   "Watch",
   "Server status requested.",
   "%.1fMB used (%.1fMB available)",
   "Server status:",
   "Server version",
   "Local session root",
   "Server memory usage",
   "Request server status",
   "Server uptime",
   "weeks",
   "days",
   "System Uptime",
   "logged in for",
   "File Sharing Enabled",
   "Ban User For",
   "User at IP %s banned for",
   "Hours",
   "Forever",
   "remove all upload bans",
   "Removing %lu upload bans",
   "AutoPriv pattern set to: ",
   "AutoPriv pattern removed.",
   "specify AutoPriv users",
   "Current /autopriv pattern is: ",
   "Unknown data format!",
   "Open Logs Folder",
   "Status",
   "Your status has been changed to: ",
   " is now ",
   "Load",
   "set user status string",
   "Bulgarian",
   "Path",
   "Retain File Paths",
   "Set alias",
   "Removed alias",
   "[name and value]",
   "create an alias",
   "remove an alias",
   "Move to Top",
   "Move to Bottom",
   "set custom window title",
   "Custom window title is now",
   "AutoUpdate Server List",
   "Added server: %s",
   "Removed server: %s",
   "BeShare v%s is now available for download.  You can upgrade at %s",
   "execute shell command",
   "Executing shell command",
   "shell command",
   "idle command set to",
   "set command for when transfers cease",
   "font size in points",
   "set font size",
   "Font size set to:",
   "Font size reset to default",
   "Client",
   "Will attempt auto-reconnect in %lu minutes.",
   "Attempting auto-reconnect.",
   "Auto-reconnect sequence terminated.",
   "Korean",
   "Limit Bandwidth",
   "bytes/second",
   "Set max download rate (per transfer)",
   "Set max upload rate (per transfer)",
   "Max download rate is",
   "Max upload rate is",
   "Hungarian",
   "Choose Colors",
   "Text Background",
   "Scrolled Text Background",
   "Border Areas",
   "Text",
   "System",
   "Warning",
   "Error",
   "Action",
   "Private",
   "Name Said",
   "Ping",
   "Local Nick",
   "Remote Nick",
   "URL",
   "Selection",
   "Watch",
   "Download Progress",
   "Upload Progress",
   "Paused Upload Progress",
   "Color prefs by",
   "Revert",
   "Default",
   "toggle custom coloring",
   "Romanian",
   "share screenshot",
   "is now sharing a screenshot",
   "Error sharing screenshot",
   " has finished downloading ",
   "Transferred this session:  %s down, %s up.",
   "show some miscellaneous info",
   "Banned",
   "until",
   "Data Compression",
   "Low",
   "Medium",
   "High",
   "Chinese (Simplified)",
   "Turkish",
   "Japanese",
   "[font name]",
   "set font",
   "Font set to",
   "Font reset to default",
   "Couldn't find font",
   "Shortest Uploads First",
   "Finnish"
};

static const char _spanishShortcuts[NUM_SHORTCUTS] = {
   'N',  // New connection
   'E',  // "Bye" to current connection
   'P',  // Shared dir
   'D',  // Download dir
   'L',  // clear Log
   'R',  // Reset Layout
   'Q',  // Quit
   'U',  // Full user Queries
   'M',  // Beep When Mentioned
   'I',  // Open private chat window
   'F',  // Toggle file logging
   'S',  // File sharing enabled
   'O',  // Logs dir
};

// Submitted by: Phantom (socca@bemail.org) and Pintaio (pinpedilicio@yahoo.es)
static const char * _spanishStrings[NUM_STRINGS] = {
   "Anónimo",
   "Desconocido",
   " está conectado.",
   " está desconectado.",
   "Usuario #",
   " (a.k.a. ",
   " es conocido como ",
   "verdadero",
   "falso",
   "<tipo desconocido>",
   "Usuario ",
   " está descargando ",
   "error al escribir el archivo ",
   "se produjo un error.",
   "En cola (maquina local está muy ocupada)",
   "En cola (maquina remota está muy ocupada)",
   "Enviado: ",
   "Recibido: ",
   "/seg, ",
   "Esperando respuesta...",
   "Conectando...",
   "Descarga completa",
   "Descarga cancelada",
   "no se pudo conectar",
   "preparado para subir",
   "preparado para descargar",
   "a",
   "desde",
   "¡Error al comenzar la descarga -- puerto no aceptado!",
   "¡Error al comenzar la conexión aplazada!",
   "¡Error al comenzar conexión aplazada -- no transmite hilo!",
   "¡Error, no se pudo crear una conexión con el hilo!",
   "(Compartiendo %i archivos locales)",
   "¡No se pudo encontrar el subdirectorio 'shared', Compartir Archivos deshabilitado!",
   "\0011Archivo",
   "\0012Usuario",
   "\0013ID de Sesión",
   "\0014Conexión",
   "Archivo",
   "Conectar al Servidor",
   "Desconectar",
   "Abrir Carpeta Compartida",
   "Abrir Carpeta de Descargas",
   "Limpiar Historial del Chat",
   "Reajustar Ventana",
   "Acerca de Beshare",
   "Salir",
   "Atributos",
   "Opciones",
   "Máximo de Subidas Simultáneas",
   "Máximo de Descargas Simultáneas",
   "Sin Límite ",
   "Ancho de Banda Para Subidas",
   "Historial",
   "Subidas",
   "Eventos de usuario",
   "Cambios en la Búsqueda",
   "Búsqueda Completa de Usuario",
   "Tengo Firewall",
   "Búsqueda:",
   "Buscar",
   "Parar",
   "Servidor:",
   "Nombre:",
   "Descargar archivos elegidos",
   "Limpiar Transferencias Terminadas/Erróneas",
   "Cancerlar Transferencia",
   "Chat",
   "Nombre",
   "ID",
   "BeShare está escuchando en el puerto %u.  ¡Seleccionar Conectar en el menú \"Archivo\" para comenzar!",
   "¡No se pudo comenzar el hilo de ejecución para compartir archivos!",
   "No se pudo descargar desde el usuario",
   ",no hay información de la conexión.",
   "No puedes bajar archivos de ",
   ", porque los dos estáis detrás de un firewall.",
   "Sesión de descarga aceptada para ",
   " ¡error para iniciar!",
   "Sesión de descarga para ",
   "Búsqueda modificada a",
   "Comenzar búsqueda",
   "¡No se pudo comenzar la sesión de Transferencia de Archivos para servir el pedido remoto de tranferencia!",
   "Tu nombre ha cambiado a ",
   "por",
   "Usuario desconocido ",
   ", mensaje \"",
   "\" no enviado.",
   "No hay un usuario designado en /msg",
   "Búsqueda detenida",
   "Sistema",
   "Peligro",
   "Error",
   "Acción",
   "Conectar a ",
   " - Conectando a ",
   " - %lu resultados mostrados (",
   " - Conectado a ",
   "Conexión establecida.",
   "Conectando a servidor...",
   "No estás conectado al servidor muscle.",
   "Conexión al servidor errónea.",
   "Inglés",
   "Español",
   "Idioma %s seleccionado. El cambio tendrá efecto cuando reinicies BeShare",
   "Idioma",
   "Alemán",
   "Tipo",
   "Tamaño",
   "Archivos",
   "Holandés",
   "Examinando Archivos...",
   "Comandos de irc disponibles:",
   "enviar un mensaje privado",
   "modificar tu nombre de usuario",
   "haz algo",
   "sinónimo para /action",
   "limpiar el historial de chat",
   "comenzar una nueva búsqueda",
   "detener la búsqueda actual",
   "conectar al servidor",
   "desconectar del servidor",
   "salir de BeShare",
   "mostrar este texto de ayuda",
   "<nombre o id de sesión> <texto>",
   "<nombre>",
   "<acción>",
   "[búsqueda]",
   "[servidor]",
   "Portugues",
   "Francés",
   "Emite un Beep Cuando tu Nombre es Mencionado",
   "Máximo de Subidas Simultáneas por Usuario",
   "Timestamps",
   "Limpiar automáticamente las Descargas Terminadas",
   "Máximo de Descargas Simultáneas por Usuario",
   "Italiano",
   "Conectar al Inicio",
   "Mensaje Privado",
   "Abrir Ventana Privada de Chat",
   "BeShare Ventana Privada de Chat",
   "Chatear Con:",
   "¡Error, usuario no especificado!",
   "Guardar Configuración",
   "Restaurar Configuración",
   "Error, comando desconocido",
   "Pulsa /help para una lista de comandos disponibles.",
   " - (%lu-%lu) de %lu resultados mostrados (",
   "Mostrar",
   "Mensajes Informativos",
   "Mensajes de Aviso",
   "Mensajes de Error",
   "Historial Habilitado",
   "Historial Deshabilitado",
   "Resultados Por Página",
   "Mueva a Pagina",
   "especificar usuarios a ignorar",
   "Ignorar modelo cambiado a: ",
   "Ignorar modelo quitado.",
   "<nombres o ids de sesión>",
   "Mover arriba",
   "Mover abajo",
   "Detener Transferencia",
   "Continuar Transferencia",
   "Abrir Archivo",
   "Ruso",
   "Chat",
   "El modelo /ignore actual es: ",
   "Deshabilitado",
   "Hay una transferencia %i en progreso, ¿estás seguro de que quieres salir?",
   "No salir",
   "Fecha de Modificación",
   "Esperanto",
   "Sueco",
   "ping otros clientes",
   "Ping devuelto en %Li milisegundos",
   "Hacer un ping a: ",
   "Noruego",
   "Serbio",
   "ausente",
   "Estado Ausente Automático",
   "minutos",
   "etiqueta",
   "modificar la etiqueta para ausente-automático",
   "Etiqueta para Ausente Automático modificada a: ",
   "Forzar estado ausente",
   "Abrir Carpeta",
   "Patrón de seguimiento modificado a: ",
   "Patrón de seguimiento quitado.",
   "El patrón de seguimiento actual es: ",
   "Especificar usuarios a seguir",
   "Comandos de inicio borrados",
   "comando",
   "agregar comando de inicio",
   "limpiar comandos de inicio",
   "Comando de inicio grabado: ",
   "Seguir a",
   "Estado del servidor solicitado",
   "%.1fMB usado (%.1fMB disponible)",
   "Estado del servidor",
   "Versión del servidor",
   "Root de la sesión local",
   "Memoria usada por el servidor",
   "Solicitar estado del servidor",
   "Tiempo en línea del servidor",
   "semanas",
   "días",
   "Tiempo conectado",
   "Conectado por",
   "Compartir Archivos activado",
   "Prohibir Usuario Para",
   "Usuario en IP %s está prohibido para",
   "Horas",
   "Siempre",
   "quitar todas las prohibiciones de subida",
   "Quitando %lu prohibiciones de subida",
   "Patrón AutoPriv establecido para:",
   "Patrón AutoPriv quitado",
   "especificar usuarios de AutoPriv",
   "Patrón /autopriv actual es",
   "¡Formato desconocido!",
   "Abrir carpeta de registros",
   "Estado",
   "Tu estado ha sido cambiado a: ",
   " está ahora ",
   "Cargar",
   "modificar el estado de usuario",
   "Búlgaro",
   "Trayectoria",
   "Conservar Trayectorias de Archivo",
   "Establecer Alias",
   "Alias quitado",
   "[nombre y valor]",
   "crear un alias",
   "quitar un alias",
   "Mover arriba del todo",
   "Mover abajo del todo",
   "establecer título de ventana",
   "El título de la ventana es",
   "Actualizar Automáticamente Lista de Servidores",
   "Servidor añadido: %s",
   "Servidor quitado: %s",
   "La version v%s de BeShare está disponible para descargar. Puede actualizarla a %s",
   "ejecutar orden de comando de líneas",
   "Ejecutando orden de comando de líneas",
   "orden de comando de líneas",
   "orden parada establecida para",
   "establecer orden para cuando termine la transferencia",
   "tamaño de fuente en puntos",
   "establecer tamaño de fuente",
   "Tamaño de fuente establecido en:",
   "Tamaño de fuente reajustado a la opción por defecto",
   "Cliente",
   "Se intentará reconectar automáticamente en %lu minutos",
   "Tratando de reconectar automáticamente",
   "Secuencia de reconexión automática terminada",
   "Coreano",
   "Límite del Ancho de Banda",
   "bytes/segundo",
   "Establecer el ratio máximo de descarga (por transferencia)",
   "Establecer el ratio máximo de subida (por transferencia)",
   "El ratio máximo de descarga es",
   "El ratio máximo de subida es",
   "Húngaro",
   "Cambiar Colores",
   "Color de Fondo",
   "Texto ya visto",
   "Color de Bordes",
   "Texto",
   "Sistema",
   "Alerta",
   "Error",
   "Acciones",
   "Mensajes Privados",
   "Nombre Mencionado",
   "Ping",
   "Nick Local",
   "Nick Remoto",
   "URL",
   "Texto Seleccionado",
   "Seguimiento de Usuario",
   "Progreso de Descarga",
   "Progreso de Subida",
   "Subida Detenida",
   "Preferencias de color por ",
   "Deshacer",
   "Predeterminado",
   "Cambiar los colores",
   "Rumano",
   "Compartir captura de pantalla",
   "compartiendo una captura de pantalla",
   "Error al compartir captura de pantalla",
   " ha finalizado la descarga ",
   "Transferencias durante esta sesión:  %s descargado, %s subido.",
   "mostrar información varia",
   "Prohibido",
   "hasta",
   "Compresión de Datos",
   "Bajo",
   "Medio",
   "Alto",
   "Chino",
   "Turco",
   "Japonés",
   "[nombre de fuente]",
   "establecer fuente",
   "Fuente establecida a",
   "Fuente reajustada a las opciones por defecto",
   "No se puede encontrar la fuente",
   "Subidas de menor tamaño primero",
   "Finés"
};

static const char _germanShortcuts[NUM_SHORTCUTS] = {
   'N',  // New connection
   'T',  // "Bye" to current connection
   'F',  // Shared dir
   'D',  // Download dir
   'L',  // clear Log
   'Z',  // Reset Layout
   'Q',  // Quit
   'K',  // Full user Queries
   'M',  // Beep When Mentioned
   'P',  // Open private chat window
   'G',  // Toggle file logging
   'E',  // File sharing enabled
   'O',  // Logs dir
};

// Submitted by:  hoshy (beat.rupp@gmx.net)
static const char * _germanStrings[NUM_STRINGS] = {
   "anonym",
   "unbekannt",
   " ist jetzt verbunden.",
   " hat die Verbindung getrennt.",
   "Benutzer #",
   " (alias ",
   " heißt jetzt ",
   "wahr",
   "falsch",
   "<unbekannter Typ>",
   "Benutzer ",
   " lädt herunter ",
   "Fehler beim Schreiben der Datei ",
   "Es trat ein Fehler auf.",
   "In Warteschlange (Lokaler Rechner ist überlastet)",
   "In Warteschlange (Entfernter Rechner ist überlastet)",
   "Gesendet: ",
   "Empfangen: ",
   "/Sek., ",
   "Erwarte Rückruf...",
   "Verbinde...",
   "Download beendet",
   "Download abgebrochen",
   "Konnte nicht verbinden",
   "Bereite Upload vor",
   "Bereite Download vor",
   "an",
   "von",
   "Fehler beim Starten des Downloads--keine gültigen Ports!",
   "Fehler beim Starten einer wartenden Verbindung!",
   "Fehler beim Starten einer wartenden Verbindung - kein Übermittlungs-Thread vorhanden!",
   "Fehler: konnte keinen Verbindungs-Thread erstellen! (Versuchen Sie, BeShare zu beenden und danach das Netzwerk neuzustarten)",
   "(Es sind %i lokale Dateien freigegeben)",
   "Konnte Ordner 'shared' nicht finden. Dateifreigabe deaktiviert!",
   "\0011Dateiname",
   "\0012Benutzer",
   "\0013SitzungsID",
   "\0014Verbindung",
   "Datei",
   "Verbinden mit Server",
   "Verbindung trennen",
   "Freigegebenen Ordner öffnen",
   "Downloads-Ordner öffnen",
   "Chat-Aufzeichnung löschen",
   "Ansicht zurücksetzen",
   "Über BeShare",
   "Beenden",
   "Attribute",
   "Einstellungen",
   "Max. Gleichzeitige Uploads",
   "Max. Gleichzeitige Downloads",
   "Keine Beschränkung",
   "Upload-Bandbreite",
   "Aufzeichnung",
   "Uploads",
   "Benutzerereignisse",
   "Änderungen abfragen",
   "Vollständige Benutzerabfragen",
   "Ich bin hinter einer Firewall",
   "Suche:",
   "Starte Abfrage",
   "Stoppe Abfrage",
   "Server:",
   "Benutzername:",
   "Markierte Dateien herunterladen",
   "Beendete/fehlerhafte Übertragungen löschen",
   "Markierte Dateien entfernen",
   "Chat",
   "Name",
   "ID",
   "BeShare lauscht auf Port %u.  Wählen Sie Verbinden im Menu Datei, um loszulegen!",
   "Server für die Dateifreigabe konnte nicht gestartet werden!",
   "Kann nicht herunterladen von Benutzer ",
   ", keine Informationen zur Verbindung sind vorhanden.",
   "Kann keine Dateien herunterladen von ",
   ", weil wir beide hinter einer Firewall sind.",
   "Sitzung für eingehenden Dateidownload von",
   " initialisieren schlug fehl!",
   "Sitzung für Dateidownload an ",
   "Abfrage geändert in",
   "Abfrage gestartet",
   "Download-Sitzung für anfragenden, entfernten Rechner konnte nicht gestartet werden!",
   "Ihr Name wurde geändert auf ",
   "von",
   "Unbekannter Benutzer ",
   ", Mitteilung \"",
   "\" nicht gesendet.",
   "Kein Zielbenutzer in /msg angegeben",
   "Abfrage gestoppt",
   "System",
   "Warnung",
   "Fehler",
   "Aktion",
   "Verbinden mit ",   //?
   " - Verbinde mit ",
   " - %lu Resultate angezeigt (",
   " - Verbunden mit ",
   "Verbindung hergestellt.",
   "Verbinde mit Server...",
   "Sie sind nicht mehr mit dem MUSCLE-Server verbunden.",
   "Verbindung zum Server schlug fehl.",
   "Englisch",
   "Spanisch",
   "Sprache %s ausgewählt.  Sie müssen BeShare neu starten, damit die Änderungen wirksam werden.",
   "Sprache",
   "Deutsch",
   "Dateiart",
   "Dateigröße",
   "Dateien",
   "Holländisch",
   "Überprüfe Dateien",
   "Vorhandene IRC-Kommandos:",
   "eine private Nachricht senden",
   "ändern Sie Ihren Benutzernamen",
   "machen Sie etwas",
   "Synonym für /action",
   "Chat-Aufzeichnung löschen",
   "neue Abfrage starten",
   "aktuelle Abfrage stoppen",
   "verbinde mit Server",
   "Verbindung trennen",
   "BeShare beenden",
   "diesen Hilfetext anzeigen",
   "<Name oder SitzungsID> <Text>",
   "<Name>",
   "<Aktion>",
   "[AbfrageString]",
   "[ServerName]",
   "Portugiesisch",
   "Französisch",
   "Piepston Ausgeben, wenn Sie Angesprochen Werden",
   "Max. Gleichzeitige Uploads pro Benutzer",
   "Zeitstempel",
   "Beendete Downloads automatisch löschen",
   "Max. Gleichzeitige Downloads pro Benutzer",
   "Italienisch",
   "Bei Programmstart automatisch einloggen",
   "Private Nachrichten",
   "Privates Chat-Fenster öffnen",
   "Privates BeShare Chat-Fenster",
   "Chatten mit",
   "Fehler: kein Benutzer angegeben!",
   "Standard-Einstellung speichern",
   "Standard-Einstellung wiederherstellen",
   "Fehler: unbekannter Befehl",
   "Geben Sie /help ein, um eine Liste von verfügbaren Befehlen anzuzeigen.",
   " - (%lu-%lu) von %lu Resultaten angezeigt (",
   "Anzeige",
   "Informationsmeldungen",
   "Warnmeldungen",
   "Fehlermeldungen",
   "Protokollierung Ein",
   "Protokollierung Aus",
   "Resultate pro Seite",
   "Wechsle zu Seite",
   "Geben Sie zu ignorierende Benutzer an",
   "Muster zur Ignorierung gesetzt auf: ",
   "Muster zur Ignorierung entfernt.",
   "<Namen oder Sitzungs-IDs>",
   "Nach oben",
   "Nach unten",
   "Transfer stoppen",
   "Transfer neustarten",
   "Datei öffnen",
   "Russisch",
   "Chat",
   "Aktuelles /ignore-Muster ist: ",
   "Aus",
   "Es sind noch %i Übertragungen im Gang. Sind Sie sicher, dass Sie BeShare beenden wollen?",
   "Nicht beenden",
   "Änderungsdatum",
   "Esperanto",
   "Schwedisch",
   "andere Rechner 'pingen'",
   "Ping antwortete in %Li Millisekunden",
   "Ping gesendet an: ",
   "Norwegisch",
   "Serbisch",
   "abwesend",
   "Automatische Abwesenheit",
   "Minuten",
   "tag",
   "Text der automatischen Abwesenheitsschaltung ändern",
   "Text der automatischen Abwesenheitsschaltung ist: ",
   "Abwesenheit erzwingen",
   "Öffne Ordner",
   "Beobachtungs-Muster gesetzt auf: ",
   "Beobachtungs-Muster entfernt.",
   "Aktuelles Beobachtungs-Muster ist: ",
   "Zu beobachtende Benutzer angeben",
   "Startbefehle gelöscht.",
   "Befehl",
   "Startbefehl hinzufügen",
   "Startbefehle löschen",
   "Aufgezeichneter Startbefehl: ",
   "Beobachte",
   "Server-Status angefordert",
   "%.1MB belegt (%.1fMB frei)",
   "Server-Status:",
   "Server-Version",
   "Lokales Wurzelverzeichnis",
   "Belegter Speicher des Servers",
   "Server-Status anfordern",
   "Server-Uptime",
   "Wochen",
   "Tage",
   "System-Uptime",
   "Online seit",
   "Dateifreigabe eingeschaltet",
   "Benutzer ausschließen für",
   "Benutzer mit IP %s ist ausgeschlossen für",
   "Stunden",
   "Für immer",
   "entferne alle Upload-Ausschlüsse",
   "Entferne %lu Upload-Ausschlüsse",
   "AutoPriv-Muster gesetzt auf: ",
   "AutoPriv-Muster entfernt.",
   "AutoPriv-Benutzer bestimmen",
   "Aktuelles /autopriv-Muster ist: ",
   "Unbekanntes Datenformat!",
   "Log-Ordner öffnen",
   "Status",
   "Ihr Status wurde geändert auf: ",
   " ist jetzt ",
   "Auslastung",
   "Benutzerstatus setzen",
   "Bulgarisch",
   "Pfad",
   "Dateipfade beibehalten",
   "Setze Alias",
   "Alias entfernt",
   "[Name und Wert]",
   "Alias erstellen",
   "Alias antfernen",
   "An erste Stelle",
   "An letzte Stelle",
   "eigene Fensterüberschrift setzen",
   "eigene Fensterüberschrift ist",
   "Serverliste automatisch updaten",
   "Server %s hinzugefügt",
   "Server %s entfernt",
   "BeShare v%s ist jetzt erhältlich zum Download. Upgraden Sie auf %s",
   "Shell-Befehl ausführen",
   "Shell-Befehl wird ausgeführt",
   "Shell-Befehl",
   "Ruhebefehl gesetzt auf",
   "Befehl setzen für beendete Downloads",
   "Schriftgrösse in Punkten",
   "Schriftgrösse setzen",
   "Schriftgrösse gesetzt auf:",
   "Schriftgrösse auf Standard zurückgesetzt",
   "Client",
   "Erneute Herstellung der Verbindung in %lu Minuten.",
   "Verbinde erneut.",
   "Automatisches Wiederverbinden beendet.",
   "Koreanisch",
   "Bandbreite begrenzen",
   "Bytes/Sekunde",
   "Max. Download-Geschwindigkeit (pro Transfer)",
   "Max. Download-Geschwindigkeit (pro Transfer) einstellen",
   "Max. Download-Geschwindigkeit ist",
   "Max. Upload-Geschwindigkeit ist",
   "Hungarian",
   "Farben",
   "Texthintergrund",
   "Gescrollter Texthintergrund",
   "Ränder",
   "Text",
   "System",
   "Warnungen",
   "Fehler",
   "Aktionen",
   "Privat",
   "Gesprochener Name",
   "Ping",
   "Lokaler Name",
   "Entfernter Name",
   "URL",
   "Auswahl",
   "Beobachtet",
   "Download-Fortschritt",
   "Upload-Fortschritt",
   "Upload-Fortschritt pausiert",
   "Farbeinstellungen von",
   "Zurücksetzen",
   "Standard",
   "Benutzerdefinierte Farben aktivieren",
   "Rumänisch",
   "Screenshot freigeben",
   "Screenshot ist freigegeben",
   "Screenshot konnte nicht freigegeben werden",
   " hat fertig heruntergeladen: ",
   "In dieser Sitzung übertragen:  %s down, %s up.",
   "Anzeigen sonstiger Infos",
   "Verbannt",
   "bis",
   "Datenkomprimierung",
   "Niedrig",
   "Mittel",
   "Hoch",
   "Chinesisch",
   "Turkish",
   "Japanese",
   "[font name]",
   "set font",
   "Font set to",
   "Font reset to default",
   "Couldn't find font",
   "Shortest Uploads First",
   "Finnisch"
};

static const char _dutchShortcuts[NUM_SHORTCUTS] = {
   'N',  // New connection
   'B',  // "Bye" to current connection
   'G',  // Shared dir
   'I',  // Download dir
   'L',  // clear Log
   'H',  // Reset Layout
   'Q',  // Quit
   'Z',  // Full user Queries
   'M',  // Beep When Mentioned
   'P',  // Open private chat window
   'F',  // Toggle file logging
   'E',  // File sharing enabled
   'O',  // Logs dir
};

// Submitted by Zathros/Ted Leeuwesteijn Ted@nds.nl, 3rdrock@bart.nl
static const char * _dutchStrings[NUM_STRINGS] = {
   "Anoniem",
   "onbekend",
   " is nu verbonden.",
   " heeft verbroken.",
   "gebruiker #",
   " (o.b.a ",
   " heeft nu de naam ",
   "waar",
   "onecht",
   "<onbekende soort>",
   "Gebruiker ",
   " is aan het binnenhalen ",
   "Fout tijdens schrijf operatie ",
   "Er is een fout opgetreden.",
   "Pauze (Lokale machine heeft het te druk)",
   "Pauze (Andere machine heeft het te druk)",
   "Zend: ",
   "Ontvangen: ",
   "/sec, ",
   "Wacht op terugbel bevestiging...",
   "Verbinden...",
   "Binnenhalen klaar",
   "Binnenhalen geannuleerd",
   "Kon niet verbinden",
   "Opmaken voor sturen",
   "Opmaken voor binnenhalen",
   "naar",
   "van",
   "Fout bij het binnenhalen bestand--geen acceptatie poort!",
   "Fout bij vertraagde verbinding!",
   "Fout bij vertraagde verbinding--geen transceiver draad!",
   "Fout, kan geen verbindings draad vinden!",
   "(Delen van %i lokale bestanden)",
   "Kan geen 'gedeelde' bestanden vinden in de shared folder, Delen niet geactiveerd!",
   "\0011Bestands Naam",
   "\0012Gebruiker",
   "\0013SessieNr",
   "\0014Verbinding",
   "Bestand",
   "Verbinden met server",
   "Verbreken",
   "Open Gedeelde Folder",
   "Open Inkomende Folder",
   "Maak Chat Log Schoon",
   "Herstel Venster",
   "Over BeShare",
   "Einde",
   "Attributen",
   "Instellingen",
   "Max Simultane Uploads",
   "Max Simultane Downloads",
   "Onbegrensd",
   "Uitgaande Bandbreedte",
   "Log",
   "Inkomend",
   "Gebruikers Gebeurtenissen",
   "Veranderde Zoekopdracht",
   "Volledige Gebruiker Zoekopdrachten",
   "Ik Ben Afgeschermd",
   "Zoek:",
   "Start Zoek",
   "Stop Zoek",
   "Server:",
   "Gebruikers Naam:",
   "Haal geselecteerde bestanden op",
   "Maak beeindigde/mislukte Transmissies schoon",
   "Verwijder Selectie",
   "Praat",
   "Naam",
   "Nr",
   "BeShare luistert op poort %i. Selecteer verbinden in het bestands menu om te beginnen!",
   "Kan geen BestandsDelingServerDraad vinden!",
   "Kan niet binnenhalen van de gebruiker ",
   ", geen verbindings informatie beschikbaar.",
   "Kan niet binnenhalen van ",
   ", omdat wij beiden achter een firewall zitten.",
   "Bestand binnenhalen acceptatie voor ",
   " fout in initialisatie!",
   "Bestands verzoek sessie naar",
   "Zoek opdracht veranderd in",
   "Zoek opdracht gestart",
   "Kan geen GedeeldeBestandsOverdracht sessie starten voor extern overdracht verzoek!",
   "Je naam is veranderd in ",
   "door",
   "Onbekende gebruiker ",
   ", bericht \"",
   "\" niet verzonden.",
   "Geen gebruikersnaam geselecteerd in /msg",
   "Zoek opdracht gestopt",
   "Systeem",
   "Waarschuwing",
   "fout",
   "Aktie",
   "Verbind met ",
   " - Verbinden met ",
   " - toont %lu resultaten (",
   " - Verbonden met ",
   "Verbinding opgebouwd.",
   "Verbinden met server...",
   "U bent niet langer verbonden met de MUSCLE server.",
   "Verbinding met server is mislukt.",
   "Engels",
   "Spaans",
   "Taal %s geselekteerd. De veranderingen vinden plaats na het herstarten van BeShare.",
   "Taal",
   "Duits",
   "Soort",
   "Bestands Grootte",
   "Aantal",
   "Nederlands",
   "Onderzoekt bestanden",
   "Beschikbare irc-stijl commandos:",
   "zend een prive bericht",
   "verander je gebruikersnaam",
   "Doe iets",
   "synoniem voor /action",
   "maak praat venster schoon",
   "start een nieuwe zoek aktie",
   "stop de huidige zoekaktie",
   "verbind met een server",
   "verbreek met de huidige server",
   "einde BeShare",
   "geeft deze helptekst weer",
   "<naam of sessie_Nr> <Tekst>",
   "<eigennaam>",
   "<aktie>",
   "[zoekregel]",
   "[servernaam]",
   "Portugees",
   "Frans",
   "Geef Geluid Wanneer u Genoemd Word",
   "Max Simultane Uploads per Gebruiker",
   "Toon Tijd",
   "AutoBeeindigde Downloads Schoon",
   "Max Simultane Downloads per Gebruiker",
   "Italians",
   "Verbind bij Starten",
   "Prive Berichten",
   "Open Prive Venster",
   "BeShare Prive Venster",
   "Praat Met:",
   "Fout, Geen Gebruiker Geselecteerd",
   "Bewaar Instelling",
   "Herstel Instelling",
   "Fout, onbekende opdracht",
   "Gebruik /help voor een lijst van beschikbare opdrachten.",
   " - (%lu-%lu) van %lu toont resultaten (",
   "Toon",
   "Berichten Info",
   "Alarm Berichten",
   "Fout Berichten",
   "Logboek Aan",
   "Logboek Uit",
   "Resultaten Per Pagina",
   "Ga naar Pagina",
   "selecteer de te negeren gebruikers",
   "Negeer patroon staat op: ",
   "Negeer patroon verwijderd.",
   "<namen of sessie nummers>",
   "Omhoog",
   "Omlaag",
   "Stop Binnenhalen",
   "Herstart Binnenhalen",
   "Open Bestand",
   "Russe",
   "Praat",
   "Huidige /ignore patroon is:",
   "Uitgeschakeld",
   "Er zijn %i transacties gaande, weet u zeker dat u wilt stoppen?",
   "Niet Stoppen",
   "Veranderd",
   "Esperanto",
   "Zweeds",
   "ping andere partij",
   "Ping antwoord in %Li Milliseconden",
   "Zend ping verzoek naar: ",
   "Noors",
   "Servisch",
   "weg",
   "Automatisch Weg",
   "minuten",
   "etiket",
   "verander het atomatisch-weg etiket",
   "Automatisch-weg etiket ingesteld op: ",
   "Forceer weg status.",
   "Open Map",
   "kijk patroon gezet op:",
   "Kijk patroon verwijderd.",
   "Huidige /kijk patroon is: ",
   "specifeer gebruikers om te kijken",
   "Opstart commando's opgeschoond.",
   "commando",
   "voeg opstart commando toe",
   "maak opstart commando's schoon",
   "Opgenomen opstart commando: ",
   "Kijk",
   "Server status verzocht.",
   "%. 1fMB gebruikt (%. 1fMB beschikbaar)",
   "Server status:",
   "Server Versie",
   "Lokale sessie root",
   "Server geheugen gebruik",
   "Verzoek server status",
   "Server leeftijd",
   "weken",
   "dagen",
   "Systeem Leeftijd",
   "ingelogd voor",
   "Delen Bestanden Aktief",
   "Weiger Gebruiker Voor",
   "Gebruiker op IP %s is geweigerd voor",
   "Uren",
   "Permanent",
   "Verwijder alle uitgaande weigeringen",
   "Verwijder %lu uitgaande weigeringen",
   "AutoPriv patroon gezet op: ",
   "Autopriv patroon verwijderd",
   "Specificeer Autopriv Gebruikers",
   "Huidige /autopriv patroon is :",
   "Gegevens formaat onbekend!",
   "Open Logboek Map",
   "Status",
   "Uw status is veranderd naar: ",
   " is nu ",
   "Bezetting",
   "Stel gebruikers gegevens regel in",
   "bulgaars",
   "locatie",
   "behoud bestands locaties",
   "Stel alias in",
   "verwijderede alias",
   "Naam en waarde",
   "creeer een alias",
   "Verwijder een alias",
   "Verplaats naar Top",
   "Verplaats naar onderaan",
   " Stel een andere verster titel in",
   "andere venster titel is nu",
   "Automatisch bijwerken van server lijst",
   "Toegevoegde server: %s",
   "verwijderde server: %s",
   "BeShare v%s is nu verkrijgbaar, u kunt opwaarderen op %s",
   "voer shell opdracht uit",
   "shell opdracht uitgevoerd",
   "shell opdracht",
   "idle opdracht ingesteld op",
   "zet op overleden download opdrachten",
   "lettergrootte in punten",
   "lettergrootte instellen",
   "lettergrootte ingesteld op:",
   "lettergrootte op standaard",
   "Client",
   "Probeert automatisch  opnieuw te verbinden in %lu minuten",
   "Probeert opnieuw te verbinden.",
   "Auto-verbind opdracht beeindigd.",
   "Koreaans",
   "Beperk bandbreedte",
   "bytes/seconde",
   "instellen max. inkomende bandbreedte  (per transfer)",
   "instellen max. uitgaande bandbreedte  (per transfer)",
   "Max. inkomende bandbreedte is",
   "Max. uitgaande bandbreedte is",
   "Hongaars",
   "Kleuren Keus",
   "Tekst Achtergrond",
   "Ander Tekst Achtergrond",
   "Boord Gebied",
   "Tekst",
   "Systeem",
   "Waarschuwing",
   "Fout",
   "Actie",
   "Prive",
   "Naam Gesproken",
   "Ping",
   "Nick Locaal",
   "Nick Afgelegen",
   "URL",
   "Selectie",
   "Kijk",
   "Download voortgang",
   "Upload voortgang",
   "Gepauzeerde upload voortgang",
   "Kleur voorkeuren bij",
   "Herstel",
   "Standaard",
   "Schakel aangepaste kleuren",
   "Roemeens",
   "Deel schermdump",
   "deelt een schermdump nu",
   "Fout met delen schermdump",
   " is klaar met binnenhalen ",
   "Overdracht deze sessie:  %s down, %s up.",
   "Toon informatie",
   "Verbannen",
   "tot",
   "Data compressie",
   "Laag",
   "Gemiddeld",
   "Hoog",
   "Chinees",
   "Turkish",
   "Japanese",
   "[font name]",
   "set font",
   "Font set to",
   "Font reset to default",
   "Couldn't find font",
   "Shortest Uploads First",
   "Finnish"
};

static const char _portugueseShortcuts[NUM_SHORTCUTS] = {
   'N',  // New connection
   'B',  // "Bye" to current connection
   'S',  // Shared dir
   'D',  // Download dir
   'L',  // clear Log
   'R',  // Reset Layout
   'Q',  // Quit
   'U',  // Full user Queries
   'M',  // Beep When Mentioned
   'P',  // Open private chat window
   'F',  // Toggle file logging
   'E',  // File sharing enabled
   'O',  // Logs dir
};

// Submitted by: BGA (bga@bug-br.org.br)
static const char * _portugueseStrings[NUM_STRINGS] = {
   "Anônimo",
   "Desconhecido",
   " conectou-se.",
   " desconectou-se.",
   "Usuário #",
   " (t.c.c ",
   " agora é conhecido por ",
   "verdadeiro",
   "falso",
   "<tipo desconhecido>",
   "Usuário ",
   " está transferindo ",
   "Erro ao escrever no arquivo ",
   "Um Erro Ocorreu.",
   "Empilhado (Máquina local muito ocupada)",
   "Empilhado (Máquina remota muito ocupada)",
   "Enviado: ",
   "Recebido: ",
   "/seg, ",
   "Esperando retorno...",
   "Conectando...",
   "Transferência completa",
   "Transferência abortada",
   "Impossivel conectar",
   "Preparando Transferência",
   "Preparando Transferência",
   "para",
   "de",
   "Erro ao iniciar transferência--porta accept inexistente!",
   "Erro ao iniciar conexão adiada!",
   "Erro ao iniciar conexão adiada--thread transceiver inexistente!",
   "Erro, impossivel criar thread de conexão!",
   "(Compartilhando %i arquivos locais)",
   "Impossivel encontrar subdiretório 'shared', compartilhamento de arquivos desabilitado!",
   "\0011Nome do Arquivo",
   "\0012Usuário",
   "\0013ID de Sessão",
   "\0014Conexão",
   "Arquivo",
   "Conectar ao servidor",
   "Desconectar",
   "Abrir Diretório Shared",
   "Abrir Diretório Downloads",
   "Apagar Histórico de Chat",
   "Resetar Layout",
   "Sobre BeShare",
   "Sair",
   "Atributos",
   "Configurações",
   "Max de Uploads Simultâneos",
   "Max de Downloads Simultâneos",
   "Sem Limite",
   "Banda de Transferência (Upload)",
   "Histórico",
   "Transferências (Uploads)",
   "Eventos de Usuários",
   "Mudanças de Pesquisa",
   "Pesquisas Completas por Usuários",
   "Estou Atrás de um Firewall",
   "Pesquisa:",
   "Iniciar Pesquisa",
   "Parar Pesquisa",
   "Servidor:",
   "Nome de Usuário:",
   "Transferir Arquivos Selecionados",
   "Limpar Transferências Completas/Falhas",
   "Remover Selecionados",
   "Conversação",
   "Nome",
   "ID",
   "BeShare está escutando na porta %u.  Selecione Conectar no menu Arquivo para iniciar!",
   "Impossivel iniciar thread do servidor de compartilhamento de arquivos!",
   "impossível transferir do usuário ",
   ", informação sobre conexão não disponível.",
   "Impossível transferir arquivos de ",
   ", porque ambos estamos atrás de firewalls.",
   "Sessão de aceitação de transferência de arquivo para ",
   " falhou durante a inicialização!",
   "Sessão de transferência de arquivo para ",
   "Pesquisa Mudada para",
   "Pesquisa Iniciada",
   "Impossível iniciar sessão de Tranferência de Arquivo para servir requisição remota de transferência!",
   "Seu nome foi mudado para ",
   "por",
   "Usuário desconhecido ",
   ", mensagem \"",
   "\" não enviada.",
   "Nenhum usuário destino especificado no /msg",
   "Pesquisa Interrompida",
   "Sistema",
   "Aviso",
   "Erro",
   "Ação",
   "Conectar em ",
   " - Conectando em ",
   " - %lu resultados mostrados (",
   " - Conectado a ",
   "Conexão estabelecida.",
   "Conectando ao servidor...",
   "Você não está mais conectado ao servidor MUSCLE.",
   "Conexão ao servidor falhou.",
   "Inglês",
   "Espanhol",
   "Lingua %s selecionada.  A mudança se tornará efetiva após você reiniciar o BeShare.",
   "Lingua",
   "Alemão",
   "Tipo",
   "Tamanho do Arquivo",
   "Arquivos",
   "Holandês",
   "Examinando Arquivos...",
   "Comandos estilo irc disponíveis:",
   "envia uma mensagem privada",
   "muda seu nome de usuário",
   "faz alguma coisa",
   "sinônimo para /action",
   "limpa o histórico de chat",
   "inicia uma nova pesquisa",
   "finaliza a pesquisa atual",
   "conecta a um servidor",
   "desconecta de um servidor",
   "sai do BeShare",
   "mostra esse texto de ajuda",
   "<nome ou id de sessão> <texto>",
   "<nome>",
   "<ação>",
   "[stringDeBusca]",
   "[nomeDoServidor]",
   "Português",
   "Francés",
   "Emitir um Bip Quando Seu Nome for Mencionado",
   "Max de Uploads Simultâneos por Usuário",
   "Timestamps",
   "AutoLimpar Downloads Completos",
   "Max de Downloads Simultâneos por Usuário",
   "Italiano",
   "Conectar ao Iniciar",
   "Mensagens Privadas",
   "Abrir Janela de Conversação Privada",
   "Janela de Conversação Privada do BeShare",
   "Conversar com:",
   "Erro, nenhum usuário especificado!",
   "Salvar Configuração",
   "Restaurar Configuração",
   "Erro, comando desconhecido",
   "Digite /help para obter uma lista dos comandos disponíveis.",
   " - (%lu-%lu) dos %lu resultados mostrados (",
   "Mostrar",
   "Mensagens Informativas",
   "Mensagens de Aviso",
   "Mensagens de Erro",
   "Log Habilitado",
   "Log Desabilitado",
   "Resultados Por Página",
   "Mudar para Página",
   "especifique usuários a ignorar",
   "Padrão a ignorar configurado para: ",
   "Padrão a ignorar removido.",
   "<nomes ou ids de sessão> ",
   "Mover Para Cima",
   "Mover Para Baixo",
   "Interromper Transfer",
   "Reiniciar Transfer",
   "Abrir Arquivo",
   "Ruso",
   "Conversação",
   "O padrão /ignore é: ",
   "Desabilitado",
   "Existem %i transferências em progresso, tem certeza de que você quer mesmo sair?",
   "Não Sair",
   "Data de Modificação",
   "Esperanto",
   "Sueco",
   "envia ping para outros clientes",
   "Ping retornou em %Li milisegundos",
   "Requisição de ping enviada para: ",
   "Norueguês",
   "Sérvio",
   "ausente",
   "Ausente Automaticamente",
   "minutos",
   "tag",
   "Alterar a tag de ausência automática",
   "Tag de ausência automática alterada para: ",
   "Forçar ausência",
   "Abrir Diretório",
   "Padrão de observação setado para: ",
   "Padrão de observação removido.",
   "Padrão de /watch atual é: ",
   "especifica usuários a observar",
   "Comandos de inicialização apagados.",
   "comando",
   "adiciona comando de inicialização",
   "apaga comandos de inicialização ",
   "Comando de inicialização gravado:",
   "Observar",
   "Status do servidor requerido.",
   "%.1fMB usados (%.1fMB disponíveis)",
   "Status do servidor:",
   "Versão do servidor",
   "Raiz da sessão local",
   "Uso de memória do servidor",
   "Requisita status do servidor",
   "Uptime do servidor",
   "semanas",
   "dias",
   "Uptime do Sistema",
   "conectado a",
   "Compartilhamento de Arquivos Habilitado",
   "Banir Usuário Por",
   "Usuário no IP %s banido por",
   "Horas",
   "Para Sempre",
   "Remover todos os banidos para upload",
   "Removendo %lu banidos para upload",
   "Padrão de AutoPriv setado para: ",
   "Padrão de AutoPriv removido.",
   "especifica usuários AutoPriv",
   "Padrão AutoPriv atual é: ",
   "Formato de dados desconhecido!",
   "Abrir Pasta de Logs",
   "Status",
   "Seu status foi mudado para: ",
   " agora está ",
   "Carga",
   "seta o texto de status do usuário",
   "Búlgaro",
   "Diretório",
   "Manter Diretórios",
   "Alias configurado",
   "Alias removido",
   "[nome e valor]",
   "cria um alias",
   "remove um alias",
   "Mover para o Topo",
   "Mover para o Fundo",
   "configura título da janela",
   "Título da janela agora é",
   "Atualização Automática da Lista de Servidores",
   "Adicionado servidor: %s",
   "Removido servidor: %s",
   "BeShare v%s está disponivel para download. Você pode atualizar em %s",
   "executa um comando shell",
   "Executando comando shell",
   "comando shell",
   "Comando ocioso setado para",
   "configura comando a ser executado quando as transferências encerram",
   "tamanho da fonte em pontos",
   "configurar tamanho de fonte",
   "Tamanho de fonte configurado para:",
   "Tamanho de fonte reconfigurado para padrão",
   "Cliente",
   "Tentativa de auto-reconexão em %lu minutos.",
   "Tentando auto-reconexão.",
   "Sequncia de auto-reconexão encerrada.",
   "Coreano",
   "Limitar Banda",
   "bytes/segundo",
   "Seta taxa máxima de download (por transferência)",
   "Seta taxa máxima de upload (por transferência)",
   "Taxa máxima de download é",
   "Taxa máxima de upload é",
   "Húngaro",
   "Escolher Cores",
   "Fundo do Texto",
   "Fundo do Texto Rolado",
   "Bordas",
   "Texto",
   "Sistema",
   "Aviso",
   "Erro",
   "Ação",
   "Privada",
   "Nome Mencionado",
   "Ping",
   "Apelido Local",
   "Apelido Remoto",
   "URL",
   "Seleção",
   "Observação",
   "Progresso do Download",
   "Progresso do Upload",
   "Progresso do Upload em Pausa",
   "Preferências de côr por",
   "Reverter",
   "Padrão",
   "habilita/desabilita cores customizadas",
   "Romeno",
   "Compartilhar captura de tela",
   "agora está compartilhando uma captura de tela",
   "Erro compartilhando captura de tela",
   " concluiu o download de ",
   "Transferidos nesta sessão: %s entrando, %d saindo",
   "mostra algumas informações",
   "Banido",
   "até",
   "Compressão de Dados",
   "Baixa",
   "Média",
   "Alta",
   "Chinês",
   "Turkish",
   "Japanese",
   "[font name]",
   "set font",
   "Font set to",
   "Font reset to default",
   "Couldn't find font",
   "Shortest Uploads First",
   "Finnish"
};

static const char _frenchShortcuts[NUM_SHORTCUTS] = {
   'N',  // New connection
   'B',  // "Bye" to current connection
   'P',  // Shared dir
   'T',  // Download dir
   'E',  // clear Log
   'R',  // Reset Layout
   'Q',  // Quit
   'U',  // Full user Queries
   'M',  // Beep When Mentioned
   'I',  // Open private chat window
   'F',  // Toggle file logging
   'S',  // File sharing enabled
   'O',  // Logs dir
};

/* French translation by Didier Bertrand (didix@mail.be) */
static const char * _frenchStrings[NUM_STRINGS] = {
   "Anonyme",
   "Inconnu",
   " connecté.",
   " déconnecté.",
   "Utilisateur #",
   " (alias ",
   " maintenant connu comme ",
   "vrai",
   "faux",
   "<type inconnu>",
   "Utilisateur ",
   " en téléchargement ",
   "Erreur d'écriture de fichier ",
   "Une erreur s'est produite.",
   "En attente (Machine locale trop occupée)",
   "En attente (Machine distante trop occupée)",
   "Envoyé: ",
   "Reçu: ",
   "/sec, ",
   "En attente d'une réponse...",
   "Connexion...",
   "Téléchargement terminé",
   "Téléchargement abandonné",
   "Connexion impossible",
   "Préparation à l'envoie",
   "Préparation au téléchargement",
   "à",
   "de",
   "Erreur en commençant le téléchargement--pas d'acceptation du port!",
   "Erreur à l'établissement de la connexion retardée!",
   "Erreur à l'établissement de la connexion retardée--pas de thread transmetteur!",
   "Erreur, création de thread connecteur impossible!",
   "(Partage de %i fichiers locaux)",
   "Dossier 'Shared' introuvable, fichiers partagés indisponibles!",
   "\0011Nom du Fichier",
   "\0012Utilisateur",
   "\0013N° de Session",
   "\0014Connexion",
   "Fichier",
   "Connecter au serveur",
   "Déconnecter",
   "Ouvrir le Dossier Partagé",
   "Ouvrir le Dossier des Téléchargements",
   "Effacer l'historique des Discussions",
   "Restaurer la Fenêtre",
   "A Propos de BeShare",
   "Quitter",
   "Attributs",
   "Configuration",
   "Max. d'envois Simultanés",
   "Max. de Téléchargements Simultanés",
   "Illimité",
   "Type de Connexion",
   "Historique",
   "Envois",
   "Evénements Utilisateur",
   "Changements de Recherche",
   "Tout Rechercher chez l'utilisateur",
   "Je Suis Protégé par un Firewall",
   "Requête:",
   "Démarrer Requête",
   "Arrêter Requête",
   "Serveur:",
   "Nom d'utilisateur:",
   "Télécharger les fichiers sélectionnés",
   "Effacer les transferts terminés/abandonnés",
   "Effacer la sélection",
   "Discussion",
   "Nom",
   "N°",
   "BeShare utilise le port %u.  Sélectionnez Connecter du menu Fichier pour commencer!",
   "Thread du serveur d'échange de fichiers impossible à lancer!",
   "Téléchargement impossible depuis l'utilisateur ",
   ", aucune information de connexion disponible.",
   "Téléchargement de fichiers impossible depuis ",
   ", parce que nous sommes derrière des Firewalls.",
   "Acceptation de session de téléchargement de fichier pour",
   " initialisation ratée!",
   "Session de téléchargement de fichier à ",
   "Requête changée en",
   "Requête démarrée",
   "Session PartageFichierTransfert impossible à commencer pour répondre à une requête de transfert distante!",
   "Votre nom a été changé en ",
   "par",
   "Utilisateur inconnu : ",
   "; le message \"",
   "\" n'a pas été envoyé.",
   "Pas de destinataire spécifié dans /msg",
   "Requête arrêtée",
   "Système",
   "Avertissement",
   "Erreur",
   "Action",
   "Connecter à ",
   " - Connexion à ",
   " - %lu résultats affichés (",
   " - Connecté à ",
   "Connexion établie.",
   "Connexion au serveur...",
   "Vous n'êtes plus connecté au serveur MUSCLE.",
   "Connexion au serveur ratée.",
   "Anglais",
   "Espagnol",
   "Langue %s sélectionnée.  Le changement prendra effet après avoir redémarré BeShare.",
   "Langue",
   "Allemand",
   "Type",
   "Taille du Fichier",
   "Fichiers",
   "Néerlandais",
   "Contrôle des fichiers...",
   "Commandes du type irc disponibles:",
   "envoyer un message privé",
   "changer votre nom d'utilisateur",
   "faire quelque chose",
   "synonyme pour /action",
   "effacer l'historique de discussion",
   "démarrer une nouvelle recherche",
   "arrêter la recherche actuelle",
   "connecter à un serveur",
   "déconnecter du serveur",
   "quitter BeShare",
   "afficher ce texte d'aide",
   "<nom ou n° de session> <texte>",
   "<nom>",
   "<action>",
   "[Chaîne de recherche]",
   "[Nom du serveur]",
   "Portugais",
   "Français",
   "Faire un Bip une Fois Mentionné",
   "Max. d'envois Simultanés par Utilisateur",
   "Horodateurs",
   "AutoEffacer les Transferts Terminés",
   "Max. de Téléchargements Simultanés par Utilisateur",
   "Italien",
   "Connexion au Lancement",
   "Messages Privés",
   "Ouvrir une Fenêtre de Discussion Privée",
   "Fenêtre Privée de Discussion de BeShare",
   "Discussion avec:",
   "Erreur, Aucun Utilisateur Spécifié!",
   "Enregistrer la Configuration",
   "Restaurer la Configuration",
   "Erreur, commande inconnue",
   "Tapez /help pour obtenir la liste des commandes disponibles.",
   " - (%lu-%lu) des %lu résultats affichés (",
   "Affichage",
   "Messages d'Information",
   "Messages d'Avertissement",
   "Messages d'Erreur",
   "Historique Disponible",
   "Historique Indisponible",
   "Résultats Par Page",
   "Changer pour la Page",
   "spécifier les utilisateursa ignorer",
   "Ignorer la formule: ",
   "Ignorer la formule supprimée.",
   "<noms ou numéros de session>",
   "Monter",
   "Descendre",
   "Interrompre le Téléchargement",
   "Recommencer le Téléchargement",
   "Ouvrir un Fichier",
   "Russe",
   "Discussion",
   "Modèle /ignore actuel: ",
   "Indisponible",
   "Il y a %i transferts en cours, êtes vous sur de vouloir quitter?",
   "Ne pas Quitter",
   "Date de Modification",
   "Espéranto",
   "Suédois",
   "ping autres utilisateurs",
   "Ping renvoyé en %Li millisecondes",
   "Envoyer une requête ping à: ",
   "Norvégien",
   "Serbe",
   "parti",
   "Partir Automatiquement",
   "minutes",
   "tag",
   "changer le tag de départ automatique",
   "Tag de départ automatique mis à: ",
   "Force l'état 'parti'",
   "Ouvrir le Dossier",
   "Modèle de surveillance mis à",
   "Modèle de surveillance supprimé.",
   "Modèle /watch actuel: ",
   "spécifier les utilisateur à surveiller",
   "Commandes de lancement annulées.",
   "commande",
   "ajouter une commnde au lancement",
   "annuler les commandes de lancement",
   "Commandes de lancement enregistrées: ",
   "Surveiller",
   "Etat du serveur demandé.",
   "%.1fMo utilisés (%.1fMo disponibles)",
   "Etat du serveur:",
   "Version du serveur:",
   "Root de la session locale",
   "Usage mémoire du serveur",
   "Demande l'état du serveur",
   "Uptime du serveur",
   "semaines",
   "jours",
   "Uptime du système",
   "connecté depuis",
   "Partage de Fichiers Disponible",
   "Bannir l'Utilisateur Pour",
   "L'utilisateur de l'IP %s est banni pour",
   "Heures",
   "Pour toujours",
   "supprimer toutes les interdictions d'envoi",
   "Supprime %lu interdictions d'envoi",
   "Modèle AutoPriv mis à: ",
   "Modèle AutoPriv supprimé.",
   "spécifier les utilisateurs AutoPriv",
   "Modèle /autopriv actuel: ",
   "Format de donnée inconnu!",
   "Ouvrir le dossier des historiques",
   "Etat",
   "Votre état a été changé en: ",
   " est maintenant ",
   "Transfert",
   "établi la phrase d'état de l'utilisateur",
   "Bulgare",
   "Chemin",
   "Garder les Chemins des Fichiers",
   "Alias mis à",
   "Alias supprimé",
   "[nom et valeur]",
   "créer un alias",
   "supprimer un alias",
   "Déplacer en Haut",
   "Déplacer en Bas",
   "établi un titre de fenêtre personnalisé",
   "Le titre de fenêtre personnalisé est maintenant",
   "AutoMAJ de la Liste des Serveurs",
   "Serveur ajouté: %s",
   "Serveur supprimé: %s",
   "BeShare v%s est maintenant disponible.  Vous pouvez le télécharger sur %s",
   "exécute une commande shell",
   "Exécution de la commande shell",
   "commande shell",
   "commande d'inactivité mise à",
   "commande quand les transfers cessent",
   "taille de police en points",
   "changer la taille de la police",
   "Taille de police mise à:",
   "Taille de police par défaut",
   "Client",
   "Va essayer de s'auto-reconnecter dans %lu minutes.",
   "Essai d'auto-reconnexion.",
   "Séquence d'auto-reconnexion terminée.",
   "Coréen",
   "Bande Passante Limite",
   "octets/seconde",
   "Limite la vitesse de téléchargement (par transfert)",
   "Limite la vitesse d'envoi (par transfert)",
   "La vitesse max de téléchargement est",
   "La vitesse max d'envoi est",
   "Hongrois",
   "Choix des Couleurs",
   "Arrière-plan du Texte",
   "Arrière-plan du Texte Défilé",
   "Bordures",
   "Texte",
   "Système",
   "Avertissement",
   "Erreur",
   "Action",
   "Privé",
   "Pseudo Prononcé",
   "Ping",
   "Pseudo Personnel",
   "Autres Pseudos",
   "URL",
   "Sélection",
   "Pseudos Surveillés",
   "Progression des Téléchargements",
   "Progresion des Envois",
   "Progression des Envois Stoppés",
   "Préférences Couleur par",
   "Annuler",
   "Défaut",
   "change la colorisation des éléments",
   "Roumain",
   "partage la capture d'écran",
   "partage maintenant une capture d'écran",
   "Erreur de partage de la capture d'écran",
   " a fini le téléchargement de ",
   "Transféré cette session: %s down, %s up.",
   "affiche quelques infos diverses",
   "Banni",
   "jusque",
   "Compression des données",
   "Basse",
   "Moyenne",
   "Haute",
   "Chinois",
   "Turkish",
   "Japanese",
   "[font name]",
   "set font",
   "Font set to",
   "Font reset to default",
   "Couldn't find font",
   "Shortest Uploads First",
   "Finnish"
};

// DA@Y2K: Added Italian localisation.
static const char _italianShortcuts[NUM_SHORTCUTS] = {
   'N',  // New connection
   'B',  // "Bye" to current connection
   'S',  // Shared dir
   'D',  // Download dir
   'L',  // clear Log
   'R',  // Reset Layout
   'Q',  // Quit
   'U',  // Full user Queries
   'M',  // Beep When Mentioned
   'I',  // Open private chat window
   'F',  // Toggle file logging
   'E',  // File sharing enabled
   'O',  // Logs dir
};

// Submitted by Dario Accornero <bexoft@bexoft.com>
static const char * _italianStrings[NUM_STRINGS] = {
   "Anonimo",
   "Ignoto",
   " è ora connesso.",
   " si è disconnesso.",
   "Utente #",
   " (ossia ",
   " è ora noto come ",
   "vero",
   "falso",
   "<tipo ingnoto>",
   "Utente ",
   " sta scaricando ",
   "Errore nella scrittura del file ",
   "Si è verificato un errore.",
   "In coda (Macchina locale sovraccarica)",
   "In coda (Macchina remota sovraccarica)",
   "Inv.: ",
   "Ric.: ",
   "/sec, ",
   "In attesa di risposta...",
   "Collegamento...",
   "Scaricamento completo",
   "Scaricamento interrotto",
   "Impossibile connettersi",
   "Preparazione al caricamento",
   "Preparazione allo scaricamento",
   "a",
   "da",
   "Errore nell'iniziare lo scaricamento--nessuna porta accettata!",
   "Errore nell'iniziare la connessione procrastinata!",
   "Errore nell'iniziare la connessione procrastinata--nessun thread di ricezione!",
   "Errore, impossibile creare thread di connessione! (Prova ad uscire da BeShare, e poi a far ripartire la rete)",
   "(Sto condividendo %i files locali)",
   "Impossibile trova la cartella 'shared', condivisione disabilitata!",
   "\0011Nome File",
   "\0012Utente",
   "\0013ID Sessione",
   "\0014Connessione",
   "File",
   "Collegati al server",
   "Disconnetti",
   "Apri Cartella Condivisa",
   "Apri Cartella Scaricamento",
   "Cancella il Chat Log",
   "Ripristina Impostazioni Finestra",
   "Informazioni su BeShare",
   "Esci",
   "Attributi",
   "Impostazioni",
   "Max Caricamenti Simultanei",
   "Max Scaricamenti Simultanei",
   "Nessun Limite",
   "Velocità di Caricamento",
   "Log",
   "Caricamenti",
   "Eventi Utente",
   "Cambiamenti della Ricerca",
   "Ricerche Utente Complete",
   "Sono Dietro un Firewall",
   "Ricerca:",
   "Inizia ricerca",
   "Termina ricerca",
   "Server:",
   "Nome utente:",
   "Scarica files selezionati",
   "Elimina trasferimenti completi/errati",
   "Rimuovi selezione",
   "Chat",
   "Nome",
   "ID",
   "BeShare sta ascoltando sulla porta %u.  Scegli Collegati dal menu File per iniziare!",
   "Impossibile iniziare thread di condivisione server!  (Prova a far ripartire la rete, poi a rilanciare BeShare)",
   "Impossibile scaricare dall'utente ",
   ", nessuna informazione disponibile sulla connessione.",
   "Impossibile scaricare files da ",
   ", perché siamo entrambi dietro un firewall.",
   "Sessione di accettazione dello scaricamento per ",
   " non è riuscita a partire!",
   "Sessione scaricamento file su ",
   "Ricerca cambiata in",
   "Ricerca attivata",
   "Impossibile iniziare sessione ShareFileTransfer per rispondere a richiesta di trasferimento remoto!  (Prova a far ripartire la rete, poi a rilanciare BeShare)",
   "Il tuo nome e' stato cambiato in ",
   "di",
   "Utente ignoto ",
   ", messaggio \"",
   "\" non inviato.",
   "Nessun utente specificato in /msg",
   "Ricerca interrotta",
   "Sistema",
   "Attenzione",
   "Errore",
   "Azione",
   "Collegati a ",
   " - Collegamento a ",
   " - %lu risultati mostrati (",
   " - Connesso a ",
   "Connessione stabilita.",
   "Collegamento al server...",
   "Non sei più connesso al server MUSCLE.",
   "Connessione al server fallita.",
   "Inglese",
   "Spagnolo",
   "Lingua %s selezionata.  La modifica avrà effetto quando rilancerai BeShare.",
   "Lingua",
   "Tedesco",
   "Tipo",
   "Dimensione File",
   "Files",
   "Olandese",
   "Sto esaminando i files...",
   "Comandi tipo IRC disponibili:",
   "invia un messaggio privato",
   "cambia il tuo nome utente",
   "fai qualcosa (azione)",
   "sinonimo per /action",
   "cancella il chat log",
   "inizia una nuova ricerca",
   "interrompi la ricerca corrente",
   "collegati al server",
   "disconnettiti dal server",
   "esci da BeShare",
   "mostra questo testo d'aiuto",
   "<nome o id sessione> <testo>",
   "<nome>",
   "<azione>",
   "[stringaRicerca]",
   "[nomeServer]",
   "Portoghese",
   "Francese",
   "Suona Quando Menzionato",
   "Max Caricamenti Simultanei per Utente",
   "Mostra Tempi",
   "Elimina Automaticamente Scaricamenti Completati",
   "Max Scaricamenti Simultanei per Utente",
   "Italiano",
   "Collegati al Lancio",
   "Messaggi Privati",
   "Apri Finestra Privata di Chat",
   "BeShare Finestra Privata di Chat",
   "Chatta Con:",
   "Errore, nessun utente specificato!",
   "Salva Impostazioni",
   "Ripristina Impostazioni",
   "Errore, comando ignoto",
   "Scrivi /help per la lista dei comandi disponibili.",
   " - (%lu-%lu) dei %lu risultati mostrati (",
   "Visualizza",
   "Messaggi Informativi",
   "Messaggi d'Avvertimento",
   "Messaggi d'Errore",
   "Log Abilitato",
   "Log Disabilitato",
   "Risultati per Pagina",
   "Passa alla Pagina",
   "specifica utenti da ignorare",
   "Ignora pattern impostato su: ",
   "Ignora pattern rimosso.",
   "<nomi o ID sessioni>",
   "Muovi Su",
   "Muovi Giù",
   "Interrompi Scaricamento",
   "Ricomincia Scaricamento",
   "Apri File",
   "Russa",
   "Chat",
   "Corrente /ignore pattern è: ",
   "Disabilitato",
   "Ci sono %i trasferimenti in corso, siete sicuri di voler uscire?",
   "Non Uscire",
   "Modificato il",
   "Esperanto",
   "Svedese",
   "Fai un ping su altri clients",
   "Il ping è ritornato in %Li millisecondi",
   "Manda una richiesta di ping a: ",
   "Norvegese",
   "Serbo",
   "via",
   "Allontanati Automaticamente",
   "minuti",
   "tag",
   "Cambia il tag di auto-allontanamento",
   "Tag di auto-allontanamento impostato come: ",
   "Forza auto allontanamento",
   "Apri Cartella",
   "Pattern di osservazione impostato su: ",
   "Pattern di osservazione eliminato.",
   "Pattern di osservazione corrente: ",
   "specifica utenti da osservare",
   "Comandi di lancio rimossi.",
   "comando",
   "aggiungi comando di lancio",
   "elimina comandi di lancio",
   "Comando di lancio registrato: ",
   "Osserva",
   "Richiesto stato del server.",
   "%.1fMB usati (%.1fMB disponibili)",
   "Stato del server:",
   "Versione del server",
   "Root della sessione locale",
   "Utilizzo memoria del server",
   "Richiedi stato del server",
   "Tempo online del server",
   "settimane",
   "giorni",
   "Tempo online del sistema",
   "connesso da",
   "Condivisione files attiva",
   "Blocca utente per",
   "Utente con indirizzo IP %s bloccato per",
   "Ore",
   "Sempre",
   "elimina tutti i blocchi per upload",
   "Sto rimuovendo %lu blocchi per upload",
   "Pattern AutoPriv impostato su: ",
   "Pattern AutoPriv rimosso.",
   "specifica utenti AutoPriv",
   "Pattern /autopriv corrente: ",
   "Formato dati ignoto!",
   "Apri Cartella Log",
   "Stato",
   "Il tuo stato è stato cambiato in: ",
   " è ora ",
   "Carico",
   "assegna stringa per stato utente",
   "Bulgarian",
   "Path",
   "Retain File Paths",
   "Set alias",
   "Removed alias",
   "[name and value]",
   "create an alias",
   "remove an alias",
   "Move to Top",
   "Move to Bottom",
   "set custom window title",
   "Custom window title is now",
   "AutoUpdate Server List",
   "Added server: %s",
   "Removed server: %s",
   "BeShare v%s is now available for download.  You can upgrade at %s",
   "execute shell command",
   "Executing shell command",
   "shell command",
   "idle command set to",
   "set command for when transfers cease",
   "font size in points",
   "set font size",
   "Font size set to:",
   "Font size reset to default",
   "Client",
   "Will attempt auto-reconnect in %lu minutes.",
   "Attempting auto-reconnect.",
   "Auto-reconnect sequence terminated.",
   "Korean",
   "Limit Bandwidth",
   "bytes/second",
   "Set max download rate (per transfer)",
   "Set max upload rate (per transfer)",
   "Max download rate is",
   "Max upload rate is",
   "Hungarian",
   "Choose Colors",  // translate me
   "Text Background",
   "Scrolled Text Background",
   "Border Areas",
   "Text",
   "System",
   "Warning",
   "Error",
   "Action",
   "Private",
   "Name Said",
   "Ping",
   "Local Nick",
   "Remote Nick",
   "URL",
   "Selection",
   "Watch",
   "Download Progress",
   "Upload Progress",
   "Paused Upload Progress",
   "Color prefs by",
   "Revert",
   "Default",
   "toggle custom coloring",
   "Romanian",
   "share screenshot",
   "is now sharing a screenshot",
   "Error sharing screenshot",
   " has finished downloading ",
   "Transferred this session:  %s down, %s up.",
   "show some miscellaneous info",
   "Banned",
   "until",
   "Data Compression",
   "Low",
   "Medium",
   "High",
   "Chinese (Simplified)",
   "Turkish",
   "Japanese",
   "[font name]",
   "set font",
   "Font set to",
   "Font reset to default",
   "Couldn't find font",
   "Shortest Uploads First",
   "Finnish"
};

static const char _russianShortcuts[NUM_SHORTCUTS] = {
   'N',  // New connection
   'B',  // "Bye" to current connection
   'S',  // Shared dir
   'D',  // Download dir
   'L',  // clear Log
   'R',  // Reset Layout
   'Q',  // Quit
   'U',  // Full user Queries
   'M',  // Beep When Mentioned
   'I',  // Open private chat window
   'F',  // Toggle file logging
   'E',  // File sharing enabled
   'O',  // Logs dir
};

// Russian translation by Oleg "2sheds" Kourapov <2sheds@newmail.ru>
static const char * _russianStrings[NUM_STRINGS] = {
   "Анонимный",
   "Неизвестный",
   " подключился.",
   " отключился.",
   "Юзер №",
   " (a.k.a. ",
   " сменил имя на ",
   "true",
   "false",
   "<неизвестный тип>",
   "Юзер ",
   " скачивает ",
   "Ошибка при записи файла ",
   "Произошла ошибка.",
   "Отложено (Локальная машина занята)",
   "Отложено (Удаленная машина занята)",
   "Отпр: ",
   "Прин: ",
   "/сек, ",
   "Ждем ответ...",
   "Соединяемся...",
   "Скачивание завершено",
   "Скачивание отменено",
   "Невозможно соединиться",
   "Подготовка к закачиванию",
   "Подготовка к скачиванию",
   "в",
   "из",
   "Не удается открыть порт!",
   "Не удается начать отложенное соединение!",
   "Не удается начать отложенное соединение--нет передающего потока!",
   "Ошибка, не удается присоединиться! (Закройте BeShare и нажмите Restart Networkiing в настройках сети)",
   "(Доступно %i локальных файлов)",
   "Не удается найти папку 'shared', разделение доступа невозможно!",
   "\0011Имя файла",
   "\0012Юзер",
   "\0013№ юзера",
   "\0014Соединение",
   "Файл",
   "Присоединиться",
   "Отсоединиться",
   "Открыть папку 'Shared'",
   "Открыть папку 'Downloads'",
   "Очистить окно разговоров",
   "Вернуть исходный вид",
   "О программе...",
   "Выйти",
   "Атрибуты",
   "Настройки",
   "Макс. число закачиваний",
   "Макс. число скачиваний",
   "Без ограничений",
   "Вид соединения",
   "Записывать",
   "Закачивания",
   "Локальные события",
   "Изменения запроса",
   "Показывать все файлы юзера",
   "Я за файрволом",
   "Искать:",
   "Начать поиск",
   "Остановить",
   "Сервер:",
   "Имя юзера:",
   "Скачать выбранные файлы",
   "Убрать законченные/прерванные скачивания",
   "Остановить выбранное",
   "Разговоры",
   "Имя",
   "№",
   "BeShare следит за портом %i.  Выберите Присоединиться в меню Файл!",
   "Couldn't start file-sharing server thread!  (Try Restarting Networking, then restarting BeShare)",
   "Не удается скачать от ",
   ", нет данных о соединении.",
   "Не удается скачать файлы от ",
   ", потому что оба клиента за файрволами.",
   "Не удается инициализировать соединение с ",
   ", возможно он находится за файрволом",
   "Не удается получить ответ от ",
   "Запрос изменен на ",
   "Запрос подан",
   "Couldn't start ShareFileTransfer session to serve remote transfer request!  (Try Restarting Networking, then restarting BeShare)",
   "Ваше имя было изменено на ",
   "по",
   "Неизвестный юзер ",
   ", сообщение \"",
   "\" не было послано.",
   "После /msg должен быть указан юзер",
   "Запрос отменен",
   "Система",
   "Внимание!",
   "Ошибка",
   "Действие",
   "Соединиться с ",
   " - Соединяемся с ",
   " - %lu вариантов показано (",
   " - Соединились с ",
   "Установлено соединение.",
   "Соединяемся с сервером...",
   "Вы не подключены к серверу MUSCLE.",
   "Не удалось соединиться с сервером.",
   "Английский",
   "Испанский",
   "Выбран %s язык.  Перезагрузите BeShare, чтобы изменения вступили в силу.",
   "Язык интерфейса",
   "Немецкий",
   "Тип",
   "Размер",
   "Файлы",
   "Датский",
   "Просматриваю файлы...",
   "Поддерживаемые IRC-команды:",
   "послать сообщение лично",
   "сменить имя",
   "сделать что-нибудь",
   "синоним команды /action",
   "стереть записанные разговоры",
   "подать новый запрос",
   "остановить запрос",
   "подсоединиться к серверу",
   "отсоединиться от сервера",
   "выйти из BeShare",
   "показать подсказку",
   "<имя или №> <текст>",
   "<имя>",
   "<действие>",
   "[запрос]",
   "[сервер]",
   "Португальский",
   "Французский",
   "Подавать сигнал при упоминании имени",
   "Макс. число закачиваний для одного юзера",
   "Проставлять время",
   "Автоматически убирать скачанные файлы",
   "Макс. число скачиваний у одного юзера",
   "Итальянский",
   "Подключаться при запуске",
   "Личные сообщения",
   "открыть окно для личного разговора",
   "Окно личного разговора",
   "Поговорить с",
   "Не указан юзер!",
   "Сохранить",
   "Восстановить",
   "Неизвестная команда ",
   "Наберите /help, чтобы увидеть список команд.",
   " - показано (%lu-%lu) вариантов из %lu (",
   "Показывать",
   "Информационные",
   "Предупреждения",
   "Ошибки",
   "Запись включена",
   "Запись выключена",
   "Количество результатов на страницу",
   "Открыть страницу",
   "игнорировать юзеров",
   "Маска команды /ignore: ",
   "Маска команды /ignore удалена.",
   "<имена или №№>",
   "Вверх",
   "Вниз",
   "Отменить скачивание",
   "Начать скачивание заново",
   "Открыть файл",
   "Русский",
   "Сказать",
   "Текущая маска команды /ignore: ",
   "нет маски",
   "Скачивается %i файл(ов), вы уверены, что хотите выйти?",
   "Остаться",
   "Изменен",
   "Эсперанто",
   "Шведский",
   "послать пакет",
   "Пакет вернулся через %Li милисекунд",
   "Пакет отправлен: ",
   "Норвежский",
   "Сербский",
   "вышел",
   "Режим \" Вышел\" через",
   "минут",
   "метка",
   "изменить метку \"Вышел\"",
   "Метка режима \"Вышел\": ",
   "включить режим \"Вышел\"",
   "Open Folder",
   "Watch pattern set to: ",
   "Watch pattern removed.",
   "Current /watch pattern is: ",
   "specify users to watch",
   "Startup commands cleared.",
   "command",
   "add startup command",
   "clear startup commands",
   "Recorded startup command: ",
   "Watch",
   "Server status requested.",
   "%.1fMB used (%.1fMB available)",
   "Server status:",
   "Server version",
   "Local session root",
   "Server memory usage",
   "Request server status",
   "Server uptime",
   "weeks",
   "days",
   "System Uptime",
   "logged in for",
   "File Sharing Enabled",
   "Ban User For",
   "User at IP %s banned for",
   "Hours",
   "Forever",
   "remove all upload bans",
   "Removing %lu upload bans",
   "AutoPriv pattern set to: ",
   "AutoPriv pattern removed.",
   "specify AutoPriv users",
   "Current /autopriv pattern is: ",
   "Unknown data format!",
   "Open Logs Folder",
   "Status",
   "Your status has been changed to: ",
   " is now ",
   "Load",
   "set user status string",
   "Bulgarian",
   "Path",
   "Retain File Paths",
   "Set alias",
   "Removed alias",
   "[name and value]",
   "create an alias",
   "remove an alias",
   "Move to Top",
   "Move to Bottom",
   "set custom window title",
   "Custom window title is now",
   "AutoUpdate Server List",
   "Added server: %s",
   "Removed server: %s",
   "BeShare v%s is now available for download.  You can upgrade at %s",
   "execute shell command",
   "Executing shell command",
   "shell command",
   "idle command set to",
   "set command for when transfers cease",
   "font size in points",
   "set font size",
   "Font size set to:",
   "Font size reset to default",
   "Client",
   "Will attempt auto-reconnect in %lu minutes.",
   "Attempting auto-reconnect.",
   "Auto-reconnect sequence terminated.",
   "Korean",
   "Limit Bandwidth",
   "bytes/second",
   "Set max download rate (per transfer)",
   "Set max upload rate (per transfer)",
   "Max download rate is",
   "Max upload rate is",
   "Hungarian",
   "Choose Colors",  // translate me
   "Text Background",
   "Scrolled Text Background",
   "Border Areas",
   "Text",
   "System",
   "Warning",
   "Error",
   "Action",
   "Private",
   "Name Said",
   "Ping",
   "Local Nick",
   "Remote Nick",
   "URL",
   "Selection",
   "Watch",
   "Download Progress",
   "Upload Progress",
   "Paused Upload Progress",
   "Color prefs by",
   "Revert",
   "Default",
   "toggle custom coloring",
   "Romanian",
   "share screenshot",
   "is now sharing a screenshot",
   "Error sharing screenshot",
   " has finished downloading ",
   "Transferred this session:  %s down, %s up.",
   "show some miscellaneous info",
   "Banned",
   "until",
   "Data Compression",
   "Low",
   "Medium",
   "High",
   "Chinese (Simplified)",
   "Turkish",
   "Japanese",
   "[font name]",
   "set font",
   "Font set to",
   "Font reset to default",
   "Couldn't find font",
   "Shortest Uploads First",
   "Finnish"
};

static const char _esperantoShortcuts[NUM_SHORTCUTS] = {
   'N',  // New connection
   'B',  // "Bye" to current connection
   'S',  // Shared dir
   'D',  // Download dir
   'L',  // clear Log
   'R',  // Reset Layout
   'Q',  // Quit
   'U',  // Full user Queries
   'M',  // Beep When Mentioned
   'P',  // Open private chat window
   'F',  // Toggle file logging
   'E',  // File sharing enabled
   'O',  // Logs dir
};

static const char * _esperantoStrings[NUM_STRINGS] = {
   "Anonima",
   "Nekonata",
   " nun estas konektita.",
   " malkonektis.",
   "Uzanto #",
   " (alinome ",
   " nun estas konata kiel ",
   "vere",
   "malvere",
   "<nekonata tipo>",
   "Uzanto ",
   " elŝutas ",
   "Eraro je skribo al dosiero ",
   "Okazis Eraro.",
   "Envicigita (Loka komputilo tro okupita)",
   "Envicigita (Fora komputilo tro okupita)",
   "Sendita: ",
   "Ricevita: ",
   "/sek, ",
   "Atendas revokon...",
   "Konektas...",
   "Elŝuto finita",
   "Elŝuto abortigita",
   "Ne eblis konekti",
   "Preparas Alŝuti",
   "Preparas Elŝuti",
   "al",
   "de",
   "Eraro je starto de elŝuto--neniu akcepta pordo!",
   "Eraro je starto de prokrastita konekto!",
   "Eraro je starto de prokrastita konekto--neniu ricevsenda fadeno!",
   "Eraro, ne eblis krei konektan fadenon! (Provu eliru BeShare-on, poste Restartigu la Retumadon)",
   "(Disponigas %i lokajn dosierojn)",
   "Ne eblis trovi la dosierujon 'shared', dosier-disponigado malebligita!",
   "\0011Dosiernomo",
   "\0012Uzanto",
   "\0013Sesia ID",
   "\0014Konekto",
   "Arkivo",
   "Konektu al servilo",
   "Malkonektu",
   "Malfermu La Disponigan Dosierujon",
   "Malfermu La Elŝutan Dosierujon",
   "Malplenigu La Babilan Protokolon",
   "Reŝarĝu La Aranĝon",
   "Pri BeShare",
   "Eliru",
   "Atributoj",
   "Preferoj",
   "Supra Limo de Samtempaj Alŝutoj",
   "Supra Limo de Samtempaj Elŝutoj",
   "Neniu Limo",
   "Alŝuta Bendlarĝo",
   "Protokolu",
   "Alŝutojn",
   "Uzant-Eventojn",
   "Serĉo-Ŝanĝojn",
   "Plenaj Uzant-Serĉoj",
   "Mi estas malantaŭ Fajroŝirmilo",
   "Serĉu:",
   "Komencu Serĉi",
   "Ĉesu Serĉi",
   "Servilo:",
   "Uzantonomo:",
   "Elŝutu Elektitajn Dosierojn",
   "Forigu Finitajn/Malsukcesajn Transigojn",
   "Forigu Elektitan",
   "Babiladon",
   "Nomo",
   "ID",
   "BeShare aŭskultas ĉe la pordo %u.  Elektu Konektu en la Arkivo-menuo por komenci!",
   "Ne eblis startigi la dosier-disponigan fadenon!  (Provu Restartigu la Retumadon, poste restartigu BeShare-on)",
   "Ne eblas elŝuti de uzanto ",
   ", neniu konekta informo haveblas.",
   "Ne eblas elŝuti dosierojn de ",
   ", ĉar ni ambaŭ estas malantaŭ fajroŝirmiloj.",
   "Dosierelŝuta akceptsesio al ",
   " malsukcesis iniciatiĝi!",
   "Dosierelŝuta sesio al ",
   "Ŝanĝis Serĉo al",
   "Komencis Serĉi",
   "Ne eblis startigi ShareFileTransfer-sesion por servi la foran transigpeton!  (Try Restarting Networking, then restarting BeShare)",
   "Via nomo estas ŝanĝita al ",
   "de",
   "Nekonata uzanto ",
   ", mesaĝo \"",
   "\" ne sendita.",
   "Ricevonta uzanto ne specifita en /msg",
   "Ĉesis Serĉi",
   "Sistemo",
   "Averto",
   "Eraro",
   "Ago",
   "Konektu al ",
   " - Konektas al ",
   " - %lu rezultoj montritaj (",
   " - Konektita al ",
   "Konekto establita.",
   "Konektas al servilo...",
   "Vi ne plu estas konektita al la MUSCLE-servilo.",
   "Konekto al la servilo malsukcesis.",
   "Angla",
   "Hispana",
   "La lingvo %s estis elektita.  La ŝanĝo efikos post restartigo de BeShare.",
   "Lingvo",
   "Germana",
   "Tipo",
   "Grandeco",
   "Dosieroj",
   "Nederlanda",
   "Ekzamenas la Dosierojn...",
   "Disponeblaj irc-stilaj komandoj:",
   "sendas privatan mesaĝon",
   "ŝanĝas vian uzantonomon",
   "faru ion",
   "sinonimo de /action",
   "malplenigas la babilan protokolon",
   "startigas novan serĉon",
   "haltigas la nunan serĉon",
   "konektas al servilo",
   "malkonektas de la servilo",
   "eliru BeShare-on",
   "montras la jenan helptekston",
   "<nomo aŭ sesia id> <teksto>",
   "<nomo>",
   "<ago>",
   "[serĉTeksto]",
   "[servilNomo]",
   "Portugala",
   "Franca",
   "Sonu Kiam Menciita",
   "Supra Limo de Samtempaj Alŝutoj por Ĉiu Uzanto",
   "Tempomarkojn",
   "Forigu Finitajn Elŝutojn Aŭtomate",
   "Supra Limo de Samtempaj Elŝutoj por Ĉiu Uzanto",
   "Itala",
   "Konektu je la Programstarto",
   "Privatajn Mesaĝojn",
   "Malfermu Privatan Babilfenestron",
   "BeShare Private Chat Window",
   "Babilu Kun:",
   "Eraro, uzanto ne specifita!",
   "Ŝparu Preferojn",
   "Reŝarĝu Preferojn",
   "Eraro, nekonata komando",
   "Skribu /help por listo de disponeblaj komandoj.",
   " - (%lu-%lu) el %lu rezultoj montritaj (",
   "Montru",
   "Informajn Mesaĝojn",
   "Alertajn Mesaĝojn",
   "Erarajn Mesaĝojn",
   "Protokolo Aktivita",
   "Protokolo Neaktivita",
   "Rezultoj sur Ĉiu Paĝo",
   "Ŝanĝu al Paĝo",
   "specifu uzantojn por ignori",
   "Ignorfiltro ŝanĝita al: ",
   "Ignorfiltro forigita.",
   "<nomoj aŭ sesiaj id-oj>",
   "Movu Supren",
   "Movu Malsupren",
   "Haltigu Elŝuton",
   "Restartigu Elŝuton",
   "Malfermu Dosieron",
   "Rusa",
   "Babilu",
   "Nuna /ignore-filtro estas: ",
   "Neaktivita",
   "Estas %i aktiva(j) transigo(j), ĉu vi vere volas eliri?",
   "Ne Eliru",            // Don't Quit
   "Laste Ŝanĝita",   // Time of the last change
   "Esperanto",
   "Sveda",               // Swedish
   "pingas aliajn klientojn",
   "La pingo revenis post %Li milisekundoj.",
   "Pingo-peto sendita al: ",
   "Norvega",
   "Serba",
   "for",
   "Aŭtomate For",
   "minutoj",
   "mesaĝo",
   "ŝanĝas la aŭtomata-for-mesaĝo",
   "Aŭtomata-for-mesaĝo ŝanĝita al: ",
   "Devige enŝaltas for-staton",
   "Malfermu La Dosierujon",
   "Observa filtro ŝanĝita al: ",
   "Observa filtro forigita.",
   "Aktuala observa filtro estas: ",
   "precizigu observotajn uzantojn",
   "Start-ordonoj nuligitaj.",
   "ordono",
   "aldonu start-ordonon",
   "nuligu start-ordonojn",
   "Registrita start-ordono: ",
   "Observu",
   "Servila stato postulita.",
   "%.1fMB uzataj (%.1fMB disponeblaj)",
   "Servila stato:",
   "Servilo versio",
   "Radiko de la loka komputilo",
   "Servila uzo de memoro",
   "Postulu la servilan staton",
   "Tempodaŭro ekde la servila ŝaltiĝo",
   "semajnojn",
   "tagojn",
   "Tempodaŭro ekde la sistema ŝaltiĝo",
   "konektita",
   "Dosierdisponado Aktiva",
   "Malpermesu Uzanton Dum",
   "Uzanto kun IP %s malpermesita dum",
   "Horoj",
   "Eterne",
   "forigu ĉiujn alŝut-malpermesojn",
   "Forigas %lu alŝut-malpermesojn",
   "AutoPriv-filtro ŝanĝita al: ",
   "AutoPriv-filtro forigita.",
   "precizigu AutoPriv-uzantojn",
   "Nuna /autopriv-filtro estas: ",
   "Nekonata datum-formato!",
   "Malfermu la Protokol-dosierujon",
   "Stato",
   "Via stato ŝanĝiĝis al: ",
   " nun estas ",
   "Ŝarĝo",
   "ŝanĝas la stato-tekston de la uzanto",
   "Bulgara",
   "Pado",
   "Konservu Dosierajn Padojn",
   "Ŝanĝis alinomon",
   "Forigis alinomon",
   "[nomo kaj valoro]",
   "kreas alinomon",
   "forigas alinomon",
   "Movu al la Supro",
   "Movu al la Malsupro",
   "ŝanĝu la fenestro-titolon",
   "La fenestrotitolo nun estas",
   "Aŭtomate Ĝisdatigi La Servil-liston",
   "Aldonis la servilon",
   "Forigis la servilon",
   "BeShare v%s nun elŝuteblas. Vi povas ĝisdatigi ĉe %s",
   "execute shell command",
   "Executing shell command",
   "shell command",
   "idle command set to",
   "set command for when transfers cease",
   "tipargrandeco en punktoj",
   "elektu tipargrandecon",
   "Tipargrandeco nun estas:",
   "Tipargrandeco ŝanĝita al la origina grandeco",
   "Kliento",
   "Provos rekonekti aŭtomate denove post %lu minutoj.",
   "Provas rekonekti aŭtomate.",
   "La aŭtomata rekonektado nuligita.",
   "Korean",
   "Limit Bandwidth",
   "bytes/second",
   "Set max download rate (per transfer)",
   "Set max upload rate (per transfer)",
   "Max download rate is",
   "Max upload rate is",
   "Hungarian",
   "Choose Colors",  // translate me
   "Text Background",
   "Scrolled Text Background",
   "Border Areas",
   "Text",
   "System",
   "Warning",
   "Error",
   "Action",
   "Private",
   "Name Said",
   "Ping",
   "Local Nick",
   "Remote Nick",
   "URL",
   "Selection",
   "Watch",
   "Download Progress",
   "Upload Progress",
   "Paused Upload Progress",
   "Color prefs by",
   "Revert",
   "Default",
   "toggle custom coloring",
   "Romanian",
   "share screenshot",
   "is now sharing a screenshot",
   "Error sharing screenshot",
   " has finished downloading ",
   "Transferred this session:  %s down, %s up.",
   "show some miscellaneous info",
   "Banned",
   "until",
   "Data Compression",
   "Low",
   "Medium",
   "High",
   "Chinese (Simplified)",
   "Turkish",
   "Japanese",
   "[font name]",
   "set font",
   "Font set to",
   "Font reset to default",
   "Couldn't find font",
   "Shortest Uploads First",
   "Finnish"
};

static const char _swedishShortcuts[NUM_SHORTCUTS] = {
   'N',  // New connection
   'K',  // "Bye" to current connection
   'S',  // Shared dir
   'D',  // Download dir
   'L',  // clear Log
   'R',  // Reset Layout
   'A',  // Quit
   'U',  // Full user Queries
   'O',  // Beep When Mentioned
   'P',  // Open private chat window
   'F',  // Toggle file logging
   'E',  // File sharing enabled
   'G',  // Logs dir
};

static const char * _swedishStrings[NUM_STRINGS] = {
   "Anonym",
   "Okänd",
   " är nu ansluten.",
   " har kopplat ner.",
   "Användare #",
   " (alias ",
   " heter nu ",
   "sant",
   "falskt",
   "<okänd typ>",
   "Användare ",
   " laddar ner ",
   "Fel vid skrivning till fil ",
   "Ett Fel Uppstod.",
   "Köad (Egna datorn för upptagen)",
   "Köad (Andra sidan för upptagen)",
   "Sänt: ",
   "Mottagit: ",
   "/sek, ",
   "Väntar på återupprigning...",
   "Ansluter...",
   "Nerladdning slutförd",
   "Nerladdning avbruten",
   "Kunde inte ansluta",
   "Förbereder Uppladdning",
   "Förbereder Nerladdning",
   "till",
   "från",
   "Fel vid start av nerladdning--ingen mottagarport!",
   "Fel vid start av fördröjd anslutning!",
   "Fel vid start av fördröjd anslutning--ingen transceivertråd!",
   "Fel, kunde inte skapa anslutningstråd! (Försök med att avsluta BeShare, och Starta om Nätverket)",
   "(Delar med sig av %i lokala filer)",
   "Kunde inte hitta underkatalogen 'shared', fildelning avstängd!",
   "\0011Filnamn",
   "\0012Användare",
   "\0013SessionsID",
   "\0014Anslutning",
   "Arkiv",
   "Anslut till server",
   "Koppla ner",
   "Öppna Katalogen med Delade Filer",
   "Öppna Katalogen med Nerladdade Filer",
   "Rensa Chatt-Loggen",
   "Nollställ Layouten",
   "Om BeShare",
   "Avsluta",
   "Attribut",
   "Inställningar",
   "Max Samtidiga Uppladdningar",
   "Max Samtidiga Nerladdningar",
   "Obegränsat",
   "Uppladdningsbandbredd",
   "Logg",
   "Uppladdningar",
   "Användarhändelser",
   "Sökändringar",
   "Fullständiga Användarsökningar",
   "Jag är bakom en Brandvägg",
   "Sök:",
   "Starta Sökning",
   "Stoppa Sökning",
   "Server:",
   "Användarnamn:",
   "Ladda Ner Valda Filer",
   "Rensa Avslutade/Avbrutna Överföringar",
   "Ta Bort Markerad",
   "Chatt",
   "Namn",
   "ID",
   "BeShare lyssnar på port %u. Välj Anslut i Arkiv-menyn för att börja!",
   "Kunde inte starta servertråden för fildelning! (Försök med att Starta om Nätverket, och sedan starta om BeShare)",
   "Kan inte ladda ner från användare ",
   ", ingen anslutningsinformation tillgänglig.",
   "Kan inte ladda ner filer från ",
   ", eftersom vi båda är bakom brandväggar.",
   "Filnerladdnings-mottagnings-sessionen för ",
   " kunde inte initialiseras!",
   "Filnerladdnings-session till ",
   "Ändrade Sökning till",
   "Startade Sökning",
   "Kunde inte starta ShareFileTransfer-session för att betjäna andra sidans överföringsbegäran!  (Försök med att Starta om Nätverket, och sedan starta om BeShare)",
   "Ditt namn har ändrats till ",
   "av",
   "Okänd användare ",
   ", meddelande \"",
   "\" sändes ej.",
   "Ingen mottagande användare angavs i /msg",
   "Stoppade Sökning",
   "System",
   "Varning",
   "Fel",
   "Händelse",
   "Anslut till ",
   " - Ansluter till ",
   " - %lu resultat visade (",
   " - Ansluten till ",
   "Anslutning etablerad.",
   "Ansluter till server...",
   "Du är inte längre ansluten till MUSCLE-servern.",
   "Anslutning till server misslyckades.",
   "Engelska",
   "Spanska",
   "Språk %s valt.  Ändringarna kommer att ta effekt efter att du startat om BeShare.",
   "Språk",
   "Tyska",
   "Typ",
   "Filstorlek",
   "Filer",
   "Holländska",
   "Undersöker Filer...",
   "Tillgängliga irc-typskommandon:",
   "sänd ett privat meddelande",
   "ändra ditt användarnamn",
   "gör någonting",
   "synonym till /action",
   "rensa chatt-loggen",
   "starta en ny sökning",
   "stoppa nuvarande sökning",
   "anslut till en server",
   "koppla ner från servern",
   "avsluta BeShare",
   "visa den här hjälptexten",
   "<namn eller sessions-id> <text>",
   "<namn>",
   "<händelse>",
   "[sökSträng]",
   "[serverNamn]",
   "Portugisiska",
   "Franska",
   "Pip När Omnämnd",
   "Max Samtidiga Uppladdningar Per Användare",
   "Tidstämplar",
   "AutoRensa Färdiga Nerladdningar",
   "Max Samtidiga Nerladdningar Per Användare",
   "Italienska",
   "Logga in vid Uppstart",
   "Privata Meddelanden",
   "Öppna Privat Chatt-Fönster",
   "BeShare Privat Chatt-Fönster",
   "Chatta Med:",
   "Fel, ingen användare angiven!",
   "Spara Inställningar",
   "Återställ Inställningar",
   "Fel, okänt kommando",
   "Skriv /help för en lista med tillgängliga kommandon.",
   " - (%lu-%lu) av %lu resultat visade (",
   "Visa",
   "Infomeddelanden",
   "Varningsmeddelanden",
   "Felmeddelanden",
   "Loggning Aktiverad",
   "Loggning Avaktiverad",
   "Resultat Per Sida",
   "Byt till Sida",
   "ange användare att ignorera",
   "Ignoreringsmönster satt till: ",
   "Ignoreringsmönster borttaget.",
   "<namn eller sessions-id:n>",
   "Flytta Upp",
   "Flytta Ner",
   "Stanna Nerladdning",
   "Fortsätt Nerladdning",
   "Öppna Fil",
   "Ryska",
   "Chatta",
   "Nuvarande /ignore-mönster är: ",
   "Avaktiverad",
   "Det finns %i pågående överföringar, är det säkert att du vill avsluta?",
   "Avsluta Inte",      // Don't Quit
   "Senaste Ändring", // Last Change
   "Esperanto",
   "Svenska",
   "pingar andra klienter",
   "Pingen återvände efter %Li millisekunder.",
   "Ping-förfrågan sänd till: ",
   "Norska",
   "Serbiska",
   "borta",
   "Automatiskt Borta",
   "minuter",
   "meddelande",
   "ändrar auto-borta-meddelandet",
   "Auto-borta-meddelandet satt till: ",
   "Påtvingar borta-läge",
   "Öppna Filer",
   "Iaktagningsmönster satt till: ",
   "Iaktagningsmönster borttaget.",
   "Nuvarande iaktagningsmönster är: ",
   "ange användare som ska iaktagas",
   "Start-kommandon rensade.",
   "kommando",
   "lägg till start-kommando",
   "rensa start-kommandon",
   "Inspelat start-kommando: ",
   "Observera",
   "Serverstatus begärd.",
   "%.1fMB använda (%.1fMB tillgängliga)",
   "Serverstatus:",
   "Serverversion",
   "Egna datorns rot",
   "Serverns minnesanvändning",
   "Begär serverstatus",
   "Serverns uppetid",
   "veckor",
   "dagar",
   "Systemets Uppetid",
   "inloggad",
   "Fildelning Aktiverad",
   "Banna Användare För",
   "Användare med IP %s bannad för",
   "Timmar",
   "Evigt",
   "ta bort alla uppladdnings-banningar",
   "Tar bort %lu uppladdnings-banningar",
   "AutoPriv-mönster satt till: ",
   "AutoPriv-mönster borttaget.",
   "ange AutoPriv-användare",
   "Nuvarande /autopriv-mönster är: ",
   "Okänt dataformat!",
   "Öppna Logg-katalogen",
   "Status",
   "Din status har ändrats till: ",
   " är nu ",
   "Belastning",
   "sätt användarens status-text",
   "Bulgariska",
   "Sökväg",
   "Bevara Fil-sökvägar",
   "Satte alias",
   "Tog bort alias",
   "[namn och värde]",
   "skapa ett alias",
   "ta bort ett alias",
   "Flytta Överst",
   "Flytta Nederst",
   "sätt egen fönstertitel",
   "Fönstertiteln är nu",
   "Uppdatera Serverlistan Automatiskt",
   "Lade till server",
   "Tog bort server",
   "BeShare v%s finns nu för nerladdning. Du kan uppgradera på %s",
   "Utför terminalkommando",
   "Kör terminalkommando",
   "Terminalkommando",
   "Ej aktiv kommando inställt till",
   "Sätt kommando till när överföring upphör",
   "fontstorlek i punkter",
   "sätt fontstorlek",
   "Fontstorlek satt till:",
   "Fontstorleken återställd till ursprungsstorlek",
   "Klient",
   "Försöker koppla upp automatiskt igen om %lu minuter.",
   "Försöker koppla upp automatiskt.",
   "Den automatiska återuppkopplingen avbruten.",
   "Koreansk",
   "Begränsa Bandbredd",
   "bytes/sekund",
   "Ställ in max nedladdningshastighet (per överföring)",
   "Ställ in max uppladningshastighet (per överföring)",
   "Max nedladdningshastighet är",
   "Max uppladdningshastighet är",
   "Ungersk",
   "Välj färger",  // translate me
   "Text Bakgrund",
   "Rullistens Text Bakgrund",
   "Gräns area",
   "Text",
   "System",
   "Varning",
   "Error",
   "Handling",
   "Privat",
   "Name Sagt",
   "Ping",
   "Lokalt Nick",
   "Fjärr Nick",
   "URL",
   "Urval",
   "Övervaka",
   "Nedladdningsstatus",
   "Uppladdningsstatus",
   "Stoppad uppladdningsstatus",
   "Färg prefenser vid",
   "Ångra",
   "Grundinställd",
   "Ändra vald färgsättning",
   "Rumänsk",
   "Dela skärmdump",
   "Delar nu skärmdump",
   "Error delning skärmdump",
   " har slutfört nedladdning ",
   "Överfört denna session:  %s ned, %s upp.",
   "visa övrig info",
   "Svartlistad",
   "tills",
   "Data Kompression",
   "Låg",
   "Medium",
   "Hög",
   "Kinesisk",
   "Turkish",
   "Japanese",
   "[font name]",
   "set font",
   "Font set to",
   "Font reset to default",
   "Couldn't find font",
   "Shortest Uploads First",
   "Finska"
};

static const char _norwegianShortcuts[NUM_SHORTCUTS] = {
   'N',  // New connection
   'B',  // "Bye" to current connection
   'S',  // Shared dir
   'D',  // Download dir
   'L',  // clear Log
   'R',  // Reset Layout
   'Q',  // Quit
   'U',  // Full user Queries
   'M',  // Beep When Mentioned
   'P',  // Open private chat window
   'F',  // Toggle file logging
   'E',  // File sharing enabled
   'O',  // Logs dir
};

static const char * _norwegianStrings[NUM_STRINGS] = {
   "Anonym",
   "Ukjent",
   " er no tilkopla.",
   " har kopla frå.",
   "Brukar #",
   " (kjend som ",
   " er no kjend som ",
   "sann",
   "usann",
   "<ukjend type>",
   "Brukar ",
   " lastar ned ",
   "Feil ved filskriving ",
   "Det vart ein feil.",
   "I kø (maskina di er oppteken)",
   "I kø (vertsmaskina er oppteken)",
   "Sendt: ",
   "Motteke: ",
   "/sek, ",
   "Ventar på svar...",
   "Koplar til...",
   "Nedlasting ferdig",
   "Nedlasting avbrote",
   "Kunne ikkje kopla til",
   "Gjer klar til å senda",
   "Gjer klar til å lasta ned",
   "til",
   "frå",
   "Kan ikkje lasta ned--ingen mottakarport!",
   "Kan ikkje starta forseinka tilkopling!",
   "Kan ikkje starta forseinka tilkopling--ingen overføringstråd!",
   "Feil, kan ikkje laga tilkoplingstråd! (Prøv å avslutta BeShare og starta Netverkstenester på nytt)",
   "(Deler %i filer på maskina di)",
   "Kan ikkje finna 'shared'-mappa, fildeling er avslegen!",
   "\0011Filnamn",
   "\0012Brukar",
   "\0013Brukarnummer",
   "\0014Tilkopling",
   "Fil",
   "Kopla til tenar",
   "Kopla frå",
   "Opna Shared-mappa",
   "Opna Downloads-mappa",
   "Slett pratelogg",
   "Start omatt oppsett",
   "Om BeShare",
   "Avslutt",
   "Eigenskapar",
   "Innstillingar",
   "Flest opplastingar samstundes",
   "Flest nedlastingar samstundes",
   "Ikkje nokor grense",
   "Opplastingsbandbreidd",
   "Logg",
   "Opplastingar",
   "Brukarhendingar",
   "Endringar i førespurnader",
   "Fulle brukarførespurnader",
   "Eg er bak ein brannmur",
   "Førespurnad:",
   "Finn!",
   "Stogg førespurnad",
   "Tenar:",
   "Brukarnamn:",
   "Last ned desse filene",
   "Slett ferdige/feilslegne nedlastingar",
   "Slett utvalde",
   "Prat",
   "Namn",
   "Nummer",
   "BeShare lyttar på port %u.  Vel Kopla til frå Fil-menyen for å byrja!",
   "Kan ikkje starta tenartråd for fildeling!  (Prøv å starta Netverkstenester på nytt, så BeShare)",
   "Kan ikkje lasta ned frå brukar ",
   ", det finst ikkje opplysningar om tilkoplinga.",
   "Kan ikkje lasta ned filer frå ",
   ", fordi me er bak brannmurar båe to.",
   "Godkjenninga av filnedlasting for ",
   " vart feil",
   "Filnedlasting for ",
   "Endra førespurnad til",
   "Starta førespurnad",
   "Kan ikkje starta ShareFileTransfer-omgang for å svara på førespurnad frå ein annan brukar!  (Prøv å starta Netverkstenester på nytt, så BeShare)",
   "Namnet ditt er endra til ",
   "av",
   "Ukjend brukar ",
   ", melding \"",
   "\" ikkje sendt.",
   "Ingen målbrukar gjeven i /msg",
   "Stogga førespurnad",
   "System",
   "Åtvaring",
   "Feil",
   "Handling",
   "Kopla til ",
   " - Koplar til ",
   " - %lu resultat synte (",
   " - Kopla til ",
   "Har sett opp tilkopling.",
   "Koplar til tenar...",
   "Du er ikkje lenger kopla til MUSCLE-tenaren.",
   "Greidde ikkje å kopla til tenar.",
   "Engelsk",
   "Spansk",
   "Språket %s er valt.  Endringane vil synast når du startar BeShare på nytt att.",
   "Språk",
   "Tysk",
   "Type",
   "Storleik",
   "Filer",
   "Nederlandsk",
   "Undersøkjer filer...",
   "Kommandoar i irc-stil som finst:",
   "send ei privat melding",
   "endra brukarnamnet ditt",
   "gjer noko",
   "synonym for /action",
   "slett prateloggen",
   "start ein ny førespurnad",
   "stogg den aktive førespurnaden",
   "kopla til ein tenar",
   "kopla frå tenaren",
   "avslutt BeShare",
   "syn meg denne hjelpeteksten",
   "<namn eller brukarnummer> <tekst>",
   "<namn>",
   "<handling>",
   "[søkjeStreng]",
   "[tenarNamn]",
   "Portugisisk",
   "Fransk",
   "Pip når nemnd",
   "Flest samstundes opplastingar for kvar brukar",
   "Tidsstempel",
   "AutoSlett ferdige nedlastingar",
   "Flest samstundes nedlastingar for kvar brukar",
   "Italiensk",
   "Logg inn ved oppstart",
   "Private meldingar",
   "Opna privat praterute",
   "BeShare privat praterute",
   "Prat med:",
   "Feil, du har ikkje valt brukar!",
   "Lagra innstilling",
   "Hent fram att innstilling",
   "Feil, ukjend kommando",
   "Skriv /help for eit oversyn over mogelege kommandoar.",
   " - (%lu-%lu) av %lu synte resultat (",
   "Syn",
   "Info-meldingar",
   "Åtvaringar",
   "Feilmeldingar",
   "Logging på",
   "Logging av",
   "Resultat for kvar side",
   "Byt til side",
   "sjå bort frå brukarar",
   "Oversjå-filteret er sett til: ",
   "Ta bort oversjå-filter.",
   "<namn eller brukarnummer>",
   "Flytt opp",
   "Flytt ned",
   "Stogg nedlasting",
   "Start nedlasting på nytt",
   "Opna fil",
   "Russisk",
   "Prat",
   "Noverande /ignore-mønster er: ",
   "Avslegen",
   "Der er %i overføringar no, er du viss på at du vil avslutta?",
   "Ikkje avslutt",      // Don't Quit
   "Siste endring", // Last Change
   "Esperanto",
   "Svensk",
   "ping andre brukarar",
   "Ping kom att på %Li millisekund",
   "Sent ping-førespurnad til: ",
   "Norsk (nynorsk)",
   "Serbisk",
   "borte",
   "Autovarsling om fråver",
   "minutt",
   "melding",
   "endrar meldinga som kjem opp automatisk når du er borte",
   "Meldinga som kjem opp når du er borte er no: ",
   "Bruk fråversmelding uansett",
   "Opna mappa",
   "Fylgjefilteret er sett til: ",
   "Fylgjefilteret er fjerna.",
   "Fylgjefilteret /watch er no: ",
   "Skriv inn kva brukarar du vil fylgja med",
   "Oppstartskommandoane er sletta.",
   "kommando",
   "legg til ein oppstartskommando",
   "slett oppstartskommandoane",
   "Har lagt til oppstartskommando: ",
   "Fylg med",
   "Spør etter tenarstatus.",
   "%.1fMB  brukt (%.1fMB tilgjengeleg)",
   "Tenarstatus:",
   "Tenarversjon",
   "Tenar-rota åt klienten din denne omgangen",
   "Minnebruk hjå tenaren",
   "Spør etter tenarstatus",
   "Tenaren har vore i drift",
   "veker",
   "dagar",
   "Maskina di har vore i drift",
   "Du har vore logga på i",
   "Fildeling på",
   "Steng ute brukar i",
   "Brukaren med IP %s er stengt ute i",
   "Timar",
   "For alltid",
   "fjern alle opplastingsstengsel",
   "Fjernar %lu opplastingsstengsel",
   "AutoPriv-mønsteret er sett til: ",
   "Har fjerna AutoPriv-mønsteret.",
   "oppgje AutoPriv-brukarar",
   "Det noverande /autopriv-mønsteret er: ",
   "Ukjent dataformat!",
   "Opna loggmappa",
   "Status",
   "Statusen din erendra til: ",
   " er ",
   "Last",
   "endrar brukarstatusen",
   "Bulgarsk",
   "Filplassering",
   "Bruk filplasseringane",
   "Bruk alias",
   "Fjerna alias",
   "[namn og verdi]",
   "lag eit alias",
   "fjern eit alias",
   "Flytt øvst",
   "Flytt nedst",
   "Gje vindauget ein eigen tittel",
   "Vindaugstittelen er no",
   "Auto-oppdater tenarlista",
   "Har lagt til tenar: %s",
   "Har fjerna tenar: %s",
   "No kan du få BeShare v%s. Du kan laste han ned frå %s.",
   "utfør skall-kommando",
   "Utfører skall-kommando",
   "skall-kommando",
   "ledig-kommandoen er sett til",
   "set kommandoar til bruk når overføringane er avslutta (ledig-kommandoar)",
   "skriftstorleik i punkt",
   "set skriftstorleik",
   "Skriftstorleiken er no:",
   "Har sett skrifta til vanleg storleik",
   "Klient",
   "Skal prøva å kopla opp att om %lu minutt ",
   "Prøver å kopla opp att ",
   "Auto-oppkopling er avbroten ",
   "Koreansk",
   "Avgrens bandbreidda",
   "bitar i sekundet",
   "Set fast største nedlastingsfart (per overføring)",
   "Set fast største opplastingsfart (per overføring)",
   "Største nedlastingsfart er",
   "Største opplastingsfart er",
   "Ungarsk",
   "Vel farger",
   "Tekstbakgrunn",
   "Opprulla tekstbakgrunn",
   "Rammeareal",
   "Tekst",
   "Systemmeldingar",
   "Åtvaringar",
   "Feilmeldingar",
   "Handlingar (/action)",
   "Private meldingar",
   "Når andre skriv namnet ditt",
   "Ping",
   "Kallenamnet ditt",
   "Andre sine kallenamn",
   "Netadresse",
   "Vald tekst",
   "Kallenamn under oppsikt",
   "Nedlasting",
   "Opplasting",
   "Stogga opplasting",
   "Fargeinnstillingar av",
   "Gjer om fargeendringar",
   "Vanleg innstilling",
   "Slå på eige fargeval",
   "Rumensk",
   "Del skjermbilete",
   "Deler no eit skjermbilete",
   "Feil: Greidde ikkje å dela skjermbilete",
   " har lasta ned ",
   "Overført denne økta:  %s ned, %s opp. ",
   "vis ymse informasjon",
   "Bannsett",
   "til",
   "Datakomprimering",
   "Låg",
   "Middels",
   "Hog",
   "Kinesisk",
   "Turkish",
   "Japanese",
   "[font name]",
   "set font",
   "Font set to",
   "Font reset to default",
   "Couldn't find font",
   "Shortest Uploads First",
   "Finnish"
};

static const char _serbianShortcuts[NUM_SHORTCUTS] = {
   'N',  // New connection
   'B',  // "Bye" to current connection
   'S',  // Shared dir
   'D',  // Download dir
   'L',  // clear Log
   'R',  // Reset Layout
   'Q',  // Quit
   'U',  // Full user Queries
   'M',  // Beep When Mentioned
   'P',  // Open private chat window
   'F',  // Toggle file logging
   'E',  // File sharing enabled
   'O',  // Logs dir
};

static const char * _serbianStrings[NUM_STRINGS] = {
   "Anoniman",
   "Nepoznat",
   " je konektovan.",
   " nije konektovan.",
   "Korisnik #",
   " (a.k.a. ",
   " se sad zove ",
   "tacno",
   "netacno",
   "<nepoznat tip>",
   "Korisnik ",
   " preuzima datoteku ",
   "Greska pri snimanju datoteke ",
   "Desila se greska.",
   "Ceka (lokalni racunar je zauzet)",
   "Ceka (udaljeni racunar je zauzet)",
   "Poslato: ",
   "Primljeno: ",
   "/sek, ",
   "Ceka odgovor...",
   "Povezivanje...",
   "Preuzimanje gotovo",
   "Preuzimanje prekinuto",
   "Povezivanje neuspesno",
   "Pripremanje slanja",
   "Pripremanje preuzimanja",
   "ka",
   "od",
   "Greska pri preuzimanju-nije prihvacen port!",
   "Greska pri odlozenoj konekciji!",
   "Greska pri odlozenoj konekciji--no transceiver thread!",
   "Greska, nije se mogla uspostaviti konekcija! (Ugasite BeShare i restartujte Networking)",
   "(Delim %i lokalnih datoteka)",
   "Ne mogu da nadjem 'deljeni' poddirektorijum, deljenje datoteka onemoguceno!",
   "\0011Ime datoteke",
   "\0012Korisnik",
   "\0013Broj sesije",
   "\0014Konekcija",
   "Datoteka",
   "Povezi se na server",
   "Prekini vezu",
   "Otvori direktorijum sa deljenim datotekama",
   "Otvori Download direktorijum",
   "Obrisi Chat Log",
   "Resetuj interfejs",
   "O BeShare-u",
   "Izadji",
   "Atributi",
   "Podesavanja",
   "Maksimum simultanih slanja",
   "Maksimum simultanih preuzimanja",
   "Bez ogranicenja",
   "Brzina konekcije",
   "Log",
   "Slanja",
   "Korisnicki dogadjaji",
   "Promene upita",
   "Puni korisnicki upiti",
   "Ja sam iza firewall-a",
   "Upit:",
   "Pokreni upit",
   "Zaustavi upit",
   "Server:",
   "Korisnicko ime:",
   "Preuzmi izabrane datoteke",
   "Izbrisi zavrsene/neuspesne transfere",
   "Izbrisi izabrano",
   "Razgovor",
   "Ime",
   "ID",
   "BeShare slusa na portu %u.  Izaberi Connect iz Datoteka menija da pocnes!",
   "Nije se mogao pokrenuti ile-sharing server thread!  (Restartujte Networking i pokrenite BeShare!)",
   "Nije moguce preuzeti datoteku od korisnika ",
   ", bez informacije o konekciji.",
   "Nemoguce preuzeti od ",
   ", zato sto smo obojica iza firewall-a.",
   "Preuzimanje datoteke prihvaceno od ",
   " neuspesna inicijalizacija!",
   "Sesija preuzimanja od ",
   "Promenjen upit u",
   "Pokrenut upit",
   "Nije pokrenuta ShareFileTransfer sesija da bi se zadovoljio zahtev! (Restartuj Networking,a potom restartuj BeShare)",
   "Vase ime je promenjeno u ",
   "od",
   "Nepoznat korisnik ",
   ", poruka \"",
   "\" nije poslata.",
   "Nije odredjen ciljni korisnik u /msg",
   "Zaustavljen sistem",
   "Sistem",
   "Upozorenje",
   "Greska",
   "Akcija",
   "Povezi se sa ",
   " - Povezi se sa ",
   " - %lu reultati prikazani (",
   " - Povezi se sa ",
   "Uspostavljena veza.",
   "Povezivanje na server...",
   "Niste vise povezani na MUSCLE server.",
   "Beuspesno povezivanje na server.",
   "Engleski",
   "Spanski",
   "Jezik %s izabran. Promena ce se prikazati po ponovnom pokretanju BeShare-a.",
   "Jezik",
   "Nemacki",
   "Tip",
   "Velicina datoteke",
   "Datoteke",
   "Holandski",
   "Ispitujem datoteke...",
   "Raspolozive irc-olike komande:",
   "posalji privatnu poruku",
   "promeni svoje korisnicko ime",
   "uradi nsto",
   "sinonim za /akciju",
   "izbrisi chat log",
   "pokreni novi upit",
   "zaustavi upit",
   "povezi se na server",
   "prekini vezu sa serverom",
   "izadji iz BeShare-a",
   "prikazi tekst pomoci",
   "<ime ili id sesije> <tekst>",
   "<ime>",
   "<akcija>",
   "[queryString]",
   "[imeservera]",
   "Portugalski",
   "Francuski",
   "Upozori zvukom kad si pomenut",
   "Maksimum istovremenih slanja po korisniku",
   "Vreme",
   "Automatski izbrisi zavrsene preuzete datoteke",
   "Maksimum istovremenih preuzimanja po korisniku",
   "Italijanski",
   "Povezi se automatski",
   "Privatne poruke",
   "Optvori prozor za privatni razgovor",
   "BeShare prozor za privatni razgovor",
   "razgovor sa:",
   "Greska, nije definisan korisnik!",
   "Snimi sablon",
   "Ponovo ucitaj sablon",
   "Greska, nepoznata komanda",
   "Ukucaj /help za listu raspolozivih komandi.",
   " - (%lu-%lu) od %lu rezultata (",
   "Prikazi",
   "Informativne poruke",
   "Poruke upozorenja",
   "Poruke o greskama",
   "Povezivanje omoguceno",
   "Povezivanje onemoguceno",
   "Resuzultati po stranici",
   "Prebaci se na stranicu",
   "odredi korisnike za ignorisanje",
   "Lista za ignorisanje podesena na: ",
   "Lista za ignorisanje izbrisana.",
   "<imena ili id sesija>",
   "Pomeri gore",
   "Pomeri dole",
   "Zaustavi preuzimanje",
   "Ponovno pokreni preuzimanje",
   "Otvori datoteku",
   "Ruski",
   "Razgovor",
   "Trenutna /lista ignorisanja: ",
   "Onemogucen",
   "Trenutno je u toku %i transfera, da li ste sigurni da hocete da izadjete?",
   "Ne izadji",
   "Vreme promene",
   "Esperanto",
   "Svedski",
   "ping-uj ostale klijente",
   "Ping se vratio za %Li milisekundi",
   "Posalji ping zahtev ka: ",
   "Norveski",
   "Srpski",
   "away",
   "Auto Away",
   "minutes",
   "tag",
   "change the auto-away tag",
   "Auto-away tag set to: ",
   "Force away state",
   "Otvori Direktorijum",
   "Watch pattern set to: ",
   "Watch pattern removed.",
   "Current /watch pattern is: ",
   "specify users to watch",
   "Startup commands cleared.",
   "command",
   "add startup command",
   "clear startup commands",
   "Recorded startup command: ",
   "Watch",
   "Server status requested.",
   "%.1fMB used (%.1fMB available)",
   "Server status:",
   "Server version",
   "Local session root",
   "Server memory usage",
   "Request server status",
   "Server uptime",
   "weeks",
   "days",
   "System Uptime",
   "logged in for",
   "File Sharing Enabled",
   "Ban User For",
   "User at IP %s banned for",
   "Hours",
   "Forever",
   "remove all upload bans",
   "Removing %lu upload bans",
   "AutoPriv pattern set to: ",
   "AutoPriv pattern removed.",
   "specify AutoPriv users",
   "Current /autopriv pattern is: ",
   "Unknown data format!",
   "Open Logs Folder",
   "Status",
   "Your status has been changed to: ",
   " is now ",
   "Load",
   "set user status string",
   "Bulgarian",
   "Path",
   "Retain File Paths",
   "Set alias",
   "Removed alias",
   "[name and value]",
   "create an alias",
   "remove an alias",
   "Move to Top",
   "Move to Bottom",
   "set custom window title",
   "Custom window title is now",
   "AutoUpdate Server List",
   "Added server: %s",
   "Removed server: %s",
   "BeShare v%s is now available for download.  You can upgrade at %s",
   "execute shell command",
   "Executing shell command",
   "shell command",
   "idle command set to",
   "set command for when transfers cease",
   "font size in points",
   "set font size",
   "Font size set to:",
   "Font size reset to default",
   "Client",
   "Will attempt auto-reconnect in %lu minutes.",
   "Attempting auto-reconnect.",
   "Auto-reconnect sequence terminated.",
   "Korean",
   "Limit Bandwidth",
   "bytes/second",
   "Set max download rate (per transfer)",
   "Set max upload rate (per transfer)",
   "Max download rate is",
   "Max upload rate is",
   "Hungarian",
   "Choose Colors",  // translate me]
   "Text Background",
   "Scrolled Text Background",
   "Border Areas",
   "Text",
   "System",
   "Warning",
   "Error",
   "Action",
   "Private",
   "Name Said",
   "Ping",
   "Local Nick",
   "Remote Nick",
   "URL",
   "Selection",
   "Watch",
   "Download Progress",
   "Upload Progress",
   "Paused Upload Progress",
   "Color prefs by",
   "Revert",
   "Default",
   "toggle custom coloring",
   "Romanian",
   "share screenshot",
   "is now sharing a screenshot",
   "Error sharing screenshot",
   " has finished downloading ",
   "Transferred this session:  %s down, %s up.",
   "show some miscellaneous info",
   "Banned",
   "until",
   "Data Compression",
   "Low",
   "Medium",
   "High",
   "Chinese (Simplified)",
   "Turkish",
   "Japanese",
   "[font name]",
   "set font",
   "Font set to",
   "Font reset to default",
   "Couldn't find font",
   "Shortest Uploads First",
   "Finnish"
};

static const char _bulgarianShortcuts[NUM_SHORTCUTS] = {
   'N',  // New connection
   'B',  // "Bye" to current connection
   'S',  // Shared dir
   'D',  // Download dir
   'L',  // clear Log
   'R',  // Reset Layout
   'Q',  // Quit
   'U',  // Full user Queries
   'M',  // Beep When Mentioned
   'P',  // Open private chat window
   'F',  // Toggle file logging
   'E',  // File sharing enabled
   'O',  // Logs dir
};

// Bulgarian translation by Zlatko Zlatinov <zlati74@rambler.bg>
static const char * _bulgarianStrings[NUM_STRINGS] = {
   "Анонимен",
   "Неизвестен",
   " се включи.",
   " беше отстранен ( disconnected).",
   "Клиент № ",
   " (известен като ",
   " си промени името на ",
   "истина",
   "лъжа",
   "<неизвестен тип (значение)>",
   "Клиент ",
   " се сваля ",
   "Грешка при запис на файла ",
   "Грешка",
   "На опашката (локалната машина е заета в момента)",
   "На опашката (отдалечената машина е заета в момента)",
   "Изпратени: ",
   "Приети: ",
   "/сек., ",
   "Чакам отговор...",
   "Connect...",
   "Свалянето завърши",
   "Свалянето е прекъснато",
   "Връзката е невъзможна",
   "Подготовка за upload",
   "Подготовка за download",
   "в",
   "от",
   "Не мога да започна свалянето - няма отворен порт!",
   "Не мога да продължа - отложена връзка (delayed)!",
   "Не мога да продължа, отложена връзка (delayed)- няма изходен поток!",
   "Грешка, не може да се създаде нишка! (Затворете BeShare и натиснете Restart Networkiing в мрежовите настройки)",
   "(Достъпни са %i локални файла)",
   "Не мога да намеря папка Shared, забранени са локалните файлове!",
   "\0011Име на файла",
   "\0012Клиент",
   "\0013№ на сесията",
   "\0014Тип на връзката",
   "Файл",
   "Connect ",
   "Disconnect",
   "Отвори папка Shared",
   "Отвори папка Downloads",
   "Изчисти чат прозореца",
   "Върни настройките по подразбиране",
   "Информация за програмата",
   "Изход",
   "Атрибути",
   "Настройки",
   "Макс. число за upload",
   "Макс. число за download",
   "Без ограничения",
   "Скорост на връзката",
   "Записи",
   "Upload",
   "Локални събития",
   "Изменения на заявката",
   "Показване на всички клиентски файлове",
   "Зад защитна стена съм (firewall)",
   "Заявка:",
   "Започни търсене",
   "Спри",
   "Сървър:",
   "Име на клиента:",
   "Свали избраните файлове",
   "Автом. изтрий завършилите /неуспелите",
   "Изтрий селектираните",
   "Разговори (чат)",
   "Име",
   "№",
   "BeShare следи порт %i.  Изберете Connect в менюто Файл!",
   "Не мога да стартирам file-sharing server thread!  (Опитай Restarting Networking, след това стартирай BeShare)", //*
   "Не мога да сваля файла от клиент ",
   ", няма информация за връзка.",
   "Не мога да сваля файловете от ",
   ", защото и двата клиента са зад защитна стена.",
   "Не може да се инициализира връзка с",
   ", възможно е той да е със защитна стена",
   "Не мога да получа отговор от ",
   "Заявката е изменена на ",
   "Заявката е стартирана",
   "Couldn't start ShareFileTransfer session to serve remote transfer request!  (Try Restarting Networking, then restarting BeShare)", // *
   "Вашето име бе променено на ",
   "от",
   "Неизвестен клиент ",
   ", съобщение \"",
   "\" не беше изпратено.",
   "След /msg задължително трябва да е указан клиент",
   "Търсенето е спряно",
   "Система",
   "Внимание!",
   "Грешка",
   "Действие",
   "Connect to ",
   " - Връзваме се със ",
   " - %lu вариант(a) са показани (",
   " - Връзка с ",
   "Установена е връзка.",
   "Връзваме се със сървър...",
   "Вие вече не сте включен към MUSCLE сървър.",
   "Не успяхте да се свържете със сървър.",
   "Английски",
   "Испански",
   "Избран е %s език.  Промяната ще настъпи след рестартиране на BeShare.",
   "Език",
   "Немски",
   "Значение",
   "Размер",
   "Файла(a)",
   "Датски",
   "Преглед на файловете...",
   "Поддръжани IRC-команди:",
   "изпрати лично съобщение",
   "смени името на клиента",
   "направи нещо",
   "синоним на команда /action",
   "изтрий записаните разговори",
   "стартирай нова заявка",
   "спри текущата заявка",
   "свържи се със сървър",
   "disconnect от сървър",
   "изход от BeShare",
   "покажи списъка с команди",
   "<име или клиентски №> <текст>",
   "<име>",
   "<действие>",
   "[заявка]",
   "[сървър]",
   "Португалски",
   "Френски",
   "Подай сигнал при споменаване на името",
   "Макс. число upload-и за клиент",
   "Покажи времето",
   "Автоматично изтрий завършилите",
   "Макс. число download-и за клиент",
   "Италиански",
   "Логин при стартиране",
   "Лични съобщения",
   "Oтвори прозорец за чат",
   "BeShare чат прозорец",
   "Поговори с ",
   "Грешка, не е указан клиент!",
   "Съхрани",
   "Въстанови",
   "Неизвестна команда ",
   "Напишете /help, за да видите списъка с валидни команди.",
   " - показани са (%lu-%lu) варианта от %lu (",
   "Покажи",
   "Информационни съобщения",
   "Предупреждения",
   "Грешки",
   "Записите са включени",
   "Записите са деактивирани",
   "Количество резултати на страница",
   "Прехвърли се на страница",
   "игнорирай клиент",
   "Маска на команда /ignore: ",
   "Маска на команда /ignore е изтрита.",
   "<имена или №>",
   "Нагоре",
   "Надолу",
   "Отмени трансфера",
   "Рестартирай трансфера",
   "Отвори файл",
   "Руски",
   "Чат",
   "Текущата маска на команда /ignore е: ",
   "деактивиран",
   "Дърпат се %i файл(а), уверени ли сте, че искате да напуснете програмата?",
   "Не",
   "Променен",
   "Есперанто",
   "Шведски",
   "пинг на другите клиенти",
   "Пакета се връща за %Li милисекунди",
   "Изпрати пинг до: ",
   "Норвежки",
   "Сръбски",
   "излязъл",
   "Режим \" Изход\" след",
   "минути",
   "отметка",
   "промени отметка \"Изход\"",
   "Отметка режим \"Изход\": ",
   "изключи режим \"Изход\"",
   "Отвори папка",
   "Watch pattern set to: ",
   "Watch pattern removed.",
   "Current /watch pattern is: ",
   "клиент(и) за наблюдение",
   "Стартовите команди са изтрити.",
   "команда",
   "добави команда при стартиране",
   "изтрий стартиращите команди",
   "показва информация за състоянието (статуса) на сървъра: ",
   "Наблюдавай",
   "Запитване за текущия статус на сървъра.",
   "%.1fMB използвани (%.1fMB достъпни)",
   "Статус на сървъра:",
   "Версия на сървъра",
   "Local session root",
   "Използвана памет от сървъра",
   "запитване за състоянието на сървъра",
   "Server uptime",
   "седмици",
   "дни",
   "System Uptime",
   "logged in for",
   "Разреши достъпа до локални файлове",
   "Ban User For",
   "User at IP %s banned for",
   "Часове",
   "Завинаги",
   "изтрий всички забрани за upload",
   "Removing %lu upload bans",
   "AutoPriv pattern set to: ",
   "AutoPriv pattern removed.",
   "specify AutoPriv users",
   "Current /autopriv pattern is: ",
   "Неизвестен формат на данните!",
   "Отвори папка Log",
   "Статус",
   "Вашият статус беше променен на: ",
   " сега се подвизава под името ",
   "Зареден в %",
   "задай клиентски статус",
   "Български",
   "Път",
   "Запомни пътищата",
   "Псевдоним",
   "Изтрий псевдоним",
   "[име и стойност]",
   "създай псевдоним",
   "изтрий псевдоним",
   "Премести най-отпред",
   "Премести най-отзад",
   "задай различно заглавие на прозореца",
   "Прозореца сега се казва",
   "Aвтоматично обнови листа на сървърите",
   "Добавен е сървър: %s",
   "Изтрит е сървър: %s",
   "BeShare v%s е достъпна за сваляне.  Можете да свалите версия %s",
   "execute shell command",
   "Executing shell command",
   "shell command",
   "idle command set to",
   "set command for when transfers cease",
   "font size in points",
   "set font size",
   "Font size set to:",
   "Font size reset to default",
   "Client",
   "Will attempt auto-reconnect in %lu minutes.",
   "Attempting auto-reconnect.",
   "Auto-reconnect sequence terminated.",
   "Korean",
   "Limit Bandwidth",
   "bytes/second",
   "Set max download rate (per transfer)",
   "Set max upload rate (per transfer)",
   "Max download rate is",
   "Max upload rate is",
   "Hungarian",
   "Choose Colors",  // translate me
   "Text Background",
   "Scrolled Text Background",
   "Border Areas",
   "Text",
   "System",
   "Warning",
   "Error",
   "Action",
   "Private",
   "Name Said",
   "Ping",
   "Local Nick",
   "Remote Nick",
   "URL",
   "Selection",
   "Watch",
   "Download Progress",
   "Upload Progress",
   "Paused Upload Progress",
   "Color prefs by",
   "Revert",
   "Default",
   "toggle custom coloring",
   "Romanian",
   "share screenshot",
   "is now sharing a screenshot",
   "Error sharing screenshot",
   " has finished downloading ",
   "Transferred this session:  %s down, %s up.",
   "show some miscellaneous info",
   "Banned",
   "until",
   "Data Compression",
   "Low",
   "Medium",
   "High",
   "Chinese (Simplified)",
   "Turkish",
   "Japanese",
   "[font name]",
   "set font",
   "Font set to",
   "Font reset to default",
   "Couldn't find font",
   "Shortest Uploads First",
   "Finnish"
};

static const char _koreanShortcuts[NUM_SHORTCUTS] = {
   'N',  // New connection
   'B',  // "Bye" to current connection
   'S',  // Shared dir
   'D',  // Download dir
   'L',  // clear Log
   'R',  // Reset Layout
   'Q',  // Quit
   'U',  // Full user Queries
   'M',  // Beep When Mentioned
   'P',  // Open private chat window
   'F',  // Toggle file logging
   'E',  // File sharing enabled
   'O',  // Logs dir
};

static const char * _koreanStrings[NUM_STRINGS] = {
   "익명",
   "모름",
   " 번이 지금 접속했음.",
   " 번이 접속을 끊었음.",
   "사용자 #",
   " (이름. ",
   " 번의 이름: ",
   "참",
   "거짓",
   "<알수없는 타입>",
   "사용자 ",
   "번이 자료 내려받는중 ",
   "파일을 쓰는중 에러",
   "에러가 발생했음.",
   "대기 (당신의 컴퓨터에 작업이 너무 많음)",
   "대기 (상대방 컴퓨터에 작업이 너무 많음)",
   "보냄: ",
   "받음: ",
   "/초, ",
   "응답을 기다리는중...",
   "접속중...",
   "내려받기 완료",
   "내려받기 실행중기",
   "접속할 수 없음",
   "자료보내기 준비중",
   "내려받기 준비중",
   "수신",
   "발신",
   "내려받기 시작중 에러--허가된 포트가 아님!",
   "지연 연결을 시작하는중 에러!",
   "지연 연결을 시작하는중 에러--송수신 쓰레드가 없음!",
   "에러, 연결 쓰레드를 생성할 수 없음! (BeShare를 종료하시오, 그런 후 네트워킹을 재시작하시오)",
   "(당신 컴퓨터의 %i 개 파일을 공유중)",
   "공유된 하위디렉토리를 찾을 수 없음, 파일을 공유하지 않음!",
   "\0011파일명",
   "\0012사용자",
   "\0013세션ID",
   "\0014접속",
   "파일",
   "서버에 접속",
   "접속중지",
   "공유폴더 열기",
   "내려받기폴더 열기",
   "채팅로그 지우기",
   "창배치 재정리",
   "BeShare에 대해",
   "종료",
   "속성",
   "설정",
   "동시에 보낼 수 있는 자료 수 제한",
   "동시에 받을 수 있는 자료 수 제한",
   "제한 없음",
   "전송 대역폭",
   "로그",
   "자료보내기",
   "User Events",
   "쿼리 변경",
   "모든 사용자 쿼리",
   "방화벽 사용중",
   "쿼리:",
   "쿼리 시작",
   "쿼리 중지",
   "서버:",
   "사용자 이름:",
   "선택된 파일 내려받기",
   "완료/실패한 전송 삭제",
   "선택항목 제거",
   "대화",
   "이름",
   "ID",
   "BeShare is listening on port %u.  시작하기 위해 파일메뉴의 접속할서버를 누르시오!",
   "Couldn't start file-sharing server thread!  (네트워킹을 재시작한 후 BeShare를 다시 실행하시오)",
   "사용자로 부터 내려받을 수 없음. ",
   ", 이용가능한 접속 정보가 없음.",
   "Can't download files from ",
   ", because both of us are behind firewalls.",
   "File download accept session for ",
   " failed to initialize!",
   "File download session to ",
   "Changed Query to",
   "Started Query",
   "Couldn't start ShareFileTransfer session to serve remote transfer request!  (네트워킹을 재시작한 후 BeShare를 다시 실행하시오)",
   "변경된 당신의 이름은 ",
   "by",
   "알수없는 사용자 ",
   ", 메세지 \"",
   "\" 보내지 않음",
   "/msg명령안에 기재된 사용자가 없음",
   "쿼리를 멈춤",
   "시스템",
   "경고",
   "에러",
   "행동",
   "접속할 서버 ",
   " - 에 접속중 ",
   " - %lu 결과 보기 (",
   " - 에 접속했음 ",
   "Connection established.",
   "서버에 접속중...",
   "당신은 더이상 MUSCLE 서버에 연결되어 있지 않음.",
   "서버에 접속 실패.",
   "영어",
   "스페인어",
   "언어가 %s 로 선택됨.  변경사항은 BeShare를 재 실행하셔야 적용됩니다.",
   "언어",
   "독일",
   "유형",
   "파일 크기",
   "파일",
   "독일어",
   "파일 검사중...",
   "irc-style 명령어 사용:",
   "비공개 메세지 보내기",
   "당신의 이름을 변경",
   "do something",
   "synonym for /action",
   "채팅로그를 삭제",
   "새 쿼리 시작",
   "지금 쿼리 중지",
   "서버에 접속",
   "서버로 부터 접속 중지",
   "BeShare 종료",
   "이것에 대한 도움말 보기",
   "<이름 또는 세션 id> <문구>",
   "<이름>",
   "<행동>",
   "[queryString]",
   "[서버명]",
   "포르투칼어",
   "프랑스어",
   "언급되었을때 소리내기",
   "사용자별 동시에 보낼수 있는 자료 수 제한",
   "시간보기",
   "내려받기 종료시 리스트 자동 삭제",
   "사용자별 동시에 받을수 있는 자료 수 제한",
   "이태리어",
   "시작시 자동 로그인",
   "비공개 메세지",
   "비공개 채팅창 열기",
   "BeShare 비공개 채팅창",
   "채팅 상대:",
   "에러, 기재된 사용자 없음!",
   "Save Preset",
   "Restore Preset",
   "에러, 모르는 명령어",
   "사용가능한 명령어 목록을 보기위해 /help를 치시오.",
   " - (%lu-%lu) 의 %lu 결과 보기 (",
   "보기",
   "정보 메세지",
   "경고 메세지",
   "에러 메세지",
   "로깅 사용가능",
   "로깅 사용불능",
   "페이지당 결과",
   "페이지로 전환",
   "무시할 사용자 등록",
   "무시하기 형태 설정: ",
   "무시하기 형태 지우기.",
   "<이름 또는 세션 ids>",
   "위로 이동",
   "아래로 이동",
   "전송 중단",
   "전송 재시작",
   "파일 열기",
   "러시아어",
   "대화",
   "현재 /ignore 명령 패턴: ",
   "사용 불능",
   "%i 전송이 진행중입니다, 정말 종료하길 원하십니까?",
   "종료하지 마세요",
   "수정 시간",
   "에스페란토",
   "스웨덴어",
   "ping other clients",
   "Ping returned in %Li milliseconds",
   "Sent ping request to: ",
   "노르웨이어",
   "세르비아어",
   "자리비움",
   "자동으로 자리비움",
   "분",
   "tag",
   "change the auto-away tag",
   "Auto-away tag set to: ",
   "Force away state",
   "폴더 열기",
   "지켜보기 형태 설정: ",
   "지켜보기 형태 지우기.",
   "현재 /watch 명령 형태는: ",
   "지켜보기위한 사용자 등록",
   "시작시 명령을 지웠음.",
   "명령",
   "시작시 명령 추가",
   "시작시 명령 지우기",
   "기록된 시작시 명령: ",
   "지켜보기",
   "서버 현황을 요청했음.",
   "%.1fMB used (%.1fMB available)",
   "서버 상태:",
   "서버 버전",
   "Local session root",
   "서버 메모리사용 현황",
   "서버 현황 요청",
   "서버 운영시간",
   "주",
   "일",
   "시스템 운영시간",
   "logged in for",
   "파일공유 사용가능",
   "Ban User For",
   "User at IP %s banned for",
   "시간",
   "영원히",
   "remove all upload bans",
   "Removing %lu upload bans",
   "AutoPriv pattern set to: ",
   "AutoPriv pattern removed.",
   "specify AutoPriv users",
   "Current /autopriv pattern is: ",
   "알수없는 데이타 형태!",
   "로그폴더 열기",
   "상태",
   "변경되어진 당신의 상태: ",
   " 현재 접속 상태: ",
   "전송상태",
   "사용자 상태 문자 설정",
   "불가리아어",
   "경로",
   "파일경로 유지",
   "별칭 설정",
   "제거된 별칭",
   "[name and value]",
   "별칭 생성",
   "별칭 지우기",
   "맨위로 이동",
   "맨아래로 이동",
   "Custom 창제목 설정",
   "Custom 창제목 is now",
   "서버목록 자동갱신",
   "추가된 서버: %s",
   "제거된 서버: %s",
   "BeShare v%s is now available for download.  You can upgrade at %s",
   "쉘 명령어 실행",
   "쉘 명령어 실행중",
   "쉘 명령어",
   "idle command set to",
   "set command for when transfers cease",
   "font size in points",
   "글꼴크기 설정",
   "글꼴크기 설정:",
   "기본사항으로 폰트크기 재설정",
   "Client",
   "Will attempt auto-reconnect in %lu minutes.",
   "Attempting auto-reconnect.",
   "Auto-reconnect sequence terminated.",
   "한국어",
   "Limit Bandwidth",
   "bytes/second",
   "Set max download rate (per transfer)",
   "Set max upload rate (per transfer)",
   "Max download rate is",
   "Max upload rate is",
   "Hungarian",
   "Choose Colors",  // translate me
   "Text Background",
   "Scrolled Text Background",
   "Border Areas",
   "Text",
   "System",
   "Warning",
   "Error",
   "Action",
   "Private",
   "Name Said",
   "Ping",
   "Local Nick",
   "Remote Nick",
   "URL",
   "Selection",
   "Watch",
   "Download Progress",
   "Upload Progress",
   "Paused Upload Progress",
   "Color prefs by",
   "Revert",
   "Default",
   "toggle custom coloring",
   "Romanian",
   "share screenshot",
   "is now sharing a screenshot",
   "Error sharing screenshot",
   " has finished downloading ",
   "Transferred this session:  %s down, %s up.",
   "show some miscellaneous info",
   "Banned",
   "until",
   "Data Compression",
   "Low",
   "Medium",
   "High",
   "Chinese (Simplified)",
   "Turkish",
   "Japanese",
   "[font name]",
   "set font",
   "Font set to",
   "Font reset to default",
   "Couldn't find font",
   "Shortest Uploads First",
   "Finnish"
};

//------------------------------------------------------------------------------------
// This is the hungarian language upgrade for the 'ShareStrings.cpp'
// From Bihari Zsolt / Hungary speltec@elender.hu
//------------------------------------------------------------------------------------

static const char _hungarianShortcuts[NUM_SHORTCUTS] = {
   'N', // New connection
   'B', // "Bye" to current connection
   'S', // Shared dir
   'D', // Download dir
   'L', // clear Log
   'R', // Reset Layout
   'Q', // Quit
   'U', // Full user Queries
   'M', // Beep When Mentioned
   'P', // Open private chat window
   'F', // Toggle file logging
   'E', // File sharing enabled
   'O', // Logs dir
};

static const char * _hungarianStrings[NUM_STRINGS] = {
   "Névtelen",
   "Ismeretlen",
   " jelenleg kapcsolatban van.",
   " kapcsolatot bontott.",
   "Felhasználó # ",
   " (--név: ",
   " ezen a néven ismert:  ",
   "létezõ",
   "hamis",
   "<ismeretlen típus>",
   "Felhasználó ",
   " letöltést indít: ",
   "Hiba a fájl írásakor",
   "Le lett állítva a letöltés, vagy valami hiba történt...",
   "Sorbanállás (A géped túlterhelt)",
   "Sorbanállás (A távoli gép túlterhelt)",
   "Küldés: ",
   "Fogadás: ",
   "/sec. ",
   "Várakozás a visszajelzésre...",
   "Csatlakozás...",
   "Letöltés teljesítve.",
   "Letöltés megszakítva.",
   "Nem lehet csatlakozni",
   "Felkészülés a feltöltéshez",
   "Felkészülés a letöltéshez",
   "Cél: ",
   "Forrás: ",
   "Letöltési hiba, nincs elfogadva a port.",
   "Indítási hiba, késleltetett csatlakozás,",
   "Indítási hiba, késleltetett csatlakozás, nincs adó-vevõ lánc",
   "Hiba, nem lehet kapcsolódni. Próbálkozz azzal, hogy kilépsz a BeShare programból és újraindítod a hálózatot",
   "(Megosztva %i helyi fájl)",
   "Nem található a 'shared' alkönyvtár, a fájlmegosztás így letiltásra kerül.",
   "\0011Fájlnév",
   "\0012Felhasználó",
   "\0013SessionID",
   "\0014Kapcsolat",
   "Fájl",
   "Csatlakozás a szerverhez",
   "Kapcsolatbontás",
   "Megosztott könyvtár ('shared') megnyitása",
   "Letöltött fájlok könyvtára",
   "Társalgási napló törlése",
   "Alapértelmezett beállítások",
   "BeShare névjegy",
   "Kilépés",
   "Tulajdonságok",
   "Beállítások",
   "Max. egyidejû fájlküldés",
   "Max. egyidejû letöltés",
   "Határok nélkül",
   "Feltöltési sávszélesség",
   "Naplózás",
   "Feltöltés",
   "Felhasználói események",
   "Keresés módosítása",
   "Keresés mindenkinél egyszerre",
   "Tûzfalazás",
   "Keresés.",
   "Keresés indítása",
   "Keresést leállít",
   "Szerver:",
   "Felhasználónév:",
   "Kijelölt fájlok letöltése",
   "Befejezett és sikertelen átvitelek törlése",
   "Kijelöltek eltávolítása",
   "Társalgás",
   "Név",
   "ID",
   "BeShare kilistázza a  %u portot. A továbbiakban (ha nincs beállítva az azonnali csatlakozás) válaszd a Fájl menüben a 'Csatlakozás' parancsot!",
   "Nem lehet indítani a fájlmegosztást! (Próbálkozz azzal, hogy kilépsz a BeShare programból és újraindítod a hálózatot)",
   "Nem tudok letölteni tõle: ",
   ", nincs a kapcsolatról hozzáférhetõ információ",
   "Nem lehet letölteni a fájlokat innen: ",
   ", mert mindegyikünk tûzfalat használ",
   "File letöltés elfogadva ehhez a szakaszhoz: ",
   " sikertelen inicializálás",
   "Letöltési szakasz: ",
   "Keresés változtatása: ",
   "Keresés indítása",
   "Nem lehet elindítani a megosztott fájlok szakaszainak átvitelét a távoli géprõl. (Próbálkozz azzal, hogy kilépsz a BeShare programból és újraindítod a hálózatot)",
   "A nevedet erre változtattad: ",
   "by",
   "Ismeretlen felhasználó",
   ", az üzenet \"",
   "\" nem lett elküldve.",
   "Nincs meghatározott felhasználói feladat /msg",
   "Keresés megállítva",
   "Rendszer",
   "Figyelmeztetés",
   "Hiba",
   "Akció",
   "Csatlakozás:",
   " - Csatlakozás :",
   " - %lu darab keresési eredmény  (",
   "Csatlakozva:",
   "Csatlakozás elfogadva.",
   "Csatlakozás a szerverhez...",
   "Nem sokáig voltál csatlakozva a MUSCLE szerverhez...",
   "A szerverhez történõ csatlakozás problémába ütközött...",
   "Angol",
   "Spanyol",
   "A %s nyelv lett kiválasztva. A változásokhoz újra kell indítani a BeShare-t.",
   "Nyelv",
   "Német",
   "Típus",
   "Fájl méret",
   "Fájlok",
   "Holland",
   "File vizsgálata...",
   "Elérhetõ IRC-stílusú parancsok: ",
   "küld egy privát üzenetet",
   "neved megváltoztatása",
   "csinálni valamit",
   "szinonima az /action parancshoz",
   "társalgási napló törlése",
   "egy új keresés indítása",
   "jelenlegi keresés megállítása",
   "Csatlakozás egy szerverhez",
   "Csatlakozás bontása",
   "Kilépés a programból",
   "ennek a súgó szövegnek a mutatása",
   "<név vagy folyamat id> <szöveg>",
   "<név>",
   "<akció>",
   "[keresendõ szó]",
   "[szervernév]",
   "Portugál",
   "Francia",
   "Hangjelzés, amikor engem érintõ dolog van",
   "Max. egyidejû fájlküldés felhasználónként",
   "Idõegység",
   "Befejezett letöltések törlése a listából",
   "Max. egyidejû letöltés felhasználónként",
   "Olasz",
   "Bejelentkezés a programindításkor",
   "Privát üzenet",
   "Privát társalgó ablak megnyitása",
   "BeShare társalgó ablak",
   "Társalgás vele :",
   "Hiba, nincs megadva felhasználó",
   "Beállítások (-preset) mentése",
   "Beállítások (-preset) visszaállítása",
   "Hiba, ismeretlen parancs",
   "Írd le:  /help  --és kapsz egy listát az elérhetõ parancsokról ",
   " - (%lu-%lu) of %lu találat van (",
   "Megjelenítés",
   "Információközlés",
   "Figyelmeztetõ üzenet",
   "Hibaüzenet",
   "Naplózás engedélyezve",
   "Naplózás letiltva",
   "Keresési eredmény oldalanként",
   "Lapozás",
   "felhasználók jellemzõi figyelmen kívül hagyva",
   "Ignore pattern set to: ",
   "Ignore pattern removed.",
   "<név vagy folyamat ids>",
   "Feljebb rak",
   "Lejjebb rak",
   "Átvitel megállítása",
   "Átvitel újraindítása",
   "Fájl megnyitása",
   "Orosz",
   "Társalgás",
   "Current /ignore pattern is: ",
   "Letiltva",
   "Most %i átvitel van folyamatban. Kilépéskor ezek megszakadnak. Biztos ki akarsz lépni ?",
   "Nem akarok kilépni",
   "Módosítva",
   "Eszperantó",
   "Svéd",
   "Többi felhasználó jelzése",
   "Visszajelzés %Li ezredmásodpercenként",
   "Kért jelzés küldése: ",
   "Norvég",
   "Szerb",
   "nincs itt",
   "'Auto Away' beállítása ('Elment / Itt van')",
   "perc",
   "cimke",
   "Az 'auto-away' ('Elment / Itt van') változtatása",
   "Az 'Auto-away' ('Elment / Itt van') átállítva: ",
   "Az 'Auto-away' ('Elment / Itt van') beállítása tetszőleges szövegre pl.: /away alszom",
   "Könyvtár megnyitása",
   "Figyelés beállítva: ",
   "Figyelés megszüntetve.",
   "Jelenleg figyelve: ",
   "megnevezett felhasználók figyelése",
   "Indítási parancs törölve.",
   "parancs",
   "indítási parancs hozzáadása",
   "indítási parancs törlése",
   "indítási parancs felvétele",
   "Figyelés beállítása : ",
   "Szerverállapot kérése",
   "%.1fMB felhasznált (%.1fMB rendelkezésre áll)",
   "Szerver állapot",
   "Szerver verzió",
   "Helyi fõ munkafolyamat",
   "Szervermemória használat",
   "Kért szerverállapot",
   "Szerverüzemidõ",
   "hét",
   "nap",
   "Rendszerüzemidõ",
   "Naplózva :",
   "Fájlmegosztás engedélyezve",
   "Felhasználó kitiltása",
   "%s IP -jû felhasználó kitiltva.",
   "óra",
   "Véglegesen",
   "minden feltöltési tiltás megszüntetése",
   "%lu feltöltési tiltásának megszüntetése",
   "Automatikus magánbeszélgetés beállítva: ",
   "Automatikus magánbeszélgetés eltávolítva.",
   "Automatikus magánbeszélgetésre kijelölt felhasználók",
   "Automatikus magánbeszélgetésre kijelölve: ",
   "Ismeretlen adatformátum",
   "A naplókönyvtár megnyitása",
   "Állapot",
   "Az állapotod erre változott: ",
   " jelenleg ",
   "Betöltés",
   "felhasználó állapotának beállítása",
   "Bolgár",
   "Útvonal",
   "File elérési útvonalának megjegyzése",
   "Álnéven beállít",
   "Álnév eltávolítása",
   "[név és érték]",
   "egy álnevet alkot",
   "Az álnév eltávolítása",
   "Lista elejére helyezés",
   "Lista végére helyezés",
   "A megszokott ablakfejléc beállíítása",
   "A megszokott ablakfejléc jelenleg ",
   "Szerverlista automatikus frissítése",
   "Szerver hozzásadása: %s",
   "Szerver eltávolítása: %s",
   "BeShare v%s most elérhetõ a letöltéshez. Innen frissítheted: %s",
   "Shell parancs indítása",
   "Shell parancs indítása",
   "Shell parancs",
   "üresjárati parancs beállítása",
   "Parancsmegadás, amikor az átvitel megszûnik",
   "betûméret pontokban",
   "betûméret megállapítása",
   "Betûméret átállítva :",
   "Betûméret alapértelmezettre állítása",
   "Kliens",
   "%lu perc múlva megint megpróbálunk csatlakozni.",
   "Kísérlet az újracsatlakozásra..",
   "Megszakításkor újracsatlakozás.",
   "Koreai",
   "Sávszélesség határa",
   "bájt/másodperc",
   "Max. letöltési arány beállítása (átvitelenként)",
   "Max. feltöltési arány beállítása (átvitelenként)",
   "Max. letöltési arány: ",
   "Max. feltöltési arány: ",
   "Magyar",
   "Színek kiválasztása",
   "Szöveg háttere",
   "Görgetett szöveg háttere",
   "Keret területe",
   "Szöveg",
   "Rendszer",
   "Figyelmeztetés",
   "Hiba",
   "Akció",
   "Privát",
   "Kimondott név",
   "Ping",
   "Saját becenév",
   "A távoli személy neve",
   "URL",
   "Kijelölés",
   "Figyelés",
   "Letöltési folyamat",
   "Küldési folyamat",
   "Küldési folyamat megállítása (Pause)",
   "Színbeállítások",
   "Vissza",
   "Alapértelmezett",
   "Átkapcsolás saját színekre",
   "Román",
   "képernyőmentés megosztása",
   "a képernyőmentés megosztva ",
   "Hiba a megosztott képernyőmentésben",
   " ezt a letöltést befejezte: ",
   "Az átviteli folyamat:  %s lent, %s fent.",
   "mutat mindenféle vegyes információt",
   "Kijelzés",
   "ameddig",
   "Adat tömörítése",
   "Kicsiny",
   "Közepes",
   "Tömény",
   "Kínai",
   "Turkish",
   "Japanese",
   "[font name]",
   "set font",
   "Font set to",
   "Font reset to default",
   "Couldn't find font",
   "Shortest Uploads First",
   "Finnish"
};

//------------------------------------------------------------------------------------
// Romanian language update for BeShare... wohooo!
// Ati vrut BeShare in romana, asa ca am stat vreo doua ore sa traduc
//     By: Cypress cypress@globeline.ro / cypress@bemail.org
//------------------------------------------------------------------------------------

static const char _romanianShortcuts[NUM_SHORTCUTS] = {
   'N', // New connection
   'B', // "Bye" to current connection
   'S', // Shared dir
   'D', // Download dir
   'L', // clear Log
   'R', // Reset Layout
   'Q', // Quit
   'U', // Full user Queries
   'M', // Beep When Mentioned
   'P', // Open private chat window
   'F', // Toggle file logging
   'E', // File sharing enabled
   'O', // Logs dir
};

static const char * _romanianStrings[NUM_STRINGS] = {
   "Anonim",
   "Necunoscut",
   " este acum conectat.",
   " s-a deconectat.",
   "Utilizator #",
   " (alias ",
   " este acum cunoscut ca si ",
   "adevarat",
   "fals",
   "<tip necunoscut>",
   "Utilizator ",
   " se copiaza ",
   "Eroare incercand sa scriu fisierul ",
   "O Eroare A Avut Loc.",
   "Queued (Statia locala prea ocupata)",
   "Queued (Statia remote prea ocupata)",
   "Trim: ",
   "Prim: ",
   "/sec, ",
   "Awaiting callback...",
   "Conectare...",
   "Download complet",
   "Download anulat",
   "Nu am putut efectua conectarea",
   "Ma pregatesc sa dau Upload",
   "Ma pregatesc sa dau Download",
   "catre",
   "de la",
   "Eroare incepand download-ul--port neacceptat!",
   "Eroare pornind conectare intarziata!",
   "Eroare pornind conectare intarziata--nici un thread transceiver!",
   "Eroare, nu s-a putut crea thread conexiune! (Incearca sa iesi din BeShare, dupa care Reporneste Networking)",
   "(Sharing %i fisiere locale)",
   "Nu am putut gasi subdirectorul 'shared', sharing dezactivat!",
   "\0011Nume Fisier",
   "\0012Utilizator",
   "\0013ID Sesiune",
   "\0014Conexiune",
   "Fisier",
   "Conectare la server",
   "Deconectare",
   "Deschide Directorul Shared",
   "Dschide Directorul Downloads",
   "Sterge Log-ul de Chat",
   "Reseteaza Layout-ul",
   "Despre BeShare",
   "Iesire",
   "Atribute",
   "Setari",
   "Max de Upload-uri Simultane",
   "Max de Download-uri Simultane",
   "Fara Limita",
   "Latime de banda pentru Upload",
   "Log",
   "Upload-uri",
   "Evenimente User",
   "Schimbari la Cautari",
   "Cautari Intregi Utilizator",
   "Sunt cu Firewall",
   "Cautare:",
   "Porneste Cautarea",
   "Opreste Cautarea",
   "Server:",
   "Nume Utilizator:",
   "Download Fisiere Selectate",
   "Inlatura Transferurile Terminate/Esuate",
   "Inlatura Selectarea",
   "Chat",
   "Nume",
   "ID",
   "BeShare asculta pe portul %u.  Selecteaza Conectare de la meniul Fisier ca sa incepi!",
   "Nu am putut porni thread-ul de server file-sharing!  (Incearca sa Repornesti Networking si apoi BeShare)",
   "Nu pot copia de la user-ul ",
   ", nu exista nici o informatie despre conexiune.",
   "Nu pot copia fisiere de la ",
   ", pentru ca amandoi suntem dupa firewalls.",
   "File download accept session for ",
   " a esuat sa se initializeze!",
   "File download session to ",
   "Schimbat Cautare in",
   "Cautare Pornita",
   "Nu s-a putut porni sesiunea de ShareFileTransfer pentru a servi transferului cerut!  (Incearca sa Repornesti Networking, dupa care lanseaza BeShare)",
   "Numele tau a fost schimbat in ",
   "de",
   "Utilizator necunoscut ",
   ", mesaj \"",
   "\" netrimis.",
   "Nici un utilizator-tinta specificat in /msg",
   "Cautare Oprita",
   "Sistem",
   "Atentie",
   "Eroare",
   "Actiune",
   "Conecteaza la ",
   " - Conectare la ",
   " - %lu rezultate afisate (",
   " - Conectat la ",
   "Conexiune facuta.",
   "Conectare la server...",
   "Nu mai esti conectat la serverul MUSCLE.",
   "Conexiunea la server failed.",
   "Engleza",
   "Spaniola",
   "Limba %s selectata.  Schimbarile vor avea efect la repornirea BeShare.",
   "Limba",
   "Germana",
   "Tip",
   "Marime Fisier",
   "Fisiere",
   "Daneza",
   "Examinare Fisiere...",
   "Comenzi de tip irc disponibile:",
   "trimite un mesaj privat",
   "schimbare nume utilizator",
   "fa ceva",
   "sinonim pentru /actiune",
   "sterge log-ul de chat",
   "cautare noua",
   "opreste cautarea curenta",
   "conectare la un server",
   "deconecatre de la server",
   "iesire BeShare",
   "arata acest text de ajutor",
   "<nume sau id sesiune> <text>",
   "<nume>",
   "<actiune>",
   "[campQuery]",
   "[numeServer]",
   "Portugheza",
   "Franceza",
   "Beep Cand Esti Amintit",
   "Maximul de Upload-uri Simultane Per Utilizator",
   "Timestamps",
   "AutoSterge Download-uri Finalizate",
   "Max de Download-uri Simultane per Utilizator",
   "Italiana",
   "Logare la Startup",
   "Mesaje Private",
   "Deschide Fereastra Privata de Chat",
   "Fereastra Privata de Chat BeShare",
   "Vorbeste cu:",
   "Eroare, nici un utilizator specificat!",
   "Salveaza Presetari",
   "Restore Presetari",
   "Eroare, comanda necunoscuta",
   "Scrie /help pentru o lista de comenzi disponibile.",
   " - (%lu-%lu) din %lu rezultate afisate (",
   "Display",
   "Mesaje de Informare",
   "Mesaje de Activare",
   "Mesaje de Eroare",
   "Logarea Activata",
   "Logarea Deactivata",
   "Rezultate pe Pagina",
   "Comuteaza la Pagina",
   "specifica utilizatori de ignorat",
   "Model Ignore setat la: ",
   "Model Ignore inlaturat.",
   "<nume sau id-uri de sesiune>",
   "Misca Ssu",
   "Misca Jos",
   "Opreste Transfer",
   "Reporneste Transferul",
   "Deschide Fisier",
   "Rusa",
   "Chat",
   "Modelul actual de /ignora este: ",
   "Dezactivat",
   "There are %i transfers in progress, are you sure you want to quit?",
   "Nu Pleca",
   "Timp de Modificare",
   "Esperanto",
   "Suedeza",
   "ping catre alti clienti",
   "Ping inapoiat in %Li milisecunde",
   "Seteaza cerere ping request catre: ",
   "Norvegiana",
   "Sarba",
   "away",
   "Auto Away",
   "minute",
   "eticheta",
   "schimba eticheta de auto-away",
   "Eticheta Auto-away setata la: ",
   "Forteaza starea de away",
   "Deschide Director",
   "Model de urmarire setat la: ",
   "Model de urmarire inlaturat.",
   "Modelul curent de /urmarire este: ",
   "specifica useri de urmarit",
   "Comenzile startup sterse.",
   "comanda",
   "adauga comanda de startup",
   "sterge comenzile de startup",
   "Comanda startup inregistrata: ",
   "Urmareste",
   "Starea serverului ceruta.",
   "%.1fMB folositi (%.1fMB disponibili)",
   "Stare server:",
   "Versiune server",
   "Sesiunea locala root",
   "Memoria folosita a serverului",
   "Cere Statutul Serverului",
   "Uptime server",
   "saptamani",
   "zile",
   "Uptime Sistem",
   "logat de",
   "File Sharing Enabled",
   "Restrictioneza User Pentru",
   "Userul de la IP-ul %s restrictionat pentru",
   "Ore",
   "Pentru Totdeauna",
   "inlatura toate restrictiile de upload",
   "Inlatur restrictia de ulpoad %lu",
   "Model AutoPriv setat la: ",
   "Model AutoPriv Inlaturat.",
   "Specifica Useri AutoPriv",
   "Modelul Curent /autopriv este: ",
   "Format necunoscut!",
   "Deschide fisierul de Log-uri",
   "Status",
   "Statutul tau a fost schimbat in: ",
   " este acum ",
   "Incarca",
   "seteaza linia de statut al utilizatorului",
   "Bulgara",
   "Cale",
   "Retine Caile Fisierelor",
   "Seteaza alias",
   "Alias Inlaturat",
   "[nume si valoare]",
   "creaza un alias",
   "sterge un alias",
   "Muta Sus",
   "Muta Jos",
   "Seteaza Titlul Normal De Fereastra",
   "Titlu de Fereastra Normal Este Acum",
   "Updateaza Automat Lista de Servere",
   "Adaugat server: %s",
   "Sters server: %s",
   "BeShare v%s este disponibil pentru download.  Poti face un upgrade la %s",
   "executa comanda shell",
   "execut comanda shell",
   "comanda shell",
   "comanda idle setata la",
   "seteaza comanda cand transferurile inceteaza",
   "marimea fontului in puncte",
   "seteaza marimea fontului",
   "Marimea fontului setata la:",
   "Marimea fontului resetata la default",
   "Client",
   "Voi incerca auto-reconectarea in %lu minute.",
   "Incerc auto-reconectarea.",
   "Secventa de auto-reconectare terminata.",
   "Koreana",
   "Limita Latime de Banda",
   "bytes/secunda",
   "Seteaza rata maxima de download-uri (per transfer)",
   "Seteaza rata maxima de upload-uri (per transfer)",
   "Rata maxima de download-uri este de",
   "Rata maxima de upload-uri este de",
   "Maghiara",
   "Alege Culori",
   "Text de Background",
   "Text de Background cu Scroll",
   "Zone Margini",
   "Text",
   "Sistem",
   "Atentie",
   "Eroare",
   "Actiune",
   "Privat",
   "Nume Spus",
   "Ping",
   "Nick Local",
   "Nick Remote",
   "URL",
   "Selectie",
   "Atentie",
   "Progres Download",
   "Progres Upload",
   "Progres Upload in Pauza",
   "Preferinte de culoare de catre",
   "Revert",
   "Normal",
   "activeaza culorile normale",
   "Romana",
   "share screenshot",
   "is now sharing a screenshot",
   "Error sharing screenshot",
   " has finished downloading ",
   "Transferred this session:  %s down, %s up.",
   "show some miscellaneous info",
   "Banned",
   "until",
   "Data Compression",
   "Low",
   "Medium",
   "High",
   "Chinese (Simplified)",
   "Turkish",
   "Japanese",
   "[font name]",
   "set font",
   "Font set to",
   "Font reset to default",
   "Couldn't find font",
   "Shortest Uploads First",
   "Finnish"
};

//====================================================================================
// This is the Simplified Chinese language upgrade for the 'ShareStrings.cpp'
// From Xuqing Kuang(kuye) - kuyeboy@163.com
//
// 这是 ShareString.cpp 的 简体中文 升级文件。
// 由旷旭卿（kuye）编写而成 - kuyeboy@163.com
//
// version 2.23.1,  2004/01/03
//------------------------------------------------------------------------------------

static const char _schineseShortcuts[NUM_SHORTCUTS] = {
   'N',  // New connection              - 新连接
   'B',  // "Bye" to current connection - 断开当前连接
   'S',  // Shared dir                  - 共享目录
   'D',  // Download dir                - 下载目录
   'L',  // clear Log                   - 清空日志
   'R',  // Reset Layout                - 重置布局
   'Q',  // Quit                        - 退出
   'U',  // Full user Queries           - 完全匹配用户查询条件
   'M',  // Beep When Mentioned         - 被呼唤时提示
   'P',  // Open private chat window    - 打开密聊窗口
   'F',  // Toggle file logging         - 锁定文件日志
   'E',  // File sharing enabled        - 启用文件共享
   'O',  // Logs dir                    - 日志目录
};

static const char * _schineseStrings[NUM_STRINGS] = {
   "匿名",
   "未知",
   " 已连接。",
   " 已断开。",
   "用户 #",
   " (a.k.a. ",
   " 为 ",
   "是",
   "否",
   "<未知类型>",
   "用户 ",
   " 下载中 ",
   "写文件出错 ",
   "未知错误",
   "序列等待中（本地计算机过忙）",
   "序列等待中（远程计算机过忙）",
   "发送： ",
   "接收： ",
   "/秒, ",
   "等待回馈中...",
   "连接中...",
   "下载完毕",
   "中断下载",
   "无法连接",
   "准备上传中",
   "准备下载中",
   "到",
   "从",
   "错误！开始下载于未验证端口！",
   "错误！开始下载于延时连接！",
   "错误！开始下载于延时连接 — 无收发线程！",
   "错误！无法创建连接线程（请尝试关闭 BeShare，并重新启动网络服务）！",
   "（已共享出 %i 个本地文件）",
   "shared 共享目录不存在，文件共享功能将被禁用！",
   "\0011文件名",
   "\0012用户",
   "\0013对话序列号",
   "\0014连接类型",
   "文件",
   "连接到服务器",
   "断开",
   "打开共享文件夹",
   "打开下载文件夹",
   "清空聊天记录",
   "重置布局",
   "关于 BeShare",
   "退出",
   "属性",
   "设置",
   "每用户最大同时上传数量",
   "每用户最大同时下载数量",
   "不限制",
   "本机网络带宽",
   "日志",
   "上载",
   "用户事件",
   "查询条件改变",
   "完全匹配查询条件",
   "我在防火墙后",
   "查询名称:",
   "开始查找",
   "停止查找",
   "服务器:",
   "用户名:",
   "下载所选择文件",
   "清空已完成或错误下载任务",
   "删除下载任务",
   "聊天",
   "名称",
   "序列号",
   "BeShare 正在监停 %u 端口。 请点击“文件”菜单中的“连接”开始。",
   "无法开启共享服务器线程！ （请重新启动网络服务并重新启动 BeShare）",
   "无法下载于 ",
   ", 无可用连接信息.",
   "无法下载文件从 ",
   "， 因为我们两个都在防火墙后面。",
   "允许文件下载对话给 ",
   " 初使化出错！",
   "文件下载对话到 ",
   "改变查询参数为",
   "开始查询",
   "无法发送文件共享传输对话请求到远程服务器！（请尝试在重新启动网络服务后重新启动 BeShare）",
   "你的昵称已改变为： ",
   "by",
   "未知用户 ",
   ", 消息 \"",
   "\" 未发送。",
   "/msg 中为指定对方帐号",
   "已停止查询",
   "系统",
   "警告",
   "错误",
   "动作",
   "连接到 ",
   " - 连接到 ",
   " - %lu 个搜索结果 (",
   " - 连接到 ",
   "连接成功。",
   "服务器连接中...",
   "你已经从 MUSCLE 服务器断开。",
   "连接到服务器出错",
   "英语",
   "西班牙语",
   "%s 语言已选择，将在重新启动 BeShare 后生效。",
   "语言",
   "德语",
   "类型",
   "文件大小",
   "文件",
   "荷兰语",
   "检查文件...",
   "可用的 IRC 样式命令：",
   "发送密聊信息",
   "改变用户名",
   "做一些动作",
   "与 /action 相同",
   "清空聊天记录",
   "开始一个新的查询",
   "停止当前查询",
   "连接到一个服务器",
   "从该服务器断开",
   "退出 BeShare",
   "显示本帮助文档",
   "<昵称或对话序列号> <文字>",
   "<昵称>",
   "<动作>",
   "[搜索条件]",
   "[服务器名]",
   "葡萄牙语",
   "法语",
   "被呼叫时提示",
   "最大上传速率",
   "时间戳",
   "自动清除已下载列表",
   "最大下载速率",
   "意大利语",
   "启动时登陆",
   "密聊信息",
   "打开密聊窗口",
   "BeShare 密聊窗口",
   "聊天对象：",
   "错误，未指定用户！",
   "保存属性配制",
   "读取属性配制",
   "错误, 未知命令",
   "输入 /help 列出所有命令。",
   " - (%lu-%lu) of %lu results shown (",
   "显示",
   "信息消息",
   "警告消息",
   "错误消息",
   "开启登陆",
   "禁用登陆",
   "每页显示数量",
   "切换到页",
   "指定忽略用户",
   "忽略列表设置为： ",
   "忽略列表已删除。",
   "<昵称或对话序列号>",
   "向上移动",
   "向下移动",
   "停止传送",
   "重新传送",
   "打开文件",
   "俄语",
   "聊天",
   "当前 /ignore 列表为： ",
   "禁用",
   "还有 %i 个传输任务正在进行中，真的要退出吗?？",
   "不要退出！",
   "修改时间",
   "世界语",
   "瑞典语",
   "Ping - 测试数据包发送到其它计算机的延迟时间",
   "网络延时为 %Li 毫秒",
   "发送 Ping 请求给: ",
   "挪威语",
   "赛尔维亚语",
   "离开",
   "自动离开",
   "分钟",
   "状态",
   "改变“自动离开”标签",
   "自动离开标签设置为： ",
   "离开状态",
   "打开文件夹",
   "监视列表设置为：",
   "监视列表已删除。",
   "当前 /watch 列表为 ",
   "指定监视用户",
   "启动命令已清除。",
   "命令",
   "添加启动命令",
   "删除启动命令",
   "已记录启动命令: ",
   "监视",
   "服务器状态请求.",
   "%.1fMB 已使用 (%.1fMB 可用)",
   "服务器状态:",
   "服务器版本",
   "本地对话管理员",
   "服务器内存占用",
   "请求服务器状态",
   "服务器开启时间",
   "周",
   "天",
   "系统开启时间",
   "已登陆为",
   "开启文件共享",
   "禁用用户",
   "IP 地址为 %s 的用户已被禁用",
   "小时",
   "永远",
   "删除所有上传禁令",
   "删除 %lu 上传禁令",
   "自动优先列表设置为： ",
   "自动优先列表已经删除。",
   "指定自动优先用户",
   "当前 /autopriv 列表为： ",
   "未知数据格式!",
   "打开日志文件夹",
   "状态",
   "你的状态改变为: ",
   " 现在为 ",
   "读取",
   "设置用户状态",
   "保加利亚语",
   "路径",
   "保留文件完整路径",
   "设置别名",
   "删除别名",
   "[名称及值]",
   "建立一个别名",
   "删除一个别名",
   "移动到最顶层",
   "移动到最底层",
   "自定义窗口标题栏",
   "自定义窗口标题栏为",
   "自动更新服务器列表",
   "已添加服务器： %s",
   "已删除服务器： %s",
   "BeShare v%s 已经可以下载了，你可以从 %s 升级。",
   "运行终端命令",
   "运行终端命令",
   "终端命令",
   "空闲命令设置为：",
   "当传输停止时运行",
   "字体大小（点距）",
   "设置字体大小",
   "字体大小设置为：",
   "重置字体大小为默认值",
   "客户端",
   "于 %lu 分钟后尝试重新连接。",
   "尝试重新连接中。",
   "自动重新连接被中断。",
   "韩文",
   "限制带宽",
   "比特/秒",
   "每连接最高下载速率",
   "每连接最高上载速率",
   "最高下载速率",
   "最高上载速率",
   "匈牙利语",
   "选择颜色",
   "文字背景",
   "已显示文字背景",
   "边框区",
   "文字",
   "系统",
   "警告",
   "错误",
   "动作",
   "私聊",
   "被呼唤昵称",
   "Ping",
   "本机昵称",
   "远程帐号昵称",
   "超链接",
   "选择",
   "监视",
   "下载进程",
   "上载进程",
   "暂停上载",
   "toggle custom coloring",
   "恢复",
   "默认值",
   "自定义颜色",
   "罗马语",
   "制作屏幕截图并共享",
   "正在共享屏幕截图",
   "共享屏幕截图时出错",
   " 已经下载完毕 ",
   "该传输对话状态： %s 已下载， %s 已上传。",
   "显示其它信息",
   "已禁用",
   "直到",
   "数据压缩",
   "低",
   "中",
   "高",
   "简体中文",
   "Turkish",
   "Japanese",
   "[font name]",
   "set font",
   "Font set to",
   "Font reset to default",
   "Couldn't find font",
   "Shortest Uploads First",
   "Finnish"
};

// Translated by Atilla Ozturk (atilla@turkbug.org)
static const char _turkishShortcuts[NUM_SHORTCUTS] = {
   'N',  // Yeni Bağlantı
   'B',  // Yürütülen Bağlantıyı bitir
   'S',  // Paylaşılan Klasör
   'D',  // Dosya indirme Klasörü
   'L',  // Oturum Notlarını sil
   'R',  // Uygulama görünümü standard değerle getir
   'Q',  // Bitir
   'U',  // Komple kullanıcı sorgulamaları
   'M',  // Konu olunduğunda sinyal çal
   'P',  // Özel görüşme penceresini aç
   'F',  // Oturum notlarını değiştir
   'E',  // Dosya paylaşmaya izin ver
   'O',  // Oturum Notların Klasörü
};

static const char * _turkishStrings[NUM_STRINGS] = {
   "Anonim",
   "Bilinmiyor",
   "bağlandı.",
   "devre dışı.",
   "Kullanıcı #",
   " (ünvanı ",
   "bilindiği lakâbı ",
   "doğru",
   "yanlış",
   "<bilinmeyen tip>",
   "Kiş ",
   "indiriyor ",
   "dosya yazılım hatası ",
   "Bir hata oldu hocam.",
   "Beklemede (kendi makinede indirme sınırına ulaştım)",
   "Beklemede (uzaktaki makine (ayni anda) daha fazla indirmeye müsade etmiyor )",
   "Gönderilen: ",
   "Ulaşan: ",
   "/saniye, ",
   "Çağrı bekliyorum...",
   "Bağlanıyorum...",
   "İndirme tamamlndı",
   "İndirme iptal edildi",
   "Bağlanamadım",
   "Göndermeye hazırlanıyorum",
   "İndirmeye hazırlanıyorum",
   "isteyen",
   "gönderen",
   "İndirmede hata oluştu--bir port aksepte edilmedi!",
   "Geciktirmeli Bağlanmada hata oluştu!",
   "Geciktirmeli Bağlanmada hata oluştu--Gönderici tred'i yok!",
   "Bağlantı tret'i kurulamadı! (BeShare'i kapatınız, 'Networking'i tekrar başlatınız)",
   "(%i Dosya paylaşılıyor)",
   "'Shared' Alt Klasörü bulamadım, dosya paylaşımı - malûm - iptal!",
   "\0011Dosya Adı",
   "\0012Kullanıcı",
   "\0013OturumID",
   "\0014Bağlantı",
   "Dosya",
   "Bağlanacak Yansı",
   "devreden çık",
   "Paylaşılan Klasörü aç",
   "Dosya indirim Klasörünü aç",
   "Çet Notlarını sil",
   "Deseni standard değerlerine al",
   "BeShare hakkında",
   "Yazılımı bitir",
   "Atributlar",
   "Ayarlar",
   "Azami paralel dosya gönderme sayısı",
   "Azami paralel dosya indirme sayısı",
   "İstediğin kadar, hocam!",
   "Dosya gönderme hız sınırlandırması",
   "Not geç",
   "Gönderilen Dosyalar",
   "Kullanıcı olayları",
   "Farkları sorgula",
   "Komple Kullanıcı sorgulaması",
   "Ateş Duvarın arkasındayım!",
   "Aranacak öğe:",
   "Aramayı başlat",
   "aramayı durdut",
   "Yansı:",
   "kullanıcı Adı:",
   "Seçilen dosyaları indir",
   "Bitirilen/İptal olan Dosya indirim tarihçesini sil",
   "Seçilenleri görünümden kaldır",
   "Çet",
   "İsim",
   "ID",
   "BeShare port %u üzerinden dinliyor.  Başlamak için lütfen Yansıya bağlanın!",
   "Dosya Paylaşım sunucu tred'ini başlatamadım!  (Networking'i tekrar başlat, ondan sonra BeShare'i tekrar başlat)",
   "Kullanıcı'dan dosya indirmedim ",
   ", bağlantı bilgileri mevcut değil.",
   "Dosya indirilemeyen kullanıcı ",
   ", çünkü ikimiz'de bir ateş duvarı arkasındayız.",
   "Dosya indirme oturumuna izin verilen kullanıcı ",
   " başlatılamadaı!",
   "Verilen Dosya indirim oturumu ",
   "Sorgulama değişmesi",
   "Arama başlatıldı",
   "Karşıdan gelen transfer isteğine Dosya Paylaşım Transferi başlatılamadı!  (Networking'i tekrar başlat, ondan sonra BeShare'i tekrar başlat)",
   "Değiştirdiğiniz Lâkâb ",
   "tarafından",
   "Bilinmeyen kullanıcı ",
   ", mesaj \"",
   "\" gönderilmedi.",
   "Gönderme yaptığınız kullanıcı belirsiz /msg",
   "Arama durdutuldu",
   "Sistem",
   "Uyarı",
   "Hata",
   "Aksiyon",
   "Yansıya bağlan: ",
   " - Yansıya bağlanıyorum ",
   " - %lu bulunan sayısı (",
   " - Bağlanılan Yansı ",
   "Yansıya bağlanıldı.",
   "Yansıya bağlanıyorum...",
   "MUSCLE Yansı'dan devre dışı olundu .",
   "Yansıya bağlanamdım.",
   "İngilizce",
   "İspanyolca",
   "%s dili seçildi.  Bir dahaki BeShare açılışında etkinleşecek.",
   "Dil",
   "Alman",
   "Nev'i",
   "Dosya büyüklüğü",
   "Dosya",
   "Flamenk'ce",
   "Dosyalar kontrol ediliyor...",
   "Mevcut İRC tipi komutlar:",
   "özel mesaj gönder",
   "lâkâb değştir",
   "bi şiiler yap",
   "/action için bir senonim",
   "Çet notlarını sil",
   "Yani bi arama başlat",
   "Yürümekte olan aramayı durdut",
   "Bir yansıya bağlan",
   "Yansıdan çık",
   "BeShare'i bitir",
   "bu yardım kılavuzunu göster",
   "<isim veya otrum id> <tekst>",
   "<isim>",
   "<aksiyon>",
   "[AramaFormülü]",
   "[yansıAdı]",
   "Portekizce",
   "Fransızca",
   "Konu olunduğunda sinyal çal",
   "Kullanıcı başına azami dosya gönderme sayısı",
   "Zaman Mühürü",
   "Tamamlanmış Dosya indirmeleri otomatikmen görünümden sil",
   "Kişi başına azami dosya indirme sayısı",
   "Italyanca",
   "BeShare başlangıcında otomatik olarak yansıya bağlan",
   "Özel mesajlar",
   "Özel mesaj penceresini aç",
   "BeShare özel mesaj penceresi",
   "Çet yapılacak kişi:",
   "Kullanıcı seçilmedi!",
   "Ayarları hatırla",
   "Hafızalanmış ayarı etkinleştir",
   "Bu komut bilinmiyor",
   " /help mevcut komutlarımı gösterir.",
   " - (%lu-%lu) sonuç gösterildi %lu 'dan/'den  (",
   "Göster",
   "Bilgi mesajları",
   "Uyarı mesajları",
   "Hata mesajları",
   "Not alınıyor",
   "Not alınmıyor",
   "Sayfa başına sonuç sayısı",
   "Geçilecek sayfa",
   "kıl olduğun/yadırgamadığın kişileri gir",
   "Aldırılmayan tip ayarı: ",
   "Aldırılmayan tip ayarı iptal edildi.",
   "<isim veya oturumİD>",
   "çık",
   "in",
   "Transferi durdut",
   "Transferi tekrarla",
   "Dosya aç",
   "Rusça",
   "Çet",
   "Ayarlanmış olan /aldırmama ayarı: ",
   "Kapat",
   "Dikkat! %i transfer devam etmekte, BeShare'i kapatmaya emin misin?",
   "Hayır kapatma",
   "Modifiye zamanı",
   "Esperanto",
   "İsveç'ce",
   "Devredeki Client'lere ping gönder",
   "Ping %Li ms'de geri geldi ",
   "Ping gönderilecek kişi: ",
   "Norweç'ce",
   "Sırbca",
   "yok",
   "Otomatik yok mesajı",
   "dakika",
   "ayar",
   "otomatik yok olma ayarını değiştir",
   "otomatik yok olma ayarı belirle: ",
   "yok olma durumu etkinleştir",
   "Klasör aç..",
   "Gözetlenecek kişiyi belirle: ",
   "Gözetleme ayarını sıfırla.",
   "Şu an ki gözetlenen kulanıcı: ",
   "Gözetlenecek kişileri belirle",
   "SUygulama başlangıç ayarları silindi.",
   "komut",
   "uygulama başlangıç komutu ekle",
   "Uygulama başlangıç komutlarını sil",
   "Kayıt olan uygulama başlangıç komutu: ",
   "Gözetle",
   "Yansı bilgileri soruluyor.",
   "%lfMB kullanılıyor (%.lfMB mevcut)",
   "ansı durumu:",
   "Yansı Versiyonu",
   "Yansı oturum Dizin kökü",
   "Yansı Ön Bellek kullanımı",
   "Yansı bilgileri sorgula",
   "Yansı işlem kümülesi",
   "hafta",
   "gün",
   "Sistem işlem kümülesi",
   "devre içi kümülesi",
   "Dosya paylaşımını çalıştır",
   "Kullanıcıyı devre'den çıkarılacak müddet",
   "%s IP 'li kullanıcı'nın devreye girme yasağı",
   "Saat",
   "Süresiz (abi öldün sen bu yansıda!)",
   "tüm dosya gönderme yasaklarını sil",
   "İptal edilen dosya gönderme yasakları %lu ",
   "Otomatik özel çet oturum ayarı: ",
   "Otomatik özel çet oturumu silindi.",
   "Otomatik özel çet oturum kullanıcıları belirt:",
   "Yüklenmiş Otomatik özel çet oturumu: ",
   "Dosya tipini algılamıyorum!",
   "Oturum Notları klasörünü aç",
   "Devre Durumu",
   "Durumunuzun değiştirildiği ayar: ",
   " şu an  ",
   "yükle",
   "Kullanıcı Durum öğesini etkinleştir",
   "Bulgarca",
   "Dosya Kökü",
   "Dosya Köklerini kopyala",
   "Alias'ı ayarla",
   "silinmiş Alias'lar",
   "[ad ve değer]",
   "Alias gir",
   "Alias sil",
   "Yukarıya çık",
   "Aşağıya in",
   "pencere ismini kişisel olarak adlandır",
   "Cpencere ismi şimdi:",
   "Otoamtik Yansı Güncellemeleri",
   "Eklenilen Yansı: %s",
   "Silien Yansı: %s",
   "BeShare v%s mevcut! Güncelleme için %s 'den indirmeniz mümkün.",
   "komut gir (şel)",
   "komut uygulanıyor",
   "şel komutu",
   "boş komutu ayarla",
   "ölen dosya indirmeler için özel komut:",
   "pt olarak karakter büyüklüğü",
   "Karakter Büyüklüğünü ayarla:",
   "Ayarlanan Karakter boyu:",
   "Karakter boyları standart değerlere çevirildi",
   "Yansı Bağlanma uygulaması:",
   "Otomatik Yansıya kayıt olma işlemin tekrarı: %lu dakika. ",
   "Tekrar bağlanmaya çalışıyorum.",
   "Tekrar Bağlanma işlemi tamamlandı",
   "Korece",
   "Veri hızı sınırlaması",
   "byte/saniye",
   "Azami transfer başına indirme hızı",
   "Azami transfer başına gönderme hızı değeri",
   "Azami indirme hızı: ",
   "Azami gönderme hızı",
   "Macarca",
   "Renk seçenekleri",
   "Karakter arkası",
   "Gezilmiş Karakter arkası",
   "Kenar renkleri",
   "Yazı",
   "Sistem",
   "Uyarma",
   "Hatalar",
   "Aksiyonlar",
   "Özel",
   "Çağrılan Ad",
   "Ping",
   "Yerel Nik",
   "Uzaktaki Nik",
   "URL",
   "Seçim",
   "Gözetleme",
   "Dosya indirim panosu",
   "Dosya gönderme panosu",
   "Ara verilmiş Dosya gönderme panosu ",
   "Renk ayarları",
   "iptal et/çevir",
   "standart",
   "kişisel renk ayarlarına geç",
   "Rumence",
   "Masa üstü vesikalığı paylaş",
   "bir Masa üstü vesikalığı paylaştı",
   "Masa üstü vesikalığı paylaşmasında hata",
   " dosya indirmeyi bitirdi ",
   "Oturum transferleri: %s indirildi, %s gönderildi.",
   "Bilimum bilgi göster",
   "Yansı'dan def edilmiş",
   "müddet",
   "Transfer sıkıştırma oranı",
   "az",
   "orta",
   "yüksek",
   "Çince",
   "Türkçe",
   "Japanese",
   "[font name]",
   "set font",
   "Font set to",
   "Font reset to default",
   "Couldn't find font",
   "Shortest Uploads First",
   "Finnish"
};

//====================================================================================
// Japanese Translated by Koichi Kimura (a.k.a. KiM)
//
// version 2.25,  2004/04/29
//------------------------------------------------------------------------------------
static const char _japaneseShortcuts[NUM_SHORTCUTS] = {
   'N',  // New connection
   'B',  // "Bye" to current connection
   'S',  // Shared dir
   'D',  // Download dir
   'L',  // clear Log
   'R',  // Reset Layout
   'Q',  // Quit
   'U',  // Full user Queries
   'M',  // Beep When Mentioned
   'P',  // Open private chat window
   'F',  // Toggle file logging
   'E',  // File sharing enabled
   'O',  // Logs dir
};

static const char * _japaneseStrings[NUM_STRINGS] = {
   "匿名",
   "未知",
   " は、今、接続しました。",
   " は、切断しました。",
   "ユーザ #",
   " (ユーザ名 ",
   " のユーザ名は ",
   "true",   //真
   "false",   //（論理値の）偽
   "<未知の形式>",
   "ユーザ ",
   " は次のファイルのダウンロードを開始しました:",
   "ファイルの書き込みに失敗しました ",
   "エラーが発生しました。",
   "順番待ち (ローカルマシンがビジーです)",
   "順番待ち (リモートマシンがビジーです)",
   "送信: ",
   "受信: ",
   "/秒, ",
   "応答を待っています...",
   "接続しています...",
   "ダウンロード完了",
   "ダウンロード失敗",
   "接続に失敗しました",
   "アップロードの準備をしています",
   "ダウンロードの準備をしています",
   "to",
   "from",
   "エラー ダウンロード開始--ポートを受け取れません!",
   "エラー 遅延接続が開始できません!",
   "エラー 遅延接続開始--スレッドを受け取れません!",
   "エラー, 接続スレッドを作成できません! (BeShare を終了し、Network の再起動を試みてください)",
   "(共有 %i ローカルファイル)",
   "'shared' サブディレクトリが見つかりません。ファイル共有は無効になります!",
   "\0011ファイル名",
   "\0012ユーザ名",
   "\0013セッションID",
   "\0014接続",
   "ファイル(F)",
   "サーバに接続",
   "切断(I)",
   "共有フォルダを開く(S)",
   "ダウンロードフォルダを開く(D)",
   "チャットログをクリア(L)",
   "レイアウトをリセット(R)",
   "バージョン情報(A)",
   "終了(Q)",
   "属性(A)",
   "設定(S)",
   "同時にアップロードする最大値(M)",
   "同時にダウンロードする最大値(D)",
   "無制限",
   "アップロードの帯域幅(B)",
   "ログ(O)",
   "アップロード(P)",
   "ユーザ イベント(E)",
   "クエリの変更",
   "全ユーザをクエリ対象とする(U)",
   "ファイヤウォールを通知する(W)",
   "クエリ:",
   "クエリ開始",
   "クエリ停止",
   "サーバ:",
   "ユーザ名:",
   "選択したファイルをダウンロード",
   "完了/失敗 した転送をクリア",
   "選択アイテムを除去",
   "チャット(C)",
   "ユーザ名",
   "ID",
   "BeShare はポート %u で待ち受け中です。ファイルメニューの\"接続 :\"を選択し開始してください。",
   "ファイル共有 サーバ スレッドが開始できません!  (Network の再起動を試みてください。その後 BeShare を開始してください。)",
   "このユーザからダウンロードできません。ユーザ名: ",
   ", 接続に関する情報が入手できません。",
   "ファイルのダウンロードができません from ",
   ", なぜなら双方共ファイアウォールに隠されているからです。",
   "ファイルダウンロード受諾セッション for ",
   " の初期化に失敗しました!",
   "ファイルダウンロードセッションは ",
   "変更するクエリは",
   "クエリの開始",
   "リモートサーバへ転送を要求しましたが、ファイル共有転送セッションが開始できません!  (Network の再起動を試みてください。その後 BeShare を開始してください。)",
   "あなたのユーザ名を次の名前に変更しました:",
   "by",
   "未知のユーザ ",
   ", メッセージ \"",
   "\" を送信していません。",
   "特定のユーザを指定しない /msg",
   "クエリの停止",
   "システム",
   "警告",
   "エラー",
   "アクション",
   "接続(N) : ",
   " - 接続先 : ",
   " - %lu ファイルの合計は (",
   " - 接続完了 : ",
   "接続を確立しました。",
   "サーバに接続しています...",
   "MUSCLE サーバから切断しました。",
   "サーバの接続に失敗しました。",
   "English",      //英語
   "Spanish",      //スペイン語
   "言語に %s が選択されました。変更内容は BeShare の再起動後に適用されます。",
   "言語設定(A)",
   "German",      //ドイツ語
   "種類",
   "サイズ",
   "項目数",
   "Dutch",      //オランダ語
   "ファイルの調査中...",
   "IRC-スタイルのコマンドが利用できます:",
   "プライベートメッセージを送信",
   "あなたの名前の変更",
   "何かをする",
   "/action と同意語",
   "チャットログのクリア",
   "新しいクエリを開始します",
   "現在のクエリを停止します",
   "サーバへ接続",
   "サーバから切断",
   "BeShare の終了",
   "このヘルプテキストの表示",
   "<ユーザ名 か セッションID> <テキスト>",
   "<ユーザ名>",
   "<アクション>",
   "[検索する文字列]",
   "[サーバ名]",
   "Portuguese",      //ポルトガル語
   "French",      //フランス語
   "名を挙げた際 Beep 音を鳴らす",
   "同時にアップロードする最大値/人数(P)",
   "タイムスタンプ(T)",
   "ダウンロード済アイテムの自動クリア(L)",
   "同時にダウンロードする最大値/人数(R)",
   "Italian",      //イタリア語
   "自動接続(G)",
   "プライベートメッセージ(M)",
   "プライベートチャットウィンドウを開く(P)",
   "プライベートチャットウィンドウ",
   "チャット相手:",
   "エラー, ユーザの指定がされていません!",
   "プリセットの保存(S)",
   "リセットの復元(R)",
   "このコマンドは無効です:",
   "/help と入力するとコマンドリストを参照することができます。",
   " - (%lu-%lu) of %lu ファイルの合計は (",
   "表示(I)",
   "情報メッセージ(I)",
   "警告メッセージ(W)",
   "エラーメッセージ(R)",
   "ログを取る",
   "ログを取らない",
   "検索結果/ページ(S)",
   "ページ切換",
   "指定ユーザを無視する",
   "無視するユーザのパターンへ登録: ",
   "無視するユーザのパターンを削除しました。",
   "<ユーザ名 か セッションID>",
   "上に移動",
   "下に移動",
   "転送の停止",
   "転送を再開",
   "ファイルを開く",
   "Russian",      //ロシア語
   "チャット",
   "現在の無視するユーザのパターンは: ",
   "無効",
   "現在 %i つの転送が進行中です。本当に終了してよろしいですか?",
   "終了しない",
   "更新日時",
   "Esperanto",      //エスペラント語
   "Swedish",      //スウェーデン語
   "他のクライアントへ ping する",
   "Ping の返答時間は %Li ミリ秒",
   "次のユーザへ ping をリクエストしました: ",
   "Norwegian",      //ノルウェー語
   "Serbian",      //セルビア語
   "不在",
   "自動不在設定(T)",
   "分間",
   "[タグ]",
   "自動不在時のタグを変更",
   "自動不在時のタグ: ",
   "強制的に不在状態にする",
   "フォルダを開く",
   "観察するユーザのパターンへ登録: ",
   "観察するユーザのパターンを削除しました。",
   "現在の観察するユーザのパターンは: ",
   "指定ユーザを観察",
   "スタートアップコマンドを削除しました。",
   "[コマンド]",
   "スタートアップコマンドの追加",
   "スタートアップコマンドのクリア",
   "登録済みスタートアップコマンド: ",
   "観察",
   "サーバの状態を要求しました。",
   "%.1fMB 使用 (%.1fMB 利用可能)",
   "サーバの状態:",
   "サーバのバージョン",
   "Local session root",
   "サーバ メモリの使用法",
   "サーバの状態を要求します",
   "サーバ アップタイム",
   "週間",
   "日間",
   "システム アップタイム",
   "ログインしてから",
   "ファイル共有を有効にする(E)",
   "このユーザを禁止する",
   "IP %s のユーザを次の間禁止します:",
   "時間",
   "永久に",
   "アップロード禁止をすべて解除します",
   "%lu 個のアップロード禁止を解除しました。",
   "自動プライベートのパターンへ登録: ",
   "自動プライベートのパターンを削除しました。",
   "自動プライベートユーザ指定",
   "現在の自動プライベートユーザのパターンは: ",
   "未知のデータ形式です!",
   "ログフォルダを開く(O)",
   "状態",
   "あなたの状態を次の状態に変更しました: ",
   " の状態は ",
   "ロード",
   "ユーザの状態の文字列を設定",
   "Bulgarian",      //ブルガリア語
   "パス",
   "ファイルパスを保持する(N)",
   "別名を設定",
   "別名を除去",
   "[ユーザ名 と 値]",
   "別名を作成",
   "別名を除去",
   "一番上に移動",
   "一番下に移動",
   "ウィンドウタイトルをカスタマイズします",
   "ウィンドウタイトルを次に変更しました",
   "サーバリストの自動更新(V)",
   "サーバを追加: %s",
   "サーバを除去: %s",
   "最新版の BeShare v%s がダウンロード可能です。 %s にてアップグレードしてください。",
   "シェルコマンドの実行",
   "シェルコマンドの実行中",
   "シェルコマンド",
   "待機コマンドの設定",
   "転送を中断するコマンドの設定",
   "[フォントサイズ(ポイント)]",
   "フォントサイズ設定",
   "フォントサイズ:",
   "フォントサイズを初期値へ戻す",
   "クライアント",
   "%lu 分後に自動再接続を試みます。",
   "自動再接続を試みています。",
   "自動連続再接続を終了しました。",
   "Korean",      //韓国語
   "限界帯域幅",
   "バイト/秒",
   "最大ダウンロード率設定 (/転送)",
   "最大アップロード率設定 (/転送)",
   "最大ダウンロード率",
   "最大アップロード率",
   "Hungarian",      //ハンガリー語
   "カラー設定(H)",
   "テキストの背景",
   "流れたテキストの背景",
   "ボーダー部分",
   "テキスト",
   "システム",
   "警告",
   "エラー",
   "アクション",
   "プライベート",
   "名前の発言",
   "Ping",
   "ローカル Nick",
   "リモート Nick",
   "URL",
   "選択アイテム",
   "観察",
   "ダウンロードの進行",
   "アップロードの進行",
   "停止したアップロードの進行",
   "カラー設定の作者は",
   "復元",
   "既定値",
   "カスタムカラーリングの切替",
   "Romanian",      //ルーマニア語
   "スクリーンショットをシェアします",
   "は今スクリーンショットをシェアしました",
   "スクリーンショットのシェアに失敗しました",
   " は次のファイルのダウンロードが完了しました:",
   "このセッションの転送状況は: ダウンロード %s ,アップロード %s 。",
   "その他の情報を表示",
   "禁止済み",
   "until",
   "データ圧縮(C)",
   "低い",
   "中",
   "高い",
   "Chino",      //中国語
   "Turkish",      //トルコ語
   "にほんご",  //日本語
   "[フォント名]",
   "フォント設定",
   "フォント設定:",
   "既定フォントへリセットされました",
   "フォントを見つけることができませんでした",
   "最短アップロード(F)",
   "Finnish"   //フィンランド語
};

static const char _finnishShortcuts[NUM_SHORTCUTS] = {
   'N',  // New connection
   'B',  // "Bye" to current connection
   'S',  // Shared dir
   'D',  // Download dir
   'L',  // clear Log
   'R',  // Reset Layout
   'Q',  // Quit
   'U',  // Full user Queries
   'M',  // Beep When Mentioned
   'P',  // Open private chat window
   'F',  // Toggle file logging
   'E',  // File sharing enabled
   'O',  // Logs dir
};

static const char * _finnishStrings[NUM_STRINGS] = {
   "Nimetön",
   "Tuntematon",
   " on nyt yhdistetty.",
   " on katkaissut yhteyden.",
   "Käyttäjä #",
   " (eli ",
   " on nyt nimeltään ",
   "tosi",
   "epätosi",
   "<tuntematon tyyppi>",
   "Käyttäjä ",
   " lataa ",
   "Virhe tiedostoon kirjoitettaessa ",
   "Tapahtui Virhe.",
   "Jonossa (Paikalliskone kiireinen)",
   "Jonossa (Etäkone kiireinen)",
   "Lähetetty: ",
   "Vastaanotettu: ",
   "/sec, ",
   "Odotetaan vastausta...",
   "Yhdistetään...",
   "Lataus valmis",
   "Lataus peruutettu",
   "Yhdistäminen epäonnistui",
   "Valmistellaan Lähetystä",
   "Valmistellaan Latausta",
   "kohteelle",
   "kohteesta",
   "Virhe latauksen alussa--ei hyväksyttyä porttia!",
   "Virhe aloitettaessa viivästettyä yhteyttä!",
   "Virhe aloitettaessa viivästettyä yhteyttä--ei vastaanotto säiettä!",
   "Virhe, säiettä ei voitu yhdistää! (Kokeile sammuttaa BeShare ja käynnistää Networking uudelleen)",
   "(Jaossa %i tiedostoa)",
   "'shared' alihakemistoa ei löytynyt, tiedostonjako poistettu käytöstä!",
   "\0011Tiedoston Nimi",
   "\0012Käyttäjä",
   "\0013SessioID",
   "\0014Yhteys",
   "Tiedosto",
   "Yhdistä palvelimelle",
   "Katkaise yhteys",
   "Avaa Jakokansio",
   "Avaa Latauskansio",
   "Tyhjennä Keskustelu Logi",
   "Palauta Asettelu",
   "Tietoja BeSharesta",
   "Lopeta",
   "Attribuutit",
   "Asetukset",
   "Max Yhtäaikaiset Lähetykset",
   "Max Yhtäaikaiset Lataukset",
   "Ei Rajoitusta",
   "Lähetyskaista",
   "Logi",
   "Lähetykset",
   "Käyttäjä Tapahtumat",
   "Hae Muutoksia",
   "Täysi Käyttäjä Haku",
   "Käytän Palomuuria",
   "Haku:",
   "Aloita Haku",
   "Pysäytä Haku",
   "Palvelin:",
   "Käyttäjänimi:",
   "Lataa Valitut Tiedostot",
   "Tyhjennä Valmiit / Epäonnistuneet Siirrot",
   "Poista Valittu",
   "Keskustelu",
   "Nimi",
   "ID",
   "BeShare kuuntelee porttia %u.  Valitse Yhdistä Tiedosto-valikosta aloittaaksesi!",
   "Tiedostonjaon palvelinsäiettä ei voitu käynnistää!  (Yritä käynnistää Networking uudelleen ja sitten uudelleenkäynnistää BeShare)",
   "Ei voida ladata käyttäjältä ",
   ", yhteystietoa ei ole saatavilla.",
   "Ei voida ladata tiedostoja käyttäjältä ",
   ", koska molemmat ovat palomuurin takana.",
   "Tiedoston latauksen hyväksymissessio kohteelle",
   " alustus epäonnistui!",
   "Tiedoston latauksen hyväksymissessio ",
   "Haku Muutettu",
   "Haku Aloitettu",
   "ShareFileTransfer-sessiopalvelua ei voitu aloittaa etäsiirtopyyntöä varten!  (Yritä käynnistää Networking uudelleen ja sitten uudelleenkäynnistää BeShare)",
   "Nimesi on muutettu muotoon ",
   "teki",
   "Tuntematon käyttäjä ",
   ", viesti \"",
   "\" ei ole lähetetty.",
   "Kohdekäyttäjää ei ole määritetty komennolle /msg",
   "Haku Pysäytetty",
   "Järjestelmä",
   "Varoitus",
   "Virhe",
   "Toiminta",
   "Yhdistä kohteeseen ",
   " - Yhdistetään kohteeseen ",
   " - %lu tulosta näytetään (",
   " - Yhdistetty kohteeseen ",
   "Yhteys muodostettu.",
   "Yhdistetään palvelimeen...",
   "Et ole enää yhteydessä MUSCLE-palvelimeen.",
   "Yhteys palvelimeen epäonnistui.",
   "Englanti",
   "Espanja",
   "Kieleksi on valittu %s.  Muutos tapahtuu kun käynnistät BeSharen uudelleen.",
   "Kieli",
   "Saksa",
   "Tyyppi",
   "Tiedoston Koko",
   "Tiedostoja",
   "Hollanti",
   "Tutkitaan Tiedostoja...",
   "Käytettävissä olevat irc-tyylin komennot:",
   "lähetä yksityisviesti",
   "vaihda käyttäjänimesi",
   "tee jotain",
   "synonyymi komennolle /action",
   "tyhjennä keskustelulogi",
   "aloita uusi haku",
   "pysäytä nykyinen haku",
   "yhdistä palvelimeen",
   "katkaise yhteys palvelimeen",
   "lopeta BeShare",
   "näytä tämä ohje",
   "<nimi tai sessio id> <teksti>",
   "<nimi>",
   "<toiminta>",
   "[haku merkkijono]",
   "[palvelinnimi]",
   "Portugali",
   "Ranska",
   "Äänimerkki Mainittaessa",
   "Max Yhtäaikaista Lähetystä Per Käyttäjä",
   "Aikaleimat",
   "Tyhjennä Valmiit Lataukset Automaattisesti",
   "Max Yhtäaikaista Latausta Per Käyttäjä",
   "Italia",
   "Kirjaudu Käynnistyksessä",
   "Yksityisviestit",
   "Avaa Yksityisviestit Ikkuna",
   "BeSharen Yksityisviestit Ikkuna",
   "Keskustele seuraavien henkilöiden kanssa:",
   "Virhe, käyttäjää ei määritelty!",
   "Tallenna Määrittelyt",
   "Palauta Määrittelyt",
   "Virhe, tuntematon komento",
   "Kirjoita /help saadaksesi komentolistan.",
   " - (%lu-%lu)  %lu tuloksesta näkyvissä (",
   "Näytä",
   "Info Viestit",
   "Varoitus Viestit",
   "Virhe Viestit",
   "Logi Päällä",
   "Logi Pois Päältä",
   "Tuloksia Per Sivu",
   "Siirry Sivulle",
   "määrittele käyttäjät joita ei huomioida",
   "Huomiotta jätetään: ",
   "Huomiotta jätetään asetus poistettu.",
   "<nimet or sessio id:t>",
   "Siirrä Ylös",
   "Siirrä Alas",
   "Pysäytä Siirto",
   "Jatka Siirtoa",
   "Avaa Tedosto",
   "Venäjä",
   "Keskustelu",
   "Nykyinen /ignore asetus on: ",
   "Poissa käytöstä",
   "Sinulla on %i siirtoa meneillään, haluatko varmasti lopettaa?",
   "Älä Lopeta",
   "Muutosaika",
   "Esperanto",
   "Ruotsi",
   "pingaa muita yhteysohjelmia",
   "Ping palasi %Li millisekunnissa",
   "Lähetään ping käyttäjälle: ",
   "Norja",
   "Serbia",
   "away",
   "Auto Poissa",
   "minuuttia",
   "tagi",
   "muuta auto poissa -tagi",
   "Auto poissa -tagi on nyt: ",
   "Pakota poissa tila",
   "Avaa Hakemisto",
   "Tarkkailulistalla ovat: ",
   "Tarkkailulista poistettu.",
   "Nykyinen /watch asetus on: ",
   "määrittele käyttäjä tarkkailtavaksi",
   "Aloituskomennot tyhjennetty.",
   "komento",
   "lisää aloituskomento",
   "tyhjennä aloituskomento",
   "Nauhoitettu aloituskomento: ",
   "Tarkkaile",
   "Palvelimen tilaraportti pyydetty.",
   "%.1fMB käytetty (%.1fMB saatavilla)",
   "Palvelimen tilaraportti:",
   "Palvelimen versio",
   "Paikallinen sessio juuri",
   "Palvelimen muistin käyttö",
   "Pyydä palvelimen tilaraporttia",
   "Palvelimen ylhäälläoloaika",
   "viikkoa",
   "päivää",
   "Järjestelmän ylhäälläoloaika",
   "kirjautuneenaoloaika",
   "Tiedostonjako Päällä",
   "Käyttäjän Banni aika",
   "Käyttäjä IP:llä %s bannattu ajaksi",
   "Tuntia",
   "Pysyvästi",
   "poista kaikki lähetys bannit",
   "Poistetaan %lu lähetys bannia",
   "AutoPriv asetettu muotoon: ",
   "AutoPriv asetus poistettu.",
   "määrittele AutoPriv käyttäjät",
   "Nykyinen /autopriv asetus on: ",
   "Tuntematon data muoto!",
   "Avaa Logi Kansio",
   "Tila",
   "Tilaksesi on muutettu: ",
   " on nyt ",
   "Lataa",
   "aseta käyttäjä merkkijono",
   "Bulgaria",
   "Polku",
   "Säilytä Tiedostopolut",
   "Aseta alias",
   "Poistettu alias",
   "[nimi ja arvo]",
   "luo alias",
   "poista alias",
   "Siirrä Ylimmäksi",
   "Siirrä Alimmaksi",
   "aseta muutettu ikkunan otsikko",
   "Muutettu Ikkunan otsikko on nyt",
   "Päivitä Palvelinlista Automaattisesti",
   "Lisätty palvelin: %s",
   "Poistettu palvelin: %s",
   "BeShare v%s on nyt ladattavissa.  Voit päivittää osoitteessa %s",
   "suorita shell-komento",
   "Suoritetaan shell-komento",
   "shell-komento",
   "idle-komento asetettu muotoon",
   "aseta komento kun siirto lakkaa",
   "fontin koko pisteinä",
   "aseta fontin koko",
   "Fontin kooksi asetettu:",
   "Fontin koko palautettu oletusarvoon",
   "Client",
   "Automaattista uudelleenyhdistämistä yritetään %lu minuutin kuluttua.",
   "Yritetään automaattista uudelleenyhdistämistä.",
   "Automaattinen uudelleenyhdistäminen lopetettu.",
   "Korea",
   "Rajoita Kaista",
   "tavua/sekunti",
   "Aseta max latausvauhti (per siirto)",
   "Aseta max lähetysvauhti (per siirto)",
   "Max latausvauhti on",
   "Max lähetysvauhti on",
   "Unkari",
   "Valitse Värit",
   "Tekstin Tausta",
   "Rullatun Tekstin Tausta",
   "Reuna-alueet",
   "Teksti",
   "Järjestelmä",
   "Varoitus",
   "Virhe",
   "Toiminta",
   "Yksityinen",
   "Nimi Sanottu",
   "Ping",
   "Paikallinen Nick",
   "Etä Nick",
   "URL",
   "Valinta",
   "Tarkkaile",
   "Latauksen Edistyminen",
   "Lähetyksen Edistyminen",
   "Pysäytetyn Lähetyksen Edistyminen",
   "Väri asetukset teki",
   "Palauta",
   "Oletus",
   "määrittele muutetut värit",
   "Romania",
   "jaa ruudunkaappaus",
   "jakaa nyt ruudunkaappauksen",
   "Virhe jaettaessa ruudunkaappausta",
   " on lopettanut latauksen ",
   "Siirretty tässä sessiossa:  %s sisään, %s ulos.",
   "näytä sekalaista tietoa",
   "Bannattu",
   "asti",
   "Datan Pakkaus",
   "Pieni",
   "Keskisuuri",
   "Suuri",
   "Kiina (yksinkertaistettu)",
   "Turkki",
   "Japani",
   "[fontin nimi]",
   "aseta fontti",
   "Fontiksi asetettu",
   "Fontti palautettu oletusasetuksiin",
   "Fonttia ei löytynyt",
   "Lyhin Lähetys Ensin",
   "Suomi"
};

int GetLanguage()
{
   return _language;
}

void SetLanguage(int wl)
{
   if ((wl >= 0)&&(wl < NUM_LANGUAGES)) _language = wl;
}

const char * GetLanguageName(int wl, bool native)
{
   switch(wl)
   {
      case LANGUAGE_ENGLISH:    return str(STR_ENGLISH,    native ? LANGUAGE_ENGLISH    : _language);
      case LANGUAGE_SPANISH:    return str(STR_SPANISH,    native ? LANGUAGE_SPANISH    : _language);
      case LANGUAGE_GERMAN:     return str(STR_GERMAN,     native ? LANGUAGE_GERMAN     : _language);
      case LANGUAGE_DUTCH:      return str(STR_DUTCH,      native ? LANGUAGE_DUTCH      : _language);
      case LANGUAGE_PORTUGUESE: return str(STR_PORTUGUESE, native ? LANGUAGE_PORTUGUESE : _language);
      case LANGUAGE_FRENCH:     return str(STR_FRENCH,     native ? LANGUAGE_FRENCH     : _language);
      case LANGUAGE_ITALIAN:    return str(STR_ITALIAN,    native ? LANGUAGE_ITALIAN    : _language);
      case LANGUAGE_RUSSIAN:    return str(STR_RUSSIAN,    native ? LANGUAGE_RUSSIAN    : _language);
      case LANGUAGE_SWEDISH:    return str(STR_SWEDISH,    native ? LANGUAGE_SWEDISH    : _language);
      case LANGUAGE_ESPERANTO:  return str(STR_ESPERANTO,  native ? LANGUAGE_ESPERANTO  : _language);
      case LANGUAGE_NORWEGIAN:  return str(STR_NORWEGIAN,  native ? LANGUAGE_NORWEGIAN  : _language);
      case LANGUAGE_SERBIAN:    return str(STR_SERBIAN,    native ? LANGUAGE_SERBIAN    : _language);
      case LANGUAGE_BULGARIAN:  return str(STR_BULGARIAN,  native ? LANGUAGE_BULGARIAN  : _language);
      case LANGUAGE_KOREAN:     return str(STR_KOREAN,     native ? LANGUAGE_KOREAN     : _language);
      case LANGUAGE_HUNGARIAN:  return str(STR_HUNGARIAN,  native ? LANGUAGE_HUNGARIAN  : _language);
      case LANGUAGE_ROMANIAN:   return str(STR_ROMANIAN,   native ? LANGUAGE_ROMANIAN   : _language);
      case LANGUAGE_SCHINESE:   return str(STR_SCHINESE,   native ? LANGUAGE_SCHINESE   : _language);
      case LANGUAGE_TURKISH:    return str(STR_TURKISH,    native ? LANGUAGE_TURKISH    : _language);
      case LANGUAGE_JAPANESE:   return str(STR_JAPANESE,   native ? LANGUAGE_JAPANESE   : _language);
      case LANGUAGE_FINNISH:    return str(STR_FINNISH,    native ? LANGUAGE_FINNISH    : _language);
      case LANGUAGE_MALKOVITCH: return "Malkovich";
      default:                  MASSERT(false, "Bad language token!"); return 0;
   }
}

const char * str(int ws, int language)
{
   const char ** base = NULL;
   switch((language < 0) ? _language : language)
   {
      case LANGUAGE_ENGLISH:    base = _englishStrings;    break;
      case LANGUAGE_SPANISH:    base = _spanishStrings;    break;
      case LANGUAGE_GERMAN:     base = _germanStrings;     break;
      case LANGUAGE_DUTCH:      base = _dutchStrings;      break;
      case LANGUAGE_PORTUGUESE: base = _portugueseStrings; break;
      case LANGUAGE_FRENCH:     base = _frenchStrings;     break;
      case LANGUAGE_ITALIAN:    base = _italianStrings;    break;
      case LANGUAGE_RUSSIAN:    base = _russianStrings;    break;
      case LANGUAGE_SWEDISH:    base = _swedishStrings;    break;
      case LANGUAGE_ESPERANTO:  base = _esperantoStrings;  break;
      case LANGUAGE_NORWEGIAN:  base = _norwegianStrings;  break;
      case LANGUAGE_SERBIAN:    base = _serbianStrings;    break;
      case LANGUAGE_BULGARIAN:  base = _bulgarianStrings;  break;
      case LANGUAGE_KOREAN:     base = _koreanStrings;     break;
      case LANGUAGE_HUNGARIAN:  base = _hungarianStrings;  break;
      case LANGUAGE_ROMANIAN:   base = _romanianStrings;   break;
      case LANGUAGE_SCHINESE:   base = _schineseStrings;   break;
      case LANGUAGE_TURKISH:    base = _turkishStrings;    break;
      case LANGUAGE_JAPANESE:   base = _japaneseStrings;   break;
      case LANGUAGE_FINNISH:    base = _finnishStrings;    break;
      case LANGUAGE_MALKOVITCH:
      {
         switch(ws)
         {
            case STR_FILE_NAME_KEY:  return "\0011Malkovich";  // gotta make sure these are
            case STR_USER_KEY:       return "\0012Malkovich";  // prefixed correctly, even
            case STR_SESSIONID_KEY:  return "\0013Malkovich";  // inside Malkovich-land
            case STR_CONNECTION_KEY: return "\0014Malkovich";
            default:                 return "Malkovich";
         }
      }
      break;
   }
   return ((base)&&(ws >= 0)&&(ws < NUM_STRINGS)) ? base[ws] : NULL;
}

char shortcut(int sc)
{
   const char * base = NULL;
   switch(_language)
   {
      case LANGUAGE_ENGLISH:    base = _englishShortcuts; break;
      case LANGUAGE_SPANISH:    base = _spanishShortcuts; break;
      case LANGUAGE_GERMAN:     base = _germanShortcuts; break;
      case LANGUAGE_DUTCH:      base = _dutchShortcuts; break;
      case LANGUAGE_PORTUGUESE: base = _portugueseShortcuts; break;
      case LANGUAGE_FRENCH:     base = _frenchShortcuts; break;
      case LANGUAGE_ITALIAN:    base = _italianShortcuts; break;
      case LANGUAGE_RUSSIAN:    base = _russianShortcuts; break;
      case LANGUAGE_SWEDISH:    base = _swedishShortcuts; break;
      case LANGUAGE_ESPERANTO:  base = _esperantoShortcuts; break;
      case LANGUAGE_NORWEGIAN:  base = _norwegianShortcuts; break;
      case LANGUAGE_SERBIAN:    base = _serbianShortcuts; break;
      case LANGUAGE_BULGARIAN:  base = _bulgarianShortcuts; break;
      case LANGUAGE_KOREAN:     base = _koreanShortcuts; break;
      case LANGUAGE_HUNGARIAN:  base = _hungarianShortcuts; break;
      case LANGUAGE_ROMANIAN:   base = _romanianShortcuts; break;
      case LANGUAGE_SCHINESE:   base = _schineseShortcuts; break;
      case LANGUAGE_TURKISH:    base = _turkishShortcuts; break;
      case LANGUAGE_JAPANESE:   base = _japaneseShortcuts; break;
      case LANGUAGE_FINNISH:    base = _finnishShortcuts; break;
      case LANGUAGE_MALKOVITCH: return 'M';
   }
   return ((base)&&(sc >= 0)&&(sc < NUM_SHORTCUTS)) ? base[sc] : 0;
}

}
;  // end namespace beshare
