#include "SmsView.h"
#include "constants.h"
extern "C" {
#include "osd.h"
void	screen_blit_T1(void*,int,int,int,void*,int,int,int,int,int);
void	screen_blit_T2(void*,int,int,int,void*,int,int,int,int,int);
void	screen_blit_T2_MMX(void*,int,int,int,void*,int,int,int,int,int);
void	screen_blit_T3(void*,int,int,int,void*,int,int,int,int,int);
void	screen_blit_T3_MMX(void*,int,int,int,void*,int,int,int,int,int);
void blur(char *src, int line_width, int num_lines, int line_modulo);
}

volatile int frame_skip      = 1;
volatile int frame_count     = 0;
volatile int frames_rendered = 0;
volatile int frame_rate      = 0;
volatile int tick_count      = 0;
volatile int old_tick_count  = 0;
volatile int skip            = 0;

int fg                       = 0;
int bg                       = 0;
volatile int msg_enable      = 0;
FILE *music_log              = NULL;
int music_log_count          = 0;
int state_slot               = 0;
int snap_count               = 0;
char msg[0x100];
char game_name[0x100];



SmsView::SmsView(BRect rect)
	: BView(rect, "smsview", B_FOLLOW_ALL_SIDES, 0)
	{
		
		BString name;
		
		stick = new BJoystick();
	
		numDevices = stick->CountDevices();
	
		for(i = 0;i < numDevices; i++) {
				if(stick->GetDeviceName(i, devName) == B_NO_ERROR) {
				stick->Open(devName);
				stick->GetControllerName(&name);
				puts(name.String());
			}
		}

	sms_bmp = NULL;
	sms_scanbitmap = NULL;
	scanner = false;
	blurring = false;
	joy = false;
	logging = false;
	
	sms_bmp = new BBitmap(BRect(0, 0, 256, 192), B_RGB16, false, true);
	sms_scanbitmap = new BBitmap(BRect(0, 0, 256*2, 192*2), B_RGB16, false, true);
	
	fThread = spawn_thread(SmsView::fDrawThread, "SmsPlusThread", B_NORMAL_PRIORITY, (void*)this);
	}

void SmsView::MessageReceived(BMessage *msg)
{
	switch(msg->what) {
	
		case RUN:
			fOpenPanel->Show();
		break;
		
		case SCAN:
			msg->FindBool("usescan", &scanner);
		break;
		
		case USEJOY:
			msg->FindBool("usejoy", &joy);
		break;
			
		case BLUR:
			msg->FindBool("useblur", &blurring);
		break;
		
		case LOG:
			msg->FindBool("uselog", &logging);
				if(logging && !exit_flag) StartLogging();
				if(!logging && !exit_flag) StopLogging();
		break;
		
		case B_REFS_RECEIVED:
				if(msg->FindRef("refs", &ref) == B_NO_ERROR) EmuStart();
		break;
		
		case SAV:
			if(!exit_flag) { state_slot = 0; save_state(); }
		break;
		
		case SAV1:
			if(!exit_flag) { state_slot = 1; save_state(); }
		break;
		
		case SAV2:
			if(!exit_flag) { state_slot = 2; save_state(); }
		break;
		
		case SAV3:
			if(!exit_flag) { state_slot = 3; save_state(); }
		break;
		
		case SAV4:
			if(!exit_flag) { state_slot = 4; save_state(); }
		break;
		
		case LOA:
			if(!exit_flag) { state_slot = 0; load_state(); }
		break;
		
		case LOA1:
			if(!exit_flag) { state_slot = 1; load_state(); }
		break;
		
		case LOA2:
			if(!exit_flag) { state_slot = 2; load_state(); }
		break;
		
		case LOA3:
			if(!exit_flag) { state_slot = 3; load_state(); }
		break;
		
		case LOA4:
			if(!exit_flag) { state_slot = 4; load_state(); }
		break;
		
		default:
			BView::MessageReceived(msg);
		break;
			
		}
	}



void SmsView::KeyDown(const char *bytes, int32 numBytes)
{
	switch(bytes[0]) {
		
		case B_UP_ARROW:
			input.pad[0] |= INPUT_UP;
		break;
		
		case B_DOWN_ARROW:
			input.pad[0] |= INPUT_DOWN;
		break;
		
		case B_LEFT_ARROW:
			input.pad[0] |= INPUT_LEFT;
		break;
		
		case B_RIGHT_ARROW:
			input.pad[0] |= INPUT_RIGHT;
		break;
		
		case B_SPACE:
			input.pad[0] |= INPUT_BUTTON1;
		break;
		
		case 'p':
		case 'P':
			input.system |= (IS_GG) ? INPUT_START : INPUT_PAUSE;
		break;
		
		case 'Z':
		case 'z':
			input.pad[0] |= INPUT_BUTTON2;
		break;
		
		case B_FUNCTION_KEY:
		
		case B_F1_KEY:
			input.system |= INPUT_HARD_RESET;
		break;
		
		default:
			BView::KeyDown(bytes, numBytes);
		break;
	}
}


void SmsView::KeyUp(const char *bytes, int32 numBytes)
{
	switch(bytes[0]) {
		
		case B_UP_ARROW:
			input.pad[0] &= ~INPUT_UP;
		break;
		
		
		case B_DOWN_ARROW:
			input.pad[0] &= ~INPUT_DOWN;
		break;
		
		case B_LEFT_ARROW:
			input.pad[0] &= ~INPUT_LEFT;
		break;
		
		case B_RIGHT_ARROW:
			input.pad[0] &= ~INPUT_RIGHT;
		break;
		
		case B_SPACE:
			input.pad[0] &= ~INPUT_BUTTON1;
		break;
		
		case 'p':
		case 'P':
			input.system &= ~(IS_GG) ? INPUT_START : INPUT_PAUSE;
		break;
		
		case 'z':
		case 'Z':
			input.pad[0] &= ~INPUT_BUTTON2;
		break;
		
		case B_FUNCTION_KEY:
		case B_F1_KEY:
			input.system &= ~INPUT_HARD_RESET;
		break;
		
		default:
			BView::KeyUp(bytes, numBytes);
		break;
	}
}


void SmsView::AttachedToWindow()
{
		fOpenPanel = new BFilePanel(B_OPEN_PANEL, new BMessenger(this), NULL, B_FILE_NODE, false);
}


bool SmsView::IsThreadRunning()
{
	if(get_thread_info(fThread, &the_info) == B_NO_ERROR)
	{
		if(the_info.state == B_THREAD_RUNNING)
			return true;
		else
			return false;
	}
	else
		return true;

}

bool SmsView::EmuStart()
{
	char temp[256];
	BEntry entry(&ref, true);
	entry.GetPath(&path);
	
	char *game = strdup(path.Path());
	
	strcpy(game_name, game);
	

	if(IsThreadRunning()) {
		save_sram();
		system_reset();
		trash_machine();
		system_shutdown();
		suspend_thread(fThread);
		
		}

	if(load_rom(game_name) == 0)
    	{
        	sprintf(temp, "Error `%s'. is not a valid Sms Game\n", game_name);
       		BAlert* alert = new BAlert(NULL, temp, "OK");
			alert->Go();
        	return false;
   	 	}
    
    option.sound        =   1;
    option.sndcard      =   2;
    option.sndrate      =   44100;
    option.fm_enable    =   1;
    
    init_machine();
    
    system_init(option.sound ? option.sndrate : 0);
    exit_flag = false;
        
    resume_thread(fThread);
    sms.country = option.country;
    sms.use_fm = option.fm_enable;
    snd.callback = log_handler;
   	load_sram();
    return true;
}


long SmsView::fDrawThread(void *data)
{
	SmsView *w;
	w = (SmsView*)data;
	
	
	while(!w->exit_flag) {
	static bigtime_t prev_tick = 0;
	static const bigtime_t frame_snooze = 1000000 / 60;
	
	
		frame_count += 1;
        frames_rendered += 1;
        skip = (frame_count % frame_skip == 0) ? 0 : 1;

        /* Get current input */
        w->update_input();
       // check_ui_keys();

        /* Run the system emulation for a frame */
        sms_frame(skip);

        /* Update the display */
        if(skip == 0)
        {
           w->update_audio();
           w->update_video();
        }

        /* Speed throttling */
        if(option.throttle)
        {
            while(tick_count == old_tick_count);
            old_tick_count = tick_count;
        }
        bigtime_t snooze_time = frame_snooze - (system_time()-prev_tick);
		if (snooze_time > 0) snooze(snooze_time - 60);
		prev_tick = system_time();
   }
   return 0;
}

void SmsView::log_handler(int data)
{
    if(music_log) fputc(data, music_log);
}

void SmsView::load_sram()
{
	char name[0x100];
    FILE *fd;
    strcpy(name, game_name);
    
    strcpy(strrchr(name, '.'), ".sav");
    fd = fopen(name, "rb");
    if(fd)
    {
        sms.save = 1;
        fread(sms.sram, 0x8000, 1, fd);
        fclose(fd);
    }

}

/* Save SRAM data */
void SmsView::save_sram(void)
{
    if(sms.save)
    {
        char name[0x100];
        FILE *fd = NULL;
        strcpy(name, game_name);
        strcpy(strrchr(name, '.'), ".sav");
        fd = fopen(name, "wb");
        if(fd)
        {
            fwrite(sms.sram, 0x8000, 1, fd);
            fclose(fd);
        }
    }
}

void SmsView::system_load_sram(void)
{
	load_sram();
}
void SmsView::update_video(void)
{
	Window()->Lock();
	if(scanner) {
	DrawBitsmap(sms_bmp, 0, 0, 0, 0, 256, 192);
	DrawBitmapAsync(sms_scanbitmap, sms_scanbitmap->Bounds(), Bounds());
	} else {
	
	DrawBitmapAsync(sms_bmp, sms_bmp->Bounds(), Bounds());
	}
	
	if(blurring && !scanner)
	{
		blur((char*)sms_bmp->Bits(), 258, 192, 0);
	}
	
	if(blurring && scanner)
	{
		blur((char*)sms_scanbitmap->Bits(), 258, 192, 0);
	}
	
	Window()->Unlock();

	Window()->Sync();
}

void SmsView::update_audio(void)
{
	if(!option.sound) return;
    osd_play_streamed_sample_16(0, &snd.buffer[0][0], snd.bufsize * 2, option.sndrate, 60, -100);
    osd_play_streamed_sample_16(1, &snd.buffer[1][0], snd.bufsize * 2, option.sndrate, 60,  100);
}

void SmsView::update_input(void)
{
	if(!joy) return;
	numAxes = stick->CountAxes();
	axes = (int16 *) malloc(sizeof(int16) * numAxes);
	numButtons = stick->CountButtons();
	buttons = stick->ButtonValues();
	
	if(stick->Update() == B_NO_ERROR) {
		
		stick->GetAxisValues(axes);
		
		horizontal = axes[0];
		vertical = axes[1];
		
		if(vertical <= (-32768/2)) {
		input.pad[0] |= INPUT_UP;
		} else {
		input.pad[0] &= ~INPUT_UP;
		}

		if(vertical >= (32768/2)) {
		input.pad[0] |= INPUT_DOWN;
		} else {
		input.pad[0] &= ~INPUT_DOWN;
		}
		
		if(horizontal <= (-32768/2)) {
		input.pad[0] |= INPUT_LEFT;
		} else {
		input.pad[0] &= ~INPUT_LEFT;
		}
		
		if(horizontal >= (32768/2)) {
		input.pad[0] |= INPUT_RIGHT;
		} else {
		input.pad[0] &= ~INPUT_RIGHT;
		}

		switch(buttons) {
		
			case 1:
				input.pad[0] |= INPUT_BUTTON1;
			break;
			
			case 2:
				input.pad[0] |= INPUT_BUTTON2;
			break;
			
			case 4:
				input.system |= (IS_GG) ? INPUT_START : INPUT_PAUSE;
			break;
			
			default:
				input.pad[0] &= ~INPUT_BUTTON1;
				input.pad[0] &= ~INPUT_BUTTON2;
				input.system &= ~(IS_GG) ? INPUT_START : INPUT_PAUSE;
			break;
		}
	
	}
}
void SmsView::DrawBitsmap(const BBitmap* bitmap, int sx, int sy, int dx, int dy, int iw, int ih)
{
	uint8*	psrc = (uint8*)bitmap->Bits();
	long		lsrc = bitmap->BytesPerRow();
	uint8* pdst = (uint8*)sms_scanbitmap->Bits();
	long ldst = sms_scanbitmap->BytesPerRow();
	screen_blit_T2_MMX( pdst, ldst, dx, dy, psrc, lsrc, sx, sy, iw, ih);

}

void SmsView::init_machine(void)
{

	if(option.sound)
    {
        /* Initialize sound and update sample rate */
        int ret = msdos_init_sound(&option.sndrate, option.sndcard);

        /* Error - disable sound */
        //if(ret != 0) option.sound = 0;
    }
	
	memset(sms_bmp->Bits(), 0, sms_bmp->BitsLength());
	memset(sms_scanbitmap->Bits(), 0, sms_scanbitmap->BitsLength());
	
    bitmap.width  = (int)sms_bmp->Bounds().Width()+1;
    bitmap.height = (int)sms_bmp->Bounds().Height()+1;
    
    bitmap.depth  = 16;
    bitmap.pitch  = sms_bmp->BytesPerRow();
    bitmap.data   = (unsigned char *)sms_bmp->Bits();
}

int SmsView::load_rom(char *filename)
{
    int size;

    if(strcmp(strrchr(filename, '.'), ".zip") == 0)
    {
        char name[0x100];

        cart.rom = loadzip(filename, name, &size);
        if(!cart.rom) return (0);
        printf("Loaded `%s', (%d bytes) from archive `%s'\n", name, size, filename);
        strcpy(game_name, name);

        /* Take care of image header, if present */
        if((size / 512) & 1)
        {
            size -= 512;
            memmove(cart.rom, cart.rom + 512, size);
        }

        cart.pages = (size / 0x4000);
    }
    else
    {
        FILE *fd = NULL;

        fd = fopen(filename, "rb");
        if(!fd) return (0);

        /* Seek to end of file, and get size */
        fseek(fd, 0, SEEK_END);
        size = ftell(fd);
        fseek(fd, 0, SEEK_SET);

        /* Don't load games smaller than 32k */
        if(size < 0x8000) return (0);

        /* Take care of image header, if present */
        if((size / 512) & 1)
        {
            size -= 512;
            fseek(fd, 512, SEEK_SET);
        }

        cart.pages = (size / 0x4000);
        cart.rom = (uint8 *)malloc(size);
        if(!cart.rom) return (0);
        fread(cart.rom, size, 1, fd);

        fclose(fd);
    }

    /* Figure out game image type */
    if(strcmp(strrchr(game_name, '.'), ".gg") == 0)
        cart.type = TYPE_GG;
    else
        cart.type = TYPE_SMS;

    return (1);
}


int SmsView::load_state(void)
{
    char name[0x100];
    FILE *fd = NULL;
    strcpy(name, game_name);
    sprintf(strrchr(name, '.'), ".st%d", state_slot);
    fd = fopen(name, "rb");
    if(!fd) return (0);
    system_load_state(fd);
    fclose(fd);
    load_sram();
    return (1);
}

/* Save system state */
int SmsView::save_state(void)
{
    char name[0x100];
    FILE *fd = NULL;
    strcpy(name, game_name);
    sprintf(strrchr(name, '.'), ".st%d", state_slot);
    fd = fopen(name, "wb");
    if(!fd) return (0);
    system_save_state(fd);
    fclose(fd);
    return(1);
}

void SmsView::StartLogging()
{

	char name[0x100];
    char ext[0x100];
    sprintf(ext, "%02d.ssl", music_log_count);
    strcpy(name, game_name);
   	strcpy(strrchr(name, '.'), ext);
    snd.log = 1;
    music_log_count += 1;
    music_log = fopen(name, "wb");

}

void SmsView::StopLogging()
{
	if(music_log)
    {
     snd.log = 0;
     fclose(music_log);
     music_log = NULL;
    }

}


void SmsView::trash_machine(void)
{
    if(option.sound) msdos_shutdown_sound();
}

SmsView::~SmsView()
{
	long result;
	Window()->Lock();
	
	exit_flag = true;
	delete sms_bmp;
	delete sms_scanbitmap;
	
	save_sram();
	system_shutdown();
	trash_machine();
	option.sound = 0;
	if(stick) stick->Close();

	//wait_for_thread(fThread, &result);
	if(!IsThreadRunning())
	kill_thread(fThread);
	

}
