#ifndef _SMSVIEW_H_
#define _SMSVIEW_H_

#include <Be.h>

class SmsView : public BView
{
public:
	SmsView(BRect rect);
	virtual ~SmsView();
	void init_machine(void);
	void system_load_sram(void);
	void update_video(void);
	void update_audio(void);
	void update_input(void);
	virtual void MessageReceived(BMessage *msg);
	virtual void KeyDown(const char *bytes, int32 numBytes);
	virtual void KeyUp(const char *bytes, int32 numBytes);
	virtual void AttachedToWindow();
	void DrawBitsmap(const BBitmap* bitmap, int sx, int sy, int dx, int dy, int iw, int ih);
	static long fDrawThread(void *data);
	bool EmuStart();
	int load_rom(char *filename);
	static void log_handler(int data);
	void trash_machine(void);
	bool IsThreadRunning();
	int save_state();
	int load_state();
	void load_sram();
	void save_sram();
	void StartLogging();
	void StopLogging();
private:
	thread_id fThread;
	BBitmap *sms_bmp;
	BBitmap *sms_scanbitmap;
	BView *fView;
	BJoystick *stick;
	BFilePanel *fOpenPanel;
	int32 i;
	char devName[B_OS_NAME_LENGTH];
	uint32 buttons;
	int32 numDevices;
	int16 *axes;
	int32 numAxes;
	int16 horizontal, vertical;
	int32 numButtons;
	entry_ref ref;
	BPath path;
	bool exit_flag;
	bool scanner;
	bool joy;
	bool blurring;
	bool logging;
	char game_name[0x100];
	thread_info the_info;
	BString name;
};

#endif
