#include "SmsWin.h"
#include "constants.h"

const char *text = "BeSmsPlus for BeOS by Caz Jones\n\nOriginally created by Charles Mac Donald\n\nHomePage: cgfm2.emuviews.com\n";

SmsWin::SmsWin(BRect frame)
	: BWindow(frame, "BeSmsPlus", B_TITLED_WINDOW, B_NOT_ZOOMABLE)
	{
	Lock();
	BRect r = Bounds();
	menubar = new BMenuBar(r, "menu_bar");
	AddChild(menubar);
	
	menu = new BMenu("File");
	item = new BMenuItem("Open", new BMessage(RUN), 'O');
	menu->AddItem(item);
	
	menu->AddSeparatorItem();
	
	statemenu = new BMenu("Save State");
	
	item = new BMenuItem("Slot 1", new BMessage(SAV));
	statemenu->AddItem(item);
	
	item = new BMenuItem("Slot 2", new BMessage(SAV1));
	statemenu->AddItem(item);
	
	item = new BMenuItem("Slot 3", new BMessage(SAV2));
	statemenu->AddItem(item);
	
	item = new BMenuItem("Slot 4", new BMessage(SAV3));
	statemenu->AddItem(item);
	
	item = new BMenuItem("Slot 5", new BMessage(SAV4));
	statemenu->AddItem(item);
	
	item = new BMenuItem(statemenu);
	menu->AddItem(item);
	
	
	loadmenu = new BMenu("Load State");
	
	item = new BMenuItem("Slot 1", new BMessage(LOA));
	loadmenu->AddItem(item);
	
	item = new BMenuItem("Slot 2", new BMessage(LOA1));
	loadmenu->AddItem(item);
	
	item = new BMenuItem("Slot 3", new BMessage(LOA2));
	loadmenu->AddItem(item);
	
	item = new BMenuItem("Slot 4", new BMessage(LOA3));
	loadmenu->AddItem(item);
	
	item = new BMenuItem("Slot 5", new BMessage(LOA4));
	loadmenu->AddItem(item);
	
	item = new BMenuItem(loadmenu);
	menu->AddItem(item);
	
	
	
	item = new BMenuItem("About", new BMessage(B_ABOUT_REQUESTED), 'A');
	menu->AddItem(item);
	menu->AddSeparatorItem();
	
	
	
	item = new BMenuItem("Exit", new BMessage(B_QUIT_REQUESTED), 'Q');
	menu->AddItem(item);
	
	menubar->AddItem(menu);
	
	menu1 = new BMenu("Options");
	
	item = new BMenuItem("Scanlines", new BMessage(SCAN));
	menu1->AddItem(item);
	
	item = new BMenuItem("Use Joystick", new BMessage(USEJOY));
	menu1->AddItem(item);
	
	item = new BMenuItem("Blur", new BMessage(BLUR));
	menu1->AddItem(item);
	
	item = new BMenuItem("Log Gym file", new BMessage(LOG));
	menu1->AddItem(item);
	
	menubar->AddItem(menu1);
	
	
	
	r.top = menubar->Bounds().bottom+1;
	fView = new SmsView(r);
	AddChild(fView);
	fView->MakeFocus(true);
	Unlock();
	
	scanner = false;
	joy = false;
	blurring = false;
	logging = false;
	
}
	
void SmsWin::MessageReceived(BMessage *msg)
{
	switch(msg->what) {
		
		case RUN:
			fView->MessageReceived(msg);
		break;
		
		case SCAN:
			if(scanner == false) scanner = true;
			else scanner = false;
			if(scanner == true) {
				menu1->ItemAt(0)->SetMarked(true);
				ResizeTo(256*2,202*2);
		} else {
			menu1->ItemAt(0)->SetMarked(false);
			ResizeTo(256,212);
		}
			msg->AddBool("usescan", scanner == 1?true:false); 
			fView->MessageReceived(msg);
		break;
		
		case USEJOY:
			if(joy == false) joy = true;
			else joy = false;
			if(joy == true) {
				menu1->ItemAt(1)->SetMarked(true);
		} else {
			menu1->ItemAt(1)->SetMarked(false);
		}
		
			msg->AddBool("usejoy", joy == 1?true:false); 
			fView->MessageReceived(msg);
		break;
		
		case BLUR:
			if(blurring == false) blurring = true;
			else blurring = false;
			if(blurring == true) {
				menu1->ItemAt(2)->SetMarked(true);
		} else {
			menu1->ItemAt(2)->SetMarked(false);
		}
		
			msg->AddBool("useblur", blurring == 1?true:false); 
			fView->MessageReceived(msg);
		break;
		
		case B_ABOUT_REQUESTED:
			alert = new BAlert("smsalert", text, "Ok", NULL, NULL, B_WIDTH_FROM_LABEL);
			alert->Go();
		break;
		
		case SAV:
			fView->MessageReceived(msg);
		break;
		
		case SAV1:
			fView->MessageReceived(msg);
		break;
		
		case SAV2:
			fView->MessageReceived(msg);
		break;
		
		case SAV3:
			fView->MessageReceived(msg);
		break;
		
		case SAV4:
			fView->MessageReceived(msg);
		break;
		
		case LOA:
			fView->MessageReceived(msg);
		break;
		
		case LOA1:
			fView->MessageReceived(msg);
		break;
		
		case LOA2:
			fView->MessageReceived(msg);
		break;
		
		case LOA3:
			fView->MessageReceived(msg);
		break;
		
		case LOA4:
			fView->MessageReceived(msg);
		break;
		
		case LOG:
			if(logging == false) logging = true;
			else logging = false;
			if(logging == true) {
			menu1->ItemAt(3)->SetMarked(true);
		} else {
			menu1->ItemAt(3)->SetMarked(false);
		}
			msg->AddBool("uselog", logging == 1?true:false); 
			fView->MessageReceived(msg);
		break;
		
		
		default:
			BWindow::MessageReceived(msg);
		break;
	}
}
		
bool SmsWin::QuitRequested()
{
	be_app->PostMessage(B_QUIT_REQUESTED);
	return(true);
}