// CClockApp.h

#ifndef CCLOCK_APP_H_
#define CCLOCK_APP_H_

#include <Application.h>
#include <Deskbar.h>
#include <PopUpMenu.h>
#include <Message.h>

#include <strstream>
#include <string>
#include <cstdio>
#include <memory>

#include "CClockWindow.h"
#include "CClockDefs.h"
#include "AboutWindow.h"
#include "CClockDeskbarView.h"
#include "CClockDeskbarMenu.h"
#include "MultiLangMenu.h"
#include "MultiLang.h"

// using std::auto_ptr;

class TCClockApp : public BApplication,TMultiLangObserver
{
public:
	TCClockApp();
	~TCClockApp();
	
	virtual void ReadyToRun();
	virtual void AboutRequested();
	virtual void MessageReceived(BMessage* _msg);
	virtual void Quit();
	virtual void LangChanged(const char* _lang);
private:
	void makeDefaultSettingFile(TConfigFile* _p_config_file);
	void initPopUpMenu();
	void cleanUpPopUpMenu();
	
	TCClockWindow*      m_main_win;
	TCClockDeskbarMenu* m_popup_menu;

	TAboutWindow* m_about_window;	

	TMultiLangMenu* m_multi_lang_menu;
};

#endif // CCLOCK_APP_H_

