#include "CClockDeskbarMenu.h"

TCClockDeskbarMenu::TCClockDeskbarMenu(const char* _name)
	:BPopUpMenu(_name,false,false)
{
}

TCClockDeskbarMenu::~TCClockDeskbarMenu()
{
}

BPoint TCClockDeskbarMenu::ScreenLocation()
{
	BPoint point = BPopUpMenu::ScreenLocation();
	BDeskbar deskbar;
	
	BRect rect(deskbar.Frame());
	float width,height;
	GetPreferredSize(&width,&height);

	// デスクバーの位置により表示位置を変える
	switch (deskbar.Location()) 
	{
	case B_DESKBAR_TOP:
		point.y = rect.bottom;
		break;
	case B_DESKBAR_BOTTOM:
		point.y = rect.top - height;
		break;
	case B_DESKBAR_LEFT_BOTTOM:
		point.x = rect.right;
		point.y = rect.top - height;
		break;
	case B_DESKBAR_RIGHT_BOTTOM:
		point.x = rect.left - width;
		point.y = rect.top - height;
		break;
	case B_DESKBAR_LEFT_TOP:
		point.x = rect.right;
		break;
	case B_DESKBAR_RIGHT_TOP:
		point.x = rect.left - width;
		break;	
	}
	
	return point;
}