#ifndef DESKBAR_VIEW_H_
#define DESKBAR_VIEW_H_

#include <Application.h>
#include <AppFileInfo.h>
#include <Roster.h>
#include <Debug.h>
#include <View.h>
#include <Bitmap.h>
#include <Message.h>
#include <Messenger.h>
#include <File.h>
#include <ClassInfo.h>

#include "CClockDefs.h"

static const uint32 DESKBAR_CLICKED = 'decl';

static const char ICON_FIELD[] = "CCLOCK_icon_bitmap";
static const char MESSENGER_FIELD[] = "CCLOCK_messenger_field";

class _EXPORT TCClockDeskbarView : public BView
{
public:
	TCClockDeskbarView(BMessenger _messenger,const char* _name,BBitmap* _icon = NULL);
	virtual ~TCClockDeskbarView();
	TCClockDeskbarView(BMessage* _archive);

	virtual status_t Archive(BMessage* o_archive,bool _deep = true) const;
	static BArchivable* Instantiate(BMessage* _archive);

	virtual void     AttachedToWindow();
//	virtual void     MessageReceived(BMessage* _msg);
	virtual void     MouseDown(BPoint _point);
	virtual void     Draw(BRect _update_rect);
private:
	BBitmap* getAppIcon();

	BMessenger m_messenger;
	BBitmap* m_icon;
};

#endif // #ifndef DESKBAR_VIEW_H_