// CClockWindow.cpp

#include "CClockWindow.h"

TCClockWindow::TCClockWindow(BRect _rect,const char* _title)
	:TMainWindow(_rect,_title,MAIN_WINDOW_LOOK,
				MAIN_WINDOW_FEEL,MAIN_WINDOW_FLAGS)
	,m_time_getter(NULL)
{
	bool error;

	TConfigFile* config_file = TConfigFile::GetConfigFile(CONFIG_FILENAME);

	// 各種設定の復元
	m_last_connected_server = config_file->GetValue(CONFIG_SERVERNAME);
	if(m_last_connected_server == "")
	{
		m_last_connected_server = DEFAULT_SERVERNAME;		
	}

	error = config_file->GetBool(CONFIG_IS_PERMANENT,&m_parmanent_flag);
	if(error != TConfigFile::OK)
	{
		m_parmanent_flag = DEFAULT_PERMANENT;
	}
	
	error = config_file->GetInt64(CONFIG_PULSE_RATE,&m_pulse_rate);
	if (error != TConfigFile::OK)
	{
		m_pulse_rate = DEFAULT_PULSE_RATE;	
	}
	else
	{
		m_pulse_rate *= PULSE_RATE_TIMES;
	}

	error = config_file->GetInt64(CONFIG_TIMEOUT,&m_timeout);
	if (error != TConfigFile::OK)
	{
		m_timeout = DEFAULT_TIMEOUT;
	}
	else
	{
		m_timeout *= TIMEOUT_TIMES;
	}

	_rect.OffsetTo(B_ORIGIN);
	m_view = new TCClockView(_rect,"MAIN_VIEW");
	AddChild(m_view);

	m_view->MakeFocus(this);

	SetParmanent(m_parmanent_flag,m_pulse_rate); // 常駐設定
}

TCClockWindow::~TCClockWindow()
{
	delete m_time_getter;
}

void TCClockWindow::MessageReceived(BMessage* _msg)
{
	TMultiLang* lang = TMultiLang::GetMultiLang();

	switch (_msg->what)
	{
	case MAIN_OK_BUTTON_CLICKED:
	{
		// OKボタンを探して見つかったらDisabledにする
		BButton* button;
		if ((button = dynamic_cast<BButton*>(m_view->FindView(MAIN_OK_BUTTON_NAME))) != NULL)
			button->SetEnabled(false);
		
		status_t ret;
		BString server_name;
	
		ret = _msg->FindString(SERVER_NAME_FIELD,&server_name);
		ASSERT(ret == B_OK);

		m_last_connected_server = server_name.String();
		timeGetting(server_name.String());

		m_wait_window = new TWaitWindow(BPoint(Frame().left + 50.0,
										Frame().top + 50.0),
									   lang->GetString(BETWEEN_CONNECT_TITLE),
									   lang->GetString(BETWEEN_CONNECT_MESSAGE) );
		m_wait_window->Begin();
		break;
	}
	case NTP_PACKET_GOT:
	{
		
		// OK ボタンを探して見つかったらEnabledにする
		BButton* button;
		if ((button = dynamic_cast<BButton*>(m_view->FindView(MAIN_OK_BUTTON_NAME))) != NULL)
			button->SetEnabled(true);

		if(m_parmanent_flag == false) m_wait_window->End();

		status_t ret;
		int32 error_code;

		ret = _msg->FindInt32(IS_ERROR_FIELD,&error_code);
		ASSERT(ret == B_OK);

		// 送られてきたパケットが正しいかどうか調べる
		switch(error_code)
		{
		case TCorrectTimeGetter::NO_ERROR:
			NtpPacket* packet;
			ret = _msg->FindPointer(NTP_PACKET_FIELD,reinterpret_cast<void**>(&packet));
			ASSERT(ret == B_OK);
			
			LocalTimeInfo* local_time;
			ret = _msg->FindPointer(LOCAL_TIME_FIELD,reinterpret_cast<void**>(&local_time));
			ASSERT(ret == B_OK);			
			
			// 結果の表示
			ntpPacketAnalyze(packet,local_time);

			break;
		case TCorrectTimeGetter::ADDRESS_NOT_FOUND:
			ShowMessage("Error",lang->GetString(ADDRESS_ERROR_MESSAGE));
			break;
		case TCorrectTimeGetter::CONNECT_TIMEOUT_ERROR:
			ShowMessage("Error",lang->GetString(TIMEOUT_ERROR_MESSAGE));
			break;					
		case TCorrectTimeGetter::NOT_VALID_ERROR:
			ShowMessage("Error",lang->GetString(NOT_VALID_ERROR_MESSAGE) );
			break;
		}
		delete m_time_getter;
		m_time_getter = NULL;
	}
	default:
		TMainWindow::MessageReceived(_msg);
		break;
	}

}

// 終了時の処理
// 設定の保存と終了
bool TCClockWindow::QuitRequested()
{
	saveSettings();
	
	return TMainWindow::QuitRequested();
}

// 設定のセーブ
void TCClockWindow::saveSettings()
{
	TConfigFile* config_file;
	config_file = TConfigFile::GetConfigFile(CONFIG_FILENAME);

	config_file->SetValue(CONFIG_SERVERNAME,m_view->GetServerNameString().c_str() );	
	config_file->SetValue(CONFIG_PULSE_RATE,m_view->GetPulseRateString().c_str() );
	config_file->SetValue(CONFIG_TIMEOUT,m_view->GetTimeoutString().c_str() );
	config_file->SetValue(CONFIG_IS_PERMANENT,m_view->GetParmanentBool() );

	TMultiLang* lang = TMultiLang::GetMultiLang();
	config_file->SetValue(CONFIG_LANGUAGE,lang->GetLangFileName() );

	config_file->Save();
}

// 時間の取得開始
void TCClockWindow::timeGetting(const char* _server_name)
{
	delete m_time_getter;
	m_time_getter = new TCorrectTimeGetter(_server_name,
						this,m_timeout);

	switch (m_time_getter->Error() )
	{
	case TCorrectTimeGetter::NO_ERROR:	
		m_time_getter->Connect();	
		break;
	case TCorrectTimeGetter::SOCKET_ERROR:
		ShowMessage("Error",SOCKET_ERROR_MESSAGE);

		be_app->PostMessage(B_QUIT_REQUESTED);
		break;
	}
}

// 受信したNTPパケットか時間を変更する
// 日本語バージョン
void TCClockWindow::ntpPacketAnalyze(NtpPacket* _p,LocalTimeInfo* _local_time)
{
	_p->Swap();

	char show_message[1024];

//	ostrstream ost;

	int32 difference_time;
	uint32 ntp_time_on_beos;
	
	_p->PrintToStream();

	
	ntp_time_on_beos = static_cast<uint32>(_p->transmit_timestamp_seconds) - NTP_SERVER_TIME_DIFFERENCE;

	difference_time = ntp_time_on_beos - real_time_clock();

#ifdef DEBUG
	cout << "transmit_timestamp_seconds: " << ntp_time_on_beos << endl;
	cout << "real_time_clock: " << real_time_clock() << endl;
#endif	

	TMultiLang* lang = TMultiLang::GetMultiLang();
	if(difference_time > 0)
	{
		sprintf(show_message,lang->GetString(TIME_INFO_SLOW_MESSAGE),difference_time,difference_time);
//		ost << "時刻が" << difference_time << "秒" << "遅れていました。" << difference_time << "秒時刻を早めます。" << '\0';
	}
	else if(difference_time < 0)
	{
		sprintf(show_message,lang->GetString(TIME_INFO_FAST_MESSAGE),-difference_time,-difference_time);
//		ost << "時刻が" << (-difference_time) << "秒" << "早まっていました。" << (-difference_time) << "秒時刻を遅めます。" << '\0';
	}
	else
	{
		sprintf(show_message,lang->GetString(TIME_INFO_SUIT_MESSAGE));
//		ost << "時刻は合っています。" << '\0';
	}
	
// 常駐だったらアラートボックスを表示しない
//	ShowMessage("RESULT",ost.str());
	ShowMessage("RESULT",show_message);

	set_real_time_clock(static_cast<int32>(real_time_clock() + difference_time));
}

// 常駐時に呼ばれる関数
void TCClockWindow::Pulse(void)
{
	timeGetting(m_view->GetServerNameString().c_str());
}

// 常駐フラグ設定処理
void TCClockWindow::SetParmanent(bool _flag,bigtime_t _pulse_rate = DEFAULT_PULSE_RATE)
{
	m_parmanent_flag = _flag;
	
	if (_flag == true) 	// 常駐開始の処理
	{
		SetPulseRate(_pulse_rate);
	}
	else 				// 常駐解除の処理
	{
		SetPulseRate(0);
	}
}

void TCClockWindow::ShowMessage(const char* _kind,const char* _message)
{
	// 常駐していたらメッセージを標準出力に流す
	if(m_parmanent_flag == true)
	{
		cout << _message << '\0' << endl;
	}
	else
	{
		(new BAlert(_kind,_message,"OK"))->Go();
	}
}

