// ConfigFile.cpp

#include "ConfigFile.h"

const char KEY_VALUE_DELIMITER = '=';

const int LOAD_BUFFER_SIZE = 8192;

using namespace std;

//----------------------------------------------
// コンストラクタ
// 引数
// _filename:作成するファイル名

TConfigFile::TConfigFile(const char* _filename)
	:m_config_info(new CONFIGFILE_DATABASE)
{
	setFilename(_filename);
}

//----------------------------------------------
// デストラクタ

TConfigFile::~TConfigFile()
{
//	delete m_config_info;
}

//----------------------------------------------
// ファイル名を設定する
// 引数
// _filename:作成するファイル名

bool TConfigFile::setFilename(const char* _filename)
{

#ifdef B_BEOS_VESION
	if (_filename[0] != '/')  // 絶対パスだったらfalse
#else
	if (_filename[1] != ':')  // 絶対パスだったらfalse
#endif
	{
#ifdef B_BEOS_VERSION
		m_filename = getSettingFolderName() + _filename;		
#endif
	}
	else
	{
		m_filename = _filename;
		
	}

	getOpenedFileMap()[_filename] = this;
	return Load();
}

//----------------------------------------------
// ファイルをセーブ
// 返値
// ファイルを書き込む上でエラーがあったらfalse
// 正常終了はtrue

bool TConfigFile::Save()
{
	if (m_config_info->empty() ) return false; // なにも情報がなかったらfalseで終了
	
	ofstream config_file(m_filename.c_str()); 
	
	if (config_file.bad())  // オープンに失敗したら、ディレクトリを作成してもう一回やる
	{
		if (createDirectory(m_filename.c_str()) != true) return false;	
	 	ofstream config_file2(m_filename.c_str());
		if (config_file2.bad()) return false;
		else				    writeKeys(config_file2);
	}
	else
	{
		writeKeys(config_file);
	}
	return true;
}

//----------------------------------------------
// ファイルをロード
// 返値
// ファイルをロードする上で問題があったらfalse

bool TConfigFile::Load()
{
	m_config_info->clear(); 

	ifstream config_file(m_filename.c_str(),ios::in || ios::nocreate);

//	ASSERT_WITH_MESSAGE(!config_file.bad(),"ConfigFile can't be opened!");
	if (config_file.bad() ) 	return false; // ファイルがオープンできなかったらfalse

	// 要素の追加
	while (!config_file.eof() )
	{
		char buffer[LOAD_BUFFER_SIZE];
		string string_buffer;
		string str_key,str_value;
		string::size_type delimiter_index;		// "="の位置
	
		config_file.getline(buffer,LOAD_BUFFER_SIZE);
		string_buffer = buffer;
		
		delimiter_index = string_buffer.find_first_of(KEY_VALUE_DELIMITER);

		// '='が見つからなかったらその行は何もしない
		if (delimiter_index == string_buffer.npos) continue;
	
		// '='が現れるまでの部分文字列をキー部分にする
		str_key = string_buffer.substr(0,delimiter_index);
	
		// '='以降の部分文字列をキー部分にする
		str_value = string_buffer.substr(delimiter_index+1);
		 
		m_config_info->insert(CONFIGFILE_DATABASE_PAIR(str_key,str_value));
	}
	return true;
}

//----------------------------------------------
// キーをファイルに書き込む
// 引数
//  _stream:オープン済みのofstreamを渡す

void TConfigFile::writeKeys(ofstream& _stream)
{
	CONFIGFILE_DATABASE::iterator ite_info;

	for(ite_info = m_config_info->begin();ite_info != m_config_info->end();++ite_info)
	{
		_stream << ite_info->first << KEY_VALUE_DELIMITER << ite_info->second << endl; 
	}

}

//----------------------------------------------
// ディレクトリの作成
// 引数
//  _stream:オープン済みのofstreamを渡す

bool TConfigFile::createDirectory(const char* _path,mode_t _mode = 0755)
{
	BPath path(_path);
	BPath parent_path;
	
	if (path.GetParent(&parent_path) != B_NO_ERROR) return false;
	else if(create_directory(parent_path.Path(),_mode) != B_OK) return false;

	return true;
}


//--------------------------------------------
// GetConfigFile関数
// ファイル名からそれに対応するTConfigFileオブジェクトを渡す

TConfigFile* TConfigFile::GetConfigFile(const char* _filename)
{
	CONFIGFILES_MAP::iterator opened_file_ite;
	opened_file_ite = getOpenedFileMap().find(_filename);

	if(getOpenedFileMap().empty() || opened_file_ite == getOpenedFileMap().end() ) 
	{
		TConfigFile* create_config_file;
		create_config_file = new TConfigFile(_filename);
		return create_config_file;
	}
	else
	{

		return opened_file_ite->second;
	}	
}

//---------------------------------------------
// IsExists()
// ファイルがそこに存在するかどうかを返す

bool TConfigFile::IsExists()
{
	BEntry entry(m_filename.c_str());
	return entry.Exists();
}

//---------------------------------------------
// getOpenedFileMap()
// オープン済みファイルマップ名を返す

CONFIGFILES_MAP& TConfigFile::getOpenedFileMap()
{
	static CONFIGFILES_MAP* opened_filemap = new CONFIGFILES_MAP;
	return *opened_filemap;
}

//---------------------------------------------
// getSettingFolderName()関数
// セッティングフォルダ名を返す
#ifdef B_BEOS_VERSION
string TConfigFile::getSettingFolderName()
{
	status_t ret;
	BPath setting_path;
	ret = find_directory(B_USER_SETTINGS_DIRECTORY,&setting_path);

	ASSERT_WITH_MESSAGE(ret == B_OK,"SETTING_DIRECTORY_FIND_FAILED!");

	return string(setting_path.Path()) + "/";
}
#endif // #ifdef B_BEOS_VERSION

//---------------------------------------------
// GetBool()関数
// ブール値の取得
int TConfigFile::GetBool(const char* _key,bool* o_value)
{
	if (o_value == NULL) return ERROR;
	
	string str_value = GetValue(_key);	
	if(str_value == "") return NOT_KEY_EXIST;
	else if(str_value == "0")
	{
		*o_value = false;
		return OK;	
	}
	else if(str_value == "1")
	{
		*o_value = true;
		return OK;
	}
	else
	{
		return ERROR;
	}
	return ERROR;
}

int TConfigFile::GetInt32(const char* _key,int32* o_value)
{
	return GetInt64(_key,reinterpret_cast<int64*>(o_value));
}

int TConfigFile::GetInt64(const char* _key,int64* o_value)
{
	if (o_value == NULL) return ERROR;
	string str_value = GetValue(_key);
	int64 value = atoi(str_value.c_str());
	
	if (str_value == "") return NOT_KEY_EXIST;
	else 
	{
		*o_value = value;
		return OK;
	}
	return ERROR;
}

void TConfigFile::SetValue(const char* _key,bool _value)
{
	ostrstream ost;
	ost << _value << '\0';
	return SetValue(_key,ost.str());	
}

void TConfigFile::SetValue(const char* _key,int32 _value)
{
	ostrstream ost;
	ost << _value << '\0';
	return SetValue(_key,ost.str());	
}

void TConfigFile::SetValue(const char* _key,int64 _value)
{
	ostrstream ost;
	ost << _value << '\0';
	return SetValue(_key,ost.str());	
}

