// MultiLang.h
// 多言語化支援クラスの設計

#ifndef MULTI_LANG_H_
#define MULTI_LANG_H_

#include <Application.h>
#include <Window.h>
#include <Roster.h>
#include <Entry.h>
#include <Directory.h>
#include <Menu.h>
#include <Debug.h>

#include <cstring>
#include <strstream>
#include <string>
#include <map>
#include <vector>
#include <algorithm>

#include "MultiLangObserve.h"

using std::string;
using std::map;

class TMultiLang;

static const char LANG_FILE_EXTENSION[] = ".lng";
static const char LANG_FILE_SEPARATOR = '\t';

static const char DEFAULT_LANGUAGE[] = "english";

static const char NOT_FOUND_LANG_FILE_MESSAGE[] 
			= "ERROR:Not Found Lang Define File";

static const char SEARCH_DEEP_LEVEL = 3;

typedef map<string,string> STRING_DB; // 文字列データベース
typedef map<string,STRING_DB> LANG_DB;  // 言語名と文字列データベースの関連づけ

class TMultiLang : public TMultiLangObservable
{
public:
	// シングルトンモデルによる、ポインタ取得
	static TMultiLang* GetMultiLang();
	
	bool SetLang(const char* _language,bool _avoid_error = true);
	// 現在選択されている言語名を返す
	const char* GetLangFileName() { return m_language.c_str(); }

	// 現在選択されている言語名の母国語版を返す
	// 日本語が指定されていたら
	// GetLangFileName()の戻り値:japanese
	// GetLang()の戻り値:日本語
	const char* GetLang();
	
	const char* GetString(const char* _key);
	const char* GetStringFromOtherLang(const char* _lang,const char* _key);
	
	string* GetLangList(); // インストール言語の一覧
	string* GetLangListFromOtherLang(const char* _lang); // インストール言語を指定された言語での取得

	string* GetLangListFromFileName(); // ファイル名によるインストール言語の一覧
	size_t GetLangListSize();

	bool IsEmpty() { return m_lang_db->empty(); }
	
private:
	LANG_DB* m_lang_db;        // 言語データベース全体
	STRING_DB* m_selected_db; // 今選択されている言語の文字列集
	string m_language;         // 選択されている言語名	
		
	TMultiLang();	             // データベースを初期化
	virtual ~TMultiLang();
	

	void initLangDataBase();    // 言語データベースの初期化
	
	// ".lng"が拡張子のファイルを見つける
	void discoverLangFile(BDirectory& _dir,int _level); 
	
	// 見つけた言語ファイルから、言語データベースへ追加
	void addLangFile(BEntry& _entry);
};

#endif // MULTI_LANG_H_
