// MultiLangMenu.h
// 多言語のメニューを提供する

#ifndef MULTI_LANG_MENU_H_
#define MULTI_LANG_MENU_H_

#include <MenuItem.h>
#include <String.h>
#include <ClassInfo.h>
#include <Looper.h>
#include <Handler.h>

#include <string>

#include "MultiLang.h"

static const char MULTI_LANG_MENU_NAME[] = "MultiLangMenu";

class TMultiLangMenu : public BMenu,TMultiLangObserver
{
public:
	TMultiLangMenu(const char* _name,menu_layout _layout = B_ITEMS_IN_COLUMN);
	TMultiLangMenu(const char* _name,float _width,float _height);
	TMultiLangMenu(BMessage* _archive);

	virtual ~TMultiLangMenu();

	static BArchivable* Instantiate(BMessage* _archive);
	status_t Archive(BMessage* o_archive,bool _deep = true) const;
	
	virtual void MessageReceived(BMessage* _message);
	virtual void LangChanged(const char* _lang);

	friend class TMultiLangMenuHandler;	
private:
	void initMultiLangMenu(const char* _lang = NULL);
//	void setTargetMenuItems();
	void constructMultiLangMenu();
};

#endif // MULTI_LANG_MENU_H_