
#include "MultiLangObserve.h"

TMultiLangObservable::~TMultiLangObservable() {}

bool TMultiLangObservable::AddObserver(TMultiLangObserver* _observer)
{
	// リストを探して、同じものがなかったら追加する
	OBSERVER_DB::iterator ite;
	ite = find(m_observers.begin(),m_observers.end(),_observer);
	if (ite == m_observers.end()) // 見つからなかったら追加
	{
		m_observers.push_back(_observer);
		return true;
	}
	else return false;
}

bool TMultiLangObservable::DeleteObserver(TMultiLangObserver* _observer)
{
	OBSERVER_DB::iterator ite;
	ite = find(m_observers.begin(),m_observers.end(),_observer);
	if (ite != m_observers.end()) // 見つかった
	{
		m_observers.erase(ite);		
		return true; // 成功
	}
	else return false; // 見つからなかったら失敗
}

void TMultiLangObservable::NotifyObservers(const char* _param)
{
	OBSERVER_DB::iterator ite = m_observers.begin();
	
	while(ite != m_observers.end() ) 
	{
		(*ite)->LangChanged(_param);
		ite++;
	}	
}
