// TMultiLangObserve.h
// Observer/Observableモデルの構築

#ifndef MULTI_LANG_OBSERVE_H_
#define MULTI_LANG_OBSERVE_H_

#include <vector>

#include <algorithm>

using std::vector;

class TMultiLangObservable;
class TMultiLangObserver;

// 言語が変更になったときに変更通知を受け取るobserverのデータベース
typedef vector<TMultiLangObserver*> OBSERVER_DB; 

class TMultiLangObserver
{
public:
	// 言語の変更になったときにこれが呼ばれる
	virtual void LangChanged(const char* _lang_name) = 0;
};

class TMultiLangObservable
{
public:
	virtual ~TMultiLangObservable();
	
	bool AddObserver(TMultiLangObserver* _observer);
	bool DeleteObserver(TMultiLangObserver* _observer);

	void NotifyObservers(const char* _param);
private:
	OBSERVER_DB m_observers;	

protected:
	OBSERVER_DB* GetObservers() { return &m_observers; }
};

#endif // MULTI_LANG_OBSERVER_H_